#!/usr/bin/env python
# coding: utf-8

import pandas as pd
from business_models import greenplum
from business_models.greenplum import GreenplumManager
import json
with open('/root/logb2b/keys.json', 'r') as f:
    keys = json.load(f)
gp_user = 'robot-sam-bridges'
gp_token = keys['sam_gp_token']
greenplum = GreenplumManager(user=gp_user, token = gp_token)

from business_models.botolib import Bot
from business_models.config_holder import ConfigHolder
from business_models.util.log import Handler

import datetime
import logging
logging.basicConfig(filename='/root/logb2b/cron.log', level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

def create_bot():
    cnf = ConfigHolder()
    bot_token = keys['tg_token']
    default_chat_id = '-456583150'
    bot = Bot(token=bot_token, default_chat_id=default_chat_id)
    return bot

bot = create_bot()
with Handler(bot_report = bot, job_name = 'dash full CR upd\n', raise_exceptions = True, notify_success = True):

    with open ('niksm_b2b_logdata493_top30.sql') as f:
        sql = f.read()
    greenplum(sql)

logging.info('SUCCESS')
