insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata493_top30', 'Start', current_timestamp);

drop table if exists niksm_temp_493_segm_statlog;
create temporary table niksm_temp_493_segm_statlog as
select claim_segment_uuid,
       min(case when segment_status = 'performer_found' then utc_created_dttm end) as utc_found_dttm,
       min(case when segment_status in ('cancelled', 'cancelled_with_items_on_hands', 'cancelled_with_payment')
            then utc_created_dttm end) as utc_cancelled_dttm
from delivery_ods_cargo_claims.claim_segment_status_log
where true
  and utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
group by claim_segment_uuid
distributed by (claim_segment_uuid);
--
analyse niksm_temp_493_segm_statlog;


drop table if exists niksm_temp_493_taxi_log;
create temporary table niksm_temp_493_taxi_log as
select order_id,
       min(case when backend_event_code = 'create' then utc_status_created_dttm end) as utc_created_dttm_log,
       min(case when backend_status = 'assigned' then utc_status_created_dttm end) as utc_found_dttm,
       min(case when backend_status = 'cancelled' then utc_status_created_dttm end) as utc_cancelled_dttm
from taxi_stg_dbprocessing.order_status_log
where utc_order_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
group by order_id
distributed by (order_id);
--
analyse niksm_temp_493_taxi_log;

drop table if exists niksm_temp_493_res;
create temporary table niksm_temp_493_res as
with cargo as (
    select max(claim.corp_client_id) as corp_client_id,
           claim.claim_id,
           max(claim.utc_created_dttm) as utc_created_dttm,
           (max(claim.utc_created_dttm) at time zone 'UTC' at time zone 'Europe/Moscow')::date as msk_created_dt,
           max(claim.status_code) as status_code,
           max(claim.taxi_order_id) as order_id,
           max(segm.claim_segment_id) as claim_segment_id,
           max(segm.claim_segment_uuid) as claim_segment_uuid,
           count(distinct case when spnt.point_type = 'source' then spnt.claim_point_id end) as source_points,
           count(distinct case when spnt.point_type = 'source' and spnt.point_status = 'visited' then spnt.claim_point_id end) as source_points_visited,
           count(distinct case when spnt.point_type = 'destination' then spnt.claim_point_id end) as destination_points,
           count(distinct case when spnt.point_type = 'destination' and spnt.point_status = 'visited' then spnt.claim_point_id end)as destination_points_visited,

           --
           bool_or(claim.utc_due_dttm is null or claim.utc_due_dttm <= (claim.utc_created_dttm + interval '30 minutes')) as cargo_soon_flg,
           bool_or(segm_statlog.claim_segment_uuid is not null) as cargo_logging_flg,
           max(segm.utc_created_dttm) utc_created_dttm_log,
           max(segm_statlog.utc_found_dttm) utc_found_dttm,
           max(segm_statlog.utc_cancelled_dttm) utc_cancelled_dttm
    from delivery_ods_cargo_claims.claim as claim
      join delivery_ods_cargo_claims.claim_segment as segm
        on segm.claim_id = claim.claim_id
      join delivery_ods_cargo_claims.claim_segment_point as spnt
        on spnt.claim_segment_id = segm.claim_segment_id
      left join niksm_temp_493_segm_statlog segm_statlog
        on segm_statlog.claim_segment_uuid = segm.claim_segment_uuid
    where true
      and claim.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and claim.utc_created_dttm <  date_trunc('day', current_timestamp at time zone 'Europe/Moscow') at time zone 'Europe/Moscow' at time zone 'UTC'
      and segm.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and spnt.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and corp_client_id in ('27751a2d0b534affb80d243bc2f68981', 'c092a390e4824110990bbe47c4e82994', '7f7b5227ca614a8b9189366c2a4537f5', '287ba434c1724fdabf64f65393f00a2c', '2ed559be16dc4b7cb6c80b2f669a2ac1', '7d41e3375d4f49dfbde17a5c2d17ec4f', 'a68fbf6c4fcd4067af4a9f0e8c79a943', 'b57e4179dff24b00be2f8b505885a180', 'e3706c4dc7cb48b08d83fc07df24fe28', '8b5bde577e0b42059d9650ef5529a959', '5e7f029795a34156a74841a12c0fe45a', 'bfcafe053244447185178870cdbd6a60', '4e69321b86d04af0a8bd763cb5c51fa7', '7595912abe4e4409b92caaf754fed38f', 'f5e622ff421347d9a99adc07806955fd', 'bf1919ef126346ba93a7542b541ef487', 'd471ffcf960d4eb6b37a25c27cb36123', '631f8abc256f49fb89ea62301e3dec5c', '06c3eca26c9342dbb7138b9ba5a29eca', 'f2e2229337ef48ac9d8433a6b656d034', '0522211c00ef48f39afca3ad2213dddc', '19392efec6b34084bd846d5dd76f32ad', 'fc1f7cc2d10c4d6ea952eb9f51294d1e', '5c0860145b8c44f0a1d01a1c509af83f', 'd6bd052fe7f740a1be0183ae2eab60c1', 'cee6f2989ef74fe1b87565ae0f4be2f8', 'ca84ad82b2a14ef8aac0ae77ab154ed2')
    group by claim.claim_id
)
, taxi as (
    select fct.corp_client_id,
           fct.order_id,
           utc_order_created_dttm,
           msk_order_created_dt,
           driver_status,
           user_status,
           success_order_flg,
           destination_plan_geohash_cnt,
           order_type = 'soon' or fct.utc_order_due_dttm <= (fct.utc_order_created_dttm + interval '30 minutes') as taxi_soon_flg,
           taxi_log.order_id is not null as taxi_logging_flg,
           utc_created_dttm_log, utc_found_dttm, utc_cancelled_dttm
    from taxi_cdm_marketplace.fct_order fct
      join snb_delivery.logdata_delivery_tariff lgst
        on lgst.order_tariff = fct.tariff_class_code
        and fct.utc_order_created_dttm between lgst.utc_datefrom and lgst.utc_dateto
      left join niksm_temp_493_taxi_log as taxi_log
        on taxi_log.order_id = fct.order_id
    where true
      and utc_order_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and corp_client_id in ('27751a2d0b534affb80d243bc2f68981', 'c092a390e4824110990bbe47c4e82994', '7f7b5227ca614a8b9189366c2a4537f5', '287ba434c1724fdabf64f65393f00a2c', '2ed559be16dc4b7cb6c80b2f669a2ac1', '7d41e3375d4f49dfbde17a5c2d17ec4f', 'a68fbf6c4fcd4067af4a9f0e8c79a943', 'b57e4179dff24b00be2f8b505885a180', 'e3706c4dc7cb48b08d83fc07df24fe28', '8b5bde577e0b42059d9650ef5529a959', '5e7f029795a34156a74841a12c0fe45a', 'bfcafe053244447185178870cdbd6a60', '4e69321b86d04af0a8bd763cb5c51fa7', '7595912abe4e4409b92caaf754fed38f', 'f5e622ff421347d9a99adc07806955fd', 'bf1919ef126346ba93a7542b541ef487', 'd471ffcf960d4eb6b37a25c27cb36123', '631f8abc256f49fb89ea62301e3dec5c', '06c3eca26c9342dbb7138b9ba5a29eca', 'f2e2229337ef48ac9d8433a6b656d034', '0522211c00ef48f39afca3ad2213dddc', '19392efec6b34084bd846d5dd76f32ad', 'fc1f7cc2d10c4d6ea952eb9f51294d1e', '5c0860145b8c44f0a1d01a1c509af83f', 'd6bd052fe7f740a1be0183ae2eab60c1', 'cee6f2989ef74fe1b87565ae0f4be2f8', 'ca84ad82b2a14ef8aac0ae77ab154ed2')
)
, raw as (
    select coalesce(cargo.corp_client_id, taxi.corp_client_id) as corp_client_id,
           cargo.claim_id,
           coalesce(cargo.order_id, taxi.order_id) as order_id,
           cargo.claim_id is not null as cargo_flg,
           taxi.order_id is not null as taxi_flg,
           cargo.claim_segment_id,
           cargo.claim_segment_uuid,
           cargo.status_code,
           taxi.driver_status,
           taxi.user_status,
           taxi.success_order_flg,
           coalesce(cargo.msk_created_dt, taxi.msk_order_created_dt) as msk_created_dt,
           --
           coalesce(cargo.source_points, 1::int) as source_points,
           coalesce(cargo.source_points_visited, success_order_flg::int) as source_points_visited,
           coalesce(cargo.destination_points, destination_plan_geohash_cnt, 1::int) as destination_points,
           coalesce(cargo.destination_points_visited, case when success_order_flg then destination_plan_geohash_cnt else 0::int end) as destination_points_visited,
           -- status
           case when cargo.claim_id is not null
               then cargo.status_code in ('cancelled','cancelled_with_items_on_hands','cancelled_with_payment')
               else taxi.user_status in ('cancelled')
               end as client_cancellation_flg,
           case when cargo.claim_id is not null then cargo.status_code = 'delivered_finish'
               else taxi.success_order_flg end as full_success_flg,
           case when cargo.claim_id is not null
               then cargo.status_code in ('performer_not_found')
               else taxi.user_status in ('expired')
               end as expired_flg,
           --
           coalesce(cargo_soon_flg,taxi_soon_flg) as soon_flg,
           coalesce(cargo_logging_flg,taxi_logging_flg) as logging_flg,
           case when cargo_logging_flg then cargo.utc_created_dttm_log
               when taxi_logging_flg then taxi.utc_created_dttm_log end as utc_created_dttm_log,
           case when cargo_logging_flg then cargo.utc_found_dttm
               when taxi_logging_flg then taxi.utc_found_dttm end as utc_found_dttm,
           case when cargo_logging_flg then cargo.utc_found_dttm is not null
               when taxi_logging_flg then taxi.utc_found_dttm is not null end as courier_found_flg,
           --
           case when cargo_logging_flg then cargo.utc_cancelled_dttm
               when taxi_logging_flg then taxi.utc_cancelled_dttm end as utc_cancelled_dttm
    from cargo
      full join taxi
        on cargo.order_id = taxi.order_id
    where cargo.order_id is not null
       or taxi.utc_order_created_dttm <  date_trunc('day', current_timestamp at time zone 'Europe/Moscow') at time zone 'Europe/Moscow' at time zone 'UTC'
)
select corp_client_id,
       lk_client_name as corp_client_name,
       msk_created_dt,
       -- flags
       cargo_flg, taxi_flg,
       client_cancellation_flg,
       logging_flg,
       courier_found_flg,
       soon_flg,
       expired_flg,
       full_success_flg,
       --
       sum(source_points) as source_points,
       sum(source_points_visited) as source_points_visited,
       sum(destination_points) as destination_points,
       sum(destination_points_visited) as destination_points_visited,
       --
       sum(case when utc_cancelled_dttm is not null then extract(epoch from utc_cancelled_dttm - utc_created_dttm_log) end) as time_sec_before_cancel,
       sum(case when utc_cancelled_dttm is not null then source_points end) as source_points_utc_cancelled,
       sum(case when courier_found_flg then extract(epoch from utc_found_dttm - utc_created_dttm_log) end) as searching_time_sec
from raw
  left join snb_b2b.niksm_b2b_lk_client_service_info
    on lk_service_name = 'cargo'
    and lk_client_id = raw.corp_client_id
group by corp_client_id,
       lk_client_name,
       msk_created_dt,
       -- flags
       cargo_flg, taxi_flg,
       client_cancellation_flg,
       logging_flg,
       courier_found_flg,
       soon_flg,
       expired_flg,
       full_success_flg;
--
analyse niksm_temp_493_res;

--====================================================================================================================--
-- drop table if exists snb_b2b.niksm_b2b_logdata493_top30;
-- create table snb_b2b.niksm_b2b_logdata493_top30 as
truncate table snb_b2b.niksm_b2b_logdata493_top30;
insert into snb_b2b.niksm_b2b_logdata493_top30
    (corp_client_id, corp_client_name, msk_created_dt,
     cargo_flg, taxi_flg, client_cancellation_flg, logging_flg, courier_found_flg, soon_flg, expired_flg, full_success_flg,
     source_points, source_points_visited, destination_points, destination_points_visited,
     time_sec_before_cancel, source_points_utc_cancelled, searching_time_sec,
     first_full_date, last_full_date)
--
select corp_client_id,
       corp_client_name,
       msk_created_dt,
       -- flags
       cargo_flg, taxi_flg,
       client_cancellation_flg,
       logging_flg,
       courier_found_flg,
       soon_flg,
       expired_flg,
       full_success_flg,
       --
       source_points, source_points_visited, destination_points, destination_points_visited,
       --
       time_sec_before_cancel,
       source_points_utc_cancelled,
       searching_time_sec,
       --
       NULL::date as first_full_date,
       NULL::date as last_full_date
from niksm_temp_493_res;


update snb_b2b.niksm_b2b_logdata493_top30
set first_full_date = ((date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC')::date,
    last_full_date = (
    select least(last_claims_date, last_fct_date) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
    )
where true;

-- comment on table snb_b2b.niksm_b2b_logdata493_top30 is 'LOGDATA-493. Витрина для дашборда Топ-30';
-- grant all on snb_b2b.niksm_b2b_logdata493_top30 to "robot-sam-bridges", "robot-corploader";

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_logdata493_top30', 'Finish', current_timestamp);
