with src as (
    select least(last_fct_date) as last_full_date
    from (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
)
, res as (
    select max(last_full_date) as last_full_date
    from snb_b2b.niksm_dash_gmv_yd_share
)
select case when src.last_full_date > res.last_full_date
                 or res.last_full_date is null
            then 1::int else 0::int end as flg
from src cross join res;
