#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
import psycopg2
import datetime
import csv
import codecs
import sys
import copy
import smtplib
import time
import imaplib
import email
import email.header
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication
import copy
import logging
import locale
import ast
from b2b_mailer import main, main2, gp2df
import pandas as pd
import requests

locale.setlocale(locale.LC_ALL, 'en_US.UTF-8')

import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

key_file='keys.json'
with open(key_file) as f:
    from_file = json.load(f)

con = f"postgresql://robot-sam-bridges:{from_file['gp_token']}@gpdb-master.taxi.yandex.net:5432/ritchie"
st_wolfgang_token = from_file['sam_gp_token']
#st_hans = from_file['st_robot_corpwelcome']

# part 2 - cut and send
query = """
select
cc.cc_id,
cc.hierarchy,
cc.pd_id,
cc.login,
cc.lead_login,
--cc.name,
cc.contract_id,
cc.top100 as top,
cc.value,
cc.pipeline,
cc.stage,
cc.manager,
cc.add_sales_options,
cc.lead,
cc.person_id,
cc.channel,
cc.integration_status,
cc.company_group,
cc.segment_,
dbt.payment_type,
dbt.contract_type,
--dbt.manager_code,
dbt.finish_dt,
ccu.can_order as ccu_can_order,
ccu.total as ccu_total,
cc.prepaid_deactivate_threshold,
cc.balance as balance,
to_timestamp(cc.created::bigint)::date as created,
to_timestamp(cc.first_seen::bigint)::date as first_seen,
to_timestamp(cc.last_seen::bigint)::date as last_seen,
trips_min.min_order,
trips_min.max_order,
cc.country,
--cc.created,
trips_min.last_trips,
trips_min.this_trips,
trips_min.corpweb_orders,
COALESCE(trips_min.this_trips - md.delivery_orders_with_several_points_cur + md.deliveries_with_several_points_cur, trips_min.this_trips) as deliveries_with_multi_cur,
COALESCE(trips_min.last_trips - md.delivery_orders_with_several_points_prev + md.deliveries_with_several_points_prev, trips_min.last_trips) as deliveries_with_multi_prev,
dbt.balance_active,
cc.is_active as adm_active,
cc.logistics,
cc.lk_contract_status,
'' as alarm,
cc.service_ids,
sum(CASE WHEN moscow_order_dt = current_date - interval '0 days' THEN count ELSE 0 END) AS date0,
sum(CASE WHEN moscow_order_dt = current_date - interval '1 days' THEN count ELSE 0 END) AS date1,
sum(CASE WHEN moscow_order_dt = current_date - interval '2 days' THEN count ELSE 0 END) AS date2,
sum(CASE WHEN moscow_order_dt = current_date - interval '3 days' THEN count ELSE 0 END) AS date3,
sum(CASE WHEN moscow_order_dt = current_date - interval '4 days' THEN count ELSE 0 END) AS date4,
sum(CASE WHEN moscow_order_dt = current_date - interval '5 days' THEN count ELSE 0 END) AS date5,
sum(CASE WHEN moscow_order_dt = current_date - interval '6 days' THEN count ELSE 0 END) AS date6,
sum(CASE WHEN moscow_order_dt = current_date - interval '7 days' THEN count ELSE 0 END) AS date7,
sum(CASE WHEN moscow_order_dt = current_date - interval '8 days' THEN count ELSE 0 END) AS date8,
sum(CASE WHEN moscow_order_dt = current_date - interval '9 days' THEN count ELSE 0 END) AS date9,
sum(CASE WHEN moscow_order_dt = current_date - interval '10 days' THEN count ELSE 0 END) AS date10,
sum(CASE WHEN moscow_order_dt = current_date - interval '11 days' THEN count ELSE 0 END) AS date11,
sum(CASE WHEN moscow_order_dt = current_date - interval '12 days' THEN count ELSE 0 END) AS date12,
sum(CASE WHEN moscow_order_dt = current_date - interval '13 days' THEN count ELSE 0 END) AS date13,
sum(CASE WHEN moscow_order_dt = current_date - interval '14 days' THEN count ELSE 0 END) AS date14,
sum(CASE WHEN moscow_order_dt = current_date - interval '15 days' THEN count ELSE 0 END) AS date15,
sum(CASE WHEN moscow_order_dt = current_date - interval '16 days' THEN count ELSE 0 END) AS date16,
sum(CASE WHEN moscow_order_dt = current_date - interval '17 days' THEN count ELSE 0 END) AS date17,
sum(CASE WHEN moscow_order_dt = current_date - interval '18 days' THEN count ELSE 0 END) AS date18,
sum(CASE WHEN moscow_order_dt = current_date - interval '19 days' THEN count ELSE 0 END) AS date19,
sum(CASE WHEN moscow_order_dt = current_date - interval '20 days' THEN count ELSE 0 END) AS date20,
sum(CASE WHEN moscow_order_dt = current_date - interval '21 days' THEN count ELSE 0 END) AS date21,
sum(CASE WHEN moscow_order_dt = current_date - interval '22 days' THEN count ELSE 0 END) AS date22,
sum(CASE WHEN moscow_order_dt = current_date - interval '23 days' THEN count ELSE 0 END) AS date23,
sum(CASE WHEN moscow_order_dt = current_date - interval '24 days' THEN count ELSE 0 END) AS date24,
sum(CASE WHEN moscow_order_dt = current_date - interval '25 days' THEN count ELSE 0 END) AS date25,
sum(CASE WHEN moscow_order_dt = current_date - interval '26 days' THEN count ELSE 0 END) AS date26,
sum(CASE WHEN moscow_order_dt = current_date - interval '27 days' THEN count ELSE 0 END) AS date27,
sum(CASE WHEN moscow_order_dt = current_date - interval '28 days' THEN count ELSE 0 END) AS date28,
sum(CASE WHEN moscow_order_dt = current_date - interval '29 days' THEN count ELSE 0 END) AS date29,
sum(CASE WHEN moscow_order_dt = current_date - interval '30 days' THEN count ELSE 0 END) AS date30,
sum(CASE WHEN moscow_order_dt = current_date - interval '31 days' THEN count ELSE 0 END) AS date31,
sum(CASE WHEN moscow_order_dt = current_date - interval '32 days' THEN count ELSE 0 END) AS date32,
sum(CASE WHEN moscow_order_dt = current_date - interval '33 days' THEN count ELSE 0 END) AS date33,
sum(CASE WHEN moscow_order_dt = current_date - interval '34 days' THEN count ELSE 0 END) AS date34,
sum(CASE WHEN moscow_order_dt = current_date - interval '35 days' THEN count ELSE 0 END) AS date35,
sum(CASE WHEN moscow_order_dt = current_date - interval '36 days' THEN count ELSE 0 END) AS date36,
sum(CASE WHEN moscow_order_dt = current_date - interval '37 days' THEN count ELSE 0 END) AS date37,
sum(CASE WHEN moscow_order_dt = current_date - interval '38 days' THEN count ELSE 0 END) AS date38,
sum(CASE WHEN moscow_order_dt = current_date - interval '39 days' THEN count ELSE 0 END) AS date39,
sum(CASE WHEN moscow_order_dt = current_date - interval '40 days' THEN count ELSE 0 END) AS date40,
sum(CASE WHEN moscow_order_dt = current_date - interval '41 days' THEN count ELSE 0 END) AS date41,
sum(CASE WHEN moscow_order_dt = current_date - interval '42 days' THEN count ELSE 0 END) AS date42,
sum(CASE WHEN moscow_order_dt = current_date - interval '43 days' THEN count ELSE 0 END) AS date43,
sum(CASE WHEN moscow_order_dt = current_date - interval '44 days' THEN count ELSE 0 END) AS date44,
sum(CASE WHEN moscow_order_dt = current_date - interval '45 days' THEN count ELSE 0 END) AS date45,
sum(CASE WHEN moscow_order_dt = current_date - interval '46 days' THEN count ELSE 0 END) AS date46,
sum(CASE WHEN moscow_order_dt = current_date - interval '47 days' THEN count ELSE 0 END) AS date47,
sum(CASE WHEN moscow_order_dt = current_date - interval '48 days' THEN count ELSE 0 END) AS date48,
sum(CASE WHEN moscow_order_dt = current_date - interval '49 days' THEN count ELSE 0 END) AS date49,
sum(CASE WHEN moscow_order_dt = current_date - interval '50 days' THEN count ELSE 0 END) AS date50,
sum(CASE WHEN moscow_order_dt = current_date - interval '51 days' THEN count ELSE 0 END) AS date51,
sum(CASE WHEN moscow_order_dt = current_date - interval '52 days' THEN count ELSE 0 END) AS date52,
sum(CASE WHEN moscow_order_dt = current_date - interval '53 days' THEN count ELSE 0 END) AS date53,
sum(CASE WHEN moscow_order_dt = current_date - interval '54 days' THEN count ELSE 0 END) AS date54,
sum(CASE WHEN moscow_order_dt = current_date - interval '55 days' THEN count ELSE 0 END) AS date55,
sum(CASE WHEN moscow_order_dt = current_date - interval '56 days' THEN count ELSE 0 END) AS date56,
sum(CASE WHEN moscow_order_dt = current_date - interval '57 days' THEN count ELSE 0 END) AS date57,
sum(CASE WHEN moscow_order_dt = current_date - interval '58 days' THEN count ELSE 0 END) AS date58,
sum(CASE WHEN moscow_order_dt = current_date - interval '59 days' THEN count ELSE 0 END) AS date59,
sum(CASE WHEN moscow_order_dt = current_date - interval '60 days' THEN count ELSE 0 END) AS date60
from (
    select
    cc.cc_id,
    d.id as pd_id,
    cc.is_active,
    '' as logistics,
    d.login,
    d.lead_login,
    d.hierarchy,
    cc.name,
    cc.contract_id,
    bmcc.prepaid_deactivate_threshold,
    bmcc.balance,
    cc.country,
    cc.created,
    d.top100,
    d.top_mass,
    d.value,
    d.stage,
    d.person_id,
    d.channel, d.company_group, d.segment_,
    d.manager,
    d.add_sales_options,
    d.lead,
    d.pipeline,
    d.integration_status,
    cc.first_seen,
    cc.last_seen,
    cc.contract_status as lk_contract_status,
    cc.service_ids
    from (
        select
            cc.cc_id,
            cc.is_active,
            cc.cargo_is_active,
            cc.name,
            case when contract_external_id is not null then contract_external_id
            else cc.contract_id end as contract_id,
            cc.country,
            cc.created,
            cc.first_seen,
            cc.last_seen,
            cc.contract_status,
            cc2.service_ids::text as service_ids
        from (
            select
                cc.id as cc_id,
                CASE WHEN (cc.services -> 'cargo' ->> 'is_active') = '1'
                    THEN 'Активен' ELSE 'Не активен' END as is_active,
                cc.services -> 'cargo' ->> 'is_active' as cargo_is_active,
                cc.name,
                CASE WHEN
                    ((cc.services -> 'cargo' ->> 'contract_id') = '') is false
                    THEN (cc.services -> 'cargo' ->> 'contract_id')
                    ELSE (cc.services -> 'taxi' ->> 'contract_id')
                END as contract_id,
                cc.billing_id,
                cc.country,
                cc.created,
                cc2.first_seen,
                cc2.last_seen,
                cc.contract_status
            from snb_b2b.bmiklaz_corp_clients as cc
            left join snb_b2b.voytekh_corp_clients as cc2
            on cc.id = cc2.id
        ) as cc
        left join snb_b2b.bmiklaz_corp_contracts as cc2
        on cc2.billing_client_id = cc.billing_id
    ) as cc
    left join (
        select contract, balance, prepaid_deactivate_threshold from (
            select
                contract_external_id as contract,
                balance ->> 'balance' as balance,
                settings ->> 'prepaid_deactivate_threshold' as prepaid_deactivate_threshold,
                row_number() over (partition by contract_external_id order by updated desc) as rn
            from
            snb_b2b.bmiklaz_corp_contracts
        ) as bmcc where rn = 1
    ) as bmcc
    on bmcc.contract = cc.contract_id
    left join (
        -- delivery deals, with agr num updated by link
    select d.id, case when (agr='') is false then agr else link_agr end as agr,
        s_options, value, stage, case when top100 is null then '' else 'ДА' end as top100,
        case when top_mass is null then '' else 'ДА' end as top_mass, pipeline,
        add_sales_options, manager, lead, login, lead_login, hierarchy, channel, company_group, segment_, person_id,
        integration_status
        from (
            select
            d.id, d.which_crm,
            (d.custom_fields ->> '5b46472f62d243f28c789cfa00dc4859a06973a8') as agr,
            '' as link_agr,
            (d.custom_fields ->> '13fedf3be30ae4c5235a248c41c3a9dbb281cdbd') as top100,
            '' as top_mass,
            '' as add_sales_options,
            s_options.label as s_options,
            d.value, s.name as stage, p.name as pipeline,
            m.login,
            m.lead_login,
            m.hierarchy::text,
            m.name_last_ru || ' ' || m.name_first_ru as manager,
            m.lead_name_last as lead,
            channel_options.label as channel,
            group_options.label as company_group,
            segment_options.label as segment_, d.person_id,
            integration_status.label as integration_status
            from
            snb_b2b.voytekh_pd2_deal as d
            LEFT JOIN snb_b2b.voytekh_pd2_org as org on org.id = d.org_id and d.which_crm = org.which_crm
            LEFT JOIN snb_b2b.voytekh_pd_stage as s
            ON d.stage_id = s.pd_id and d.which_crm = s.which_crm
            LEFT JOIN snb_b2b.voytekh_pd_pipeline as p
            ON d.pipeline_id = p.pd_id and d.which_crm = p.which_crm
            LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
            from snb_b2b.voytekh_pd2_deal_field
            where key = 'f9178a9518c8aeb705d24c897f8b1b03d09a2aeb') as s_options
            ON (d.custom_fields ->> 'f9178a9518c8aeb705d24c897f8b1b03d09a2aeb') = s_options.id_
            LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
            from snb_b2b.voytekh_pd2_deal_field
            where key = '07d4db4f54185adb5764b984c15bd99af4d744a6') as channel_options
            ON (d.custom_fields ->> '07d4db4f54185adb5764b984c15bd99af4d744a6') = channel_options.id_
            LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
            from snb_b2b.voytekh_pd2_org_field
            where key = 'fbc99f7699d1648bc9258bfa3972bb2118f92187') as group_options
            ON (org.custom_fields ->> 'fbc99f7699d1648bc9258bfa3972bb2118f92187') = group_options.id_
            LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
            from snb_b2b.voytekh_pd2_org_field
            where key = '7f759625b61c32d403deba6af2511335cf91f75e') as segment_options
            ON (org.custom_fields ->> '7f759625b61c32d403deba6af2511335cf91f75e') = segment_options.id_
            LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
            from snb_b2b.voytekh_pd2_deal_field
            where key = '5986d68f2bcbaf03efad4d8025cbe15b0ad42498') as integration_status
            ON (d.custom_fields ->> '5986d68f2bcbaf03efad4d8025cbe15b0ad42498') = integration_status.id_
            LEFT JOIN snb_b2b.voytekh_pd_user as o
            ON d.user_id = o.pd_id and d.which_crm = o.which_crm
            LEFT JOIN snb_b2b.voytekh_manager_v2 as m
            ON split_part(o.email, '@', 1) = m.login
            where d.which_crm = 6
        ) as d where (agr='') is false or (link_agr='') is false
    ) as d on d.agr = cc.contract_id
    where (cc.contract_id = '') is false
    and cc.country in ('rus', 'kaz', 'arm', 'blr')
) as cc
left join (
    select corp_client_id as cc_id, moscow_order_dt, count(*) as count
    from summary.dm_order where
    corp_order_flg = true
    and success_order_flg = true
    and order_tariff in {t}
    and moscow_order_dt > '2020-02-13'
    group by corp_client_id, moscow_order_dt
) as trips
on trips.cc_id = cc.cc_id
left join (
    select
    corp_client_id as cc_id,
    min(moscow_order_dt) as min_order,
    max(moscow_order_dt) as max_order,
    count(*) filter (WHERE moscow_order_dt >= date_trunc('month', current_date - interval '1 month')
        and moscow_order_dt < date_trunc('month', current_date)) as last_trips,
    count(*) filter (WHERE moscow_order_dt >= date_trunc('month', current_date)) as this_trips,
    count(*) filter (WHERE moscow_order_dt >= date_trunc('month', current_date - interval '1 month')
        and moscow_order_dt < date_trunc('month', current_date)
        and application_platform = 'corpweb') as corpweb_orders
    from summary.dm_order where
    corp_order_flg = true
    and success_order_flg = true
    and order_tariff in {t}
    group by corp_client_id
) as trips_min
on trips_min.cc_id = cc.cc_id
left join (
    select * from (
        select *,
        row_number() over (partition by contract order by start_dt desc) as rn,
        CASE WHEN NOT (dbt.faxed_dt is null AND signed_dt is null) AND (cancelled_dt is null AND finish_dt is null AND suspended_dt is null) THEN 'Активен' ELSE 'Не активен' END as balance_active
        from snb_b2b.voytekh_corporate_contracts_and_debts as dbt
    ) as dbt where rn = 1
) as dbt
on dbt.contract = cc.contract_id
left join snb_b2b.voytekh_corp_user_count as ccu
on ccu.clid = cc.cc_id
left join ( select
    corp_contract_id,
    sum(delivery_orders_with_several_points) filter (WHERE moscow_order_dt::date >= date_trunc('month', current_date)) as delivery_orders_with_several_points_cur,
    sum(delivery_orders_with_several_points) filter (WHERE moscow_order_dt::date >= date_trunc('month', current_date - interval '1 month')
        and moscow_order_dt::date < date_trunc('month', current_date)) as delivery_orders_with_several_points_prev,
    sum(deliveries_with_several_points) filter (WHERE moscow_order_dt::date >= date_trunc('month', current_date)) as deliveries_with_several_points_cur,
    sum(deliveries_with_several_points) filter (WHERE moscow_order_dt::date >= date_trunc('month', current_date - interval '1 month')
        and moscow_order_dt::date < date_trunc('month', current_date)) as deliveries_with_several_points_prev
from snb_b2b.bmiklaz_orders_with_points
where true
  and order_tariff in {t}
group by corp_contract_id) as md
on cc.contract_id = md.corp_contract_id
where (trips.cc_id is not null or cc.stage is not null)
group by
cc.is_active,
cc.cc_id,
cc.hierarchy,
cc.pd_id,
cc.login,
cc.lead_login,
--cc.name,
cc.contract_id,
cc.top100,
cc.value,
cc.pipeline,
cc.stage,
cc.manager,
cc.add_sales_options,
cc.lead,
cc.integration_status,
cc.person_id,
cc.channel,
cc.company_group,
cc.segment_,
dbt.payment_type,
dbt.contract_type,
dbt.balance_active,
--dbt.manager_code,
dbt.finish_dt,
ccu.can_order,
ccu.total,
cc.prepaid_deactivate_threshold,
cc.balance,
to_timestamp(cc.created::bigint)::date,
to_timestamp(cc.first_seen::bigint)::date,
to_timestamp(cc.last_seen::bigint)::date,
trips_min.min_order,
trips_min.max_order,
cc.country,
cc.logistics,
--cc.created,
trips_min.last_trips,
trips_min.this_trips,
trips_min.corpweb_orders,
deliveries_with_multi_cur,
deliveries_with_multi_prev,
cc.lk_contract_status,
cc.service_ids
"""


vars = [
    {'t': "('express', 'courier')"},
    {'t': "('cargo', 'cargocorp')"},
]

# name columns for excel
col_names = {
    'alarm': 'Тревога по оттоку',
    'pd_id': 'PipeDrive id',
    'manager_login': 'Логин менеджера',
    'lead_login': 'Логин лида',
    'contract_id': 'Договор',
    'value': 'Потенциал',
    'pipeline': 'Воронка',
    'stage': 'Этап',
    'manager': 'Менеджер',
    'lead': 'Тимлид',
    'person_id': 'id контакта',
    'channel': 'Канал привлечения',
    # 'company_group': 'Группа компаний',
    'segment_': 'Сегмент рынка',
    'payment_type': 'Тип оплаты',
    'contract_type': 'Тип договора',
    'ccu_can_order': 'Активных сотрудников с правом заказа',
    'ccu_total': 'Активных сотрудников всего',

    'finish_dt': 'Дата окончания',
    'prepaid_deactivate_threshold': 'Порог отключения',
    'balance': 'Баланс счета',
    'contract_status': 'Статус договора в балансе',
    'lk_contract_status': 'Статус договора в балансе (админка)',
    'is_active': 'ЛК активен',
    'created': 'Дата создания',
    'first_seen': 'Первый логин в ЛК',
    'last_seen': 'Последний логин в ЛК',
    'min_order': 'Первый заказ',
    'max_order': 'Последний заказ',
    'country': 'Страна',
    'last_trips': 'Поездок в прошлом месяце',
    'this_trips': 'Поездок в этом месяце',
    'corpweb_orders': 'Поездок в прошлом месяце через ЛК',
    'deliveries_with_multi_cur': 'Доставок с учетом мультиточек в текущем месяце',
    'deliveries_with_multi_prev': 'Доставок с учетом мультиточек в прошлом месяце',
    'balance_active': 'Активен в балансе',
    'adm_active': 'Активен в админке',
    'logistics': 'Наличие логистики',
}

for y in range(0, 61):
    col_names['date{}'.format(y)] = (datetime.datetime.now() - datetime.timedelta(days=y)).strftime('%Y-%m-%d')

key_key='gp_token'

df1 = gp2df(query.format(t=vars[0]['t']), key_file, key_key, user='robot-corploader')
df2 = gp2df(query.format(t=vars[1]['t']), key_file, key_key, user='robot-corploader')

logging.info(f"DataFrame loaded: delivery len = {len(df1)}, cargo len = {len(df2)}")

def datelist_(x):
    r = []
    for i in x:
        base = datetime.datetime.strptime(i.split(':')[0], '%Y-%m-%d')
        date_list = [(base + datetime.timedelta(days=x)).date() for x in range(int(i.split(':')[1]))]
        r += date_list
    return r


try:
    # config
    url = 'https://st-api.yandex-team.ru/v2/issues/TAXICORPBOTS-10'
    headers = {'Authorization': 'OAuth {}'.format(st_wolfgang_token)}
    r = requests.get(url, headers=headers)
    bytes_value = r.content
    my_json = bytes_value.decode('utf8')
    data = json.loads(my_json)
    config = json.loads(data['description'].replace("'", '"').replace("\n", ''))
    config2 = copy.deepcopy(config)

    for k, v in config['exclude_filters'].items():
        config['exclude_filters'][k] = datelist_(v)

    # backup
    json.dump(config2, open('mailer_delivery_config', 'w'))
except:
    config = json.load(open('mailer_delivery_config', 'r'))

    for k, v in config['exclude_filters'].items():
        config['exclude_filters'][k] = datelist_(v)
    payload = {
        "text": "Конфиг сломан и не читается. Рассылку произвожу с использованием последней корректной версии.",
        "summonees": [config['maintainer'], ]
    }
    url = 'https://st-api.yandex-team.ru/v2/issues/TAXICORPBOTS-10/comments'
    headers = {'Authorization': 'OAuth {}'.format(st_wolfgang_token)}
    r = requests.post(url, headers=headers, json=payload)


def alarms(x):
    r = []

    if datetime.datetime.today().date() not in config['exclude_filters']['no_trips_last3'] \
            and x['contract_id'] not in config['exclude_contracts']['no_trips_last3']:
        if x.loc['date0':'date3'].sum() == 0 and x.loc['date0':'date9'].sum() > 0:
            r.append('no_trips_last3')

    if datetime.datetime.today() not in config['exclude_filters']['declining_trips'] \
            and x['contract_id'] not in config['exclude_contracts']['declining_trips']:
        trips_2w = x.loc['date15':'date28'].sum()
        trips_decline = x.loc['date0':'date14'].sum() / trips_2w if trips_2w > 0 else 1
        for bd in config['bad_decline']:
            if bd[0] <= trips_2w < bd[1] and trips_decline < bd[2]:
                r.append('declining_trips')
                break
    return ','.join([config['localize'][s] for s in r])


df1['alarm'] = df1.apply(lambda x: alarms(x), axis=1)
# df1 = df1.style.apply(highlight_, subset=['alarm'])

logging.info('Alarm set')

sql = """
select max(moscow_order_dttm)
from summary.dm_order
where corp_order_flg
  and utc_order_dt >= current_date - 30
"""
df = pd.read_sql_query(sql, con)
dt = df.loc[:, 'max'].iloc[0].strftime('%Y-%m-%d %H:%M:%S')
note = f'\n\nдата последнего заказа в БД - {dt}'

logging.info('Max date set')

def highlight_(x):
    return ['background-color: red' if v else '' for v in x]

try:

    main2(
         # define who receivers are. can use all attributes at once. value should be a list of strings or None
         receivers_url=None,  # add to receivers all people from specific groups at staff
         receivers_ancestors=None,
         receivers_logins= [],#['aa-sinicyn', 'annmaksimova', 'pahareva', 'vparshinova',
                           #'anashche',
                           #'isinchurin', 'alesyaloseva', 'aleynikov-d'],  # add to receivers people by logins
         exclude_logins=['sinelnikov'],  # do not send to these people, if they are selected in 3 parameters above
         flat=['niksm','ferenec' ],  # ,'voytekh', 'bruiaka', 'tsapenko', 'lyadovayuliya', 'gaman' list of logins to send all rows to
         mail_name='Робот по доставке. Тест Нирваны', # name of letter
         mail_text='Этот робот по сделкам в СРМ Доставки ' + note, # body of letter
         mail_cc=['voytekh@yandex-team.ru'],  # send a copy to listed emails  'bmiklaz@yandex-team.ru'
         hierarchy=True,  # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
         emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
         key_file=key_file,  # where the keys are
         key_key=key_key,  # key of gp token in file
         user='robot-corploader',  # user for gp. defaults to user='robot-corploader'
         host='gpdb-master.taxi.yandex.net',
         sheets=[
            {'query': None,
             'df': df1,
             'exclude_columns': ['integration_status'],
             'col_names': col_names,
             'sheet_name': 'express_courier',
             'style': {'func': highlight_, 'subset': ['Тревога по оттоку']}
             },
            {'query': None,
            'df': df2,
             'exclude_columns': ['integration_status'],
            'col_names': col_names,
            'sheet_name': 'cargo'},
         ]
    )
    logging.info('Main version sent')

    main2(
         # define who receivers are. can use all attributes at once. value should be a list of strings or None
         receivers_url=None,  # add to receivers all people from specific groups at staff
         receivers_ancestors=None,
         receivers_logins=[],  # add to receivers people by logins
         exclude_logins=['sinelnikov'],  # do not send to these people, if they are selected in 3 parameters above
         flat=[ 'niksm', 'ferenec'],  #  'eninaev', 'voytekh', list of logins to send all rows to
         mail_name='Робот по доставке eninaev. Тест Нирваны', # name of letter
         mail_text='Этот робот по сделкам в СРМ Доставки для eninaev' + note, # body of letter
         mail_cc=['niksm@yandex-team.ru'],  # send a copy to listed emails  'bmiklaz@yandex-team.ru'
         hierarchy=True,  # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
         emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
         key_file=key_file,  # where the keys are
         key_key=key_key,  # key of gp token in file
         user='robot-corploader',  # user for gp. defaults to user='robot-corploader'
         host='gpdb-master.taxi.yandex.net',
         sheets=[
            {'query': None,
            'df': df1[~df1['integration_status'].isna()],
            'exclude_columns': None,
            'col_names': col_names,
            'sheet_name': 'express_courier'},
            {'query': None,
            'df': df2[~df2['integration_status'].isna()],
            'exclude_columns': None,
            'col_names': col_names,
            'sheet_name': 'cargo'},
         ]
    )
    logging.info('eninaev version sent')

    main2(
         # define who receivers are. can use all attributes at once. value should be a list of strings or None
         receivers_url=None,  # add to receivers all people from specific groups at staff
         receivers_ancestors=None,
         receivers_logins=[],  # add to receivers people by logins
         exclude_logins=['sinelnikov'],  # do not send to these people, if they are selected in 3 parameters above
         flat=['niksm', 'ferenec'],  # , 'voytekh', 'asstafeeva', 'koroleva-e' list of logins to send all rows to
         mail_name='Робот по доставке для Клиентской службы. Тест Никрваны', # name of letter
         mail_text='Этот робот по сделкам в СРМ Доставки для Клиентской службы' + note, # body of letter
         mail_cc=['niksm@yandex-team.ru'],  # send a copy to listed emails  'bmiklaz@yandex-team.ru'
         hierarchy=True,  # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
         emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
         key_file=key_file,  # where the keys are
         key_key=key_key,  # key of gp token in file
         user='robot-corploader',  # user for gp. defaults to user='robot-corploader'
         host='gpdb-master.taxi.yandex.net',
         sheets=[
            {'query': None,
            'df': df1[(df1['login'] == 'wubbo_ockels')
                       | (df1.hierarchy.apply(lambda x: 'askerovasm' in (x if x else ())))
                       | (df1.pipeline.isin(['ТЕЛЕМАРКЕТИНГ И САМОРЕГИСТРАЦИЯ','САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ']))
                      ],
            'exclude_columns': None,
            'col_names': col_names,
            'sheet_name': 'express_courier'},
            {'query': None,
            'df': df2[(df2['login'] == 'wubbo_ockels')
                       | (df1.hierarchy.apply(lambda x: 'askerovasm' in (x if x else ())))
                       | (df2.pipeline.isin(['ТЕЛЕМАРКЕТИНГ И САМОРЕГИСТРАЦИЯ','САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ']))
                      ],
            'exclude_columns': None,
            'col_names': col_names,
            'sheet_name': 'cargo'},
         ]
    )
    logging.info('Support version sent, SUCCESS')
except Exception as e:
    logging.error(f'mailer failed {e}')
