#!/usr/bin/env python
# coding: utf-8


import pandas as pd
from business_models import greenplum, hahn
from business_models.greenplum import GreenplumManager
from business_models.hahn import HahnDataLoader
import json
with open('/root/logb2b/keys.json', 'r') as f:
    keys = json.load(f)
gp_user = 'robot-sam-bridges'
gp_token = keys['sam_gp_token']
greenplum = GreenplumManager(user=gp_user, token = gp_token)
yt_token = keys['yt_token']
HahnDataLoader(token=yt_token)

import datetime
from datetime import datetime as dt
import logging

import sys
logging.basicConfig(filename='/root/logb2b/cron.log', level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

v_datefrom_str = (datetime.date.today() - datetime.timedelta(days = 3)).strftime('%Y-%m-%d')
with open ('parks_hourly_dynamics_YT.sql') as f:
    yt_template = f.read()

sql_yt = yt_template.format(utc_datefrom = v_datefrom_str)
hahn(sql_yt)
logging.info(f'YT loaded from {v_datefrom_str}')

sql_delete_template = """
delete from snb_delivery.niksm_park_orders_hourly_raw
where utc_order_created_hour >= '{utc_datefrom} 00:00:00'
"""
sql_delete = sql_delete_template.format(utc_datefrom = v_datefrom_str)
greenplum(sql_delete)
logging.info(f'GP deleted from {v_datefrom_str}')

greenplum.replicate(yt_path='//home/taxi-delivery/analytics/production/b2b/parks/park_orders_hourly',
                    table_name='snb_delivery.niksm_park_orders_hourly_raw',
                    if_exists='append')
logging.info('GP loaded from YT')

with open ('parks_hourly_dynamics_dash.sql') as f:
    sql = f.read()
greenplum(sql)
logging.info('dash datamart calculated, SUCCESS')
