PRAGMA yson.DisableStrict;
PRAGMA yt.InferSchema;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;

$res_table = '//home/taxi-delivery/analytics/production/b2b/parks/park_orders_hourly';

$res = (
    select
        park_client_id,
        corp_order_flg,
        utc_order_created_hour,
        some(taximeter_park_id) as taximeter_park_id,
        count(order_id) as success_orders_cnt,
        max(utc_order_created_dttm) as max_utc_order_created_dttm
    from
        range(`//home/taxi-dwh/ods/dbprocessing/order`,`2021-12-01`)
    where true
        and success_order_flg
        and not mqc_order_flg
        and tariff_class_id in ['express', 'courier']
        and currency_code in ['RUB']
        and park_client_id is not null
        and utc_order_created_dttm >= '{utc_datefrom} 00:00:00'
    group by
        park_client_id,
        corp_order_flg,
        substring(utc_order_created_dttm,0,13) || ':00:00' as utc_order_created_hour
);

insert into $res_table with truncate
    (park_client_id, corp_order_flg,
     utc_order_created_hour, taximeter_park_id,
     success_orders_cnt, max_utc_order_created_dttm)
select park_client_id, corp_order_flg,
     utc_order_created_hour, taximeter_park_id,
     success_orders_cnt, max_utc_order_created_dttm
from $res;