-- last = 28 + 1 day, full hours only
drop table if exists niksm_temp_park_orders_hourly_last;
create temporary table niksm_temp_park_orders_hourly_last as
with t as (
    select park_client_id,
           max(taximeter_park_id) over (partition by park_client_id) as taximeter_park_id,
           corp_order_flg,
           utc_order_created_hour::timestamp as utc_order_created_hour,
           success_orders_cnt,
           max(max_utc_order_created_dttm::timestamp) over (partition by park_client_id) as utc_last_park_order_dttm,
           max(max_utc_order_created_dttm::timestamp) over () as max_dttm_total
    from snb_delivery.niksm_park_orders_hourly_raw
)
select park_client_id,
       taximeter_park_id,
       corp_order_flg,
       utc_order_created_hour,
       success_orders_cnt,
       utc_last_park_order_dttm,
       date_trunc('hour',max_dttm_total) - interval '1 hour' as max_utc_hour_available
from t
where utc_order_created_hour between
    date_trunc('hour',max_dttm_total) - interval '29 days'
    and date_trunc('hour',max_dttm_total) - interval '1 hour';
analyse niksm_temp_park_orders_hourly_last;

-- base
drop table if exists niksm_temp_park_orders_hourly_base;
create temporary table niksm_temp_park_orders_hourly_base as
select park_client_id,
       max(taximeter_park_id) as taximeter_park_id,
       corp_order_flg,
       extract(hour from utc_order_created_hour)::int as hour_num,
       sum(success_orders_cnt) / 28. as success_orders_cnt_forecast,
       max(max_utc_hour_available) as max_utc_hour_available,
       max(utc_last_park_order_dttm) as utc_last_park_order_dttm
from niksm_temp_park_orders_hourly_last
where utc_order_created_hour <= max_utc_hour_available - interval '1 day'
group by park_client_id,
         corp_order_flg,
         extract(hour from utc_order_created_hour)::int;
analyse niksm_temp_park_orders_hourly_base;

-- fact
drop table if exists niksm_temp_park_orders_hourly_fact;
create temporary table niksm_temp_park_orders_hourly_fact as
select park_client_id,
       corp_order_flg,
       extract(hour from utc_order_created_hour)::int as hour_num,
       sum(success_orders_cnt) as success_orders_cnt_fact
from niksm_temp_park_orders_hourly_last
where utc_order_created_hour >= max_utc_hour_available - interval '1 day' + interval '1 hour'
group by park_client_id,
         corp_order_flg,
         extract(hour from utc_order_created_hour);
analyse niksm_temp_park_orders_hourly_fact;

drop table if exists niksm_temp_park_orders_hourly_res;
create temporary table niksm_temp_park_orders_hourly_res as
with t as (
    select base.park_client_id,
           base.taximeter_park_id,
           base.corp_order_flg,
           date_trunc('day',base.max_utc_hour_available)
               + make_time(base.hour_num,0,0)
               - case when base.hour_num > extract(hour from base.max_utc_hour_available)
                   then interval '1 day' else interval '0 day' end
            as utc_order_created_dttm,
           base.success_orders_cnt_forecast,
           base.max_utc_hour_available,
           coalesce(fact.success_orders_cnt_fact,0) as success_orders_cnt_fact,
           base.utc_last_park_order_dttm
    from niksm_temp_park_orders_hourly_base base
      left join niksm_temp_park_orders_hourly_fact fact
        on base.park_client_id = fact.park_client_id
        and base.corp_order_flg = fact.corp_order_flg
        and base.hour_num = fact.hour_num
)
select park_client_id, taximeter_park_id,
       corp_order_flg,
       utc_order_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as msk_order_created_dttm,
       extract(hour from max_utc_hour_available - utc_order_created_dttm)::int + 1 as order_created_lag,
       success_orders_cnt_forecast,
       success_orders_cnt_fact,
       utc_last_park_order_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as msk_last_park_order_dttm,
       max_utc_hour_available at time zone 'UTC' at time zone 'Europe/Moscow' as max_msk_hour_available
from t;

-- drop table if exists snb_delivery.niksm_park_orders_hourly_planfact;
-- create table snb_delivery.niksm_park_orders_hourly_planfact as
truncate table snb_delivery.niksm_park_orders_hourly_planfact;
insert into snb_delivery.niksm_park_orders_hourly_planfact
    (park_client_id, taximeter_park_id,
       corp_order_flg,
       msk_order_created_dttm, order_created_lag,
       success_orders_cnt_forecast, success_orders_cnt_fact,
       msk_last_park_order_dttm,
       max_msk_hour_available,
       planfact_flg)
select park_client_id, taximeter_park_id,
       corp_order_flg,
       msk_order_created_dttm, order_created_lag,
       success_orders_cnt_forecast, success_orders_cnt_fact,
       msk_last_park_order_dttm,
       max_msk_hour_available,
       true as planfact_flg
from niksm_temp_park_orders_hourly_res;

insert into snb_delivery.niksm_park_orders_hourly_planfact
    (park_client_id, taximeter_park_id,
       corp_order_flg,
       msk_order_created_dttm, order_created_lag,
       success_orders_cnt_forecast, success_orders_cnt_fact,
       msk_last_park_order_dttm,
       max_msk_hour_available,
       planfact_flg)
select park_client_id, taximeter_park_id,
       corp_order_flg,
       utc_order_created_hour at time zone 'UTC' at time zone 'Europe/Moscow' as msk_order_created_dttm,
       null as order_created_lag,
       null as success_orders_cnt_forecast,
       success_orders_cnt as success_orders_cnt_fact,
       utc_last_park_order_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as msk_last_park_order_dttm,
       max_utc_hour_available at time zone 'UTC' at time zone 'Europe/Moscow' as max_msk_hour_available,
       false as planfact_flg
from niksm_temp_park_orders_hourly_last
where utc_order_created_hour >= max_utc_hour_available - interval '7 day' + interval '1 hour'
  and utc_order_created_hour <= max_utc_hour_available - interval '1 day';

-- comment on table snb_delivery.niksm_park_orders_hourly_planfact is 'Витрина для дашборда Park orders hourly dynamics';

------------------------------------------------------------------------------------------------------------------------

-- select max(max_utc_order_created_dttm::timestamp) at time zone 'UTC' at time zone 'Europe/Moscow' as max_dttm_total
-- from snb_delivery.niksm_park_orders_hourly_raw;
--
-- select max(max_msk_hour_available) from snb_delivery.niksm_park_orders_hourly_planfact;
--
-- select planfact_flg, count()
-- from snb_delivery.niksm_park_orders_hourly_planfact
-- group by rollup(planfact_flg);
--
-- select msk_order_created_dttm,
--        order_created_lag,
--        max_msk_hour_available,
--        sum(success_orders_cnt_forecast),
--        sum(success_orders_cnt_fact)
-- from snb_delivery.niksm_park_orders_hourly_planfact
-- group by 1,2,3
-- order by 1;
--
-- select park_client_id,
--        sum(success_orders_cnt_forecast) as success_orders_cnt_forecast,
--        sum(success_orders_cnt_fact) as success_orders_cnt_fact,
--        sum(success_orders_cnt_fact) - sum(success_orders_cnt_forecast) as delta
-- from snb_delivery.niksm_temp_park_orders_hourly_res
-- group by 1
-- order by delta;
--
-- with t as (
--     select park_client_id, sum(success_orders_cnt) as success_orders_cnt,
--            row_number() over (order by sum(success_orders_cnt) desc) as rn,
--            (sum(sum(success_orders_cnt)) over (order by sum(success_orders_cnt) desc rows between unbounded preceding and current row ))::double precision
--             / sum(sum(success_orders_cnt)) over () as orders_share_accum
--     from snb_delivery.niksm_park_orders_hourly_raw
--     group by 1
-- )
-- select * from t order by rn;