WITH taxi_cntr as (
    select distinct "Contract_Num_Yandex_Taxi__c" as taxi_contract_id
    from snb_b2b.bmiklaz_ods_sf_b2b_contracts
    where "Contract_Num_Yandex_Taxi__c" is not null
      and "Contract_Num_Yandex_Taxi__c" <> ''
)
, blnc_inn_cargo as (
    select person_inn,
           string_agg(distinct contract_external_id,', ') as contracts_array,
           bool_or(crm6.contract_id is not null) as cargo_crm_flg,
           bool_or(taxi_cntr.taxi_contract_id is not null) as taxi_crm_flg
    from snb_b2b.niksm_b2b_balance_contract_info as blnc_cargo
      left join taxi_cntr
        on blnc_cargo.contract_external_id = taxi_cntr.taxi_contract_id
      left join snb_b2b.niksm_b2b_contracts_info crm6
        on crm6.contract_id = blnc_cargo.contract_external_id
        and crm6.which_crm = 6
    where legal_contract_cargo = 1
    group by person_inn
)
select bs.inn,
       bs.contract_id,
       --
       blnc.contract_external_id is not null as contract_in_billing,
       blnc.person_inn as billing_inn,
       case when blnc.legal_contract_taxi = 1 then 'ООО Яндекс.Такси'
            when blnc.legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
            end as legal_entity,
       blnc.contract_services,
       coalesce(blnc.is_active = 1, False) as contract_in_billing_is_active,
       --
       crm6.contract_id is not null as contract_in_cargo_crm,
       taxi_cntr.taxi_contract_id is not null as contract_in_taxi_crm,
       --
       coalesce(lk_cargo_is_active = 1, False) as lk_cargo_is_active,
       ----
       blnc_inn_cargo.person_inn is not null as some_cargo_contract_by_inn,
       blnc_inn_cargo.contracts_array as cargo_contracts_by_inn_array,
       coalesce(blnc_inn_cargo.cargo_crm_flg, False) as cargo_contract_by_inn_in_cargo_crm,
       coalesce(blnc_inn_cargo.taxi_crm_flg, False) as cargo_contract_by_inn_in_taxi_crm
from snb_b2b.niksm_logdata655_fullbase bs
  left join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = bs.contract_id
  left join snb_b2b.niksm_b2b_contracts_info crm6
    on crm6.contract_id = bs.contract_id
    and crm6.which_crm = 6
  left join taxi_cntr
    on taxi_cntr.taxi_contract_id = bs.contract_id
  left join snb_b2b.niksm_b2b_lk_contract_info lk
    on lk.contract_external_id = bs.contract_id
  left join blnc_inn_cargo
    on blnc_inn_cargo.person_inn = case when length(bs.inn)>4 then bs.inn else blnc.person_inn end;
