#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pandas as pd
import psycopg2
import datetime
import re
import json
import requests
pd.options.display.max_columns = 500
pd.options.display.max_colwidth = 10000
from yql.api.v1.client import YqlClient
import time
import logging

from b2b_mailer import main, main2, gp2df

import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

key_file = 'keys.json'

with open(key_file) as f:
    from_file = json.load(f)
con = f"postgresql://robot-corploader:{from_file['gp_token']}@gpdb-master.taxi.yandex.net:5432/ritchie"

# GP query
with open('logdata_655_taxi_contracts.sql') as f:
    query_GP = f.read()

df = pd.read_sql_query(query_GP, con)
logging.info(f"df len {len(df)}")


# name columns for excel
col_names = {
    'inn': 'ИНН из начального списка',
    'contract_id': 'Номер договора из начального списка',
    'contract_in_billing': 'В биллинге есть номер договора из начального списка',
    'billing_inn': 'ИНН, прописанный в биллинге к договору из начального списка',
    'legal_entity': 'ЮЛ по договору из начального списка',
    'contract_services': 'Сервис в биллинге по договору из начального списка',
    'contract_in_billing_is_active': 'Активность договора из начального списка в биллинге',
    'contract_in_cargo_crm': 'Наличие договора из начального списка в CRM Доставки',
    'contract_in_taxi_crm': 'Наличие договора из начального списка в CRM Такси',
    'lk_cargo_is_active': 'Активность доставки в админке по номеру договора из начального списка',
    'some_cargo_contract_by_inn': 'Наличие договора на ООО Яндекс.Доставка по ИНН из начального списка',
    'cargo_contracts_by_inn_array': 'Список договоров, если такие есть',
    'cargo_contract_by_inn_in_cargo_crm': 'Есть ли в CRM Доставки сделки с номером договора на ООО Яндекс.Доставка',
    'cargo_contract_by_inn_in_taxi_crm': 'Есть ли в CRM Такси сделки с номером договора на ООО Яндекс.Доставка'
}

key_key = 'gp_token'

main2(
    receivers_url=None,
    # add to receivers all people from specific groups at staff
    receivers_ancestors=None,
    # add to receivers people, who have listed groups above theirs
    receivers_logins=None,  # add to receivers people by logins
    exclude_logins=None,
    mail_name='LOGDATA-655 (Целевое состояние)',  # name of letter
    mail_text='.',  # body of letter
    mail_cc=['niksm@yandex-team.ru', 'ferenec@yandex-team.ru'],  # send a copy to listed emails
    hierarchy=True,
    # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
    emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
    key_file=key_file,  # where the keys are
    key_key=key_key,  # key of gp token in file
    flat=['ferenec'], #'v-kats' # list of emails. mail all rows to these addresses
    user='robot-corploader',
    sheets=[
        {'query': None,
         'df': df,
         'exclude_columns': None,
         'col_names': col_names,
         'sheet_name': 'data'},
    ]
)

logging.info('SUCCESS')
