#!/usr/bin/env python
# coding: utf-8

import pandas as pd
from business_models import greenplum, hahn
from business_models.greenplum import GreenplumManager
import json
with open('keys.json') as f:
    keys = json.load(f)
gp_user = 'robot-sam-bridges'
gp_token = keys['sam_gp_token']
greenplum = GreenplumManager(user=gp_user, token = gp_token)

import argparse
import datetime
from datetime import datetime as dt
import logging

import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

with open ('logdata_855_corp_tariff_client_zone.sql') as f:
    sql_template = f.read()

# v_datefrom_str = (datetime.date.today() - datetime.timedelta(days = 13)).strftime('%Y-%m-%d')
# v_dateto_str = datetime.date.today().strftime('%Y-%m-%d')
# sql = sql_template.format(utc_datefrom = v_datefrom_str, utc_dateto = v_dateto_str)
# greenplum(sql)
# logging.info(f"data loaded from {v_datefrom_str} to {v_dateto_str}")

def main_week():
    logging.info('main_week start')
    v_period_type = 'week'
    v_datefrom_str = (datetime.date.today()
                      + datetime.timedelta(days = (
                        -datetime.date.today().isoweekday()+1-7))
                      ).strftime('%Y-%m-%d')
    v_dateto_str = (datetime.date.today()
                      + datetime.timedelta(days = (
                        -datetime.date.today().isoweekday()+1-1))
                      ).strftime('%Y-%m-%d')
    sql = sql_template.format(period_type = v_period_type, datefrom = v_datefrom_str, dateto = v_dateto_str)
    greenplum(sql)
    logging.info('main_week completed')

def main_month():
    logging.info('main_month start')
    v_period_type = 'month'
    v_datefrom_str = (datetime.date.today().replace(day=1) - datetime.timedelta(days = 1)).replace(day=1).strftime('%Y-%m-%d')
    v_dateto_str = (datetime.date.today().replace(day=1) - datetime.timedelta(days = 1)).strftime('%Y-%m-%d')
    sql = sql_template.format(period_type = v_period_type, datefrom = v_datefrom_str, dateto = v_dateto_str)
    greenplum(sql)
    logging.info('main_month completed')


main_week()
main_month()

logging.info('SUCCESS')