-- Распил snb_b2b.niksm_b2b_tariffs по колонкам --
drop table if exists niksm_temp_855_corp_tariffs;
create temporary table niksm_temp_855_corp_tariffs as
with t as (
    select *,
           replace(
               replace(
                   replace(
                       replace(
                           replace(
                               replace(
                                   replace(
                                       special_taximeters,
                                       '{{''','{{"'),
                                   '''}}','"}}'),
                               ': ''',': "'),
                           ''':','":'),
                       ', ''',', "'),
                   ''', ','", '),
               'None','null') :: json as special_taximeters_json,
           replace(
               replace(
                   replace(
                       replace(
                           replace(
                               replace(
                                   replace(
                                       summable_requirements,
                                       '{{''','{{"'),
                                   '''}}','"}}'),
                               ': ''',': "'),
                           ''':','":'),
                       ', ''',', "'),
                   ''', ','", '),
               'None','null') :: json as summable_requirements_json
    from snb_b2b.niksm_b2b_tariffs
    where true
      and class_name in ('courier','express')
)
select t.tariff_series_id,
       t.tariff_series_name,
       t.dttm_from,
       t.dttm_to,
       t.class_name,
       t.day_type,
       t.name_key,
       t.category_type,
       t.updated_dttm,
       --
       t.disable_surge,
       t.inherited,
       t.add_minimal_to_paid_cancel,
       t.minimal,
       t.paid_cancel_fix,
       t.waiting_included,
       t.waiting_price,
       t.waiting_price_type,
       st.*,
       sr.*
from t
     cross join lateral (
         select max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 0 ->> 'begin')::double precision end) as distance_price_intervals_home_1st_begin,
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 0 ->> 'end')::double precision end) as distance_price_intervals_home_1st_end,
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 0 ->> 'price')::double precision end) as distance_price_intervals_home_1st_price,
                --
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 1 ->> 'begin')::double precision end) as distance_price_intervals_home_2nd_begin,
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 1 ->> 'end')::double precision end) as distance_price_intervals_home_2nd_end,
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 1 ->> 'price')::double precision end) as distance_price_intervals_home_2nd_price,
                ----
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 0 ->> 'begin')::double precision end) as time_price_intervals_home_1st_begin,
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 0 ->> 'end')::double precision end) as time_price_intervals_home_1st_end,
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 0 ->> 'price')::double precision end) as time_price_intervals_home_1st_price,
                --
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 1 ->> 'begin')::double precision end) as time_price_intervals_home_2nd_begin,
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 1 ->> 'end')::double precision end) as time_price_intervals_home_2nd_end,
                max(case when (special_taximeters_zone ->> 'zone_name') = home_zone
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 1 ->> 'price')::double precision end) as time_price_intervals_home_2nd_price,
                ------
                ------
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 0 ->> 'begin')::double precision end) as distance_price_intervals_suburb_1st_begin,
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 0 ->> 'end')::double precision end) as distance_price_intervals_suburb_1st_end,
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 0 ->> 'price')::double precision end) as distance_price_intervals_suburb_1st_price,
                --
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 1 ->> 'begin')::double precision end) as distance_price_intervals_suburb_2nd_begin,
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 1 ->> 'end')::double precision end) as distance_price_intervals_suburb_2nd_end,
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,distance_price_intervals}}'
                              -> 1 ->> 'price')::double precision end) as distance_price_intervals_suburb_2nd_price,
                ----
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 0 ->> 'begin')::double precision end) as time_price_intervals_suburb_1st_begin,
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 0 ->> 'end')::double precision end) as time_price_intervals_suburb_1st_end,
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 0 ->> 'price')::double precision end) as time_price_intervals_suburb_1st_price,
                --
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 1 ->> 'begin')::double precision end) as time_price_intervals_suburb_2nd_begin,
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 1 ->> 'end')::double precision end) as time_price_intervals_suburb_2nd_end,
                max(case when (special_taximeters_zone ->> 'zone_name') = 'suburb'
                    then (special_taximeters_zone #> '{{price,time_price_intervals}}'
                              -> 1 ->> 'price')::double precision end) as time_price_intervals_suburb_2nd_price
         from (select t.home_zone, json_array_elements(t.special_taximeters_json) as special_taximeters_zone) st0
         ) st
    cross join lateral (
        select max(case when summable_requirements_prm ->> 'type' = 'waiting_in_transit'
                    then (summable_requirements_prm ->> 'max_price')::double precision end) as waiting_in_transit_price,
               max(case when summable_requirements_prm ->> 'type' = 'door_to_door'
                    then (summable_requirements_prm ->> 'max_price')::double precision end) as door_to_door_price,
               max(case when summable_requirements_prm ->> 'type' = 'fake_middle_point_express'
                    then (summable_requirements_prm ->> 'max_price')::double precision end) as fake_middle_point_express_price
        from (select json_array_elements(t.summable_requirements_json) as summable_requirements_prm) sr0
    ) sr
distributed by (tariff_series_id)
;
--
analyze niksm_temp_855_corp_tariffs;
-- select * from niksm_temp_855_corp_tariffs limit 10;

-- endof Распил snb_b2b.niksm_b2b_tariffs по колонкам --

------------------------------------------------------------------------------------------------------------------------

drop table if exists niksm_temp_855_dlv;
create temporary table niksm_temp_855_dlv as
select fct.order_id,
       fct.utc_order_created_dttm,
       fct.msk_order_created_dt,
       fct.corp_client_id,
       lk_client_name as corp_client_name,
       case when crm.manager_group in ('INTERCO') then 2
           when crm.manager_group in ('ГПП 1','ГПП 2') then 1
           else 0 end as gpp_client,
       fct.tariff_class_code,
       fct.tariff_geo_zone_code,
       fct.decoupling_success_flg,
       case when fct.decoupling_success_flg then
           coalesce(sign(fct.decoupling_user_cost - fct.decoupling_driver_cost),0)
           else 0 end as decoupling_sign,
       case when fct.decoupling_success_flg then fct.decoupling_user_cost end as decoupling_user_cost,
       case when fct.decoupling_success_flg then fct.decoupling_driver_cost end as decoupling_driver_cost,
       fct.driver_cost,
       --
       delivery_point_cnt as deliveries_cnt,
       fct.gmv_amt * fct.currency_rate as gmv,
       fct.gross_commission_revenue_amt * fct.currency_rate as gross_commission_revenue,
       fct.incentives_amt * fct.currency_rate as incentives,
       case when fct.decoupling_success_flg then
           (fct.decoupling_user_cost - fct.decoupling_driver_cost) * fct.currency_rate else 0 end
           as decoupling_fee,
       (fct.gross_commission_revenue_amt - fct.incentives_amt
            + case when fct.decoupling_success_flg then
                fct.decoupling_user_cost - fct.decoupling_driver_cost else 0 end) * fct.currency_rate as net_inflow,
       transporting_distance_plan_km as travel_distance_km,
       fct.country_name_ru
from taxi_cdm_marketplace.fct_order_metric as fct
  left join snb_b2b.niksm_b2b_lk_client_service_info lk
    on lk.lk_client_id = fct.corp_client_id
    and lk_service_name = 'cargo'
  JOIN snb_delivery.logdata_delivery_tariff logtrf
    ON logtrf.order_tariff = fct.tariff_class_code
    and fct.utc_order_created_dttm between utc_datefrom and utc_dateto
  left join snb_b2b.niksm_b2b_contracts_info as crm
    on crm.contract_id = fct.corp_contract_id
where fct.success_order_flg
  and fct.corp_order_flg
--and fct.country_name_ru = 'Россия'
  and fct.tariff_class_code in ('courier','express')
  and fct.utc_order_created_dttm >= '{datefrom}'::date - interval '1 day'
  and msk_order_created_dt between '{datefrom}'::date and '{dateto}'::date
--   and fct.utc_order_created_dttm >= date_trunc('month',current_date) - interval '1 month' - interval '1 day'
--   and msk_order_created_dt
--       between date_trunc('month',current_date)::date - interval '1 month'
--       and date_trunc('month',current_date)::date - interval '1 day'
distributed by (utc_order_created_dttm)
;
--
analyse niksm_temp_855_dlv;

-- select min(msk_order_created_dt), max(msk_order_created_dt), count() from niksm_temp_855_dlv;

drop table if exists niksm_temp_855_res;
create temporary table niksm_temp_855_res as
with dlv_trf0 as (
    select dlv,
    --        ctp.date_from as client_tariff_plan_date_from,
    --        ctp.date_to as client_tariff_plan_date_to,
           tp.tariff_plan_series_id,
           tp.tariff_plan_series_name,
           trf,
           current_timestamp >= ctp.dttm_from
            and (current_timestamp < ctp.dttm_to or ctp.dttm_to is null)
            and current_timestamp >= tp.dttm_from
            and (current_timestamp < tp.dttm_to or tp.dttm_to is null)
            and current_timestamp >= trf.dttm_from
            and (current_timestamp < trf.dttm_to or trf.dttm_to is null) as actual_tariff_flg,
           greatest(ctp.dttm_from,tp.dttm_from,trf.dttm_from)::date as tariff_dt_from,
           row_number() over (partition by (dlv).order_id
               order by ctp.updated_dttm desc nulls last,
                   tp.updated_dttm desc nulls last,
                   trf.updated_dttm desc nulls last
                   ) as rn
    from niksm_temp_855_dlv dlv
      left join snb_b2b.niksm_b2b_client_tariff_plans as ctp
        on ctp.client_id = dlv.corp_client_id
        and dlv.utc_order_created_dttm >= ctp.dttm_from
        and (dlv.utc_order_created_dttm < ctp.dttm_to or ctp.dttm_to is null)
        and ctp.service = 'cargo'
      left join snb_b2b.niksm_b2b_tariff_plans as tp
        on tp.tariff_plan_series_id = ctp.tariff_plan_series_id
        and dlv.utc_order_created_dttm >= tp.dttm_from
        and (dlv.utc_order_created_dttm < tp.dttm_to or tp.dttm_to is null)
        and tp.tariff_zone = dlv.tariff_geo_zone_code
      left join niksm_temp_855_corp_tariffs as trf
        on trf.tariff_series_id = tp.tariff_series_id
        and dlv.utc_order_created_dttm >= trf.dttm_from
        and (dlv.utc_order_created_dttm < trf.dttm_to or trf.dttm_to is null)
        and trf.class_name = dlv.tariff_class_code
        and trf.day_type = 2
        and trf.name_key = 'interval.always'
        and trf.category_type = 'application'
)
, dlv_trf as (
    select (dlv).*,
           tariff_plan_series_id,
           tariff_plan_series_name,
           (trf).*,
           actual_tariff_flg,
           tariff_dt_from
    from dlv_trf0
    where rn = 1
)
select tariff_class_code as order_tariff,
       tariff_geo_zone_code as tariff_zone,
       tariff_plan_series_id,
       tariff_plan_series_name,
       tariff_series_id,
       tariff_series_name,
       actual_tariff_flg,
       min(tariff_dt_from) as tariff_dt_from,
       count() as orders_cnt,
       sum(deliveries_cnt) as deliveries_cnt,
       sum(gmv) as gmv,
       sum(gross_commission_revenue) as gross_commission_revenue,
       sum(incentives) as incentives,
       sum(decoupling_fee) as decoupling_fee,
       sum(decoupling_user_cost) as decoupling_user_cost,
       sum(decoupling_driver_cost) as decoupling_driver_cost,
       sum(driver_cost) as driver_cost,
       sum(net_inflow) as net_inflow,
       sum(travel_distance_km) as travel_distance_km,
       sum(greatest(0.,travel_distance_km - 10.)) as travel_distance_km_far,
       sum((travel_distance_km > 0)::int) as orders_cnt_km_defined,
       sum(case when travel_distance_km > 0 then deliveries_cnt end) as deliveries_cnt_km_defined,
       sum(case when travel_distance_km > 0 then gmv end)            as gmv_km_defined,
       case when sum(case when travel_distance_km > 0 then deliveries_cnt end) > 0
           then sum(travel_distance_km) / sum(case when travel_distance_km > 0 then deliveries_cnt end)
           end as avg_deliverie_km,
       case when sum(travel_distance_km) > 0
           then sum(case when travel_distance_km > 0 then gmv end) / sum(travel_distance_km)
           end as km_price_incl_vat,
       case when sum(gmv) > 0
           then sum(net_inflow) / sum(gmv) end as ni_prc,
       --
       count(distinct corp_client_id) as clients_cnt,
       max(gpp_client) as gpp_client,
       case when tariff_plan_series_id is not null then
           substr(string_agg(distinct corp_client_name,', '),1,1000)
           end as clients_array,
       sum(sum(deliveries_cnt)) over (partition by tariff_geo_zone_code) as geo_zone_dlv,
       --
       disable_surge, add_minimal_to_paid_cancel, minimal, paid_cancel_fix, waiting_included, waiting_price, waiting_price_type,
       distance_price_intervals_home_1st_begin, distance_price_intervals_home_1st_end, distance_price_intervals_home_1st_price,
       distance_price_intervals_home_2nd_begin, distance_price_intervals_home_2nd_end, distance_price_intervals_home_2nd_price,
       time_price_intervals_home_1st_begin, time_price_intervals_home_1st_end, time_price_intervals_home_1st_price,
       time_price_intervals_home_2nd_begin, time_price_intervals_home_2nd_end, time_price_intervals_home_2nd_price,
       distance_price_intervals_suburb_1st_begin, distance_price_intervals_suburb_1st_end, distance_price_intervals_suburb_1st_price,
       distance_price_intervals_suburb_2nd_begin, distance_price_intervals_suburb_2nd_end, distance_price_intervals_suburb_2nd_price,
       time_price_intervals_suburb_1st_begin, time_price_intervals_suburb_1st_end, time_price_intervals_suburb_1st_price,
       time_price_intervals_suburb_2nd_begin, time_price_intervals_suburb_2nd_end, time_price_intervals_suburb_2nd_price,
       waiting_in_transit_price, door_to_door_price, fake_middle_point_express_price, country_name_ru
from dlv_trf
group by tariff_class_code,
         tariff_geo_zone_code,
         tariff_plan_series_id,
         tariff_plan_series_name,
         tariff_series_id,
         tariff_series_name,
         actual_tariff_flg,
         --
         disable_surge, add_minimal_to_paid_cancel, minimal, paid_cancel_fix, waiting_included, waiting_price, waiting_price_type,
       distance_price_intervals_home_1st_begin, distance_price_intervals_home_1st_end, distance_price_intervals_home_1st_price,
       distance_price_intervals_home_2nd_begin, distance_price_intervals_home_2nd_end, distance_price_intervals_home_2nd_price,
       time_price_intervals_home_1st_begin, time_price_intervals_home_1st_end, time_price_intervals_home_1st_price,
       time_price_intervals_home_2nd_begin, time_price_intervals_home_2nd_end, time_price_intervals_home_2nd_price,
       distance_price_intervals_suburb_1st_begin, distance_price_intervals_suburb_1st_end, distance_price_intervals_suburb_1st_price,
       distance_price_intervals_suburb_2nd_begin, distance_price_intervals_suburb_2nd_end, distance_price_intervals_suburb_2nd_price,
       time_price_intervals_suburb_1st_begin, time_price_intervals_suburb_1st_end, time_price_intervals_suburb_1st_price,
       time_price_intervals_suburb_2nd_begin, time_price_intervals_suburb_2nd_end, time_price_intervals_suburb_2nd_price,
       waiting_in_transit_price, door_to_door_price, fake_middle_point_express_price, country_name_ru
order by geo_zone_dlv desc,
         tariff_zone,
         order_tariff,
         deliveries_cnt desc
;
analyse niksm_temp_855_res;

-- drop table if exists snb_delivery.niksm_corp_tariff_client_zone;
-- create table snb_delivery.niksm_corp_tariff_client_zone as
----
delete from snb_delivery.niksm_corp_tariff_client_zone
where true
  and period_type = '{period_type}';
--
insert into snb_delivery.niksm_corp_tariff_client_zone
    (order_tariff, tariff_zone,
       tariff_plan_series_id, tariff_plan_series_name, tariff_series_id, tariff_series_name, actual_tariff_flg, tariff_dt_from,
       orders_cnt, deliveries_cnt, gmv, gross_commission_revenue, incentives,
       decoupling_fee, decoupling_user_cost, decoupling_driver_cost, driver_cost, net_inflow,
       travel_distance_km, travel_distance_km_far, orders_cnt_km_defined, deliveries_cnt_km_defined, gmv_km_defined, avg_deliverie_km, km_price_incl_vat,
       ni_prc, clients_cnt, gpp_client, clients_array, geo_zone_dlv,
       disable_surge, add_minimal_to_paid_cancel, minimal, paid_cancel_fix,
       waiting_included, waiting_price, waiting_price_type,
       distance_price_intervals_home_1st_begin, distance_price_intervals_home_1st_end, distance_price_intervals_home_1st_price,
       distance_price_intervals_home_2nd_begin, distance_price_intervals_home_2nd_end, distance_price_intervals_home_2nd_price,
       time_price_intervals_home_1st_begin, time_price_intervals_home_1st_end, time_price_intervals_home_1st_price,
       time_price_intervals_home_2nd_begin, time_price_intervals_home_2nd_end, time_price_intervals_home_2nd_price,
       distance_price_intervals_suburb_1st_begin, distance_price_intervals_suburb_1st_end, distance_price_intervals_suburb_1st_price,
       distance_price_intervals_suburb_2nd_begin, distance_price_intervals_suburb_2nd_end, distance_price_intervals_suburb_2nd_price,
       time_price_intervals_suburb_1st_begin, time_price_intervals_suburb_1st_end, time_price_intervals_suburb_1st_price,
       time_price_intervals_suburb_2nd_begin, time_price_intervals_suburb_2nd_end, time_price_intervals_suburb_2nd_price,
       waiting_in_transit_price, door_to_door_price, fake_middle_point_express_price,
       period_type, period, etl_dttm,country_name_ru)
--
select order_tariff, tariff_zone,
       tariff_plan_series_id, tariff_plan_series_name, tariff_series_id, tariff_series_name, actual_tariff_flg, tariff_dt_from,
       orders_cnt, deliveries_cnt, gmv, gross_commission_revenue, incentives,
       decoupling_fee, decoupling_user_cost, decoupling_driver_cost, driver_cost, net_inflow,
       travel_distance_km, travel_distance_km_far, orders_cnt_km_defined, deliveries_cnt_km_defined, gmv_km_defined, avg_deliverie_km, km_price_incl_vat,
       ni_prc, clients_cnt, gpp_client, clients_array, geo_zone_dlv,
       disable_surge, add_minimal_to_paid_cancel, minimal, paid_cancel_fix,
       waiting_included, waiting_price, waiting_price_type,
       distance_price_intervals_home_1st_begin, distance_price_intervals_home_1st_end, distance_price_intervals_home_1st_price,
       distance_price_intervals_home_2nd_begin, distance_price_intervals_home_2nd_end, distance_price_intervals_home_2nd_price,
       time_price_intervals_home_1st_begin, time_price_intervals_home_1st_end, time_price_intervals_home_1st_price,
       time_price_intervals_home_2nd_begin, time_price_intervals_home_2nd_end, time_price_intervals_home_2nd_price,
       distance_price_intervals_suburb_1st_begin, distance_price_intervals_suburb_1st_end, distance_price_intervals_suburb_1st_price,
       distance_price_intervals_suburb_2nd_begin, distance_price_intervals_suburb_2nd_end, distance_price_intervals_suburb_2nd_price,
       time_price_intervals_suburb_1st_begin, time_price_intervals_suburb_1st_end, time_price_intervals_suburb_1st_price,
       time_price_intervals_suburb_2nd_begin, time_price_intervals_suburb_2nd_end, time_price_intervals_suburb_2nd_price,
       waiting_in_transit_price, door_to_door_price, fake_middle_point_express_price,
       '{period_type}' as period_type,
       '{datefrom} - {dateto}' as period,
       current_timestamp as etl_dttm,country_name_ru
from niksm_temp_855_res;

