import pandas as pd
import psycopg2
from business_models import hahn
from business_models.hahn import HahnDataLoader
import json

import datetime
import logging

import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

import os

#os.environ[‘TAXI_DB_CRM_TOKEN’]

# key_file='keys.json'
# with open(key_file) as f:
#     from_file = json.load(f)

yt_token = os.environ['SAM_YT_TOKEN']
HahnDataLoader(token=yt_token)

def get_pgaas_cursor():
    gp_conn = psycopg2.connect(f"""
            host=man-afo7rwg5g8jaawuo.db.yandex.net,sas-m231jv0kb0j2hdg8.db.yandex.net,vla-hj70jdv5mecxgnvx.db.yandex.net
            port=6432
            dbname=taxi_db_crm_shard0
            user=taxi
            password={os.environ['TAXI_DB_CRM_TOKEN']}
            sslmode=require
            target_session_attrs=read-write""")
    return gp_conn
con_pgaas = get_pgaas_cursor()

# LOGDATA-713

sql = """
    with t as (
        select date_,
            (case when substr(data,1,1) = '[' then '' else '[' end ||
                    replace(data, '}{', '},{') ||
                case when substr(data,1,1) = '[' then '' else ']' end
                )::json as data_json
        from analyst.voytekh_raw_cisco_calls
        where date_ >= '2021-08-01'
          and substr(data,2,1) in ('{','"')
    )
    , tt as (
        select date_,
               json_array_elements(data_json) as qqq
        from t
    )
    select date_::text as record_dttm,
           qqq ->> 'Cisco-Guid' as cisco_guid,
           (qqq ->> 'call_duration')::int as call_duration,
           qqq ->> 'number_A' as number_a,
           qqq ->> 'number_B' as number_b,
           qqq ->> 'recording_url' as recording_url,
           (to_timestamp((
               substr(qqq ->> 'Event-Date-Timestamp',1,10) ||
                    case when length(qqq ->> 'Event-Date-Timestamp') > 10
                        then '.' || substr(qqq ->> 'Event-Date-Timestamp',11,6)
                        else '' end)::double precision))::text as event_dttm,
           case when (qqq ->> 'call_duration')::int > 0 then
               'http://s3.mds.yandex.net/taxi-biz/' || (qqq ->> 'Cisco-Guid') || '.wav' end as call_link
    from tt
    where (qqq ->> 'Cisco-Guid') is not null
"""

df = pd.read_sql(sql=sql, con=con_pgaas)

types = {
    'record_dttm': 'String',
    'cisco_guid': 'String',
    'call_duration': 'Int32?',
    'number_a': 'String?',
    'number_b': 'String?',
    'recording_url': 'String?',
    'event_dttm': 'String?',
    'call_link': 'String?'
}

hahn.write_table('home/taxi-delivery/analytics/production/b2b/support/cisco_calls', df, types=types)

logging.info(f"cisco_calls loaded, df len = {len(df)}")

# LOGDATA-741

sql = f"""
    select
      dt::text as record_dttm,
      data_ ->> 'Guid' as guid,
      (data_ ->> 'call_duration')::int as call_duration,
      data_ ->> 'number_a' as number_a,
      data_ ->> 'number_b' as number_b,
           (to_timestamp((
               substr(data_ ->> 'Event-Date-Timestamp',1,10) ||
                    case when length(data_ ->> 'Event-Date-Timestamp') > 10
                        then '.' || substr(data_ ->> 'Event-Date-Timestamp',11,6)
                        else '' end)::double precision))::text as event_dttm,
           case when (data_ ->> 'call_duration')::int > 0 then
               'http://s3.mds.yandex.net/taxi-biz/' || (data_ ->> 'Guid') || '.wav' end as call_link
    from analyst.cisco_calls_v2
"""

df = pd.read_sql(sql=sql, con=con_pgaas)

types = {
    'record_dttm': 'String',
    'guid': 'String',
    'call_duration': 'Int32?',
    'number_a': 'String?',
    'number_b': 'String?',
    'event_dttm': 'String?',
    'call_link': 'String?'
}

hahn.write_table('home/taxi-delivery/analytics/production/b2b/support/total_calls', df, types=types)

logging.info(f"total_calls loaded, df len = {len(df)}, SUCCESS")