drop view if exists snb_b2b.dbcorp_client_tariff_plan_current;
create or replace view snb_b2b.dbcorp_client_tariff_plan_current as
with client_tariff_plan_cur as (
    select (ctp0).*
    from (
        select ctp0,
               row_number() over (partition by corp_client_id, service_name
                   order by utc_updated_dttm desc nulls last) as rn_tp
        from taxi_ods_dbcorp.client_tariff_plan as ctp0
        where true
          and tariff_plan_valid_from_dttm <= current_timestamp
          and (tariff_plan_valid_to_dttm > current_timestamp or tariff_plan_valid_to_dttm is null)
    ) q
    where rn_tp = 1
)
, tariff_plan_cur as (
    select (tp0).*
    from (
        select tp0,
               row_number() over (partition by tariff_plan_series_id order by utc_updated_dttm desc nulls last) as rn_tp
        from taxi_ods_dbcorp.tariff_plan as tp0
        where true
          and date_from_dttm <= current_timestamp
          and (date_to_dttm > current_timestamp or date_to_dttm is null)
    ) q
    where rn_tp = 1
)
select ctp.client_tariff_plan_id,
       ctp.corp_client_id,
       ctp.service_name,
       ctp.tariff_plan_series_id,
       ctp.tariff_plan_valid_from_dttm as client_tariff_plan_from_dttm,
       ctp.tariff_plan_valid_to_dttm as client_tariff_plan_to_dttm,
       --
       tp.country_code_en,
       tp.date_from_dttm as tariff_plan_from_dttm,
       tp.date_to_dttm as tariff_plan_to_dttm,
       tp.multiplier_rate,
       tp.tariff_plan_id,
       tp.tariff_plan_name,
       tp.wo_fixed_price_flg,
       tp.wo_tariff_fallback_flg
from client_tariff_plan_cur as ctp
  join tariff_plan_cur as tp
    on ctp.tariff_plan_series_id = tp.tariff_plan_series_id;

comment on view snb_b2b.dbcorp_client_tariff_plan_current is 'Текущие тарифные планы на уровне клиентов. Автор niksm. Заменить на объект DWH, когда появится';
