insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_logdata_462_kfc_report', 'Start', clock_timestamp());

drop table if exists niksm_temp_logdata_462_kfc_report_res;
create temporary table niksm_temp_logdata_462_kfc_report_res as
with store_geohash_dict (store_name, lat, lon, YUM_ID) as (
    values
        ('KFC Mega Almaty',43.202163, 76.892707,74013921),
        ('KFC Maxima Almaty',43.264596, 76.899658,74020383),
        ('KFC Aport Almaty',43.233863, 76.778087,74020413),
        ('KFC Essentay Almaty',43.218225, 76.928093,74020445),
        ('KFC Dostyk Plaza Almaty',43.234055, 76.953324,74020561),
        ('KFC Mega Expo Mall Astana',51.088593, 71.409015,74021009),
        ('KFC Forum Mall Almaty',43.234626, 76.935723,74020966),
        ('KFC Mart Almaty',43.334847, 76.953385,74021599),
        ('KFC Merey Almaty',43.271991, 76.949993,74020459),
        ('KFC VAZ Almaty',43.341467, 76.984327,74021314),
        ('KFC Kulager Almaty',43.301256, 76.930436,74021284),
        ('KFC ADK Mall Almaty',43.233321, 76.880047,74020388),
        ('KFC Gogolya Almaty',43.260647, 76.953534,74020401),
        ('KFC Magnum Almaty',43.218468, 76.844766,74021940),
        ('KFC Tole Bi Almaty',43.252763, 76.911990,74020748),
        ('KFC Moscow Mall Almaty',43.227395, 76.864081,74020845),
        ('KFC Atakent Almaty',43.225209, 76.909078,74020720),
        ('KFC Boulan Sholak Almaty',43.240704, 76.926144,74020800),
        ('KFC Silk Way Almaty',43.254516, 76.937318,74013345),
        ('KFC Kazgu Almaty',43.227070, 76.922354,74021257),
        ('KFC Ainabulak Almaty',43.319463, 76.916692,74021372),
        ('KFC TSUM Almaty',43.262501, 76.940067,74021550),
        ('KFC Malika Almaty',43.250721, 76.880391,74021549),
        ('KFC Domillion Almaty',43.253454, 76.838859,74015698),
        ('KFC Globus Almaty',43.240336, 76.905782,74021884),
        ('KFC Keruen Astana',51.128127, 71.425356,74020380),
        ('KFC Asia Park Astana',51.127681, 71.412606,74020755),
        ('KFC Sary Arka Astana',51.138427, 71.410543,74020819),
        ('KFC Mega Park Almaty',43.263175, 76.931291,74020563),
        ('KFC Manasa Astana',51.145823, 71.461028,74015981),
        ('KFC Bogenbay Batyr Astana',51.175311, 71.402311,74020562),
        ('KFC Oasis Astana',51.142209, 71.484681,74020728),
        ('KFC Green Astana',51.171598, 71.439411,74020564),
        ('KFC Mechta Astana',51.149004, 71.445691,74020560),
        ('KFC Golden Key Astana',51.185519, 71.407694,74020801),
        ('KFC Nomad Astana',51.114595, 71.416410,74020475),
        ('KFC Astrakhanka Astana',51.181771, 71.375476,74021203),
        ('KFC Keruen City Aktobe',50.289243, 57.193640,74021136),
        ('KFC Central Stadium Aktobe',50.294039, 57.157742,74021074),
        ('KFC Baizaar Atyrau',47.106723, 51.899843,74020846),
        ('KFC Flag Karaganda',49.788183, 73.135954,74020820),
        ('KFC City Mall Karaganda',49.800176, 73.087977,74020844),
        ('KFC Batyr Mall Pavlodar',52.274224, 76.987757,74020841),
        ('KFC Kutuzova Pavlodar',52.267607, 76.967225,74021644),
        ('KFC Shymkent Plazza Shymkent',42.314564, 69.587739,74021027),
        ('KFC Limon Shimkent',42.321787, 69.586443,74021212),
        ('KFC Sever Shymkent',42.339634, 69.639644,74021598),
        ('KFC Neftek Uralsk',51.246038, 51.394640,74021213),
        ('KFC Alem Plaza Uralsk',51.217459, 51.379574,74021143),
        ('KFC Atameken Taldykorgan',45.020121, 78.377883,74021551),
        ('KFC Pobeda Ust-Kamenogorsk',49.948806, 82.617250,74021373),
        ('KFC Mart Kostanay',53.212182, 63.638528,74021739),
        ('KFC Masato Almaty',43.211504, 76.869189,74021885),
        ('KFC Saryarka Almaty',43.229928, 76.856862,74021882),
        ('KFC Magnum Edil Nur-Sultan',51.144602, 71.528079,74021881),
        ('KFC Aray Kyzylorda',44.807413, 65.51904,74021933),
        ('KFC Shum Aktau',43.637465, 51.165689,74021886)
)
, dlv as (
    select *,
           min(case when success_order_flg then utc_created_dttm end) over (partition by destination_contact_phone_pd_id) as user_first_order
    from snb_delivery.niksm_fct_delivery
    where true
        and utc_created_dttm >= date_trunc('month', current_date-7)
        and utc_created_dttm < current_date
      and corp_client_id = '2cdaf1bb11d14b6687c51fe416a5df21'       -- corp_client_id в 2 местах
)
,ext_t as (
    select cargo_ref_id,
           coalesce(max(case when point_type = 'destination' then point.external_order_id end),
                    max(case when point_type = 'source' then point.external_order_id end)) as external_order_id
    from delivery_ods_cargo_claims.point
      join delivery_ods_cargo_claims.claim_point
        using (point_id)
      join delivery_ods_cargo_claims.claim
        using (claim_id)
    where true
      and point.utc_created_dttm >= date_trunc('month', current_date-7) - interval '3 days'
      and claim_point.utc_created_dttm >= date_trunc('month', current_date-7) - interval '3 days'
      and claim.utc_created_dttm >= date_trunc('month', current_date-7) - interval '3 days'
      and corp_client_id = '2cdaf1bb11d14b6687c51fe416a5df21'                       -- corp_client_id в 2 местах
    group by cargo_ref_id
)
, t as (
    SELECT dlv.cargo_ref_id                    as order_id,
           '0'                             as pr_counting,
           store_geohash_dict.YUM_ID   as id_at,
--            source_address,
           '1'                             as without_cashregister,
           utc_accepted_dttm               as time,
           'closed'                        as status,
           'delivery'                      as type,
           'online'                        as payment_method,
        /*items.product_count*/
           NULL                            as product_count,
        /*items.product_price*/
           NULL                            as product_price,
           claim_final_price_wo_vat_cur    as delivery_price,
           external_order_id                    as order_vdu,
           'Yandex Delivery'               as fio,
           'Yandex Delivery'               as courier_firm,
           '74959999999'                   as courier_phone,
           destination_contact_phone_pd_id as user_phone,
           user_first_order,
           utc_lookup_dttm                 as courier_search_start_ts,
           utc_found_dttm                  as delivery_status_wait_for_courier_payment_ts,
           utc_a_arrived_dttm              as delivery_status_courier_paid_for_order_ts,
           utc_a_visited_dttm              as delivery_status_in_delivery_ts,
           utc_cancelled_dttm              as canceled_at,
           utc_b_visited_last_dttm         as delivery_status_delivered_ts,
           case
               when claim_status_code in ('delivered', 'delivered_finish')
                   and utc_b_visited_last_dttm > utc_accepted_dttm
                   then case
                            when extract(epoch from utc_b_visited_last_dttm - utc_accepted_dttm) <= 45 * 60 -- 45 min
                                then 'yes'
                            else 'no'
                   end
               end                         as promise_fulfilled,
           case
               when claim_status_code in ('delivered', 'delivered_finish')
                   then 'delivered'
               else 'cancelled' end        as final_status,
           '45'                            as order_time_zone, -- планируемое время на доставку
           case
               when claim_status_code in ('cancelled', 'cancelled_with_payment', 'cancelled_with_items_on_hands')
                   or taxi_user_status = 'cancelled' then 'by client'
               when claim_status_code = 'cancelled_by_taxi'
                   or taxi_driver_status = 'cancelled' then 'by driver'
               else '' end                 as cancel_reason,
           destination_address             as user_address,
           store_geohash_dict.store_name   as id_at_fact,
           ''                              as user_email,

           6371 * 2 * ASIN(SQRT(
                       POWER(SIN(((ST_PointFromGeoHash(dlv.source_geohash)::point)[1] - store_geohash_dict.lat) * PI() /
                                 180 / 2), 2) +
                       COS((ST_PointFromGeoHash(dlv.source_geohash)::point)[1] * PI() / 180) *
                       COS(store_geohash_dict.lat * PI() / 180) *
                       POWER(SIN(((ST_PointFromGeoHash(dlv.source_geohash)::point)[0] - store_geohash_dict.lon) * PI() /
                                 180 / 2), 2)
               ))                          as distance,
           row_number() over ( partition by dlv.cargo_ref_id
               order by 6371 * 2 * ASIN(SQRT(
                           POWER(SIN(((ST_PointFromGeoHash(dlv.source_geohash)::point)[1] - store_geohash_dict.lat) *
                                     PI() / 180 / 2), 2) +
                           COS((ST_PointFromGeoHash(dlv.source_geohash)::point)[1] * PI() / 180) *
                           COS(store_geohash_dict.lat * PI() / 180) *
                           POWER(SIN(((ST_PointFromGeoHash(dlv.source_geohash)::point)[0] - store_geohash_dict.lon) *
                                     PI() / 180 / 2), 2)
                   ))
               )                           as rank_d
--            (ST_PointFromGeoHash(dlv.source_geohash))[1],  (ST_PointFromGeoHash(source_geohash)::point)[0]
--             store_geohash_dict.lat, store_geohash_dict.lon,
    from dlv
             cross join store_geohash_dict
    left join ext_t on dlv.cargo_ref_id=ext_t.cargo_ref_id
--   left join store_geohash_dict
--     on store_geohash_dict.geohash = substr(dlv.source_geohash,1,6);
)
 select * from t
    where rank_d = 1;

-- drop table if exists snb_b2b.niksm_logdata_462_kfc_report;
-- create table snb_b2b.niksm_logdata_462_kfc_report as
truncate table snb_b2b.niksm_logdata_462_kfc_report;
insert into snb_b2b.niksm_logdata_462_kfc_report
    (order_id, pr_counting,
       id_at,
--      source_address,
       without_cashregister, time, status, type, payment_method,
       product_count, product_price,
       delivery_price, order_vdu,
       fio, courier_firm, courier_phone, user_phone, user_first_order,
       courier_search_start_ts, delivery_status_wait_for_courier_payment_ts, delivery_status_courier_paid_for_order_ts,
       delivery_status_in_delivery_ts, canceled_at, delivery_status_delivered_ts,
       promise_fulfilled,
       final_status, order_time_zone, cancel_reason, user_address, id_at_fact, user_email)
select order_id, pr_counting,
       id_at,
--        source_address,
       without_cashregister, time, status, type, payment_method,
       product_count, product_price,
       delivery_price, order_vdu,
       fio, courier_firm, courier_phone, user_phone, user_first_order,
       courier_search_start_ts, delivery_status_wait_for_courier_payment_ts, delivery_status_courier_paid_for_order_ts,
       delivery_status_in_delivery_ts, canceled_at, delivery_status_delivered_ts,
       promise_fulfilled,
       final_status, order_time_zone, cancel_reason, user_address, id_at_fact, user_email
from niksm_temp_logdata_462_kfc_report_res;

-- comment on table snb_b2b.niksm_logdata_462_kfc_report is 'Отчёт для KFC. LOGDATA-462';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_logdata_462_kfc_report', 'Finish', clock_timestamp());
