insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp)
VALUES ('anayat_b2b_logdata2473', 'Start', clock_timestamp());

drop table if exists anayat_b2b_logdata2473_res;
create
    temporary table anayat_b2b_logdata2473_res as
with blnc0 as (select contract_id::bigint                     as billing_contract_id,
                      invoice                                 as lst,
                      manager,
                      person_inn,
                      max(contract)                           as corp_contract_id,
                      max(client_id)                          as billing_client_id,
                      max(client)                             as billing_client_name,
                      max(start_dt::date)                     as start_dt,
                      coalesce(max(act_sum), 0.)              as act_sum,
                      coalesce(max(invoice_payments_sum), 0.) as invoice_payments_sum,
                      coalesce(max(overdue_debt), 0.)            overdue_debt,
                      coalesce(max(debt00), 0.)                  debt00,
                      coalesce(max(debt130), 0.)                 debt130,
                      coalesce(max(debt3060), 0.)                debt3060,
                      coalesce(max(debt6090), 0.)                debt6090,
                      coalesce(max(debtover90), 0.)              debtover90
               from snb_b2b.voytekh_corporate_contracts_and_debts
               where currency = 'ILS'
--                  and payment_type = 'предоплата'
                 and start_dt::date <= current_date
                 and (faxed_dt is not null or signed_dt is not null)
--                  and coalesce(finish_dt, '2099-12-31')::date >= current_date
                 and coalesce(cancelled_dt, '2099-12-31')::date >= current_date
                 and coalesce(suspended_dt, '2099-12-31')::date >= current_date
               group by 1, 2, 3, 4)
   , blnc as (select billing_contract_id,
                     max(lst)                                 as lst,
                     max(manager)                                manager,
                     max(person_inn)                             person_inn,
                     max(corp_contract_id)                    as corp_contract_id,
                     max(billing_client_id)                   as billing_client_id,
                     max(billing_client_name)                 as billing_client_name,
                     max(start_dt)                            as start_dt,
                     sum(invoice_payments_sum) - sum(act_sum) as actual_balance,
                     sum(act_sum)                                act_sum,
                     sum(invoice_payments_sum)                   total_payment,
                     sum(overdue_debt)                           overdue_debt,
                     sum(debt00)                                 debt00,
                     sum(debt130)                                debt130,
                     sum(debt3060)                               debt3060,
                     sum(debt6090)                               debt6090,
                     sum(debtover90)                             debtover90
              from blnc0
              group by billing_contract_id)
   , dlv as (select corp_contract_id,
                    sum(decoupling_user_cost) as decoupling_user_cost
             from taxi_cdm_marketplace.fct_order
             where utc_order_created_dttm between current_date - 30 and current_date
               and corp_order_flg
               and currency_code = 'ILS'
             group by 1)
select blnc.*,
       lk.quasi_threshold_ccy_value,
       payment_30d,
       decoupling_user_cost                                                 as decoupling_user_cost_30_days,
       decoupling_user_cost / least(30, nullif(current_date - start_dt, 0)) as daily_user_cost,
       (actual_balance - quasi_threshold_ccy_value)
           / nullif(
                   decoupling_user_cost / least(30, nullif(current_date - start_dt, 0)),
                   0.)                                                      as days_till_block
from blnc
         left join snb_b2b.dbcorp_contract_info lk
                   on lk.billing_contract_id::bigint = blnc.billing_contract_id
         left join dlv
                   on dlv.corp_contract_id = blnc.corp_contract_id
         left join
     (select invoice_eid, COALESCE(sum(amt_w_nds), 0) as payment_30d
      from snb_b2b.balance_oebs_cash_payment_fact
      where doc_date between current_date - 31 and current_date - 1
      group by invoice_eid) bocp
     on blnc.lst = bocp.invoice_eid::text
order by days_till_block nulls last;


-- drop table if exists snb_b2b.anayat_b2b_logdata2473;
-- create table snb_b2b.anayat_b2b_logdata2473 as
truncate table snb_b2b.anayat_b2b_logdata2473;
insert into snb_b2b.anayat_b2b_logdata2473
(billing_contract_id, lst, manager, person_inn, corp_contract_id, billing_client_id, billing_client_name, start_dt,
 actual_balance, act_sum, total_payment, overdue_debt, debt00, debt130, debt3060, debt6090, debtover90,
 quasi_threshold_ccy_value, payment_30d,
 daily_user_cost, days_till_block)
select billing_contract_id,
       lst,
       manager,
       person_inn,
       corp_contract_id,
       billing_client_id,
       billing_client_name,
       start_dt,
       actual_balance,
       act_sum,
       total_payment,
       overdue_debt,
       debt00,
       debt130,
       debt3060,
       debt6090,
       debtover90,
       cast(quasi_threshold_ccy_value as double precision),
       cast(payment_30d as double precision),
       cast(daily_user_cost as double precision),
       days_till_block
from anayat_b2b_logdata2473_res;

-- comment on table snb_b2b.anayat_b2b_logdata2473 is 'Витрина для дашборда Долг по Израилю';


insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp)
VALUES ('anayat_b2b_logdata2473', 'Finish', clock_timestamp());
