--=====================================================
-- update balance_sales_daily

drop table if exists dt_upd;
create temporary table dt_upd as
with up_t as ( select min(dt) as min_dt from snb_b2b.balance_sales_daily_raw_temp)
, t_bas as  (select max(dt) as max_dt from snb_b2b.balance_sales_daily_raw)

select case when max_dt>=min_dt then  min_dt else null end date_update
    from t_bas   cross join up_t;

delete from  snb_b2b.balance_sales_daily_raw
where dt>=(select date_update from dt_upd)
;
insert into   snb_b2b.balance_sales_daily_raw
 select     act_client_id::double precision,
    act_external_id ::        varchar,
    act_id  ::                double precision,
    act_new_client   ::       double precision,
    act_qty ::                double precision,
    act_trans_id      ::      double precision,
    activity_type_1_id  ::    double precision,
    activity_type_1_name  ::  varchar,
    activity_type_2_id   ::   double precision,
    activity_type_2_name ::   varchar,
    agency_id    ::           double precision,
    agency_name   ::          varchar,
    amount      ::            double precision,
    amount_nds      ::        double precision,
    amount_nsp   ::           double precision,
    amt_byn   ::              double precision,
    amt_eur  ::               double precision,
    amt_kzt    ::             double precision,
    amt_rur  ::               double precision,
    amt_rur_inv      ::       double precision,
    amt_rur_inv_with_nds ::   double precision,
    amt_rur_with_nds ::       double precision,
    amt_try   ::              double precision,
    amt_uah   ::              double precision,
    amt_usd   ::              double precision,
    ar_commission_type ::     double precision,
    client_name    ::         varchar,
    consume_id    ::          double precision,
    contract_eid    ::        varchar,
    contract_id    ::         double precision,
    credit     ::             double precision,
    currency      ::          varchar,
    direct_discount_pct ::    double precision,
    discount_pct  ::          double precision,
    dt        ::              varchar,
    dt_month     ::           double precision,
    dt_month_str   ::         varchar,
    dt_querter  ::            double precision,
    dt_year    ::             double precision,
    factura  ::               varchar,
    firm_id  ::               double precision,
    group_id  ::              double precision,
    group_name  ::            varchar,
    ico         ::            double precision,
    ico_cl_ind   ::           double precision,
    inv_client_id ::          double precision,
    inv_dt     ::             varchar,
    invoice_eid   ::          varchar,
    invoice_id   ::           double precision,
    ip_receipt_dt   ::        varchar,
    is_agency_under_itself :: double precision,
    manager_code     ::       double precision,
    manager_group  ::         double precision,
    manager_name   ::         varchar,
    netting       ::          double precision,
    office_id     ::          double precision,
    office_name   ::          varchar,
    order_class_id  ::        double precision,
    order_client_agency_id :: double precision,
    order_client_id   ::      double precision,
    order_client_is_agency :: double precision,
    order_id        ::        double precision,
    order_region_id  ::       double precision,
    overdraft        ::       double precision,
    paid_amt_rur    ::        double precision,
    payment_term_dt  ::       varchar,
    paysys_id        ::       double precision,
    paysys_name      ::       varchar,
    person_id        ::       double precision,
    person_inn       ::       varchar,
    person_region_code ::     varchar,
    person_type       ::      varchar,
    postpay           ::      double precision,
    product_commission_type:: double precision,
    product_id     ::         double precision,
    product_name    ::        varchar,
    promo_code_id   ::        double precision,
    service_id      ::        double precision,
    service_name    ::        varchar,
    service_order_id  ::      double precision,
    static_discount_pct ::    double precision,
    subgroup_id     ::        double precision,
    subgroup_name   ::        varchar,
    supergroup_id   ::        double precision,
    supergroup_name  ::       varchar,
    transf_mngr_code ::       double precision,
    trasf_grp_code   ::       double precision,
    tree_manager_code ::      double precision,
    url_group_id     ::       double precision

 from snb_b2b.balance_sales_daily_raw_temp
where dt>=(select date_update from dt_upd)
;

--=====================================================
-- update balance_oebs_cash_payment_fact

drop table if exists dt_upd;
create temporary table dt_upd as
with up_t as ( select min(doc_date) as min_dt from snb_b2b.balance_oebs_cash_payment_fact_raw_temp)
, t_bas as  (select max(doc_date) as max_dt from snb_b2b.balance_oebs_cash_payment_fact_raw)

select case when max_dt>=min_dt then  min_dt else null end date_update
    from t_bas   cross join up_t;

delete from  snb_b2b.balance_oebs_cash_payment_fact_raw
where doc_date>=(select date_update from dt_upd)
;
insert into   snb_b2b.balance_oebs_cash_payment_fact_raw
 select
 acc_number   ::     varchar,
    account_name ::     varchar,
    agency_id    ::     double precision,
    amt          ::     double precision,
    amt_w_nds    ::     double precision,
    bik          ::     varchar,
    client_id    ::     double precision,
    client_name   ::    varchar,
    customer_name ::    varchar,
    doc_date      ::    varchar,
    doc_number    ::    varchar,
    firm_id       ::    double precision,
    ids_services  ::    varchar,
    inn           ::    varchar,
    inv_discount_type:: double precision,
    invoice_currency::   varchar,
    invoice_dt   ::     varchar,
    invoice_eid  ::     varchar,
    invoice_type ::     varchar,
    nds        ::       double precision,
    nds_pct     ::      double precision,
    operation_type ::   varchar,
    payment_number ::   varchar,
    payment_term_dt ::  varchar,
    person_id    ::     double precision,
    source_type  ::     varchar,
    total_sum    ::     double precision,
    total_sum_w_nds  :: double precision
 from snb_b2b.balance_oebs_cash_payment_fact_raw_temp
where doc_date>=(select date_update from dt_upd)
;

--=====================================================
-- update balance_contracts


truncate table snb_b2b.balance_contracts_raw;
insert into   snb_b2b.balance_contracts_raw
 select
    account_type          ::     varchar,
    agency_id             ::     double precision,
    agency_name           ::     varchar,
    atypical_conditions   ::     varchar,
    auto_credit           ::     varchar,
    bank_details_id       ::     varchar,
    belarus_budget        ::     double precision,
    brand_type            ::     varchar,
    budget_discount_pct   ::     double precision,
    calc_defermant        ::     varchar,
    client_id             ::     double precision,
    client_name           ::     varchar,
    com_charge_type       ::     varchar,
    commission            ::     double precision,
    commission_declared_sum ::   double precision,
    commission_name         ::   varchar,
    commission_payback_pct  ::   double precision,
    commission_payback_type ::   varchar,
    consolidated_discount   ::   double precision,
    contract_discount    ::      double precision,
    contract_eid        ::       varchar,
    contract_id         ::       double precision,
    contract_projects   ::       varchar,
    contract_type        ::      double precision,
    contract_type_name   ::      varchar,
    country               ::     varchar,
    credit_limit_single  ::      double precision,
    credit_type          ::      varchar,
    ctype                ::      varchar,
    currency             ::      varchar,
    deal_passport        ::      varchar,
    declared_sum          ::     double precision,
    discount_commission   ::     double precision,
    discount_findt         ::    varchar,
    discount_fixed         ::    varchar,
    discount_pct           ::    double precision,
    discount_policy_type  ::     varchar,
    dt                    ::     varchar,
    end_dt                ::     varchar,
    finish_dt             ::     varchar,
    firm_id               ::     double precision,
    firm_name             ::     varchar,
    fixed_discount_pct    ::     double precision,
    ids_services         ::      varchar,
    is_booked           ::       varchar,
    is_cancelled        ::       varchar,
    is_faxed            ::       varchar,
    is_signed           ::     varchar,
    is_suspended        ::       varchar,
    kz_budget            ::      double precision,
    lift_credit_on_payment   ::  varchar,
    link_contract_id       ::    double precision,
    loyal_clients          ::    varchar,
    manager_bo_code        ::    double precision,
    manager_bo_name        ::    varchar,
    manager_code          ::     double precision,
    manager_name          ::     varchar,
    memo_contr            ::     varchar,
    nds_for_receipt       ::     double precision,
    new_commissioner_report ::   varchar,
    non_resident_clients    ::   varchar,
    partner_commission_pct  ::   double precision,
    partner_commission_sum  ::   double precision,
    partner_credit         ::    varchar,
    payment_term          ::     double precision,
    payment_term_max      ::     double precision,
    payment_type          ::    varchar,
    person_city           ::     varchar,
    person_email          ::     varchar,
    person_id            ::      double precision,
    person_inn           ::      varchar,
    person_name          ::      varchar,
    person_phone         ::      varchar,
    personal_account     ::      varchar,
    print_form_type      ::      varchar,
    region               ::      varchar,
    repayment_on_consume ::      varchar,
    representative       ::      varchar,
    retro_discount        ::     double precision,
    scommission_name      ::     varchar,
    sent_dt               ::     varchar,
    service_name          ::     varchar,
    supercommission       ::     double precision,
    unilateral            ::     varchar,
    use_consolidated_discount::  varchar,
    use_regional_cons_discount:: varchar,
    use_ua_cons_discount   ::    varchar,
    wo_nds                ::     varchar,
    wsale_ag_prm_awrd_sc_code::  double precision,
    wsale_ag_prm_awrd_sc_tp ::   varchar,
    passport_id           ::     double precision,
    person_client_id      ::     double precision,
    person_kpp             ::    varchar
 from snb_b2b.balance_contracts_raw_temp
;

--=====================================================
-- update balance_invoice


truncate table snb_b2b.balance_invoice_raw;
insert into   snb_b2b.balance_invoice_raw
 select
    adjust_qty     ::     double precision,
    agency_discount_pct:: double precision,
    amount          ::    double precision,
    amount_nds     ::     double precision,
    amount_nsp      ::    double precision,
    bank_details_id  ::   double precision,
    bank_id      ::       double precision,
    base_iso_currency ::   varchar,
    client_id      ::     double precision,
    commission_type  ::   double precision,
    consume_sum   ::      double precision,
    contact_id    ::      double precision,
    contract_id   ::      double precision,
    credit        ::      double precision,
    currency      ::      varchar,
    currency_rate   ::    double precision,
    currency_rate_src ::  varchar,
    discount_type    ::   double precision,
    dt              ::    varchar,
    effective_sum   ::    double precision,
    extern          ::    double precision,
    external        ::    double precision,
    external_id     ::    varchar,
    fast_payment    ::    double precision,
    firm_id         ::    double precision,
    full_render     ::    double precision,
    hidden          ::    double precision,
    id              ::    double precision,
    internal_acts  ::     double precision,
    internal_rate   ::    double precision,
    is_docs_detailed ::   double precision,
    is_docs_separated::   double precision,
    iso_currency  ::      varchar,
    legal_entity   ::     double precision,
    loyal_clients  ::     double precision,
    manager_code   ::     double precision,
    market_postpay  ::    double precision,
    nds           ::      double precision,
    nds_pct        ::     double precision,
    need_processing ::    double precision,
    offer_type_id   ::    double precision,
    overdraft      ::     double precision,
    parent_template_id :: double precision,
    passport_id    ::     double precision,
    payment_date    ::    varchar,
    payment_method_id  :: double precision,
    payment_number  ::    varchar,
    payment_term_dt ::    varchar,
    payment_term_id  ::   double precision,
    paysys_id       ::    double precision,
    person_id       ::    double precision,
    postpay         ::    double precision,
    promo_code_id   ::    double precision,
    receipt_dt      ::    varchar,
    receipt_dt_1c   ::    varchar,
    receipt_sum     ::    double precision,
    receipt_sum_1c   ::   double precision,
    receipts_count   ::   double precision,
    request_id     ::     double precision,
    request_seq    ::     double precision,
    resident       ::     double precision,
    rur_sum        ::     double precision,
    status_id      ::     double precision,
    total_act_sum  ::     double precision,
    total_sum      ::     double precision,
    transfer_acted ::     double precision,
    turn_on_dt     ::     varchar,
    type          ::      varchar,
    unilateral    ::      double precision,
    upd_contract_dt ::    varchar,
    update_dt_yt   ::     varchar,
    usd_rate      ::      double precision
from snb_b2b.balance_invoice_raw_temp;