
import json
import requests
import pandas as pd
import psycopg2
import datetime
import csv
import codecs
import sys

import smtplib
import time
import imaplib
import email
import email.header
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication

from yql.api.v1.client import YqlClient
import logging

from business_models import greenplum, hahn
from business_models.greenplum import GreenplumManager
from business_models.hahn import HahnDataLoader
import time
import os

logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

key_file = 'keys.json'
gp_user = 'robot-sam-bridges'
key_key = 'sam_gp_token'
with open(key_file, 'r') as f:
    keys = json.load(f)
gp_token = keys[key_key]
greenplum = GreenplumManager(user=gp_user, token=gp_token)
yt_token = keys['sam_yt_token']
# yt_token = keys['corploader_hahn']
hahn = HahnDataLoader(token=yt_token)


query_gp_filtr = f"""
select max(doc_date)  max_doc_date
from snb_b2b.balance_oebs_cash_payment_fact_raw;
"""
gp_filtr=greenplum(query_gp_filtr)
datefrom=(datetime.datetime.strptime(gp_filtr['max_doc_date'][0],  '%Y-%m-%d').date()-datetime.timedelta(days=7)).strftime('%Y-%m-%d')
yt_query = f"""
PRAGMA yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$oebs_cpf=(
select *
from `//home/taxi-dwh/import/yandex-balance/oebs_cash_payment_fact`
where doc_date >='{datefrom}'
);

 insert into `//home/taxi-delivery/analytics/production/b2b/yandex-balance/oebs_cash_payment_fact_slice` with truncate
    select * from $oebs_cpf;
 select count(*) as cnt from $oebs_cpf;
"""
# where doc_date >='{datefrom}'
df = hahn(yt_query)
text = 'oebs_cash_payment_fact'
logging.info(f"{text} loaded, df len = {len(df)}, df value = {df['cnt'][0]}")
text = 'balance_oebs_cash_payment_fact'

yt_query = f"""
PRAGMA yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
 select * from `//home/taxi-delivery/analytics/production/b2b/yandex-balance/oebs_cash_payment_fact_slice`;
"""
df = hahn(yt_query)
tn='snb_b2b.balance_oebs_cash_payment_fact_raw_temp'
greenplum.write(df, table_name=tn,sep=';',index=False)

# greenplum.replicate(yt_path='//home/taxi-delivery/analytics/production/b2b/yandex-balance/oebs_cash_payment_fact_slice',
#                     table_name='snb_b2b.balance_oebs_cash_payment_fact_raw_temp',
#                     if_exist='replace',
#                     with_truncate=True)
logging.info(f"{text} Success")


query_gp_filtr = f"""
select max(dt) max_dt
from snb_b2b.balance_sales_daily_raw;
"""
gp_filtr=greenplum(query_gp_filtr)
datefrom=(datetime.datetime.strptime(gp_filtr['max_dt'][0],  '%Y-%m-%d').date()-datetime.timedelta(days=7)).strftime('%Y-%m-%d')
yt_query = f"""
PRAGMA yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$s_d=(
select *
from `//home/taxi-dwh/import/yandex-balance/sales_daily`
where dt>='{datefrom}'
);

 insert into `//home/taxi-delivery/analytics/production/b2b/yandex-balance/sales_daily_slice` with truncate
    select * from $s_d;
select count(*) as cnt from $s_d;
"""
# where dt>='{datefrom}'
df = hahn(yt_query)
text = 'sales_daily'
logging.info(f"{text} loaded,, df len = {len(df)}, df value = {df['cnt'][0]}")
text = 'balance_sales_daily'

yt_query = f"""
PRAGMA yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
 select * from `//home/taxi-delivery/analytics/production/b2b/yandex-balance/sales_daily_slice`;
"""
df = hahn(yt_query)
tn='snb_b2b.balance_sales_daily_raw_temp'
greenplum.write(df, table_name=tn,sep=';',index=False)

# greenplum.replicate(yt_path='//home/taxi-delivery/analytics/production/b2b/yandex-balance/sales_daily_slice',
#                     table_name='snb_b2b.balance_sales_daily_raw_temp',
#                     if_exist='replace',
#                     with_truncate=True)
logging.info(f"{text} Success")


yt_query = f"""
PRAGMA yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$s_d=(
select *
from `//home/taxi-dwh/import/yandex-balance/contracts` as t
where ids_services like '%650%'
   or ids_services like '%718%'
);

 insert into `//home/taxi-delivery/analytics/production/b2b/yandex-balance/balance_contracts` with truncate
    select * from $s_d;
select count(*) as cnt from $s_d;
"""
df = hahn(yt_query)
text = 'balance_contracts'
logging.info(f"{text} loaded,, df len = {len(df)}, df value = {df['cnt'][0]}")

yt_query = f"""
PRAGMA yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
 select * from `//home/taxi-delivery/analytics/production/b2b/yandex-balance/balance_contracts`;
"""
df = hahn(yt_query)
tn='snb_b2b.balance_contracts_raw_temp'
greenplum.write(df, table_name=tn,sep=';',index=False)
# greenplum.replicate(yt_path='//home/taxi-delivery/analytics/production/b2b/yandex-balance/balance_contracts',
#                     table_name='snb_b2b.balance_contracts_raw',
#                     if_exist='replace',
#                     with_truncate=True)
logging.info(f"{text} Success")

text = 'balance_invoice'
yt_query = f"""
PRAGMA yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
 select * from `//home/taxi-dwh/import/yandex-balance/invoice`;
"""
df = hahn(yt_query)
tn='snb_b2b.balance_invoice_raw_temp'
greenplum.write(df, table_name=tn,sep=';',index=False)

# greenplum.replicate(yt_path='//home/taxi-dwh/import/yandex-balance/invoice',
#                     table_name='snb_b2b.balance_invoice_raw',
#                     if_exist='replace',
#                     with_truncate=True)
logging.info(f"{text} Success")

logging.info(f"Success Full")
