from business_models import greenplum, hahn
from business_models.greenplum import GreenplumManager
from business_models.hahn import HahnDataLoader
import requests
from yql.api.v1.client import YqlClient
import json
import datetime
import logging
import sys
import time
import os

logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

key_file = 'keys.json'
gp_user = 'robot-sam-bridges'
key_key = 'sam_gp_token'
with open(key_file, 'r') as f:
    keys = json.load(f)
gp_token = keys[key_key]
greenplum = GreenplumManager(user=gp_user, token=gp_token)
yt_token = keys['sam_yt_token']
hahn = HahnDataLoader(token=yt_token)

days_window = 14
days_window2 = 45
datefrom = (datetime.datetime.today() - datetime.timedelta(days=days_window - 1)).strftime('%Y-%m-%d')
datefrom2 = (datetime.datetime.today() - datetime.timedelta(days=days_window2 - 1)).strftime('%Y-%m-%d')
# dateto = datetime.datetime.today().strftime('%Y-%m-%d')

# PRAGMA yt.Pool='taxi-delivery';
# PRAGMA yt.TmpFolder='//home/taxi-delivery/tmp';
yt_query = f"""
PRAGMA yt.TmpFolder='//tmp';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$oebs_cpf=(
select *
from `//home/taxi-dwh/import/yandex-balance/oebs_cash_payment_fact`
where doc_date >='{datefrom}'
);

 insert into `//home/taxi-delivery/analytics/production/b2b/yandex-balance/oebs_cash_payment_fact_slice` with truncate
    select * from $oebs_cpf;
 select count(*) as cnt from $oebs_cpf;
"""

df = hahn(yt_query)
text = 'oebs_cash_payment_fact'
logging.info(f"{text} loaded, df len = {len(df)}, df value = {df['cnt'][0]}")

query_gp = f"""
delete from snb_b2b.balance_oebs_cash_payment_fact_raw
where doc_date >= '{datefrom2}'
"""
greenplum(query_gp)
logging.info(f"{text} gp rows deleted")

yt_query = f"""
PRAGMA yt.TmpFolder='//tmp';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$s_d=(
select *
from `//home/taxi-dwh/import/yandex-balance/sales_daily`
where dt>='{datefrom2}'
);

 insert into `//home/taxi-delivery/analytics/production/b2b/yandex-balance/sales_daily_slice` with truncate
    select * from $s_d;
select count(*) as cnt from $s_d;
"""

df = hahn(yt_query)
text = 'sales_daily'
logging.info(f"{text} loaded,, df len = {len(df)}, df value = {df['cnt'][0]}")

query_gp = f"""
delete from snb_b2b.balance_sales_daily_raw
where dt >= '{datefrom2}'
"""
greenplum(query_gp)
logging.info(f"{text} gp rows deleted")

yt_query = f"""
PRAGMA yt.TmpFolder='//tmp';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$s_d=(
select *
from `//home/taxi-dwh/import/yandex-balance/contracts` as t
where ids_services like '%650%'
   or ids_services like '%718%'
);

 insert into `//home/taxi-delivery/analytics/production/b2b/yandex-balance/balance_contracts` with truncate
    select * from $s_d;
select count(*) as cnt from $s_d;
"""

df = hahn(yt_query)
text = 'balance_contracts'
logging.info(f"{text} loaded,, df len = {len(df)}, df value = {df['cnt'][0]}")
