-- with dt AS (
--     SELECT generate_series('2021-01-01'::date,
--         --date_trunc('month'::text, ('now'::text::date - 93)::timestamp with time zone),
--                            'now'::text::date::timestamp with time zone, '1 day'::interval) AS calday
-- )
--     ,bc as (select coalesce(crm.country,crm_sf.country) as country
--                   ,manager_metagroup
--                   ,coalesce(crm.manager_group,crm_sf.manager_group) as manager_group
--                   ,coalesce(crm.manager_login,crm_sf.manager_login) as manager_login
--                   ,blct.contract_eid
--                   ,blct.payment_term
--                   ,blct.currency
--                   ,blct.payment_type
--
--               FROM snb_b2b.balance_contracts blct
--                        left join snb_b2b.amo_leads_info crm
--                                  on crm.contract_id = blct.contract_eid
--                                      and manager_group <> 'B2B платформа'
--                        left join snb_b2b.niksm_b2b_contracts_info_sf crm_sf
--                                  on crm_sf.contract_id = blct.contract_eid
--               where (crm.contract_id is not null
--                   or crm_sf.contract_id is not null)
--               )
-- select dt.calday, bc.country,bc.manager_metagroup, bc.manager_group, bc.manager_login
--       ,bc.contract_eid, bc.payment_term, bc.currency, bc.payment_type
--       , sum(bsd.amount)  AS accruals
--       , sum(
--         CASE WHEN (bsd.dt::date + bc.payment_term::integer) < dt.calday THEN bsd.amount
--             ELSE 0::numeric END) AS accruals_0
--       , sum(
--             CASE WHEN (bsd.dt::date + bc.payment_term::integer + 15) < dt.calday THEN bsd.amount
--                 ELSE 0::numeric END) AS accruals_15
-- from dt
--     CROSS JOIN bc
--     LEFT JOIN snb_b2b.balance_sales_daily bsd
--                             ON bsd.contract_eid::text = bc.contract_eid::text AND bsd.dt::date < dt.calday
-- group by dt.calday, bc.country,bc.manager_metagroup, bc.manager_group, bc.manager_login
--       ,bc.contract_eid, bc.payment_term, bc.currency, bc.payment_type
-- ;
----------------------------------------------------------------------------------------------------------------
drop table if exists balance_allocation;
create temporary table balance_allocation as
with act as (select contract_eid,
                    act_external_id,
                    invoice_eid,
                    dt,
                    sum(amount) as accruals
             from snb_b2b.balance_sales_daily
--              where contract_eid  in ('1581488/21') --in('570170/20','420579/19')
             group by contract_eid, act_external_id, invoice_eid, dt)
, pay as (select invoice_eid,
                 payment_number,
                 doc_date,
                 sum(amt_w_nds) as payment
          from snb_b2b.balance_oebs_cash_payment_fact
--           where invoice_eid in ('ЛСТ-3550850726-1')  --in('ЛСТ-2789306117-1','ЛСТ-1978207345-1')
          group by invoice_eid,
                 payment_number,
                 doc_date)
, t as (select contract_eid
             , act.invoice_eid
             , act_external_id
             , dt
             , accruals
             , payment_number
             , payment
             ,doc_date
              , coalesce(sum(accruals)
                        over (partition by contract_eid,act.invoice_eid,payment_number,doc_date order by dt,act_external_id rows between unbounded preceding and 1 preceding),
                        0)                                                                                            as accruals_old
             , coalesce(sum(accruals) over (partition by contract_eid,act.invoice_eid,payment_number,doc_date order by dt,act_external_id),
                        0)                                                                                            as accruals_c
             , coalesce(sum(payment) over (partition by contract_eid,act.invoice_eid,act_external_id,dt order by doc_date,payment_number),
                        0)                                                                                            as payment_c
             , least(payment,greatest(0,
                coalesce(sum(payment)
                         over (partition by contract_eid,act.invoice_eid,act_external_id,dt order by doc_date,payment_number), 0)
                - coalesce(sum(accruals)
                           over (partition by contract_eid,act.invoice_eid,payment_number,doc_date  order by dt,act_external_id rows between unbounded preceding and 1 preceding),
                           0)))
             - least(payment,greatest(0,
                coalesce(sum(payment)
                         over (partition by contract_eid,act.invoice_eid,act_external_id,dt order by doc_date,payment_number), 0)
                - coalesce(sum(accruals)
                           over (partition by contract_eid,act.invoice_eid,payment_number,doc_date  order by dt,act_external_id),0))) as payment_act
            , (least(payment,greatest(0,
                coalesce(sum(payment)
                         over (partition by contract_eid,act.invoice_eid,act_external_id,dt order by doc_date,payment_number), 0)
                - coalesce(sum(accruals)
                           over (partition by contract_eid,act.invoice_eid,payment_number,doc_date  order by dt,act_external_id rows between unbounded preceding and 1 preceding),
                           0)))
             - least(payment,greatest(0,
                coalesce(sum(payment)
                         over (partition by contract_eid,act.invoice_eid,act_external_id,dt order by doc_date,payment_number), 0)
                - coalesce(sum(accruals)
                           over (partition by contract_eid,act.invoice_eid,payment_number,doc_date  order by dt),0))))>0 as pmnt_act_flg
         from act
                 left join pay
                           on act.invoice_eid = pay.invoice_eid)
, tt as (select contract_eid
              , invoice_eid
              , act_external_id
              , dt                                                              as act_date
              , accruals                                                        as accruals
              , case when pmnt_act_flg = true then payment_number else null end as payment_number
              , case when pmnt_act_flg = true then doc_date else null end       as payment_date
              , case when pmnt_act_flg = true then payment else null end        as payment
              , case
                    when pmnt_act_flg = true then payment_act
                    else
                            accruals -
                            coalesce(sum(payment_act) over (partition by contract_eid, invoice_eid, act_external_id),
                                     0) end                                     as accruals_act
              , payment_act
              , (case
                     when pmnt_act_flg = true then payment_act
                     else
                             accruals -
                             coalesce(sum(payment_act) over (partition by contract_eid, invoice_eid, act_external_id),
                                      0) end) > 0                               as act_flg
         from t
         group by contract_eid, invoice_eid, act_external_id, dt, accruals
                , case when pmnt_act_flg = true then payment_number else null end
                , case when pmnt_act_flg = true then doc_date else null end
                , case when pmnt_act_flg = true then payment else null end
                , payment_act, pmnt_act_flg
         order by act_external_id, act_date, payment_date
)
select contract_eid, invoice_eid, act_external_id
     ,act_date,accruals,payment_number,payment_date,payment
     ,accruals_act,payment_act
from tt
where act_flg=true;

-- drop table if exists snb_b2b.balance_allocation_act_and_payment;
-- create table snb_b2b.balance_allocation_act_and_payment as
truncate table snb_b2b.balance_allocation_act_and_payment;
insert into snb_b2b.balance_allocation_act_and_payment
(contract_eid, invoice_eid, act_external_id
     ,act_date,accruals,payment_number,payment_date,payment
     ,accruals_act,payment_act)
select contract_eid, invoice_eid, act_external_id
     ,act_date,accruals,payment_number,payment_date,payment
     ,accruals_act,payment_act
from  balance_allocation;

-- select *
-- from snb_b2b.balance_oebs_cash_payment_fact
-- where  true
-- and payment_number='10389'
-- and   invoice_eid in('ЛСТ-1978207345-1');
--
--
-- select  *
-- from snb_b2b.balance_sales_daily
-- where contract_eid  in('420579/19')
-- and act_external_id='160389248'
-- and service_order_id=20000019402602;

--------------------------------------------------------------------------------------------
drop table if exists snb_b2b.act_time_repayment;
create table snb_b2b.act_time_repayment as
with t as (select act_p.contract_eid,
                  act_p.invoice_eid,
                  act_p.act_external_id,
                  max(coalesce(ctr.country,ctr_sf.country)) as country,
                  max(date_trunc('month', act_p.act_date::date)::date)               as month_act,
                  max(act_p.act_date)                                                   act_date,
                  max(act_p.accruals)                                                   accruals,
                  sum(act_p.accruals_act)                                               accruals_act,
                  sum(act_p.payment_act)                                             as payment_act,
                  sum(act_p.accruals_act*coalesce(crn.rate,1))                                               accruals_act_rur,
                  sum(act_p.payment_act*coalesce(crn.rate,1))                                             as payment_act_rur,
-- act_p.payment_number,
-- act_p.payment_date,
-- act_p.payment,
-- act_p.accruals_act,
-- act_p.payment_act,
                  max(coalesce(payment_term, 0))                                        payment_term,
                  sum(accruals_act) - sum(payment_act) <= 0                             payment_flg,
                  sum(accruals_act) - sum(payment_act) <= 100                           payment_flg_100,
                  coalesce(case
                      when sum(accruals_act) - sum(payment_act) <= 0 then greatest(0, max(act_p.payment_date::date) -
                                                                                      max(act_p.act_date::date))
                      else greatest(0, current_date - max(act_p.act_date::date)) end,0) as days_payment_all,
                  coalesce(case
                      when sum(accruals_act) - sum(payment_act) <= 100 then greatest(0, max(act_p.payment_date::date) -
                                                                                        max(act_p.act_date::date))
                      else greatest(0, current_date - max(act_p.act_date::date)) end,0) as days_payment_100,
               1 as cnt_act,
               max(coalesce(ctr.manager_group,ctr_sf.manager_group)) as manager_group,
                max(case when bcnt.payment_type='предоплата' and
                COALESCE((lkc.lk_contract_prepaid_deactivate_threshold <= (-100)::double precision)::integer,0)=1
                    then 'квази предоплата' else bcnt.payment_type end) as payment_type
                ,sum(1) over (partition by
                                     max(coalesce(ctr.country,ctr_sf.country))
                                    ,max(date_trunc('month', act_p.act_date::date)::date)
--                                     ,max(coalesce(ctr.manager_group,ctr_sf.manager_group))
--                                     ,sum(accruals_act) - sum(payment_act) <= 0
--                                     ,max(case when bcnt.payment_type='предоплата' and
--                                         COALESCE((lkc.lk_contract_prepaid_deactivate_threshold <= (-100)::double precision)::integer,0)=1
--                                             then 'квази предоплата' else bcnt.payment_type end)
                    order by
                        coalesce(case when sum(accruals_act) - sum(payment_act) <= 0
                                    then greatest(0, max(act_p.payment_date::date) -max(act_p.act_date::date))
                      else greatest(0, current_date - max(act_p.act_date::date)) end,0)
                        ,max(act_p.act_date),act_p.act_external_id )
           as row_n_act
                   ,sum(1) over (partition by
                             max(coalesce(ctr.country,ctr_sf.country))
                            ,max(date_trunc('month', act_p.act_date::date)::date)
                       )
           as row_all_n_act
            ,sum(sum(act_p.accruals_act*coalesce(crn.rate,1))) over (partition by
                                     max(coalesce(ctr.country,ctr_sf.country))
                                    ,max(date_trunc('month', act_p.act_date::date)::date)
                      order by
                        coalesce(case when sum(accruals_act) - sum(payment_act) <= 0
                                    then greatest(0, max(act_p.payment_date::date) -max(act_p.act_date::date))
                      else greatest(0, current_date - max(act_p.act_date::date)) end,0)
                        ,max(act_p.act_date),act_p.act_external_id )
           as row_n_accruals
                   ,sum(sum(act_p.accruals_act*coalesce(crn.rate,1))) over (partition by
                             max(coalesce(ctr.country,ctr_sf.country))
                            ,max(date_trunc('month', act_p.act_date::date)::date)
                       )
           as row_all_n_accruals
           ,sum(1) over (partition by
                max(date_trunc('month', act_p.act_date::date)::date)
                    order by
                        coalesce(case when sum(accruals_act) - sum(payment_act) <= 0
                                    then greatest(0, max(act_p.payment_date::date) -max(act_p.act_date::date))
                      else greatest(0, current_date - max(act_p.act_date::date)) end,0)
                        ,max(act_p.act_date),act_p.act_external_id )
           as row_n_act_all
                   ,sum(1) over (partition by
                            max(date_trunc('month', act_p.act_date::date)::date)
                       )
           as row_all_n_act_all
            ,sum(sum(act_p.accruals_act*coalesce(crn.rate,1))) over (partition by
                                    max(date_trunc('month', act_p.act_date::date)::date)
                      order by
                        coalesce(case when sum(accruals_act) - sum(payment_act) <= 0
                                    then greatest(0, max(act_p.payment_date::date) -max(act_p.act_date::date))
                      else greatest(0, current_date - max(act_p.act_date::date)) end,0)
                        ,max(act_p.act_date),act_p.act_external_id )
           as row_n_accruals_all
                   ,sum(sum(act_p.accruals_act*coalesce(crn.rate,1))) over (partition by
                            max(date_trunc('month', act_p.act_date::date)::date)
                       )
           as row_all_n_accruals_all


           from snb_b2b.balance_allocation_act_and_payment act_p
                    left join snb_b2b.niksm_b2b_contracts_info ctr on ctr.contract_id = act_p.contract_eid
                    left join snb_b2b.niksm_b2b_contracts_info_sf ctr_sf on ctr_sf.contract_id = act_p.contract_eid
                    left join (select *, row_number() over (partition by contract_eid order by dt desc) rn
                               from snb_b2b.balance_contracts) bcnt
                        on bcnt.contract_eid = act_p.contract_eid and rn=1
                    left JOIN snb_b2b.niksm_b2b_lk_contract_info lkc ON act_p.contract_eid::text = lkc.contract_external_id
                    left join (select case when source_cur='RUB' then 'RUR' else source_cur end source_cur,rate,
                              row_number() over (partition by source_cur, target_cur order by date desc) rn
                               from dds.dim_currency_rate dcr
                               where target_cur='RUB') crn
                        on crn.rn=1 and bcnt.currency=crn.source_cur
           where (ctr.contract_id is not null or ctr_sf.contract_id is not null)
           and not coalesce(ctr.pipeline_name,'0') in('ДОГОВОРЫ ЯНДЕКС ТАКСИ')
           and not (coalesce(ctr.pipeline_name,'0') in('РАСТОРГНУТЫЕ ДОГОВОРЫ') and coalesce(ctr.stage_name,'0')=('ОТКЛЮЧЕНА ДОСТАВКА дог. ЯНДЕКС.ТАКСИ'))
--              and act_p.contract_eid = '1101626/20'
           group by act_p.contract_eid, act_p.invoice_eid, act_p.act_external_id
           )
, tt as (select country,
                month_act,
                manager_group,
                payment_type,
                days_payment_all-payment_term<=30 as day_30,
                case
                    when days_payment_all <= payment_term then 'free_debt'
                    when days_payment_all <= payment_term + 15 then 'debt0_15'
                    when days_payment_all <= payment_term + 30 then 'debt15_30'
                    when days_payment_all <= payment_term + 60 then 'debt30_60'
                    when days_payment_all <= payment_term + 90 then 'debt60_90'
                    else 'debt90+' end   debt_type,
               case when  coalesce(row_n_act*1.0/row_all_n_act,0.0)<=0.5 then 'percentile_50'
                    when  coalesce(row_n_act*1.0/row_all_n_act,0.0)<=0.8 then 'percentile_80'
                    when  coalesce(row_n_act*1.0/row_all_n_act,0.0)<=0.9 then 'percentile_90'
                    when  coalesce(row_n_act*1.0/row_all_n_act,0.0)<=0.97 then 'percentile_97'
                        else 'percentile_100' end as percentile,
              case when  coalesce(row_n_accruals*1.0/row_all_n_accruals,0.0)<=0.5 then 'percentile_50'
                    when  coalesce(row_n_accruals*1.0/row_all_n_accruals,0.0)<=0.8 then 'percentile_80'
                    when  coalesce(row_n_accruals*1.0/row_all_n_accruals,0.0)<=0.9 then 'percentile_90'
                    when  coalesce(row_n_accruals*1.0/row_all_n_accruals,0.0)<=0.97 then 'percentile_97'
                        else 'percentile_100' end as percentile_accruals,
              case when  coalesce(row_n_act_all*1.0/row_all_n_act_all,0.0)<=0.5 then 'percentile_50'
                    when  coalesce(row_n_act_all*1.0/row_all_n_act_all,0.0)<=0.8 then 'percentile_80'
                    when  coalesce(row_n_act_all*1.0/row_all_n_act_all,0.0)<=0.9 then 'percentile_90'
                    when  coalesce(row_n_act_all*1.0/row_all_n_act_all,0.0)<=0.97 then 'percentile_97'
                        else 'percentile_100' end as percentile_all,
              case when  coalesce(row_n_accruals_all*1.0/row_all_n_accruals_all,0.0)<=0.5 then 'percentile_50'
                    when  coalesce(row_n_accruals_all*1.0/row_all_n_accruals_all,0.0)<=0.8 then 'percentile_80'
                    when  coalesce(row_n_accruals_all*1.0/row_all_n_accruals_all,0.0)<=0.9 then 'percentile_90'
                    when  coalesce(row_n_accruals_all*1.0/row_all_n_accruals_all,0.0)<=0.97 then 'percentile_97'
                        else 'percentile_100' end as percentile_accruals_all,

                max(days_payment_all) as max_days_pmnt,
                sum(cnt_act)          as cnt_act,
                sum(accruals_act)     as accruals_act,
                sum(payment_act)      as payment_act,
                sum(accruals_act_rur)     as accruals_act_rur,
                sum(payment_act_rur)      as payment_act_rur,
                payment_flg,
                sum(days_payment_all) as days_payment_all,
                sum(greatest(0,days_payment_all-payment_term))::bigint as days_payment_after_term,
                sum(greatest(0,(days_payment_all-payment_term)*accruals_act)) as days_payment_after_term_15,
                sum(case when days_payment_all-payment_term>0 then cnt_act else 0 end) as  cnt_act_after_term,
                sum(case when days_payment_all-payment_term>0 then accruals_act else 0 end) as  cnt_act_after_term_15,
                sum(case when payment_flg=false then accruals_act-payment_act else 0 end) as bad_debt,
                sum(case when payment_flg=false then accruals_act_rur-payment_act_rur else 0 end) as bad_debt_rur
--        payment_flg_100,
--        sum(days_payment_100) as days_payment_100,


         from t
         group by country, month_act, manager_group, payment_type,
                  payment_flg
                ,days_payment_all-payment_term<=30
                , case
                   when days_payment_all <= payment_term then 'free_debt'
                   when days_payment_all <= payment_term + 15 then 'debt0_15'
                   when days_payment_all <= payment_term + 30 then 'debt15_30'
                   when days_payment_all <= payment_term + 60 then 'debt30_60'
                   when days_payment_all <= payment_term + 90 then 'debt60_90'
                   else 'debt90+' end
                , payment_type
               ,case when  coalesce(row_n_act*1.0/row_all_n_act,0.0)<=0.5 then 'percentile_50'
                    when  coalesce(row_n_act*1.0/row_all_n_act,0.0)<=0.8 then 'percentile_80'
                    when  coalesce(row_n_act*1.0/row_all_n_act,0.0)<=0.9 then 'percentile_90'
                    when  coalesce(row_n_act*1.0/row_all_n_act,0.0)<=0.97 then 'percentile_97'
                        else 'percentile_100' end
               ,case when  coalesce(row_n_accruals*1.0/row_all_n_accruals,0.0)<=0.5 then 'percentile_50'
                    when  coalesce(row_n_accruals*1.0/row_all_n_accruals,0.0)<=0.8 then 'percentile_80'
                    when  coalesce(row_n_accruals*1.0/row_all_n_accruals,0.0)<=0.9 then 'percentile_90'
                    when  coalesce(row_n_accruals*1.0/row_all_n_accruals,0.0)<=0.97 then 'percentile_97'
                        else 'percentile_100' end
               ,case when  coalesce(row_n_act_all*1.0/row_all_n_act_all,0.0)<=0.5 then 'percentile_50'
                    when  coalesce(row_n_act_all*1.0/row_all_n_act_all,0.0)<=0.8 then 'percentile_80'
                    when  coalesce(row_n_act_all*1.0/row_all_n_act_all,0.0)<=0.9 then 'percentile_90'
                    when  coalesce(row_n_act_all*1.0/row_all_n_act_all,0.0)<=0.97 then 'percentile_97'
                        else 'percentile_100' end
              ,case when  coalesce(row_n_accruals_all*1.0/row_all_n_accruals_all,0.0)<=0.5 then 'percentile_50'
                    when  coalesce(row_n_accruals_all*1.0/row_all_n_accruals_all,0.0)<=0.8 then 'percentile_80'
                    when  coalesce(row_n_accruals_all*1.0/row_all_n_accruals_all,0.0)<=0.9 then 'percentile_90'
                    when  coalesce(row_n_accruals_all*1.0/row_all_n_accruals_all,0.0)<=0.97 then 'percentile_97'
                        else 'percentile_100' end

         )

select *
from tt;
--------------------------------------------------------------------------------------
drop table if exists snb_b2b.act_nopaid_data;
create table snb_b2b.act_nopaid_data as
with t as (select act_p.contract_eid,
                  act_p.invoice_eid,
                  act_p.act_external_id,
                  max(bcnt.client_name) client_name,
                  max(coalesce(ctr.country, ctr_sf.country))                                      as country,
                  max(date_trunc('month', act_p.act_date::date)::date)                            as month_act,
                  max(act_p.act_date)                                                                act_date,
                  max(act_p.accruals)                                                                accruals,
                  sum(act_p.accruals_act)                                                            accruals_act,
                  sum(act_p.payment_act)                                                          as payment_act,
                  sum(act_p.accruals_act * coalesce(crn.rate, 1))                                    accruals_act_rur,
                  sum(act_p.payment_act * coalesce(crn.rate, 1))                                  as payment_act_rur,

                  max(coalesce(payment_term, 0))                                                     payment_term,
                  sum(accruals_act) - sum(payment_act) <= 0                                          payment_flg,
                  coalesce(case
                               when sum(accruals_act) - sum(payment_act) <= 0 then greatest(0,
                                                                                            max(act_p.payment_date::date) -
                                                                                            max(act_p.act_date::date))
                               else greatest(0, current_date - max(act_p.act_date::date)) end, 0) as days_payment_all,

                  1                                                                               as cnt_act,
                  max(coalesce(ctr.manager_group, ctr_sf.manager_group))                          as manager_group,
                  max(coalesce(ctr.manager_login, ctr_sf.manager_login))                          as manager_login,
                  max(case
                          when bcnt.payment_type = 'предоплата' and
                               COALESCE((lkc.lk_contract_prepaid_deactivate_threshold <=
                                         (-100)::double precision)::integer, 0) = 1
                              then 'квази предоплата'
                          else bcnt.payment_type end)                                             as payment_type
           ,max(ctr.pipeline_name) pipeline_name


           from snb_b2b.balance_allocation_act_and_payment act_p
                    left join snb_b2b.niksm_b2b_contracts_info ctr on ctr.contract_id = act_p.contract_eid
                    left join snb_b2b.niksm_b2b_contracts_info_sf ctr_sf on ctr_sf.contract_id = act_p.contract_eid
                    left join (select *, row_number() over (partition by contract_eid order by dt desc) rn
                               from snb_b2b.balance_contracts) bcnt
                              on bcnt.contract_eid = act_p.contract_eid and rn = 1
                    left JOIN snb_b2b.niksm_b2b_lk_contract_info lkc
                              ON act_p.contract_eid::text = lkc.contract_external_id
                    left join (select case when source_cur = 'RUB' then 'RUR' else source_cur end                source_cur,
                                      rate,
                                      row_number() over (partition by source_cur, target_cur order by date desc) rn
                               from dds.dim_currency_rate dcr
                               where target_cur = 'RUB') crn
                              on crn.rn = 1 and bcnt.currency = crn.source_cur
           where (ctr.contract_id is not null or ctr_sf.contract_id is not null)
           and not coalesce(ctr.pipeline_name,'0') in('ДОГОВОРЫ ЯНДЕКС ТАКСИ')
           and not (coalesce(ctr.pipeline_name,'0') in('РАСТОРГНУТЫЕ ДОГОВОРЫ') and coalesce(ctr.stage_name,'0')=('ОТКЛЮЧЕНА ДОСТАВКА дог. ЯНДЕКС.ТАКСИ'))
--              and act_p.contract_eid = '1101626/20'
           group by act_p.contract_eid, act_p.invoice_eid, act_p.act_external_id
)

select contract_eid, invoice_eid, act_external_id,act_date,payment_type
       ,client_name, country, manager_group, manager_login,  pipeline_name
       ,sum(accruals_act)accruals_act, sum(payment_act) payment_act
       ,sum(accruals_act_rur)accruals_act_rur, sum(payment_act_rur)payment_act_rur
from t
where payment_flg=false
and days_payment_all> payment_term
group by contract_eid, invoice_eid, act_external_id,act_date,payment_type
       ,client_name, country, manager_group, manager_login,pipeline_name;