drop table if exists debt_base;
create temporary table debt_base as
WITH dt AS (
    SELECT generate_series(date_trunc('month'::text, ('now'::text::date - 93)::timestamp with time zone),
                           'now'::text::date::timestamp with time zone, '1 day'::interval) AS calday
),
     a AS (
         SELECT balance_contracts.account_type,
                balance_contracts.agency_id,
                balance_contracts.agency_name,
                balance_contracts.atypical_conditions,
                balance_contracts.auto_credit,
                balance_contracts.bank_details_id,
                balance_contracts.belarus_budget,
                balance_contracts.brand_type,
                balance_contracts.budget_discount_pct,
                balance_contracts.calc_defermant,
                balance_contracts.client_id,
                balance_contracts.client_name,
                balance_contracts.com_charge_type,
                balance_contracts.commission,
                balance_contracts.commission_declared_sum,
                balance_contracts.commission_name,
                balance_contracts.commission_payback_pct,
                balance_contracts.commission_payback_type,
                balance_contracts.consolidated_discount,
                balance_contracts.contract_discount,
                balance_contracts.contract_eid,
                balance_contracts.contract_id,
                balance_contracts.contract_projects,
                balance_contracts.contract_type,
                balance_contracts.contract_type_name,
                balance_contracts.country,
                balance_contracts.credit_limit_single,
                balance_contracts.credit_type,
                balance_contracts.ctype,
                balance_contracts.currency,
                balance_contracts.deal_passport,
                balance_contracts.declared_sum,
                balance_contracts.discount_commission,
                balance_contracts.discount_findt,
                balance_contracts.discount_fixed,
                balance_contracts.discount_pct,
                balance_contracts.discount_policy_type,
                balance_contracts.dt,
                balance_contracts.end_dt,
                balance_contracts.finish_dt,
                balance_contracts.firm_id,
                balance_contracts.firm_name,
                balance_contracts.fixed_discount_pct,
                balance_contracts.ids_services,
                balance_contracts.is_booked,
                balance_contracts.is_cancelled,
                balance_contracts.is_faxed,
                balance_contracts.is_signed,
                balance_contracts.is_suspended,
                balance_contracts.kz_budget,
                balance_contracts.lift_credit_on_payment,
                balance_contracts.link_contract_id,
                balance_contracts.loyal_clients,
                balance_contracts.manager_bo_code,
                balance_contracts.manager_bo_name,
                balance_contracts.manager_code,
                balance_contracts.manager_name,
                balance_contracts.memo_contr,
                balance_contracts.nds_for_receipt,
                balance_contracts.new_commissioner_report,
                balance_contracts.non_resident_clients,
                balance_contracts.partner_commission_pct,
                balance_contracts.partner_commission_sum,
                balance_contracts.partner_credit,
                balance_contracts.payment_term,
                balance_contracts.payment_term_max,
                balance_contracts.payment_type,
                balance_contracts.person_city,
                balance_contracts.person_email,
                balance_contracts.person_id,
                balance_contracts.person_inn,
                balance_contracts.person_name,
                balance_contracts.person_phone,
                balance_contracts.personal_account,
                balance_contracts.print_form_type,
                balance_contracts.region,
                balance_contracts.repayment_on_consume,
                balance_contracts.representative,
                balance_contracts.retro_discount,
                balance_contracts.scommission_name,
                balance_contracts.sent_dt,
                balance_contracts.service_name,
                balance_contracts.supercommission,
                balance_contracts.unilateral,
                balance_contracts.use_consolidated_discount,
                balance_contracts.use_regional_cons_discount,
                balance_contracts.use_ua_cons_discount,
                balance_contracts.wo_nds,
                balance_contracts.wsale_ag_prm_awrd_sc_code,
                balance_contracts.wsale_ag_prm_awrd_sc_tp,
                row_number()
                OVER (PARTITION BY balance_contracts.contract_eid ORDER BY balance_contracts.dt DESC) AS rn
         FROM snb_b2b.balance_contracts
     ),
     bc AS (
         SELECT a.account_type,
                a.agency_id,
                a.agency_name,
                a.atypical_conditions,
                a.auto_credit,
                a.bank_details_id,
                a.belarus_budget,
                a.brand_type,
                a.budget_discount_pct,
                a.calc_defermant,
                a.client_id,
                a.client_name,
                a.com_charge_type,
                a.commission,
                a.commission_declared_sum,
                a.commission_name,
                a.commission_payback_pct,
                a.commission_payback_type,
                a.consolidated_discount,
                a.contract_discount,
                a.contract_eid,
                a.contract_id,
                a.contract_projects,
                a.contract_type,
                a.contract_type_name,
                a.country,
                a.credit_limit_single,
                a.credit_type,
                a.ctype,
                a.currency,
                a.deal_passport,
                a.declared_sum,
                a.discount_commission,
                a.discount_findt,
                a.discount_fixed,
                a.discount_pct,
                a.discount_policy_type,
                a.dt,
                a.end_dt,
                a.finish_dt,
                a.firm_id,
                a.firm_name,
                a.fixed_discount_pct,
                a.ids_services,
                a.is_booked,
                a.is_cancelled,
                a.is_faxed,
                a.is_signed,
                a.is_suspended,
                a.kz_budget,
                a.lift_credit_on_payment,
                a.link_contract_id,
                a.loyal_clients,
                a.manager_bo_code,
                a.manager_bo_name,
                a.manager_code,
                a.manager_name,
                a.memo_contr,
                a.nds_for_receipt,
                a.new_commissioner_report,
                a.non_resident_clients,
                a.partner_commission_pct,
                a.partner_commission_sum,
                a.partner_credit,
                a.payment_term,
                a.payment_term_max,
                a.payment_type,
                a.person_city,
                a.person_email,
                a.person_id,
                a.person_inn,
                a.person_name,
                a.person_phone,
                a.personal_account,
                a.print_form_type,
                a.region,
                a.repayment_on_consume,
                a.representative,
                a.retro_discount,
                a.scommission_name,
                a.sent_dt,
                a.service_name,
                a.supercommission,
                a.unilateral,
                a.use_consolidated_discount,
                a.use_regional_cons_discount,
                a.use_ua_cons_discount,
                a.wo_nds,
                a.wsale_ag_prm_awrd_sc_code,
                a.wsale_ag_prm_awrd_sc_tp,
                a.rn
         FROM a
         WHERE a.rn = 1
     ),
     d_invoice AS (
         SELECT bc.contract_eid,
                bsd.invoice_eid,
                bc.currency,
                bc.payment_type,
                bc.dt as start_date_contract,
                dt.calday,
                sum(bsd.amount)  AS accruals,
                sum(
                        CASE
                            WHEN (bsd.dt::date + bc.payment_term::integer) < dt.calday THEN bsd.amount
                            ELSE 0::numeric
                            END) AS accruals_0,
                sum(
                        CASE
                            WHEN (bsd.dt::date + bc.payment_term::integer + 15) < dt.calday THEN bsd.amount
                            ELSE 0::numeric
                            END) AS accruals_15,
                sum(
                        CASE
                            WHEN (bsd.dt::date + bc.payment_term::integer + 30) < dt.calday THEN bsd.amount
                            ELSE 0::numeric
                            END) AS accruals_30,
                sum(
                        CASE
                            WHEN (bsd.dt::date + bc.payment_term::integer + 45) < dt.calday THEN bsd.amount
                            ELSE 0::numeric
                            END) AS accruals_45,
                sum(
                        CASE
                            WHEN (bsd.dt::date + bc.payment_term::integer + 60) < dt.calday THEN bsd.amount
                            ELSE 0::numeric
                            END) AS accruals_60,
                sum(
                        CASE
                            WHEN (bsd.dt::date + bc.payment_term::integer + 75) < dt.calday THEN bsd.amount
                            ELSE 0::numeric
                            END) AS accruals_75,
                sum(
                        CASE
                            WHEN (bsd.dt::date + bc.payment_term::integer + 90) < dt.calday THEN bsd.amount
                            ELSE 0::numeric
                            END) AS accruals_90,
                sum(
                        CASE
                            WHEN (bsd.dt::date + bc.payment_term::integer + 180) < dt.calday THEN bsd.amount
                            ELSE 0::numeric
                            END) AS accruals_180
         FROM dt
                  CROSS JOIN bc
                  LEFT JOIN snb_b2b.balance_sales_daily bsd
                            ON bsd.contract_eid::text = bc.contract_eid::text AND bsd.dt::date < dt.calday
         GROUP BY bc.contract_eid, bsd.invoice_eid, dt.calday, bc.currency, bc.payment_type,  bc.dt
     ),
     debt_base AS (
         SELECT di.contract_eid,
                di.invoice_eid,
                di.currency,
                di.payment_type,
                di.start_date_contract,
                di.calday,
                di.accruals,
                di.accruals - di.accruals_0      AS accruals_fresh,
                di.accruals_0 - di.accruals_15   AS accruals_0_15,
                di.accruals_15 - di.accruals_30  AS accruals_15_30,
                di.accruals_30 - di.accruals_45  AS accruals_30_45,
                di.accruals_45 - di.accruals_60  AS accruals_45_60,
                di.accruals_60 - di.accruals_75  AS accruals_60_75,
                di.accruals_75 - di.accruals_90  AS accruals_75_90,
                di.accruals_90 - di.accruals_180 AS accruals_90_180,
                di.accruals_180                  AS accruals_over180,
                COALESCE(sum(bocp.amt_w_nds),0)           AS payment,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals) > 0::numeric THEN di.accruals - di.accruals_0
                    ELSE GREATEST(sum(bocp.amt_w_nds) - di.accruals_0, 0::numeric)
                    END                          AS payment_fresh,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals_0) > 0::numeric THEN di.accruals_0 - di.accruals_15
                    ELSE GREATEST(sum(bocp.amt_w_nds) - di.accruals_15, 0::numeric)
                    END                          AS payment_0_15,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals_15) > 0::numeric THEN di.accruals_15 - di.accruals_30
                    ELSE GREATEST(sum(bocp.amt_w_nds) - di.accruals_30, 0::numeric)
                    END                          AS payment_15_30,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals_30) > 0::numeric THEN di.accruals_30 - di.accruals_45
                    ELSE GREATEST(sum(bocp.amt_w_nds) - di.accruals_45, 0::numeric)
                    END                          AS payment_30_45,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals_45) > 0::numeric THEN di.accruals_45 - di.accruals_60
                    ELSE GREATEST(sum(bocp.amt_w_nds) - di.accruals_60, 0::numeric)
                    END                          AS payment_45_60,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals_60) > 0::numeric THEN di.accruals_60 - di.accruals_75
                    ELSE GREATEST(sum(bocp.amt_w_nds) - di.accruals_75, 0::numeric)
                    END                          AS payment_60_75,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals_75) > 0::numeric THEN di.accruals_75 - di.accruals_90
                    ELSE GREATEST(sum(bocp.amt_w_nds) - di.accruals_90, 0::numeric)
                    END                          AS payment_75_90,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals_90) > 0::numeric THEN di.accruals_90 - di.accruals_180
                    ELSE GREATEST(sum(bocp.amt_w_nds) - di.accruals_180, 0::numeric)
                    END                          AS payment_90_180,
                CASE
                    WHEN (sum(bocp.amt_w_nds) - di.accruals_180) > 0::numeric THEN di.accruals_180 - 0::numeric
                    ELSE GREATEST(sum(bocp.amt_w_nds) - 0::numeric, 0::numeric)
                    END                          AS payment_over180
         FROM d_invoice di
                  LEFT JOIN snb_b2b.balance_oebs_cash_payment_fact bocp
                            ON di.invoice_eid::text = bocp.invoice_eid::text AND bocp.doc_date <= di.calday
         GROUP BY di.contract_eid, di.invoice_eid, di.calday, di.currency, di.payment_type, di.start_date_contract
                  ,di.accruals, di.accruals_0,di.accruals_15, di.accruals_30, di.accruals_45, di.accruals_60
                  ,di.accruals_75, di.accruals_90,di.accruals_180
     )
    select * from  debt_base;
    analyse debt_base;

-- create table snb_delivery.debtor_dash_data_logdata635 as
-- drop table snb_delivery.debtor_dash_data_logdata635;

drop table if exists temp_debtor_dash_data_logdata635;
create temporary table temp_debtor_dash_data_logdata635 as
with  fin AS (
         SELECT debt_base.contract_eid,
                debt_base.invoice_eid,
                debt_base.calday,
                debt_base.currency,
                debt_base.payment_type,
                debt_base.start_date_contract,
                ctf.manager_group,
                ctf.manager_name,
                ctf.pipeline_name,
                ctf.stage_name,
                ctf.tier,

                debt_base.accruals,
                debt_base.payment,
                debt_base.accruals_fresh,
                debt_base.accruals_0_15,
                debt_base.accruals_15_30,
                debt_base.accruals_30_45,
                debt_base.accruals_45_60,
                debt_base.accruals_60_75,
                debt_base.accruals_75_90,
                debt_base.accruals_90_180,
                debt_base.accruals_over180,
                debt_base.payment_fresh,
                debt_base.payment_0_15,
                debt_base.payment_15_30,
                debt_base.payment_30_45,
                debt_base.payment_45_60,
                debt_base.payment_60_75,
                debt_base.payment_75_90,
                debt_base.payment_90_180,
                debt_base.payment_over180,
                GREATEST(debt_base.accruals - debt_base.payment, 0::numeric)                                                   AS debt_all,
                debt_base.accruals_fresh - debt_base.payment_fresh                                                             AS debt_fresh,
                debt_base.accruals_0_15 - debt_base.payment_0_15                                                               AS debt_0_15,
                debt_base.accruals_15_30 - debt_base.payment_15_30                                                             AS debt_15_30,
                debt_base.accruals_30_45 - debt_base.payment_30_45                                                             AS debt_30_45,
                debt_base.accruals_45_60 - debt_base.payment_45_60                                                             AS debt_45_60,
                debt_base.accruals_60_75 - debt_base.payment_60_75                                                             AS debt_60_75,
                debt_base.accruals_75_90 - debt_base.payment_75_90                                                             AS debt_75_90,
                debt_base.accruals_90_180 - debt_base.payment_90_180                                                           AS debt_90_180,
                debt_base.accruals_over180 - debt_base.payment_over180                                                         AS debt_over180,
                lag(GREATEST(debt_base.accruals - debt_base.payment, 0::numeric),
                'now'::text::date - ('now'::text::date - '1 mon'::interval)::date)
                OVER (PARTITION BY debt_base.contract_eid, debt_base.invoice_eid ORDER BY debt_base.calday)                    AS debt_1_mon,
                lag(GREATEST(debt_base.accruals - debt_base.payment, 0::numeric),
                'now'::text::date - ('now'::text::date - '2 mons'::interval)::date)
                OVER (PARTITION BY debt_base.contract_eid, debt_base.invoice_eid ORDER BY debt_base.calday)                    AS debt_2_mon,
                sum(
                CASE
                    WHEN debt_base.calday = date_trunc('month'::text, debt_base.calday)
                        THEN GREATEST(debt_base.accruals - debt_base.payment, 0::numeric)
                    ELSE 0::numeric
                    END)
                OVER (PARTITION BY debt_base.contract_eid, debt_base.invoice_eid, date_trunc('month'::text, debt_base.calday)) AS debt_start_mon,
                sum(
                CASE
                    WHEN debt_base.calday = date_trunc('month'::text, debt_base.calday) THEN debt_base.accruals
                    ELSE 0::numeric
                    END)
                OVER (PARTITION BY debt_base.contract_eid, debt_base.invoice_eid, date_trunc('month'::text, debt_base.calday)) AS accruals_start_mon,
                sum(
                CASE
                    WHEN debt_base.calday = date_trunc('month'::text, debt_base.calday) THEN debt_base.payment_fresh+debt_base.payment_0_15+debt_base.payment_15_30
            +debt_base.payment_30_45+debt_base.payment_45_60+debt_base.payment_60_75+debt_base.payment_75_90+ debt_base.payment_90_180+ debt_base.payment_over180
                    ELSE 0::numeric
                    END)
                OVER (PARTITION BY debt_base.contract_eid, debt_base.invoice_eid, date_trunc('month'::text, debt_base.calday)) AS payment_start_mon,
                fct.delivery_cnt,
                fct.delivery,
                fct.delivery_cnt_all,
                fct.delivery_flg,
                COALESCE((lkc.lk_contract_prepaid_deactivate_threshold <= (-100)::double precision)::integer,
                         0)                                                                                                    AS quasi_flg,
                dlh.pipeline_name                                                                                              AS pipeline_name_hist,
                dlh.stage_name                                                                                                 AS stage_name_hist,
                sum(case when dlh.pipeline_name in ('DEBT-BRUT', 'DEBT-LONGIN') then 1 else 0 end) over
                (partition by debt_base.contract_eid, debt_base.invoice_eid, date_trunc('month',debt_base.calday::date) order by debt_base.calday)>0 as debt_funnel_flg,
                lkc.lk_contract_is_active as contract_is_active
         FROM debt_base
                  left JOIN snb_b2b.niksm_b2b_contracts_info ctf
                       ON ctf.contract_id = debt_base.contract_eid::text AND ctf.which_crm = 6
                  left JOIN (select pipeline_name, stage_name, contract_id, which_crm, snapshot_date
                            , row_number() over (partition by contract_id,which_crm,snapshot_date order by add_date desc) as rn
                            from snb_b2b.niksm_b2b_deals_info_hist) dlh
                       ON dlh.contract_id = debt_base.contract_eid::text AND dlh.which_crm = 6 AND
                          dlh.contract_id IS NOT NULL AND debt_base.calday = dlh.snapshot_date and dlh.rn=1
                 left JOIN snb_b2b.niksm_b2b_lk_contract_info lkc ON debt_base.contract_eid::text = lkc.contract_external_id
                  LEFT JOIN (SELECT fct_order.corp_contract_id,
                                    sum(
                                            CASE
                                                WHEN fct_order.utc_order_created_dttm >= date_trunc('month'::text,
                                                                                                    ('now'::text::date - 31)::timestamp with time zone) AND
                                                     fct_order.utc_order_created_dttm <= (date_trunc('month'::text,
                                                                                                     'now'::text::date::timestamp with time zone)::date -
                                                                                          1)
                                                    THEN fct_order.delivery_point_cnt
                                                ELSE 0
                                                END)                      AS delivery_cnt,
                                    sum(
                                            CASE
                                                WHEN fct_order.utc_order_created_dttm >= date_trunc('month'::text,
                                                                                                    ('now'::text::date - 31)::timestamp with time zone) AND
                                                     fct_order.utc_order_created_dttm <= (date_trunc('month'::text,
                                                                                                     'now'::text::date::timestamp with time zone)::date -
                                                                                          1)
                                                    THEN fct_order.delivery_point_cnt
                                                ELSE 0
                                                END) > 0                  AS delivery,
                                    sum(fct_order.delivery_point_cnt)     AS delivery_cnt_all,
                                    sum(fct_order.delivery_point_cnt) > 0 AS delivery_flg
                             FROM taxi_cdm_marketplace.fct_order
                             WHERE fct_order.utc_order_created_dttm >=
                                   date_trunc('month'::text, ('now'::text::date - 93)::timestamp with time zone)
                               AND fct_order.utc_order_created_dttm <=
                                   (date_trunc('month'::text, 'now'::text::date::timestamp with time zone)::date - 1)
                             GROUP BY fct_order.corp_contract_id) fct
                            ON fct.corp_contract_id::text = debt_base.contract_eid::text
     )
SELECT fin.contract_eid,
       fin.invoice_eid,
       fin.calday::text,
       fin.currency,
       CASE
           WHEN fin.payment_type::text = 'предоплата'::text AND fin.quasi_flg = 1
               THEN 'квази предоплата'::character varying
           ELSE fin.payment_type
           END AS payment_type,
       fin.manager_group,
       fin.manager_name,
       fin.pipeline_name,
       fin.tier,
       fin.accruals,
       fin.payment,
       fin.accruals_fresh,
       fin.accruals_0_15,
       fin.accruals_15_30,
       fin.accruals_30_45,
       fin.accruals_45_60,
       fin.accruals_60_75,
       fin.accruals_75_90,
       fin.accruals_90_180,
       fin.accruals_over180,
       fin.payment_fresh,
       fin.payment_0_15,
       fin.payment_15_30,
       fin.payment_30_45,
       fin.payment_45_60,
       fin.payment_60_75,
       fin.payment_75_90,
       fin.payment_90_180,
       fin.payment_over180,
       fin.debt_all,
       fin.debt_fresh,
       fin.debt_0_15,
       fin.debt_15_30,
       fin.debt_30_45,
       fin.debt_45_60,
       fin.debt_60_75,
       fin.debt_75_90,
       fin.debt_90_180,
       fin.debt_over180,
       fin.debt_1_mon,
       fin.debt_2_mon,
       fin.debt_start_mon,
       fin.accruals_start_mon,
       fin.payment_start_mon,
       fin.stage_name,
       fin.delivery_cnt,
       fin.delivery,
       fin.delivery_cnt_all,
       fin.delivery_flg,
       fin.quasi_flg,
       fin.pipeline_name_hist,
       fin.debt_funnel_flg,
       fin.stage_name_hist,
       coalesce(sum(fin.debt_15_30 +fin.debt_30_45+fin.debt_45_60+fin.debt_60_75+fin.debt_75_90+fin.debt_90_180+fin.debt_over180 )
           over(partition by fin.contract_eid, fin.invoice_eid order by fin.calday::date range between 1 preceding and 1 preceding),0) as crit_dept_last_d1,
       coalesce(sum(fin.debt_15_30 +fin.debt_30_45+fin.debt_45_60+fin.debt_60_75+fin.debt_75_90+fin.debt_90_180+fin.debt_over180 )
           over(partition by fin.contract_eid, fin.invoice_eid order by fin.calday::date range
               between (date_part('day',fin.calday::date -(fin.calday::date-interval'1 mon'))::int) preceding
               and (date_part('day',fin.calday::date -(fin.calday::date-interval'1 mon'))::int) preceding),0) as crit_dept_last_m1,
       coalesce(sum(fin.debt_all)
           over(partition by fin.contract_eid, fin.invoice_eid order by fin.calday::date range
               between (date_part('day',fin.calday::date -(fin.calday::date-interval'1 mon'))::int) preceding
               and (date_part('day',fin.calday::date -(fin.calday::date-interval'1 mon'))::int) preceding),0) as dept_last_m1,
       fin.start_date_contract,
       fin.contract_is_active

FROM fin
WHERE fin.calday >= date_trunc('month'::text, ('now'::text::date - 61)::timestamp with time zone)
  AND fin.calday <= 'now'::text::date;


-- create table   snb_delivery.debtor_dash_data_logdata_635 as
-- drop table snb_delivery.debtor_dash_data_logdata_635
truncate table snb_delivery.debtor_dash_data_logdata_635;
insert into snb_delivery.debtor_dash_data_logdata_635
select * from temp_debtor_dash_data_logdata635;

-- comment on table snb_delivery.debtor_dash_data_logdata635 is 'Денные для дэша по дебиторской задолжности. LOGDATA-635';

