import pandas as pd
from business_models import greenplum, hahn
from business_models.greenplum import GreenplumManager
from business_models.hahn import HahnDataLoader
import json

key_file = 'keys.json'
gp_user = 'robot-sam-bridges'
key_key='sam_gp_token'
with open(key_file, 'r') as f:
    keys = json.load(f)
gp_token = keys[key_key]
greenplum = GreenplumManager(user=gp_user, token = gp_token)
yt_token = keys['sam_yt_token']
hahn = HahnDataLoader(token=yt_token)

import datetime
from datetime import datetime as dt
import logging

import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f"%(asctime)s %(filename)s %(levelname)s: %(message)s")
logging.info('Start')

greenplum.replicate(yt_path = '//home/taxi-dwh/import/yandex-balance/contracts',
                   table_name = 'snb_b2b.balance_contracts',
                   if_exist = 'replace',
                   with_truncate = True)
logging.info('contracts Success')

greenplum.replicate(yt_path = '//home/taxi-dwh/import/yandex-balance/invoice',
                   table_name = 'snb_b2b.balance_invoice',
                   if_exist = 'replace',
                   with_truncate = True)
logging.info('invoice Success')

greenplum.replicate(yt_path = '//home/taxi-delivery/analytics/production/b2b/yandex-balance/oebs_cash_payment_fact_slice',
                   table_name = 'snb_b2b.balance_oebs_cash_payment_fact',
                   if_exist = 'append')
logging.info('oebs_cash_payment_fact_slice Success')

greenplum.replicate(yt_path = '//home/taxi-delivery/analytics/production/b2b/yandex-balance/sales_daily_slice',
                   table_name = 'snb_b2b.balance_sales_daily',
                   if_exist = 'append')
logging.info('sales_daily_slice Success')
