insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp)
VALUES ('dash_decoupling', 'Start', clock_timestamp());

drop table if exists t_surge;
create temporary table t_surge as
select claim.taxi_order_id          order_id,
       sum(total_surge_lcy_cost) as surge
from delivery_ods_cargo_claims.claim
  join delivery_ods_cargo_pricing.receipt
    on claim.final_pricing_calc_id = 'cargo-pricing/v1/' || receipt.calc_id
where true
  and claim.utc_created_dttm >= date_trunc('week',current_date-4*7)::date - interval '7 days'
  and receipt.utc_created_dttm >= date_trunc('week',current_date-4*7)::date - interval '7 days'
group by 1
distributed by (order_id);

drop table if exists tariff_plan_current;
create temporary table tariff_plan_current as
select corp_client_id,
       tariff_plan_series_id,
       tariff_plan_name
from snb_b2b.dbcorp_client_tariff_plan_current
where service_name = 'cargo'
distributed by (corp_client_id);

-- уйдёт в snb_delivery.dash_decoupling_orders_slice --
drop table if exists raw_orders_slice;
create temporary table raw_orders_slice as
SELECT fct.corp_client_id,
       fct.corp_contract_id,
       fct.tariff_geo_zone_code AS tariff_zone,
       geonode.name_ru AS agglomeration_name,
       fct.country_name_ru,
       fct.tariff_class_code,
       ctp.tariff_plan_series_id,
       ctp.tariff_plan_name,
       date_trunc('week', fct.msk_order_created_dt)::date AS calday,
       fct.currency_code,
       fct.delivery_point_cnt AS deliveries_cnt,
       fct.gmv_amt AS gmv_lcy,
       fct.gmv_amt * COALESCE(fct.currency_rate, 1.) AS gmv_rub,
       fct.gmv_amt::double precision / COALESCE(vat.vat_rate, 1.) AS nmv_lcy,
       fct.gmv_amt * COALESCE(fct.currency_rate, 1.) / COALESCE(vat.vat_rate, 1.) AS nmv_rub,
       fct.net_inflow_amt AS net_inflow_lcy,
       fct.net_inflow_amt * COALESCE(fct.currency_rate, 1.) AS net_inflow_rub,
       fct.b2b_decoupling_amt AS b2b_decoupling_lcy,
       fct.b2b_decoupling_amt * COALESCE(fct.currency_rate, 1.) AS b2b_decoupling_rub,
       CASE WHEN fct.decoupling_success_flg THEN fct.decoupling_driver_cost ELSE 0 END as decoupling_driver_cost_lcy,
       CASE WHEN fct.decoupling_success_flg THEN fct.decoupling_driver_cost * COALESCE(fct.currency_rate, 1.)
                   ELSE 0 END AS decoupling_driver_cost_rub,
       fct.incentives_amt AS incentives_lcy,
       fct.incentives_amt * COALESCE(fct.currency_rate, 1.) AS incentives_rub,
       fct.transporting_distance_plan_km AS distance,
       CASE WHEN fct.transporting_distance_plan_km > 0 THEN fct.delivery_point_cnt ELSE 0 END AS dlv_for_distance,
       CASE WHEN fct.success_order_flg THEN fct.order_before_surge_cost ELSE 0::numeric END AS order_before_surge_cost_lcy,
       CASE WHEN fct.success_order_flg THEN
           CASE WHEN fct.order_cost = 0 THEN 0
                WHEN fct.order_cost > 0 THEN COALESCE((fct.order_cost - t_surge.surge), fct.order_before_surge_cost)
                WHEN t_surge.surge > fct.order_cost THEN fct.order_before_surge_cost
               END ELSE 0
           END AS order_before_surge_cost_lcy_new,
       CASE WHEN fct.success_order_flg THEN fct.order_before_surge_cost * COALESCE(fct.currency_rate, 1.)
           ELSE 0 END AS order_before_surge_cost_rub,
       CASE WHEN fct.success_order_flg THEN
               CASE WHEN fct.order_cost = 0 THEN 0
                    WHEN fct.order_cost > 0
                        THEN COALESCE((fct.order_cost - t_surge.surge) * COALESCE(fct.currency_rate, 1.),
                                      fct.order_before_surge_cost * COALESCE(fct.currency_rate, 1.))
                    WHEN t_surge.surge > fct.order_cost
                        THEN fct.order_before_surge_cost * COALESCE(fct.currency_rate, 1.)
                    END
           ELSE 0 END AS order_before_surge_cost_rub_new,
       t_surge.surge AS surge,
       t_surge.surge * COALESCE(fct.currency_rate, 1.) AS surge_rub,
       CASE WHEN fct.success_order_flg THEN fct.order_cost
           ELSE 0 END AS order_cost_lcy,
       CASE WHEN fct.success_order_flg THEN fct.order_cost * COALESCE(fct.currency_rate, 1.)
            ELSE 0 END AS order_cost_rub,
       fct.delivery_point_cnt * COALESCE(fct.balance_rate, 1.) AS balance_rate_sum
FROM taxi_cdm_marketplace.fct_order_metric fct
  LEFT JOIN snb_b2b.niksm_country_vat_rate vat
    ON vat.country_name_ru = fct.country_name_ru
  JOIN snb_delivery.logdata_delivery_tariff lgst
    ON lgst.order_tariff = fct.tariff_class_code
    AND fct.utc_order_created_dttm >= lgst.utc_datefrom
    AND fct.utc_order_created_dttm <= lgst.utc_dateto
  JOIN tariff_plan_current ctp
    ON ctp.corp_client_id = fct.corp_client_id
  LEFT JOIN taxi_cdm_geo.dim_geo_node geonode
    ON geonode.agglomeration_node_id = fct.agglomeration_node_id
    AND geonode.node_type = 'agglomeration'
    AND geonode.root_node_id = 'br_root'
  left JOIN t_surge
    ON t_surge.order_id = fct.order_id
WHERE true
  AND fct.utc_order_created_dttm >= date_trunc('week',current_date-4*7)::date - interval '1 day'
  AND fct.msk_order_created_dt between date_trunc('week',current_date-4*7)::date and current_date-1;

-- добавится в snb_b2b.dash_decoupling --
drop table if exists dash_decoupling_res;
create temporary table dash_decoupling_res as
select raw.corp_client_id,
       lk.corp_client_name,
       raw.corp_contract_id, tariff_zone,
       agglomeration_name, country_name_ru,
       tariff_class_code, tariff_plan_series_id, tariff_plan_name,
       calday, raw.currency_code,
       --
       sum(deliveries_cnt)                  as deliveries_cnt,
       sum(gmv_lcy)                         as gmv_lcy,
       sum(gmv_rub)                         as gmv_rub,
       sum(nmv_lcy)                         as nmv_lcy,
       sum(nmv_rub)                         as nmv_rub,
       sum(net_inflow_lcy)                  as net_inflow_lcy,
       sum(net_inflow_rub)                  as net_inflow_rub,
       sum(b2b_decoupling_lcy)              as b2b_decoupling_lcy,
       sum(b2b_decoupling_rub)              as b2b_decoupling_rub,
       sum(decoupling_driver_cost_lcy)      as decoupling_driver_cost_lcy,
       sum(decoupling_driver_cost_rub)      as decoupling_driver_cost_rub,
       sum(incentives_lcy)                  as incentives_lcy,
       sum(incentives_rub)                  as incentives_rub,
       sum(distance)                        as distance,
       sum(dlv_for_distance)                as dlv_for_distance,
       sum(order_before_surge_cost_lcy)     as order_before_surge_cost_lcy,
       sum(order_before_surge_cost_lcy_new) as order_before_surge_cost_lcy_new,
       sum(order_before_surge_cost_rub)     as order_before_surge_cost_rub,
       sum(order_before_surge_cost_rub_new) as order_before_surge_cost_rub_new,
       sum(surge)                           as surge,
       sum(surge_rub)                       as surge_rub,
       sum(order_cost_lcy)                  as order_cost_lcy,
       sum(order_cost_rub)                  as order_cost_rub,
       sum(balance_rate_sum)                as balance_rate_sum,
       count()                              AS cnt_order
from raw_orders_slice raw
  left join snb_b2b.dbcorp_client_info lk
    on lk.corp_client_id = raw.corp_client_id
GROUP BY raw.corp_client_id,
         lk.corp_client_name,
         raw.corp_contract_id, tariff_zone, country_name_ru,
         agglomeration_name, tariff_class_code, tariff_plan_series_id, tariff_plan_name,
         calday, raw.currency_code;

--====================================================================================================================--
-- drop table if exists snb_delivery.dash_decoupling_orders_slice;
-- create table snb_delivery.dash_decoupling_orders_slice as
truncate table snb_delivery.dash_decoupling_orders_slice;
insert into snb_delivery.dash_decoupling_orders_slice
    (corp_client_id, corp_contract_id, tariff_zone,
       agglomeration_name, country_name_ru,
       tariff_class_code, tariff_plan_series_id, tariff_plan_name,
       calday, currency_code,
       deliveries_cnt, gmv_lcy, gmv_rub, nmv_lcy, nmv_rub, net_inflow_lcy, net_inflow_rub,
       b2b_decoupling_lcy, b2b_decoupling_rub, decoupling_driver_cost_lcy, decoupling_driver_cost_rub,
       incentives_lcy, incentives_rub,
       distance, dlv_for_distance,
       order_before_surge_cost_lcy, order_before_surge_cost_lcy_new,
       order_before_surge_cost_rub, order_before_surge_cost_rub_new,
       surge, surge_rub, order_cost_lcy, order_cost_rub, balance_rate_sum)
select corp_client_id, corp_contract_id, tariff_zone,
       agglomeration_name, country_name_ru,
       tariff_class_code, tariff_plan_series_id, tariff_plan_name,
       calday, currency_code,
       deliveries_cnt, gmv_lcy, gmv_rub, nmv_lcy, nmv_rub, net_inflow_lcy, net_inflow_rub,
       b2b_decoupling_lcy, b2b_decoupling_rub, decoupling_driver_cost_lcy, decoupling_driver_cost_rub,
       incentives_lcy, incentives_rub,
       distance, dlv_for_distance,
       order_before_surge_cost_lcy, order_before_surge_cost_lcy_new,
       order_before_surge_cost_rub, order_before_surge_cost_rub_new,
       surge, surge_rub, order_cost_lcy, order_cost_rub, balance_rate_sum
from raw_orders_slice;

-- comment on table snb_delivery.dash_decoupling_orders_slice is 'Свежий срез заказов для дашборда Decoupling. LOGDATA-1216';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp)
VALUES ('dash_decoupling', 'dash_decoupling_orders_slice updated', clock_timestamp());

------------------------------------------------------------------------------------------------------------------------
-- drop table if exists snb_b2b.dash_decoupling;
-- create table snb_b2b.dash_decoupling as
-- truncate table snb_b2b.dash_decoupling;
--
delete from snb_b2b.dash_decoupling where calday >= date_trunc('week',current_date-4*7)::date;
insert into snb_b2b.dash_decoupling
    (corp_client_id,
       corp_client_name,
       corp_contract_id, tariff_zone,
       agglomeration_name, country_name_ru,
       tariff_class_code, tariff_plan_series_id, tariff_plan_name,
       calday, currency_code,
       deliveries_cnt, gmv_lcy, gmv_rub, nmv_lcy, nmv_rub, net_inflow_lcy, net_inflow_rub,
       b2b_decoupling_lcy, b2b_decoupling_rub, decoupling_driver_cost_lcy, decoupling_driver_cost_rub,
       incentives_lcy, incentives_rub,
       distance, dlv_for_distance,
       order_before_surge_cost_lcy, order_before_surge_cost_lcy_new,
       order_before_surge_cost_rub, order_before_surge_cost_rub_new,
       surge, surge_rub, order_cost_lcy, order_cost_rub, balance_rate_sum,
       cnt_order)
select corp_client_id,
       corp_client_name,
       corp_contract_id, tariff_zone,
       agglomeration_name, country_name_ru,
       tariff_class_code, tariff_plan_series_id, tariff_plan_name,
       calday, currency_code,
       deliveries_cnt, gmv_lcy, gmv_rub, nmv_lcy, nmv_rub, net_inflow_lcy, net_inflow_rub,
       b2b_decoupling_lcy, b2b_decoupling_rub, decoupling_driver_cost_lcy, decoupling_driver_cost_rub,
       incentives_lcy, incentives_rub,
       distance, dlv_for_distance,
       order_before_surge_cost_lcy, order_before_surge_cost_lcy_new,
       order_before_surge_cost_rub, order_before_surge_cost_rub_new,
       surge, surge_rub, order_cost_lcy, order_cost_rub, balance_rate_sum,
       cnt_order
from dash_decoupling_res;

-- comment on table snb_b2b.dash_decoupling is 'Витрина для мониторинга экономики клиента. Дашборд Decoupling. LOGDATA-1216';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp)
VALUES ('dash_decoupling', 'Finish', clock_timestamp());
