-- create table snb_b2b.dz_automatic_inclusion_debtors as
truncate table snb_b2b.dz_automatic_inclusion_debtors;
insert into snb_b2b.dz_automatic_inclusion_debtors
select lk.lk_client_id as corp_client_id,
       crm.contract_id as contract,
       (bd_reason is not null and bd_reason <> '') as baddebt,
       crm.credit_rating as rating,
    to_char(now(), 'DD-MM-YYYY HH24:MI:SS') as dt
from snb_b2b.amo_contracts_info crm
  join snb_b2b.niksm_b2b_lk_contract_info lk
    on lk.contract_external_id = crm.contract_id
where crm.crm_source = 'yandexdelivery'
  and pipeline_name not in ('РАСТОРГНУТЫЕ ДОГОВОРЫ', 'DEBT-BRUT',
        'DEBT-LONGIN', 'ДОГОВОРЫ ЯНДЕКС ТАКСИ')
-- distributed by (corp_client_id, contract);