
import pandas as pd
from business_models import greenplum
from business_models.greenplum import GreenplumManager
import json

key_file = 'keys.json'
gp_user = 'robot-sam-bridges'
key_key='sam_gp_token'
with open(key_file, 'r') as f:
    keys = json.load(f)
gp_token = keys[key_key]
greenplum = GreenplumManager(user=gp_user, token = gp_token)

from b2b_mailer import main2

import datetime
from datetime import datetime as dt
import logging

import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

with open('dz_rep_mailer.sql') as f:
    query = f.read()
df = greenplum(query)

logging.info(f"df len {len(df)}")

# name columns for excel
col_names = {
    'contract': 'Договор',
    'payment_type': 'Тип оплаты',
    'quasi': 'Квазипостоплата',
    'contract_type': 'Тип',
    'payment_term': 'Срок оплаты',
    'deactivate_threshold': 'Порог отключения',
    'invoice': 'ЛСТ',
    'start_dt': 'Дата договора (баланс)',
    'signed_dt': 'Дата оригинала (баланс)',
    'first_trip': 'Дата первой поездки',
    'person_name': 'Клиент',
    'city': 'Город',
    'person_email': 'e-mail',
    'rating': 'Категория клиента',
    'mname': 'Менеджер',
    'lead_name_last': 'ТЛ',
    'pipeline': 'Воронка продаж',
    'stage': 'этап в crm',
    'debt': 'bad debt (CRM)',
    'bd_reason': 'Причина ПДЗ (CRM)',
    'invoice_payments_sum': 'Всего оплат',
    'debt_sum': 'Общий долг',
    'overdue_clean_debt': 'Просроченный долг',
    'debt00': 'Свежий долг',
    'debt130': '0-30',
    'debt3060': '30-60',
    'debt6090': '60-90',
    'debtover90': '90+',
    'critical': 'Критический долг',
    'payed_perc': '% оплат',
    'person_inn': 'ИНН',
    'b_status': 'Статус договора',
    's_status': 'Статус ЛК',
    'link': 'Адрес сделки CRM',
    'overdue_share': 'Доля просроченной ДЗ',
    'critical_share': 'Доля критической ДЗ',
    'postpone_cost': 'Затраты на предоставление отсрочки',
    'dso': 'DSO',
    'order_cost365': 'Сумма год',
    'order_cost90': 'Сумма 90 дней',
    'debt_service': 'дебт сервисы',
    'debt_service_id': 'id дебт сервисов',
    'currency': 'Валюта',
    'market_segment': 'Сфера деятельности',
    'potential': 'Потенциал',
    'lk_cargo_is_active': 'Активность сервиса (Доставка) на договоре',
    'fact_delivery': 'Факт совершенных',
    'delivery_days':'Кол-во дней с фактическими доставками', 
    'date_debtor': 'Дата задачи Дебиторская задолженность',
    'status_debtor': 'Статус задачи Дебиторская задолженность',
    'client_name': 'Группа компаний'
}

main2(
    receivers_url=['yandex_rkub_taxi_dev_corp_9970_4628', 'outstaff_2289_6747_dep24617'],  # add to receivers all people from specific groups at staff
    receivers_ancestors=['yandex_rkub_taxi_dev_corp_dep13862', 'yandex_rkub_taxi_dev_corp_dep76395',
                         'outstaff_2289_6747_dep94284_dep80684', 'outstaff_2289_6747_dep94284',
                         'outstaff_2289_6747_dep24617', 'yandex_rkub_taxi_dev_corp_9970_4628',
                         'yandex_rkub_taxi_dep80055_dep49675_dep81903'],  # add to receivers people, who have listed groups above theirs
    receivers_logins=['nemici'],  # add to receivers people by logins
    exclude_logins=['seremkin', 'shtan15'],
    mail_name='Отчет по ДЗ', # name of letter
    mail_text='ДЗ должна быть уничтожена. \nВаш отчет во вложении.', # body of letter
    mail_cc=None,  # send a copy to listed emails
    hierarchy=True,  # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
    emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
    key_file=key_file,  # where the keys are
    key_key=key_key,  # key of gp token in file
    flat=[ 'demkinv', 'kgotvald', 'fedorivashkin','niksm', 'ferenec','alextitov'],  # list of emails. mail all rows to these addresses,
    user=gp_user,
    host='gpdb-master.taxi.yandex.net',
    sheets=[
        {'query': None,
         'df': df,
         'exclude_columns': None,
         'col_names': col_names,
         'sheet_name': 'data'}
    ]
)

logging.info('SUCCESS')
