--explain
drop table if exists alextitov_logdata_1127_contract_data;
create temporary table alextitov_logdata_1127_contract_data as

with  actual_contracts as (
    select distinct contract_id::int as contract_id
    from snb_b2b.voytekh_corporate_contracts_and_debts
    where start_dt::date <= current_date
      and (finish_dt is null
        or finish_dt::date >= current_date)
      and cancelled_dt is null
)
, cc0 as (
    select *,
           row_number() over (partition by contract_external_id order by id desc, updated desc ) as rn
    from snb_b2b.bmiklaz_corp_contracts as cntr
      join actual_contracts as act
        on act.contract_id = cntr.id
)
select contract_external_id,
       (settings ->> 'is_active')::int as is_active,
       (settings ->> 'prepaid_deactivate_threshold')::double precision as deactivate_threshold
from cc0
where rn = 1;
------------------------------------------------------------------------------------------------------------------------

drop table if exists alextitov_logdata_1127_dealis_data;
create temporary table alextitov_logdata_1127_dealis_data as
with  d0 as (
    select d.id,
           d.which_crm,
           d.custom_fields ->> '5b46472f62d243f28c789cfa00dc4859a06973a8'   as agr_name,
           payment_options.label                                            as quasi,
           ct.city                                                          as city,
           ct.client_name as client_name,
           ct.market_segment                                                as market_segment,
           ct.potential                                                     as potential,
           --org.custom_fields ->> 'b2d63d8a9a4ce926b4c3fe2989d74daac44dba6a' as city,
           rating_options.label                                             as rating,
           debt_options.label                                               as debt,
           bd_reason_options.label                                          as bd_reason,
           d.pipeline_id,
           d.stage_id,
           d.user_id,
           knp.add_time::date as date_debtor,
           knp.done::int as status_debtor
          -- 'ДОСТАВКА'                                                       as product

    from snb_b2b.voytekh_pd2_deal_history as d
             left join snb_b2b.voytekh_pd2_org as org on d.org_id = org.id and d.which_crm = org.which_crm
             left join (select deal_id, city, market_segment, potential ,which_crm,client_name from  snb_b2b.niksm_b2b_deals_info) as ct
                 on ct.deal_id=d.id and ct.which_crm=d.which_crm
             left join ( select * from
                            (select deal_id,done,add_time, row_number() over (partition by deal_id order by add_time desc) rn
                             from snb_b2b.voytekh_pd2_activity
                             where which_crm = 6 and type = 'call' and subject='Дебиторская задолженность' --type = 'kontrol_oplati'
                                ) t
                        where rn=1 ) knp on knp.deal_id=d.id
             LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
                        from snb_b2b.voytekh_pd2_org_field
                        where key = 'c65f1f9256993489daabf9ae850c5c6ff889dcf0') as rating_options
                       ON (org.custom_fields ->> 'c65f1f9256993489daabf9ae850c5c6ff889dcf0') = rating_options.id_

             LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
                        from snb_b2b.voytekh_pd2_org_field
                        where key = 'c49360f086734eb22d00eadabf48fef2a7b36c04') as payment_options
                       ON (org.custom_fields ->> 'c49360f086734eb22d00eadabf48fef2a7b36c04') = payment_options.id_

             LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
                        from snb_b2b.voytekh_pd2_deal_field
                        where key = '291891bf0256ce6579a70ea8068dadafecc9b821') as debt_options
                       ON (d.custom_fields ->> '291891bf0256ce6579a70ea8068dadafecc9b821') = debt_options.id_
             LEFT JOIN (select json_object_keys(options) as id_, options ->> json_object_keys(options) as label
                        from snb_b2b.voytekh_pd2_deal_field
                        where key = '7db8be4f382aed7b7d08f19c673ce802ebcf8d38') as bd_reason_options
                       ON (d.custom_fields ->> '7db8be4f382aed7b7d08f19c673ce802ebcf8d38') = bd_reason_options.id_
    where d.which_crm = 6
      and (d.custom_fields ->> '5b46472f62d243f28c789cfa00dc4859a06973a8') is not NULL
      and d.record_date = '2022-03-29'
)
, d1 as (
        select d.id, d.which_crm, d.agr_name, d.quasi, d.city,d.market_segment,d.client_name,d.potential, d.rating, d.debt, d.bd_reason,
               s.name as stage, p.name as pipeline, m.name_last_ru, m.name_first_ru, m.lead_name_last, m.hierarchy, m.lead_login, --d.product,
                d.date_debtor, d.status_debtor,
               row_number() over (partition by d.agr_name order by d.which_crm asc) as rn
        from d0 as d
		  LEFT JOIN snb_b2b.voytekh_pd_stage as s
		    ON d.stage_id = s.pd_id and d.which_crm = s.which_crm
		  LEFT JOIN snb_b2b.voytekh_pd_pipeline as p
		    ON d.pipeline_id = p.pd_id and d.which_crm = p.which_crm
		  LEFT JOIN snb_b2b.voytekh_pd_user as o
		    ON d.user_id = o.pd_id and d.which_crm = o.which_crm
		  LEFT JOIN snb_b2b.voytekh_manager_v2 as m
		    ON split_part(o.email, '@', 1) = m.login
)
    select d.id, d.which_crm, d.agr_name, d.quasi, d.city,d.market_segment,d.client_name,d.potential, d.rating, d.debt, d.bd_reason,
           d.stage, d.pipeline, d.name_last_ru, d.name_first_ru, d.lead_name_last, d.hierarchy, d.lead_login, --d.product,
           d.date_debtor, d.status_debtor
    from d1 as d
    where d.rn = 1 ;

analyse  alextitov_logdata_1127_contract_data;
analyse  alextitov_logdata_1127_dealis_data;

------------------------------------------------------------------------------------------------------------------------
with db as (
	select
        contract_id,
        contract,
        contract_type,
        payment_type,
        start_dt,
        finish_dt,
        signed_dt,
        faxed_dt,
        cancelled_dt,
        suspended_dt,
        is_deactivated,
        is_booked,
        booked_dt,
        client_id,
        client,
        person_id,
        person_name,
        person_inn,
        person_email,
        person_phone,
        invoice_id,
        invoice,
        act_sum,
        payment_term,
        invoice_payments_sum,
        currency,
        sum(debt00) as debt00,
        sum(debt130) as debt130,
        sum(debt3060) as debt3060,
        sum(debt6090) as debt6090,
        sum(debtover90) as debtover90,
        sum(debt_sum) as debt_sum,
        sum(bad_debt) as bad_debt,
        sum(overdue_debt) as overdue_debt,
        sum(clean_debt) as clean_debt,
        sum(overdue_clean_debt) as overdue_clean_debt,
        string_agg(debt_service_id::text, ', ') as debt_service_id,
        string_agg(debt_service, ', ') as debt_service
    from snb_b2b.voytekh_corporate_contracts_and_debts
    group by
        contract_id,
        contract,
        contract_type,
        payment_type,
        start_dt,
        finish_dt,
        signed_dt,
        faxed_dt,
        cancelled_dt,
        suspended_dt,
        is_deactivated,
        is_booked,
        booked_dt,
        client_id,
        client,
        person_id,
        person_name,
        person_inn,
        person_email,
        person_phone,
        invoice_id,
        invoice,
        act_sum,
        payment_term,
        invoice_payments_sum,
        currency
)

SELECT d.hierarchy,
       db.contract,
       db.payment_type,
       case when db.payment_type = 'предоплата' and cc.deactivate_threshold < 0 then 1 else 0 end quasi,
       --d.quasi,
       db.contract_type,
       db.payment_term,
       cc.deactivate_threshold,
       db.invoice,
       db.start_dt,
       db.signed_dt,
       min_order.moscow_order_dt                                                          as             first_trip,
       db.person_name,
       d.city,
       db.person_email,
       d.rating,
       d.name_last_ru || ' ' || d.name_first_ru                                           as             mname,
       d.lead_name_last,
       d.pipeline,
       d.stage,
       d.debt,
       d.bd_reason,
       db.invoice_payments_sum,
       db.debt_sum,
       db.overdue_clean_debt, -- db.clean_debt,
       db.debt00,
       db.debt130,
       db.debt3060,
       db.debt6090,
       db.debtover90,
       COALESCE(db.debt3060, 0) + COALESCE(db.debt6090, 0) +
       COALESCE(db.debtover90, 0)                                                         as             critical,
       case
           when db.invoice_payments_sum > 0
               then db.invoice_payments_sum / (db.invoice_payments_sum + db.debt_sum) end as             payed_perc,
       db.person_inn,
       CASE
           WHEN db.suspended_dt IS NOT NULL OR (db.finish_dt IS NOT NULL and db.finish_dt::date <= now()) OR
                db.cancelled_dt IS NOT NULL THEN 'inactive'
           ELSE 'active' END                                                              as             b_status,
       CASE
           WHEN cc.is_active = 1 THEN 'активен'
           WHEN cc.is_active = 0 then 'деактивирован'
           else 'отсутствует' END                                                         as             s_status,
       CASE
           WHEN d.which_crm = 0 THEN ' https://yandextaxi.pipedrive.com/deal/' || d.id
           WHEN d.which_crm = 2 THEN ' https://yti.pipedrive.com/deal/' || d.id
           WHEN d.which_crm = 5 THEN ' https://yil.pipedrive.com/deal/' || d.id
           WHEN d.which_crm = 6 THEN ' https://yandexdelivery.pipedrive.com/deal/' || d.id
           END                                                                            as             link,
       case when db.debt_sum > 0 then db.overdue_clean_debt / db.debt_sum end             as             overdue_share,
       case
           when db.debt_sum > 0 then
                   (COALESCE(db.debt130, 0) + COALESCE(db.debt3060, 0) + COALESCE(db.debt6090, 0) +
                    COALESCE(db.debtover90, 0)) /
                   db.debt_sum end                                                        as             critical_share,
       case when order_cost365.sum_ > 0 then db.payment_term::integer / 360 * 0.15 * order_cost365.sum_ end
                                                                                          as             postpone_cost,
       case
           when order_cost90.sum_ > 0
               then db.debt_sum / order_cost90.sum_ * 90 end                              as             dso,
       order_cost365.sum_                                                                 as             order_cost365,
       order_cost90.sum_                                                                  as             order_cost90,
       --d.product,
       db.debt_service_id,
       db.debt_service,
       db.currency,
       d.market_segment,
       d.client_name,
       d.potential,
       ctn.lk_cargo_is_active                                                             as             active_servis,
       fct.fact_delivery,
       fct.delivery_days,
       d.date_debtor,
       d.status_debtor::int
FROM db
  left join alextitov_logdata_1127_dealis_data d on d.agr_name = db.contract
  left join alextitov_logdata_1127_contract_data cc on db.contract = cc.contract_external_id
  left join snb_b2b.niksm_b2b_lk_contract_info as ctn on db.contract = ctn.contract_external_id
  left join (
    select corp_contract_id,
         sum(delivery_point_cnt)                      as fact_delivery,
         count(distinct utc_order_created_dttm::date) as delivery_days
    from taxi_cdm_marketplace.fct_order
    where utc_order_created_dttm between current_date - 30 and current_date
    group by corp_contract_id
    ) fct on fct.corp_contract_id = db.contract
  LEFT JOIN (
    SELECT corp_contract_id, sum(order_cost) as sum_
    FROM summary.dm_order
    where moscow_order_dt >= (now() - INTERVAL '365 days')
      AND corp_order_flg = true
    group by corp_contract_id
    ) as order_cost365 ON order_cost365.corp_contract_id = db.contract
  LEFT JOIN (
    SELECT corp_contract_id, sum(order_cost) as sum_
    FROM summary.dm_order
    where moscow_order_dt >= (now() - INTERVAL '90 days')
      AND corp_order_flg = true
    group by corp_contract_id
    ) as order_cost90 ON order_cost90.corp_contract_id = db.contract
  LEFT JOIN (
    SELECT corp_contract_id, min(moscow_order_dt) as moscow_order_dt
    FROM summary.dm_order
    where corp_order_flg = true
    group by corp_contract_id
) as min_order ON min_order.corp_contract_id = db.contract
where d.agr_name is not null
