insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('dz_rep_mailer', 'Start', clock_timestamp());

drop table if exists alextitov_logdata_1127_contract_data;
create temporary table alextitov_logdata_1127_contract_data as
select lk.contract_external_id,
       lk_contract_is_active,
       lk_contract_prepaid_deactivate_threshold,
       lk_cargo_is_active
from snb_b2b.niksm_b2b_lk_contract_info lk
  join snb_b2b.niksm_b2b_balance_contract_info blnc
    on blnc.billing_contract_id = lk.billing_contract_id
where start_dt <= current_date
      and (finish_dt is null
        or finish_dt >= current_date)
      and cancelled_dt is null;
--
analyse alextitov_logdata_1127_contract_data;
----------------------------------------------
drop table if exists alextitov_logdata_1127_crm;
create temporary table alextitov_logdata_1127_crm as
select d.contract_id,
       d.crm_source,
       'https://yandexdelivery.amocrm.ru/leads/detail/' || lead_id::text as lead_link,
       d.city,
       coalesce(holding_name, company_name)                              as client_name,
       d.market_segment,
       d.price                                                           as potential,
       d.credit_rating                                                   as rating,
       d.debt                                                            as debt,
       d.bd_reason                                                       as bd_reason,
--            knp.add_time::date as date_debtor,
--            knp.done::int as status_debtor
       d.pipeline_status_name                                            as stage,
       d.pipeline_name                                                   as pipeline,
       d.manager_name,
       d.teamlead_name                                                   as lead_name,
       d.permissions                                                     as hierarchy,
       d.risk_repay_ovr_debt,
       d.risk_downside_2022,
       d.risk_debt_2022,
       d.debt_working
from snb_b2b.amo_contracts_info d
where d.crm_source = 'yandexdelivery'
  union all
select cn_sf.contract_id as contract_id,
       'Isr' as crm_source,
       null::text as lead_link,
       null::varchar as city,
       cn_sf.client_name,
       cn_sf.market_segment,
       cn_sf.potential,
       null as rating,
       null as debt,
       null as bd_reason,
--            knp.add_time::date as date_debtor,
--            knp.done::int as status_debtor
       null as stage,
       null as pipeline,
       cn_sf.manager_name,
       cn_sf.lead_name,
       cn_sf.permissions as hierarchy,
       null as risk_repay_ovr_debt,
       null as risk_downside_2022,
       null as risk_debt_2022,
       null as debt_working
from snb_b2b.niksm_b2b_contracts_info_sf cn_sf;
--
analyse alextitov_logdata_1127_crm;

drop table if exists alextitov_logdata_1127_dlv;
create temporary table alextitov_logdata_1127_dlv as
select corp_contract_id,
    sum(case when msk_order_created_dt between current_date-30 and current_date-1 then delivery_point_cnt end) as fact_delivery,
    count(distinct (case when msk_order_created_dt between current_date-30 and current_date-1 then msk_order_created_dt end)) as delivery_days,
    sum(case when msk_order_created_dt between date_trunc('month',date_trunc('month',current_date)::date-1)::date
           and date_trunc('month',current_date)::date-1 then order_cost end) order_cost_full_month,
    sum(case when msk_order_created_dt between current_date - 90 and current_date - 1 then order_cost end) order_cost90,
    sum(case when msk_order_created_dt between current_date - 365 and current_date - 1 then order_cost end) order_cost365,
    min(msk_order_created_dt)::date as msk_first_delivery_dt
from taxi_cdm_marketplace.fct_order
where corp_order_flg
  and utc_order_created_dttm >= current_date - 365 - 1
group by corp_contract_id
DISTRIBUTED BY (corp_contract_id);
--
analyse alextitov_logdata_1127_dlv;

drop table if exists alextitov_logdata_1127_res;
create temporary table alextitov_logdata_1127_res as
with db as (
	select
        contract_id,
        max(contract)       as contract,
        max(contract_type)  as contract_type,
        max(payment_type)   as payment_type,
        max(start_dt)       as start_dt,
        max(finish_dt)      as finish_dt,
        max(signed_dt)      as signed_dt,
        max(faxed_dt)       as faxed_dt,
        max(cancelled_dt)   as cancelled_dt,
        max(suspended_dt)   as suspended_dt,
        max(is_deactivated) as is_deactivated,
        max(is_booked)      as is_booked,
        max(booked_dt)      as booked_dt,
        max(client_id)      as client_id,
        max(client)         as client,
        max(person_id)      as person_id,
        max(person_name)    as person_name,
        max(person_inn)     as person_inn,
        max(person_email)   as person_email,
        max(person_phone)   as person_phone,
        max(invoice_id)     as invoice_id,
        invoice,
        max(act_sum)              as act_sum,
        max(payment_term::numeric)    as payment_term,
        max(invoice_payments_sum) as invoice_payments_sum,
        max(currency)             as currency,
       --
        sum(debt00) as debt00,
        sum(debt130) as debt130,
        sum(debt3060) as debt3060,
        sum(debt6090) as debt6090,
        sum(debtover90) as debtover90,
        sum(debt_sum) as debt_sum,
        sum(bad_debt) as bad_debt,
        sum(overdue_debt) as overdue_debt,
        sum(clean_debt) as clean_debt,
        sum(overdue_clean_debt) as overdue_clean_debt,
        string_agg(debt_service_id::text, ', ') as debt_service_id,
        string_agg(debt_service, ', ') as debt_service
    from snb_b2b.voytekh_corporate_contracts_and_debts
    group by
        contract_id,
        invoice
)
    select crm.hierarchy,
           db.contract,
           db.payment_type,
           case
               when db.payment_type = 'предоплата'
                   and cc.lk_contract_prepaid_deactivate_threshold < 0 then 1
               else 0 end                                                                     as quasi,
           --d.quasi,
           db.contract_type,
           db.payment_term,
           cc.lk_contract_prepaid_deactivate_threshold,
           db.invoice,
           db.start_dt,
           db.signed_dt,
           fct.msk_first_delivery_dt,
           db.person_name,
           crm.city,
           db.person_email,
           crm.rating,
           crm.manager_name,
           crm.lead_name,
           crm.pipeline,
           crm.stage,
           crm.debt_working                                                                   as debt,          -- crm.debt,
           crm.bd_reason                                                                      as bd_reason,     --crm.bd_reason,
           db.invoice_payments_sum,
           db.debt_sum,
           db.overdue_clean_debt,                                                                               -- db.clean_debt,
           db.debt00,
           db.debt130,
           db.debt3060,
           db.debt6090,
           db.debtover90,
           COALESCE(db.debt3060, 0) + COALESCE(db.debt6090, 0) + COALESCE(db.debtover90, 0) as critical,
           case
               when db.invoice_payments_sum > 0
                   then db.invoice_payments_sum / (db.invoice_payments_sum + db.debt_sum) end as payed_perc,
           db.person_inn,
           CASE
               WHEN db.suspended_dt IS NOT NULL OR (db.finish_dt IS NOT NULL and db.finish_dt::date <= now()) OR
                    db.cancelled_dt IS NOT NULL THEN 'inactive'
               ELSE 'active' END                                                              as contract_balance_status,
           CASE
               WHEN cc.lk_contract_is_active = 1 THEN 'активен'
               WHEN cc.lk_contract_is_active = 0 then 'деактивирован'
               else 'отсутствует' END                                                         as contract_lk_status,
           crm.lead_link,
           case when db.debt_sum > 0 then db.overdue_clean_debt / db.debt_sum end             as overdue_share,
           case
               when db.debt_sum > 0 then
                       (COALESCE(db.debt130, 0.) + COALESCE(db.debt3060, 0.) + COALESCE(db.debt6090, 0.) +
                        COALESCE(db.debtover90, 0.)) /
                       db.debt_sum end                                                        as critical_share,
       case when fct.order_cost365 > 0 then db.payment_term / 360 * 0.15 * fct.order_cost365 end
                                                                                          as postpone_cost,
       case when fct.order_cost90 > 0
            then db.debt_sum / fct.order_cost90 * 90. end                               as dso,
       fct.order_cost365                                                                  as order_cost365,
       fct.order_cost90                                                                   as order_cost90,
       fct.order_cost_full_month as order_cost_full_month,
       --d.product,
       db.debt_service_id,
       db.debt_service,
       db.currency,
       crm.market_segment,
       crm.client_name,
       crm.potential,
       cc.lk_cargo_is_active                                                              as active_servis,
       fct.fact_delivery,
       fct.delivery_days,
       null::date                                                                         as date_debtor,   --crm.date_debtor,
       null::text                                                                         as status_debtor, --crm.status_debtor::int
       crm.risk_debt_2022,
       crm.risk_repay_ovr_debt,
       crm.risk_downside_2022,
       bocp.payment_30d
from db
  join alextitov_logdata_1127_crm crm
    on crm.contract_id = db.contract
  left join alextitov_logdata_1127_dlv fct
    on fct.corp_contract_id = db.contract
  left join alextitov_logdata_1127_contract_data cc
    on db.contract = cc.contract_external_id
  left join
    (select invoice_eid, COALESCE(sum(amt_w_nds),0) as payment_30d
     from snb_b2b.balance_oebs_cash_payment_fact
      where doc_date between  current_date-31 and   current_date-1 group by  invoice_eid  ) bocp
    on  db.invoice= bocp.invoice_eid::text
;

-- drop table if exists snb_b2b.balance_dz_mailer_data;
-- create table snb_b2b.balance_dz_mailer_data as
truncate table snb_b2b.balance_dz_mailer_data;
insert into snb_b2b.balance_dz_mailer_data
    (hierarchy, contract, payment_type, quasi, contract_type, payment_term, lk_contract_prepaid_deactivate_threshold,
       invoice, start_dt, signed_dt, msk_first_delivery_dt, person_name, city, person_email, rating,
       manager_name, lead_name, pipeline, stage, debt, bd_reason,
       invoice_payments_sum, debt_sum, overdue_clean_debt, debt00, debt130, debt3060, debt6090, debtover90,
       critical, payed_perc, person_inn, contract_balance_status, contract_lk_status, lead_link, overdue_share,
       critical_share, postpone_cost, dso, order_cost365, order_cost90,order_cost_full_month,payment_30d,  debt_service_id, debt_service, currency,
       market_segment, client_name, potential, active_servis, fact_delivery, delivery_days,
       date_debtor, status_debtor, risk_debt_2022, risk_repay_ovr_debt, risk_downside_2022,
       _etl_processed_dttm)
select hierarchy, contract, payment_type, quasi, contract_type, payment_term, lk_contract_prepaid_deactivate_threshold,
       invoice, start_dt, signed_dt, msk_first_delivery_dt, person_name, city, person_email, rating,
       manager_name, lead_name, pipeline, stage, debt, bd_reason,
       invoice_payments_sum, debt_sum, overdue_clean_debt, debt00, debt130, debt3060, debt6090, debtover90,
       critical, payed_perc, person_inn, contract_balance_status, contract_lk_status, lead_link, overdue_share,
       critical_share, postpone_cost, dso, order_cost365, order_cost90,order_cost_full_month,payment_30d, debt_service_id, debt_service, currency,
       market_segment, client_name, potential, active_servis, fact_delivery, delivery_days,
       date_debtor, status_debtor, risk_debt_2022, risk_repay_ovr_debt, risk_downside_2022,
       (current_timestamp at time zone 'UTC')::text as _etl_processed_dttm
from alextitov_logdata_1127_res;

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('dz_rep_mailer', 'Finish', clock_timestamp());
