---- Догружаем tlog ----
---- Revenue
drop table if exists niksm_temp_1002_tlog_detailed;
create temporary table niksm_temp_1002_tlog_detailed as
select 'revenue' as source,
       service_id,
       revenue.currency_code as order_currency_code,
       revenue.ccy_code as transaction_currency_code,
       coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
       revenue.cargo_claim_id,
       tariff_class,
       detailed_product,
       transaction_value_ccy * aggregation_sign_code as transaction_value_ccy,
       utc_transaction_dttm,
       db_id, park_id
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.cargo_ref_id is not null
    and claim.utc_created_dttm >= '2022-03-01'
where utc_transaction_dttm >= '2022-05-01'
--   and utc_transaction_dttm <  '2022-00-01'
;
---- Expenses
insert into niksm_temp_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm, db_id, park_id)
select 'expenses' as source,
       service_id,
       currency_code as order_currency_code,
       ccy_code as transaction_currency_code,
       order_id,
       NULL::varchar as cargo_claim_id,
       tariff_class,
       detailed_product,
       case when transaction_type = 'payment' then transaction_value_ccy else -transaction_value_ccy end as transaction_value_ccy,
       utc_transaction_dttm,
       db_id, park_id
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2022-05-01'
--   and utc_transaction_dttm <  '2022-00-01'
;

delete from snb_b2b.niksm_1002_tlog_detailed
where utc_transaction_dttm >= '2022-05-01'
--   and utc_transaction_dttm <  '2022-04-01'
;
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code, order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm, db_id, park_id)
select source, service_id, order_currency_code, transaction_currency_code, order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm, db_id, park_id
from niksm_temp_1002_tlog_detailed;
--
analyse snb_b2b.niksm_1002_tlog_detailed;
---- endof Догружаем tlog ----
------------------------------------------------------------------------------------------------------------------------

-- Считаем слоты [geohash - 10 min] с высоким econom surge
drop table if exists niksm_temp_1002_taxi_high_surge;
create temporary table niksm_temp_1002_taxi_high_surge as
select substr(source_geohash,1,5) as source_geohash,
       date_trunc('hour',utc_order_created_dttm)
       + make_interval(0, 0, 0, 0, 0,
           (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot,
       true as taxi_high_surge_flg
from taxi_cdm_marketplace.fct_order
where true
  and utc_order_created_dttm >= '2021-11-01'
  and tariff_class_code = 'econom'
  and success_order_flg
group by 1,2
having sum(order_cost) > sum(order_before_surge_cost) * 1.5
distributed by (source_geohash, time_slot)
;
analyse niksm_temp_1002_taxi_high_surge;
------------------------------------------------------------------------------------------------------------------------

-- Достаём атрибуты заказа доставки из fct_order
drop table if exists niksm_temp_1002_fct;
create temporary table niksm_temp_1002_fct as
select order_id,
       utc_order_created_dttm,
       executor_profile_sk,
       country_name_ru,
       corp_order_flg,
       crm_main.contract_id is not null or crm_isr.contract_id is not null as delivery_crm_flg,     -- contract_id есть в CRM Доставки
       --
       substr(source_geohash,1,5) as source_geohash,
       date_trunc('hour',utc_order_created_dttm)
       + make_interval(0, 0, 0, 0, 0,
           (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot
from taxi_cdm_marketplace.fct_order_metric fct
  join snb_delivery.logdata_delivery_tariff
    on tariff_class_code = order_tariff
  left join snb_b2b.amo_contracts_info crm_main
    on crm_main.contract_id = fct.corp_contract_id
  left join snb_b2b.niksm_b2b_contracts_info_sf crm_isr
    on crm_isr.contract_id = fct.corp_contract_id
where utc_order_created_dttm >= '2021-11-01'
distributed by (order_id, executor_profile_sk)
;
analyse niksm_temp_1002_fct;
------------------------------------------------------------------------------------------------------------------------

-- Выделяем заказы, где исполнитель имел любой тариф помимо доставочных
drop table if exists niksm_temp_1002_fct_supply_state_hist;
create temporary table niksm_temp_1002_fct_supply_state_hist as
select order_id,
       executor_profile_sk,
       array_length(
           array_remove(
               array_remove(
                   array_remove(
                       array_remove(
                           array_remove(
                               array_remove(
                                   array_remove(
                                       lcl_available_tariff_class_code_list,
                                       'courier'),
                                   'express'),
                               'cargo'),
                           'cargocorp'),
                       'ubernight'),
                   'night'),
               'sdd')
               , 1) > 0 as driver_has_taxi_tariff_flg
from (
    select sppl.order_id,
           sppl.executor_profile_sk,
           lcl_available_tariff_class_code_list,
           row_number() over (partition by sppl.order_id, sppl.executor_profile_sk order by utc_valid_from_dttm nulls last) as rn
    from taxi_cdm_supply.fct_supply_state_hist sppl
      join niksm_temp_1002_fct fct
        on sppl.order_id = fct.order_id
        and sppl.executor_profile_sk = fct.executor_profile_sk
    where utc_valid_from_dttm >= '2021-11-01'
) q
where rn = 1
distributed by (order_id, executor_profile_sk)
;
analyse niksm_temp_1002_fct_supply_state_hist;
------------------------------------------------------------------------------------------------------------------------

-- Собираем все атрибуты order_id вместе
drop table if exists niksm_temp_1002_order_attr;
create temporary table niksm_temp_1002_order_attr as
select fct.order_id,
       country_name_ru,
       corp_order_flg,
       delivery_crm_flg,
       coalesce(driver_has_taxi_tariff_flg, False) as driver_has_taxi_tariff_flg,
       coalesce(taxi_high_surge_flg, False) as taxi_high_surge_flg
from niksm_temp_1002_fct fct
  left join niksm_temp_1002_fct_supply_state_hist sppl
    on sppl.order_id = fct.order_id
    and sppl.executor_profile_sk = fct.executor_profile_sk
  left join niksm_temp_1002_taxi_high_surge taxi_high_surge
    on taxi_high_surge.source_geohash = fct.source_geohash
    and taxi_high_surge.time_slot = fct.time_slot
distributed by (order_id)
;
analyse niksm_temp_1002_order_attr;

-- drop table if exists snb_b2b.niksm_temp_1002_order_attr;
-- create table snb_b2b.niksm_temp_1002_order_attr as
truncate table snb_b2b.niksm_temp_1002_order_attr;
insert into snb_b2b.niksm_temp_1002_order_attr (order_id, country_name_ru, corp_order_flg, delivery_crm_flg, driver_has_taxi_tariff_flg, taxi_high_surge_flg)
select order_id, country_name_ru, corp_order_flg, delivery_crm_flg, driver_has_taxi_tariff_flg, taxi_high_surge_flg
from niksm_temp_1002_order_attr;
------------------------------------------------------------------------------------------------------------------------
drop table if exists temp_service_owners;
create temporary table temp_service_owners(service_id,service_owner) as (
    values (1161, 'Delivery'),
           (1162, 'Delivery'),
           (1163, 'Delivery'),
           (1164, 'Delivery'),
           (719,  'Delivery'),
           (718,  'Delivery'),
           (1168, 'Delivery'),
           (111, 'Taxi'),
           (124, 'Taxi'),
           (125, 'Taxi'),
           (128, 'Taxi'),
           (137, 'Taxi'),
           (651, 'Taxi'),
           (650, 'Taxi'),
           (697, 'Taxi')
);

drop table if exists temp_employment_type;
create temporary table temp_employment_type as
select park_client_id,
       park_taximeter_id,
       string_agg(distinct executor_employment_type,',') as executor_employment_type
from taxi_cdm_executor.dim_executor_profile_hist
where true
--   and utc_valid_from_dttm < current_timestamp
  and utc_valid_to_dttm >= '2022-05-01'
group by 1,2
distributed by (park_client_id, park_taximeter_id);
analyse temp_employment_type;

-- Группировка tlog
drop table if exists niksm_temp_1002_tlog_raw0;
create temporary table niksm_temp_1002_tlog_raw0 as
select order_id,
       order_currency_code,
       transaction_currency_code,
       case when b2b_expenses<>0 then tariff_class end as tariff_class,
       utc_transaction_dttm,
       transaction_value_ccy * gross_commission_revenue as gross_commission_revenue,
       transaction_value_ccy * incentives as incentives,
       transaction_value_ccy * b2b_revenue as b2b_revenue,
       transaction_value_ccy * b2b_expenses as b2b_expenses,
       tlog.service_id,
       tlog.park_id,
       tlog.db_id
from snb_b2b.niksm_1002_tlog_detailed as tlog
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = tlog.source
    and metr.detailed_product = tlog.detailed_product;

drop table if exists niksm_temp_1002_tlog_raw1;
create temporary table niksm_temp_1002_tlog_raw1 as
select order_id,
       order_currency_code,
       transaction_currency_code,
       tariff_class,
       utc_transaction_dttm,
       gross_commission_revenue,
       incentives,
       b2b_revenue,
       b2b_expenses,
--        tlog.service_id,
       tlog.park_id,
       tlog.db_id,
       serv.service_owner
from niksm_temp_1002_tlog_raw0 as tlog
  left join temp_service_owners serv
    on serv.service_id = tlog.service_id;

drop table if exists niksm_temp_1002_tlog_raw2;
create temporary table niksm_temp_1002_tlog_raw2 as
select order_id,
       order_currency_code,
       transaction_currency_code,
       tariff_class,
       utc_transaction_dttm,
       gross_commission_revenue,
       incentives,
       b2b_revenue,
       b2b_expenses,
--        tlog.service_id,
--        tlog.park_id,
--        tlog.db_id,
       service_owner,
       executor_employment_type
from niksm_temp_1002_tlog_raw1 as tlog
  left join temp_employment_type emp
    on emp.park_client_id = tlog.park_id
    and emp.park_taximeter_id = tlog.db_id;

drop table if exists niksm_temp_1002_tlog;
create temporary table niksm_temp_1002_tlog as
select order_id,
       order_currency_code,
       transaction_currency_code,
       service_owner,
       max(max(tariff_class))
           over (partition by order_id) as order_tariff_class,
       utc_transaction_dttm,
       sum(gross_commission_revenue) as gross_commission_revenue,
       sum(incentives) as incentives,
       sum(b2b_revenue) as b2b_revenue,
       sum(b2b_expenses) as b2b_expenses,
       -- в т.ч. записи по order_id могут быть на другую дату транзакции; обрезать по датам после расчёта флагов
       bool_or(sum(b2b_revenue)<>0 and service_owner = 'Delivery')
           over (partition by order_id) as delivery_client_service_flg,
       bool_or(sum(b2b_expenses)<>0 and service_owner = 'Delivery')
           over (partition by order_id) as delivery_park_service_flg,
       max(max(executor_employment_type))
           over (partition by order_id) as executor_employment_type
from niksm_temp_1002_tlog_raw2
group by order_id,
         order_currency_code,
         transaction_currency_code,
         service_owner,
         utc_transaction_dttm
distributed by (order_id);
--
analyse niksm_temp_1002_tlog;
------------------------------------------------------------------------------------------------------------------------

drop table if exists currency_rates;
create temporary table currency_rates as
select calmonth,
       date,
       source_cur,
       rate
from (
    select date_trunc('month',date)::date as calmonth,
           date,
           source_cur,
           rate,
           row_number() over (partition by source_cur, date_trunc('month',date)::date order by date desc) as rn
    from dds.dim_currency_rate
    where true
      and target_cur = 'RUB'
      and date >= '2022-01-01'
)q
where rn = 1;

drop table if exists temp_1002_res;
create temporary table temp_1002_res as
with tlog as (
    select order_id,
           utc_transaction_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as msk_transaction_dttm,
           order_currency_code,
           transaction_currency_code,
           service_owner,
           executor_employment_type,
           order_tariff_class,
           gross_commission_revenue,
           incentives,
           b2b_revenue,
           b2b_expenses,
           delivery_client_service_flg,
           delivery_park_service_flg
    from niksm_temp_1002_tlog
    where utc_transaction_dttm >= timestamp'2022-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
--       and utc_transaction_dttm <  timestamp'2022-06-01' at time zone 'Europe/Moscow' at time zone 'UTC'
)
, tlog_attr as (
    select date_trunc('month',msk_transaction_dttm)::date as msk_transaction_month,
           msk_transaction_dttm::date as msk_transaction_dt,
           order_currency_code,
           transaction_currency_code,
           service_owner,
           executor_employment_type,
           delivery_client_service_flg,
           delivery_park_service_flg,
           order_tariff_class,
           order_attr.country_name_ru,
           order_attr.corp_order_flg,
           coalesce(order_attr.delivery_crm_flg, False) as delivery_crm_flg,
           coalesce(order_attr.driver_has_taxi_tariff_flg, False) as driver_has_taxi_tariff_flg,
           coalesce(order_attr.taxi_high_surge_flg, False) as taxi_high_surge_flg,
           --
           sum(gross_commission_revenue) as gross_commission_revenue,
           sum(incentives) as incentives,
           sum(b2b_revenue) as b2b_revenue,
           sum(b2b_expenses) as b2b_expenses
    from tlog
      left join snb_b2b.niksm_temp_1002_order_attr order_attr
        on order_attr.order_id = tlog.order_id
    group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14
)
select msk_transaction_month,
       msk_transaction_dt,
       order_currency_code, transaction_currency_code,
       service_owner, executor_employment_type, delivery_client_service_flg, delivery_park_service_flg, order_tariff_class,
       country_name_ru, corp_order_flg,
       delivery_crm_flg, driver_has_taxi_tariff_flg, taxi_high_surge_flg,
       gross_commission_revenue, incentives, b2b_revenue, b2b_expenses,
       gross_commission_revenue * rate as gross_commission_revenue_rub,
       incentives * rate as incentives_rub,
       b2b_revenue * rate as b2b_revenue_rub,
       b2b_expenses * rate as b2b_expenses_rub
from tlog_attr
  left join currency_rates
    on currency_rates.calmonth = tlog_attr.msk_transaction_month
    and currency_rates.source_cur = tlog_attr.transaction_currency_code
;

--====================================================================================================================--
---- Итоговая таблица ----
-- drop table if exists snb_delivery.niksm_fin_delivery_taxi_demerge;
-- create table snb_delivery.niksm_fin_delivery_taxi_demerge as
truncate table snb_delivery.niksm_fin_delivery_taxi_demerge;
insert into snb_delivery.niksm_fin_delivery_taxi_demerge
    (msk_transaction_month,
       msk_transaction_dt,
       order_currency_code, transaction_currency_code,
       service_owner, executor_employment_type, delivery_client_service_flg, delivery_park_service_flg, order_tariff_class,
       country_name_ru, corp_order_flg, delivery_crm_flg, driver_has_taxi_tariff_flg, taxi_high_surge_flg,
       gross_commission_revenue, incentives, b2b_revenue, b2b_expenses,
       gross_commission_revenue_rub, incentives_rub, b2b_revenue_rub, b2b_expenses_rub)
--
select msk_transaction_month,
       msk_transaction_dt,
       order_currency_code, transaction_currency_code,
       service_owner, executor_employment_type, delivery_client_service_flg, delivery_park_service_flg, order_tariff_class,
       country_name_ru, corp_order_flg, delivery_crm_flg, driver_has_taxi_tariff_flg, taxi_high_surge_flg,
       gross_commission_revenue, incentives, b2b_revenue, b2b_expenses,
       gross_commission_revenue_rub, incentives_rub, b2b_revenue_rub, b2b_expenses_rub
from temp_1002_res;
--
-- revoke select on snb_delivery.niksm_fin_delivery_taxi_demerge from ro_snb_delivery;
-- grant select on snb_delivery.niksm_fin_delivery_taxi_demerge to niksm, ustinenko, ro_snb_b2b;
-- analyse snb_delivery.niksm_fin_delivery_taxi_demerge;

--====================================================================================================================--
-- check monthly
select date_trunc('month',utc_transaction_dttm)::date,
       count() filter ( where source = 'revenue' ) as revenue_cnt,
       count() filter ( where source = 'expenses' ) as expenses_cnt
from snb_b2b.niksm_1002_tlog_detailed
group by 1 order by 1;

-- check for new service_id (target = NULL)
select tlog.service_id, count()
from snb_b2b.niksm_1002_tlog_detailed tlog
  left join temp_service_owners serv
    on serv.service_id = tlog.service_id
where serv.service_id is null
group by tlog.service_id;

-- check for new currency (target = NULL)
select date_trunc('month',utc_transaction_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date,
       transaction_currency_code,
       count()
from niksm_temp_1002_tlog
  left join currency_rates
    on currency_rates.calmonth = date_trunc('month',utc_transaction_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date
    and currency_rates.source_cur = transaction_currency_code
where utc_transaction_dttm >= timestamp'2022-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
  and (currency_rates.rate is null
    or currency_rates.rate <= 0)
group by 1,2 order by 1,2;
--====================================================================================================================--

select * from snb_delivery.niksm_fin_delivery_taxi_demerge
where true
  and msk_transaction_dt < current_date
order by msk_transaction_dt;

select transaction_currency_code,
       msk_transaction_month,
       msk_transaction_dt,
       executor_employment_type,
       sum(case when service_owner = 'Taxi' then gross_commission_revenue end) as gross_commission_revenue_taxi_serv,
       sum(case when service_owner = 'Taxi' then incentives end) as incentives_taxi_serv,
       sum(case when service_owner = 'Taxi'
                 and corp_order_flg
                 and not delivery_client_service_flg
                 and delivery_park_service_flg
                then b2b_revenue else 0 end) as resale_revenue,
       coalesce(sum(case when service_owner = 'Taxi'
                         then b2b_revenue else 0 end),0)
       - coalesce(sum(case when service_owner = 'Taxi'
                 and corp_order_flg
                 and not delivery_client_service_flg
                 and delivery_park_service_flg
                then b2b_revenue else 0 end),0)
       - coalesce(sum(case when service_owner = 'Taxi'
                then b2b_expenses else 0 end),0) as decoupling_taxi_serv_wo_resale,
       sum(case when corp_order_flg
                 and not delivery_crm_flg
                 and not delivery_client_service_flg
                then b2b_revenue - b2b_expenses else 0 end) as taxi_household_decoupling,
       sum(case when driver_has_taxi_tariff_flg
                 and taxi_high_surge_flg
                then gross_commission_revenue * 0.25 else 0 end) as fallback_high_surge_commission
from snb_delivery.niksm_fin_delivery_taxi_demerge
where true
  and msk_transaction_dt < current_date
group by 1,2,3,4
order by msk_transaction_dt;
