-- drop table if exists snb_b2b.niksm_1002_tlog_detailed;
create table snb_b2b.niksm_1002_tlog_detailed
(
    source                    varchar,
    service_id                bigint,
    order_currency_code       varchar,
    transaction_currency_code varchar,
    order_id                  varchar,
    cargo_claim_id            varchar,
    tariff_class              varchar,
    detailed_product          varchar,
    transaction_value_ccy     numeric,
    utc_transaction_dttm      timestamp
)
distributed by (order_id)
partition by range (utc_transaction_dttm) (
    partition "202112" start ('2021-12-01 00:00:00'::timestamp without time zone) end ('2022-01-01 00:00:00'::timestamp without time zone),
    partition "202201" start ('2022-01-01 00:00:00'::timestamp without time zone) end ('2022-02-01 00:00:00'::timestamp without time zone),
    partition "202202" start ('2022-02-01 00:00:00'::timestamp without time zone) end ('2022-03-01 00:00:00'::timestamp without time zone),
    partition "202203" start ('2022-03-01 00:00:00'::timestamp without time zone) end ('2022-04-01 00:00:00'::timestamp without time zone),
    partition "202204" start ('2022-04-01 00:00:00'::timestamp without time zone) end ('2022-05-01 00:00:00'::timestamp without time zone),
    partition "202205" start ('2022-05-01 00:00:00'::timestamp without time zone) end ('2022-06-01 00:00:00'::timestamp without time zone),
    partition "202206" start ('2022-06-01 00:00:00'::timestamp without time zone) end ('2022-07-01 00:00:00'::timestamp without time zone),
    partition "202207" start ('2022-07-01 00:00:00'::timestamp without time zone) end ('2022-08-01 00:00:00'::timestamp without time zone),
    partition "202208" start ('2022-08-01 00:00:00'::timestamp without time zone) end ('2022-09-01 00:00:00'::timestamp without time zone),
    partition "202209" start ('2022-09-01 00:00:00'::timestamp without time zone) end ('2022-10-01 00:00:00'::timestamp without time zone),
    partition "202210" start ('2022-10-01 00:00:00'::timestamp without time zone) end ('2022-11-01 00:00:00'::timestamp without time zone),
    partition "202211" start ('2022-11-01 00:00:00'::timestamp without time zone) end ('2022-12-01 00:00:00'::timestamp without time zone),
    partition "202212" start ('2022-12-01 00:00:00'::timestamp without time zone) end ('2023-01-01 00:00:00'::timestamp without time zone)
    );

------------------------------------------------------------------------------------------------------------------------
truncate table snb_b2b.niksm_1002_tlog_detailed;
---- Revenue Dec'21
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
select 'revenue' as source,
       service_id,
       revenue.currency_code as order_currency_code,
       revenue.ccy_code as transaction_currency_code,
       coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
       revenue.cargo_claim_id,
       tariff_class,
       detailed_product,
       transaction_value_ccy * aggregation_sign_code as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.cargo_ref_id is not null
    and claim.utc_created_dttm >= '2021-10-01'
where utc_transaction_dttm >= '2021-12-01'
  and utc_transaction_dttm <  '2022-01-01';

---- Revenue Jan'22
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
select 'revenue' as source,
       service_id,
       revenue.currency_code as order_currency_code,
       revenue.ccy_code as transaction_currency_code,
       coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
       revenue.cargo_claim_id,
       tariff_class,
       detailed_product,
       transaction_value_ccy * aggregation_sign_code as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.cargo_ref_id is not null
    and claim.utc_created_dttm >= '2021-11-01'
where utc_transaction_dttm >= '2022-01-01'
  and utc_transaction_dttm <  '2022-02-01';

---- Revenue Feb'22
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
select 'revenue' as source,
       service_id,
       revenue.currency_code as order_currency_code,
       revenue.ccy_code as transaction_currency_code,
       coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
       revenue.cargo_claim_id,
       tariff_class,
       detailed_product,
       transaction_value_ccy * aggregation_sign_code as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.cargo_ref_id is not null
    and claim.utc_created_dttm >= '2021-12-01'
where utc_transaction_dttm >= '2022-02-01'
  and utc_transaction_dttm <  '2022-03-01';

---- Revenue Mar'22
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
select 'revenue' as source,
       service_id,
       revenue.currency_code as order_currency_code,
       revenue.ccy_code as transaction_currency_code,
       coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
       revenue.cargo_claim_id,
       tariff_class,
       detailed_product,
       transaction_value_ccy * aggregation_sign_code as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.cargo_ref_id is not null
    and claim.utc_created_dttm >= '2022-01-01'
where utc_transaction_dttm >= '2022-03-01'
  and utc_transaction_dttm <  '2022-04-01';

---- Revenue Apr'22
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
select 'revenue' as source,
       service_id,
       revenue.currency_code as order_currency_code,
       revenue.ccy_code as transaction_currency_code,
       coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
       revenue.cargo_claim_id,
       tariff_class,
       detailed_product,
       transaction_value_ccy * aggregation_sign_code as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.cargo_ref_id is not null
    and claim.utc_created_dttm >= '2022-02-01'
where utc_transaction_dttm >= '2022-04-01'
  and utc_transaction_dttm <  '2022-05-01';

---- Revenue May'22
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
select 'revenue' as source,
       service_id,
       revenue.currency_code as order_currency_code,
       revenue.ccy_code as transaction_currency_code,
       coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
       revenue.cargo_claim_id,
       tariff_class,
       detailed_product,
       transaction_value_ccy * aggregation_sign_code as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.cargo_ref_id is not null
    and claim.utc_created_dttm >= '2022-03-01'
where utc_transaction_dttm >= '2022-05-01'
  and utc_transaction_dttm <  '2022-06-01';

---- Revenue Jun'22
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
select 'revenue' as source,
       service_id,
       revenue.currency_code as order_currency_code,
       revenue.ccy_code as transaction_currency_code,
       coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
       revenue.cargo_claim_id,
       tariff_class,
       detailed_product,
       transaction_value_ccy * aggregation_sign_code as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.cargo_ref_id is not null
    and claim.utc_created_dttm >= '2022-04-01'
where utc_transaction_dttm >= '2022-06-01'
  and utc_transaction_dttm <  '2022-07-01';
------------------------------------------------------------------------------------------------------------------------

---- Expenses Dec'21
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
 select 'expenses' as source,
       service_id,
       currency_code as order_currency_code,
       ccy_code as transaction_currency_code,
       order_id,
       NULL::varchar as cargo_claim_id,
       tariff_class,
       detailed_product,
       (transaction_value_ccy - coalesce(vat,0)) * (case when transaction_type = 'payment' then 1 else -1 end) as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2021-12-01'
  and utc_transaction_dttm <  '2022-01-01';

---- Expenses Jan'21
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
 select 'expenses' as source,
       service_id,
       currency_code as order_currency_code,
       ccy_code as transaction_currency_code,
       order_id,
       NULL::varchar as cargo_claim_id,
       tariff_class,
       detailed_product,
       (transaction_value_ccy - coalesce(vat,0)) * (case when transaction_type = 'payment' then 1 else -1 end) as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2022-01-01'
  and utc_transaction_dttm <  '2022-02-01';

---- Expenses Feb'21
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
 select 'expenses' as source,
       service_id,
       currency_code as order_currency_code,
       ccy_code as transaction_currency_code,
       order_id,
       NULL::varchar as cargo_claim_id,
       tariff_class,
       detailed_product,
       (transaction_value_ccy - coalesce(vat,0)) * (case when transaction_type = 'payment' then 1 else -1 end) as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2022-02-01'
  and utc_transaction_dttm <  '2022-03-01';

---- Expenses Mar'21
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
 select 'expenses' as source,
       service_id,
       currency_code as order_currency_code,
       ccy_code as transaction_currency_code,
       order_id,
       NULL::varchar as cargo_claim_id,
       tariff_class,
       detailed_product,
       (transaction_value_ccy - coalesce(vat,0)) * (case when transaction_type = 'payment' then 1 else -1 end) as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2022-03-01'
  and utc_transaction_dttm <  '2022-04-01';

---- Expenses Apr'21
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
 select 'expenses' as source,
       service_id,
       currency_code as order_currency_code,
       ccy_code as transaction_currency_code,
       order_id,
       NULL::varchar as cargo_claim_id,
       tariff_class,
       detailed_product,
       (transaction_value_ccy - coalesce(vat,0)) * (case when transaction_type = 'payment' then 1 else -1 end) as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2022-04-01'
  and utc_transaction_dttm <  '2022-05-01';

---- Expenses May'21
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
 select 'expenses' as source,
       service_id,
       currency_code as order_currency_code,
       ccy_code as transaction_currency_code,
       order_id,
       NULL::varchar as cargo_claim_id,
       tariff_class,
       detailed_product,
       (transaction_value_ccy - coalesce(vat,0)) * (case when transaction_type = 'payment' then 1 else -1 end) as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2022-05-01'
  and utc_transaction_dttm <  '2022-06-01';

---- Expenses Jun'21
insert into snb_b2b.niksm_1002_tlog_detailed
    (source, service_id, order_currency_code, transaction_currency_code,
     order_id, cargo_claim_id, tariff_class, detailed_product, transaction_value_ccy, utc_transaction_dttm)
 select 'expenses' as source,
       service_id,
       currency_code as order_currency_code,
       ccy_code as transaction_currency_code,
       order_id,
       NULL::varchar as cargo_claim_id,
       tariff_class,
       detailed_product,
       (transaction_value_ccy - coalesce(vat,0)) * (case when transaction_type = 'payment' then 1 else -1 end) as transaction_value_ccy,
       utc_transaction_dttm
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2022-06-01'
  and utc_transaction_dttm <  '2022-07-01';

analyse snb_b2b.niksm_1002_tlog_detailed;

-- select * from core_ods_billing.revenue;
-- select * from core_ods_billing.expenses;
