-- 1) fct_order
drop table if exists snb_delivery.niksm_temp_logdata1002_fct_order;
create table snb_delivery.niksm_temp_logdata1002_fct_order as
select order_id,
       utc_order_created_dttm,
       --
       country_name_ru,
       fact_payment_type,
       case when not corp_order_flg then '1_C2C/SMB'
            when blnc.legal_contract_cargo = 1 then '2_Yandex.Delivery'
            when (crm.contract_id is not null or crm_sf.contract_id is not null) then '3_Yandex.Delivery (potential)'
            else '4_Yandex.Taxi' end as client_legal_type,
       currency_code, order_cost
from taxi_cdm_marketplace.fct_order
  left join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = fct_order.corp_contract_id
  left join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = fct_order.corp_contract_id
    and crm.which_crm = 6
    and crm.status <> 'lost'
  left join snb_b2b.niksm_b2b_contracts_info_sf crm_sf
    on crm_sf.contract_id = fct_order.corp_contract_id
where utc_order_created_dttm >= '2021-09-01'
--   and utc_order_created_dttm <  '2021-12-01'
  and tariff_class_code in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight');
--
analyse snb_delivery.niksm_temp_logdata1002_fct_order;

-- 2) revenue
drop table if exists snb_delivery.niksm_temp_logdata1002_revenue;
create table snb_delivery.niksm_temp_logdata1002_revenue as
select coalesce(order_id,taxi_order_id) as order_id,
       utc_transaction_dttm,
       service_id in (718) as delivery_service_flg,
       claim.corp_client_id is not null as claim_corp_flg,
       detailed_product,
       ccy_code, revenue.currency_code,
       case when transaction_type = 'payment' then transaction_value
            when transaction_type = 'refund' then -transaction_value end as transaction_value,
       case when transaction_type = 'payment' then transaction_value_ccy
            when transaction_type = 'refund' then -transaction_value_ccy end as transaction_value_ccy
from core_ods_billing.revenue
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and claim.utc_created_dttm >= '2021-09-01'
--     and claim.utc_created_dttm <  '2021-12-01'
    and claim.cargo_ref_id is not null
where utc_transaction_dttm >= '2021-10-01'
--   and utc_transaction_dttm <  '2021-12-01'
  and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight');
--
analyse snb_delivery.niksm_temp_logdata1002_revenue;

-- 2.1) rev delivery clients
drop table if exists snb_delivery.niksm_temp_logdata1002_rev_dlv_flg;
create table snb_delivery.niksm_temp_logdata1002_rev_dlv_flg as
select order_id
from snb_delivery.niksm_temp_logdata1002_fct_order
where client_legal_type <> '4_Yandex.Taxi'
union
select distinct order_id
from snb_delivery.niksm_temp_logdata1002_revenue
where delivery_service_flg;
--
analyse snb_delivery.niksm_temp_logdata1002_rev_dlv_flg;


-- 3) expenses
drop table if exists snb_delivery.niksm_temp_logdata1002_expenses;
create table snb_delivery.niksm_temp_logdata1002_expenses as
select order_id,
       utc_transaction_dttm,
       service_id in (719) as delivery_service_flg,
       detailed_product,
       ccy_code, expenses.currency_code,
       case when transaction_type = 'payment' then transaction_value
            when transaction_type = 'refund' then -transaction_value end as transaction_value,
       case when transaction_type = 'payment' then transaction_value_ccy
            when transaction_type = 'refund' then -transaction_value_ccy end as transaction_value_ccy
from core_ods_billing.expenses
where utc_transaction_dttm >= '2021-10-01'
--   and utc_transaction_dttm <  '2021-12-01'
  and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight');
--
analyse snb_delivery.niksm_temp_logdata1002_expenses;

-- 3.1) exp delivery clients
drop table if exists snb_delivery.niksm_temp_logdata1002_exp_dlv_flg;
create table snb_delivery.niksm_temp_logdata1002_exp_dlv_flg as
select distinct order_id
from snb_delivery.niksm_temp_logdata1002_expenses
where delivery_service_flg;
--
analyse snb_delivery.niksm_temp_logdata1002_exp_dlv_flg;


-- check
-- select delivery_service_flg,
--        client_legal_type,
--        sum(transaction_value)
-- from snb_delivery.niksm_temp_logdata1002_revenue rev
--   left join snb_delivery.niksm_temp_logdata1002_fct_order fct
--     on rev.order_id = fct.order_id
-- where utc_transaction_dttm >= '2021-11-01'
--   and utc_transaction_dttm <  '2021-12-01'
-- group by 1,2 order by 1,2;

-- MAIN
select date_trunc('month',utc_transaction_dttm)::date as calmonth,
       country_name_ru,
       rev_dlv_flg.order_id is not null as target_delivery_client_flg,
       client_legal_type,
       fact_payment_type,
       exp_dlv_flg.order_id is not null as target_delivery_park_flg,
       'revenue' as billing_source,
       delivery_service_flg,
       detailed_product,
       currency_code,
       sum(transaction_value) as transaction_value,
       ccy_code,
       sum(transaction_value_ccy) as transaction_value_ccy
from snb_delivery.niksm_temp_logdata1002_revenue rev
  left join snb_delivery.niksm_temp_logdata1002_fct_order fct
    on fct.order_id = rev.order_id
  left join snb_delivery.niksm_temp_logdata1002_rev_dlv_flg rev_dlv_flg
    on rev_dlv_flg.order_id = rev.order_id
  left join snb_delivery.niksm_temp_logdata1002_exp_dlv_flg exp_dlv_flg
    on exp_dlv_flg.order_id = rev.order_id
where utc_transaction_dttm >= '2021-11-01'
--   and utc_transaction_dttm <  '2021-12-01'
group by date_trunc('month',utc_transaction_dttm),
       country_name_ru,
       rev_dlv_flg.order_id is not null,
       client_legal_type,
       fact_payment_type,
       exp_dlv_flg.order_id is not null,
       delivery_service_flg,
       detailed_product,
       currency_code,
       ccy_code
--
union all
select date_trunc('month',utc_transaction_dttm)::date as calmonth,
       country_name_ru,
       rev_dlv_flg.order_id is not null as target_delivery_client_flg,
       client_legal_type,
       fact_payment_type,
       exp_dlv_flg.order_id is not null as target_delivery_park_flg,
       'expenses' as billing_source,
       delivery_service_flg,
       detailed_product,
       currency_code,
       sum(transaction_value) as transaction_value,
       ccy_code,
       sum(transaction_value_ccy) as transaction_value_ccy
from snb_delivery.niksm_temp_logdata1002_expenses exp
  left join snb_delivery.niksm_temp_logdata1002_fct_order fct
    on fct.order_id = exp.order_id
  left join snb_delivery.niksm_temp_logdata1002_rev_dlv_flg rev_dlv_flg
    on rev_dlv_flg.order_id = exp.order_id
  left join snb_delivery.niksm_temp_logdata1002_exp_dlv_flg exp_dlv_flg
    on exp_dlv_flg.order_id = exp.order_id
where utc_transaction_dttm >= '2021-11-01'
--   and utc_transaction_dttm <  '2021-12-01'
group by date_trunc('month',utc_transaction_dttm),
       country_name_ru,
       rev_dlv_flg.order_id is not null,
       client_legal_type,
       fact_payment_type,
       exp_dlv_flg.order_id is not null,
       delivery_service_flg,
       detailed_product,
       currency_code,
       ccy_code;
-- endof MAIN


-- fct_order dynamics
with parks as (
    select clid,
           bool_or(is_signed_719) and bool_or(is_signed_1161) and bool_or(is_signed_1164) as is_signed_full
    from snb_b2b.niksm_park_delivery_transfer_status
    group by clid
    having bool_or(is_signed_719) or bool_or(is_signed_1161) or bool_or(is_signed_1164)
)
select date_trunc('month',fct.msk_order_created_dt)::date as calmonth,
       date_trunc('week',fct.msk_order_created_dt)::date as calweek,
       fct.msk_order_created_dt between current_date-30 and current_date-1 as last_30d_flg,
       --
       fct.country_name_ru,
       case when not fct.corp_order_flg then '1_C2C/SMB'
            when blnc.legal_contract_cargo = 1 then '2_Yandex.Delivery'
            when (crm.contract_id is not null or crm_sf.contract_id is not null) then '3_Yandex.Delivery (potential)'
            else '4_Yandex.Taxi' end as client_legal_type,
       case when fct.fact_payment_type in ('applepay', 'card', 'googlepay') then 'card/pay'
           else coalesce(fct.fact_payment_type,'N/A') end as fact_payment_type,
       case when is_signed_full is null then '3_Yandex.Taxi'
            when is_signed_full then '1_Yandex.Delivery'
            when not is_signed_full then '2_Yandex.Delivery (potential)'
           end as park_legal_type,
       fct.currency_code,
       sum(fct.gmv_amt * case when fct.currency_code = 'RUB' then 1.0 else fct.currency_rate end) as gmv_amt_rub,
       sum(fct.gross_commission_revenue_amt * case when fct.currency_code = 'RUB' then 1.0 else fct.currency_rate end) as gross_commission_revenue_amt_rub,
       sum(fct.incentives_amt * case when fct.currency_code = 'RUB' then 1.0 else fct.currency_rate end) as incentives_amt_rub,
       sum(case when fct.decoupling_success_flg then
           fct.decoupling_user_cost * case when fct.currency_code = 'RUB' then 1.0 else fct.currency_rate end end) as decoupling_user_cost_rub,
       sum(case when fct.decoupling_success_flg then
           fct.decoupling_driver_cost * case when fct.currency_code = 'RUB' then 1.0 else fct.currency_rate end end) as decoupling_driver_cost_rub
from taxi_cdm_marketplace.fct_order_metric fct
  join taxi_cdm_marketplace.fct_order
    on fct.order_id = fct_order.order_id
  left join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = fct.corp_contract_id
  left join snb_b2b.niksm_b2b_contracts_info crm
    on crm.contract_id = fct.corp_contract_id
    and crm.which_crm = 6
    and crm.status <> 'lost'
  left join snb_b2b.niksm_b2b_contracts_info_sf crm_sf
    on crm_sf.contract_id = fct.corp_contract_id
  left join parks
    on parks.clid = fct_order.park_client_id::numeric
where true
  and fct.utc_order_created_dttm >= '2021-11-01'
  and fct_order.utc_order_created_dttm >= '2021-11-01'
--   and utc_order_created_dttm <  '2021-12-01'
  and fct.tariff_class_code in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
group by date_trunc('month',fct.msk_order_created_dt)::date,
       date_trunc('week',fct.msk_order_created_dt)::date,
       fct.msk_order_created_dt between current_date-30 and current_date-1,
       --
       fct.country_name_ru,
       case when not fct.corp_order_flg then '1_C2C/SMB'
            when blnc.legal_contract_cargo = 1 then '2_Yandex.Delivery'
            when (crm.contract_id is not null or crm_sf.contract_id is not null) then '3_Yandex.Delivery (potential)'
            else '4_Yandex.Taxi' end,
         case when fct.fact_payment_type in ('applepay', 'card', 'googlepay') then 'card/pay'
           else coalesce(fct.fact_payment_type,'N/A') end,
       case when is_signed_full is null then '3_Yandex.Taxi'
            when is_signed_full then '1_Yandex.Delivery'
            when not is_signed_full then '2_Yandex.Delivery (potential)'
           end,
       fct.currency_code;

select park_client_id::numeric,
       sum(order_cost)
from taxi_cdm_marketplace.fct_order fct
where true
  and fct.utc_order_created_dttm >= '2021-11-01'
  and country_name_ru = 'Казахстан'
group by 1 order by 2 desc;

select *
from snb_b2b.niksm_park_delivery_transfer_status
where clid = 400000646896;

select currency_code,
       currency_rate is not null,
       count()
from taxi_cdm_marketplace.fct_order fct
where true
  and fct.utc_order_created_dttm >= '2021-11-01'
--   and fct.tariff_class_code in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
--   and currency_rate is null
group by 1,2

select clid is not null, count(), sum(delivery_point_cnt)
from taxi_cdm_marketplace.fct_order
  left join (select distinct clid
      from snb_b2b.niksm_park_delivery_transfer_status) q
    on clid = park_client_id::numeric
where utc_order_created_dttm >= '2021-12-01'
  and delivery_point_cnt>0
  and country_name_ru = 'Россия'
group by 1;

-- select is_signed_719, is_signed_1161, is_signed_1162, is_signed_1163, is_signed_1164,
--        count(),
--        sum(total_trips) as total_trips,
--        sum(delivery_trips) as delivery_trips
-- from (
--     select clid,
--            bool_or(is_signed_719) as is_signed_719,
--            bool_or(is_signed_1161) as is_signed_1161,
--            bool_or(is_signed_1162) as is_signed_1162,
--            bool_or(is_signed_1163) as is_signed_1163,
--            bool_or(is_signed_1164) as is_signed_1164,
--            sum(total_trips) as total_trips,
--            sum(delivery_trips) as delivery_trips
--     from snb_b2b.niksm_park_delivery_transfer_status
--     group by clid
-- ) q
-- group by is_signed_719, is_signed_1161, is_signed_1162, is_signed_1163, is_signed_1164
-- order by is_signed_719, is_signed_1161, is_signed_1162, is_signed_1163, is_signed_1164;

select client_id, count()
from snb_b2b.niksm_park_delivery_transfer_status
group by client_id
having count()>1;

select date_trunc('month',utc_order_created_dttm)::date as calmonth,
       country_name_ru,
       rev_dlv_flg.order_id is not null as target_delivery_client_flg,
       client_legal_type,
       fact_payment_type,
       exp_dlv_flg.order_id is not null as target_delivery_park_flg,
       currency_code,
       sum(order_cost) as order_cost
from snb_delivery.niksm_temp_logdata1002_fct_order fct
  left join snb_delivery.niksm_temp_logdata1002_rev_dlv_flg rev_dlv_flg
    on rev_dlv_flg.order_id = fct.order_id
  left join snb_delivery.niksm_temp_logdata1002_exp_dlv_flg exp_dlv_flg
    on exp_dlv_flg.order_id = fct.order_id
where utc_order_created_dttm >= '2021-11-01'
  and utc_order_created_dttm <  '2021-12-01'
group by date_trunc('month',utc_order_created_dttm),
       country_name_ru,
       rev_dlv_flg.order_id is not null,
       client_legal_type,
       fact_payment_type,
       exp_dlv_flg.order_id is not null,
       currency_code;

-- check service_id
select 'revenue' as billing_source,
       service_id,
       detailed_product,
       currency_code,
       sum(case when transaction_type = 'payment' then transaction_value
            when transaction_type = 'refund' then -transaction_value end) as transaction_value
from core_ods_billing.revenue
where utc_transaction_dttm >= '2021-11-01'
  and utc_transaction_dttm <  '2021-12-01'
  and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
group by service_id,
       detailed_product,
       currency_code
union all
select 'expenses' as billing_source,
       service_id,
       detailed_product,
       currency_code,
       sum(case when transaction_type = 'payment' then transaction_value
            when transaction_type = 'refund' then -transaction_value end) as transaction_value
from core_ods_billing.expenses
where utc_transaction_dttm >= '2021-11-01'
  and utc_transaction_dttm <  '2021-12-01'
  and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
group by service_id,
       detailed_product,
       currency_code;

select *--corp_order_flg, fact_payment_type, sum(transaction_value)
--        service_id_agg, count(), sum(transaction_value) as transaction_value
from (
    select order_id,
           string_agg(distinct service_id::text, ',') as service_id_agg,
           sum(transaction_value) as transaction_value,
           max(currency_code) as currency_code
    from (
        select order_id, service_id, transaction_value, currency_code
        from snb_delivery.niksm_temp_logdata1002_revenue
        union all
        select order_id, service_id, transaction_value, currency_code
        from snb_delivery.niksm_temp_logdata1002_expenses
    ) q
    group by 1
) qq
  join snb_delivery.niksm_temp_logdata1002_fct_order
    using (order_id)
where service_id_agg = '650' and currency_code = 'RUB'
-- group by 1,2 order by 2 desc
;

select order_id, service_id, client_legal_type, null as courier_legal_type, claim_corp_flg, detailed_product, ccy_code, currency_code, transaction_value, transaction_value_ccy
from snb_delivery.niksm_temp_logdata1002_revenue
where order_id = '0090a2362654cfa8aa1245ab8f2e44d8'
union all
select order_id, service_id, null as client_legal_type, courier_legal_type, null as claim_corp_flg, detailed_product, ccy_code, currency_code, transaction_value, transaction_value_ccy
from snb_delivery.niksm_temp_logdata1002_expenses
where order_id = '0090a2362654cfa8aa1245ab8f2e44d8';

select *
from snb_delivery.niksm_temp_logdata1002_fct_order
where order_id = '000ae1577c313a8a99c467d36e863680';

select order_cost
from taxi_cdm_marketplace.fct_order
where utc_order_created_dttm between '2021-11-01' and '2021-12-01'
  and order_id = '000ae1577c313a8a99c467d36e863680';

select transaction_type,
       aggregation_sign_code,
       count(),
       sum(transaction_value),
       min(transaction_value),
       max(transaction_value)
from core_ods_billing.revenue
where utc_transaction_dttm between '2021-11-01' and '2021-12-01'
group by 1,2;


with rev as (
    select order_id,
           sum(case when transaction_type = 'payment' then transaction_value
                when transaction_type = 'refund' then -transaction_value end) as transaction_value
    from core_ods_billing.revenue
    where utc_transaction_dttm >= '2021-11-01'
      and utc_transaction_dttm <  '2021-12-01'
      and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
      and service_id = 111
      and currency_code = 'RUB'
    group by 1
)
, exp as (
    select order_id,
           sum(case when transaction_type = 'payment' then transaction_value
                when transaction_type = 'refund' then -transaction_value end) as transaction_value
    from core_ods_billing.expenses
    where utc_transaction_dttm >= '2021-11-01'
      and utc_transaction_dttm <  '2021-12-01'
      and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
      and service_id = 719
      and currency_code = 'RUB'
    group by 1
)
select count(),
       sum(rev.transaction_value),
       sum(exp.transaction_value)
from rev join exp using (order_id);

select 'revenue' as billing_source,
       service_id,
       detailed_product,
       sum(case when transaction_type = 'payment' then transaction_value
            when transaction_type = 'refund' then -transaction_value end) as transaction_value
from core_ods_billing.revenue
where utc_transaction_dttm >= '2021-11-01'
  and utc_transaction_dttm <  '2021-12-01'
      and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
group by service_id, detailed_product
union all
select 'expenses' as billing_source,
       service_id,
       detailed_product,
       sum(case when transaction_type = 'payment' then transaction_value
            when transaction_type = 'refund' then -transaction_value end) as transaction_value
from core_ods_billing.expenses
where utc_transaction_dttm >= '2021-11-01'
  and utc_transaction_dttm <  '2021-12-01'
      and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
group by service_id, detailed_product;


with taxi_surge as (
    select tariff_geo_zone_code,
           date_trunc('hour',utc_order_created_dttm) as utc_time_slot,
           sum(order_cost) / sum(order_before_surge_cost) as surge
    from taxi_cdm_marketplace.fct_order
    where utc_order_created_dttm between '2021-11-01' and '2021-12-20'
      and tariff_class_code = 'econom'
      and success_order_flg
    group by tariff_geo_zone_code,
           date_trunc('hour',utc_order_created_dttm)
    having sum(order_before_surge_cost)>0
)
, parks as (
    select clid,
           bool_or(is_signed_719) and bool_or(is_signed_1161) and bool_or(is_signed_1164) as is_signed_full
    from snb_b2b.niksm_park_delivery_transfer_status
    group by clid
    having bool_or(is_signed_719) or bool_or(is_signed_1161) or bool_or(is_signed_1164)
)
select dlv.country_name_ru,
       dlv.utc_order_created_dt,
       coalesce(surge,1.0)>=1.5 as high_surge,
       sum(dlv.delivery_point_cnt) as delivery_point_cnt,
       sum(gmv_amt
               * case when dlv.currency_code = 'RUB' then 1. else dlv.currency_rate end) as gmv_rub,
       sum(gross_commission_revenue_amt
               * case when dlv.currency_code = 'RUB' then 1. else dlv.currency_rate end) as gross_commission_revenue_rub
from taxi_cdm_marketplace.fct_order_metric dlv
  join taxi_cdm_marketplace.fct_order
    on dlv.order_id = fct_order.order_id
  left join taxi_surge
    on taxi_surge.tariff_geo_zone_code = dlv.tariff_geo_zone_code
    and taxi_surge.utc_time_slot = date_trunc('hour',dlv.utc_order_created_dttm)
  left join parks
    on parks.clid = fct_order.park_client_id::numeric
where true
  and dlv.utc_order_created_dttm between '2021-11-01' and '2021-12-20'
  and fct_order.utc_order_created_dttm between '2021-11-01' and '2021-12-20'
  and dlv.delivery_point_cnt>0
  and dlv.success_order_flg
  and parks.clid is null
group by 1,2,3;




select surge_value, count()
from taxi_ods_mdb.order_offer_price
where utc_created_dttm between '2021-12-01' and '2021-12-04'
  and tariff = 'econom'
group by 1 order by 1;

with parks as (
    select clid,
           bool_or(is_signed_719) and bool_or(is_signed_1161) and bool_or(is_signed_1164) as is_signed_full
    from snb_b2b.niksm_park_delivery_transfer_status
    group by clid
    having bool_or(is_signed_719) or bool_or(is_signed_1161) or bool_or(is_signed_1164)
)
, fct1 as (
    select substr(source_geohash,1,5) as source_geohash,
           date_trunc('hour',utc_order_created_dttm)
           + make_interval(0, 0, 0, 0, 0,
               (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot,
           floor(sum(order_cost) / sum(order_before_surge_cost) / .1) *.1 as surge_value
    from taxi_cdm_marketplace.fct_order
    where true
      and utc_order_created_dttm >= '2021-10-31'
      and tariff_class_code = 'econom'
      and success_order_flg
    group by 1,2
    having sum(order_before_surge_cost)>0
)
, fct2 as (
    select tariff_geo_zone_code,
           date_trunc('hour',utc_order_created_dttm) as time_slot,
           floor(sum(order_cost) / sum(order_before_surge_cost) / .1) *.1 as surge_value
    from taxi_cdm_marketplace.fct_order
    where true
      and utc_order_created_dttm >= '2021-10-31'
      and tariff_class_code = 'econom'
      and success_order_flg
    group by 1,2
    having sum(order_before_surge_cost)>0
)
select date_trunc('month',fct.msk_order_created_dt)::date as calmonth,
       date_trunc('week',fct.msk_order_created_dt)::date as calweek,
       parks.clid is not null as delivery_park_flg,
       fct.country_name_ru,
       order_offer_price.surge_value as offer_surge_value,
       fct1.surge_value is not null as slot1_flg,
       fct1.surge_value as slot1_surge_value,
       fct2.surge_value is not null as slot2_flg,
       fct2.surge_value as slot2_surge_value,
       count(),
       sum(gmv_amt
               * case when fct.currency_code = 'RUB' then 1. else fct.currency_rate end) as gmv_rub,
       sum(gross_commission_revenue_amt
               * case when fct.currency_code = 'RUB' then 1. else fct.currency_rate end) as gross_commission_revenue_rub
from taxi_cdm_marketplace.fct_order_metric fct
  join taxi_cdm_marketplace.fct_order
    on fct.order_id = fct_order.order_id
  left join taxi_ods_mdb.order_offer_price
    on fct.offer_id = order_offer_price.offer_id
    and utc_created_dttm >= '2021-10-31'
    and tariff = 'econom'
  left join parks
    on parks.clid = fct_order.park_client_id::numeric
  left join fct1
    on fct1.source_geohash = substr(fct.source_geohash,1,5)
    and fct1.time_slot = date_trunc('hour',fct.utc_order_created_dttm)
           + make_interval(0, 0, 0, 0, 0,
               (floor(extract(minute from fct.utc_order_created_dttm)/10.)*10) :: int)
  left join fct2
    on fct2.tariff_geo_zone_code = fct.tariff_geo_zone_code
    and fct2.time_slot = date_trunc('hour',fct.utc_order_created_dttm)
where true
  and fct.utc_order_created_dttm >= '2021-10-31'
  and fct_order.utc_order_created_dttm >= '2021-10-31'
  and fct.msk_order_created_dt between '2021-11-01' and '2021-12-21'
  and fct.delivery_point_cnt>0
  and fct.success_order_flg
group by 1,2,3,4,5,6,7,8,9;



with parks as (
    select clid,
           bool_or(is_signed_719) and bool_or(is_signed_1161) and bool_or(is_signed_1164) as is_signed_full
    from snb_b2b.niksm_park_delivery_transfer_status
    group by clid
    having bool_or(is_signed_719) or bool_or(is_signed_1161) or bool_or(is_signed_1164)
)
, taxi_high_surge as (
    select substr(source_geohash,1,5) as source_geohash,
           date_trunc('hour',utc_order_created_dttm)
           + make_interval(0, 0, 0, 0, 0,
               (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot,
           true as taxi_high_surge_flg
    from taxi_cdm_marketplace.fct_order
    where true
      and utc_order_created_dttm >= '2021-12-01'
      and tariff_class_code = 'econom'
      and success_order_flg
    group by 1,2
    having sum(order_cost) > sum(order_before_surge_cost)*1.5
)
select fct.country_name_ru,
       fct.msk_order_created_dt,
       parks.clid is not null as delivery_park_flg,
       coalesce(is_signed_full,False) as is_signed_full,
       coalesce(taxi_high_surge_flg,False) as taxi_high_surge_flg,
       --
       count() as orders_cnt,
       sum(fct.delivery_point_cnt) as deliveries_cnt,
       sum(gmv_amt
               * case when fct.currency_code = 'RUB' then 1. else fct.currency_rate end) as gmv_rub,
       sum(gross_commission_revenue_amt
               * case when fct.currency_code = 'RUB' then 1. else fct.currency_rate end) as gross_commission_revenue_rub
from taxi_cdm_marketplace.fct_order_metric fct
  join snb_delivery.logdata_delivery_tariff trf
    on trf.order_tariff = fct.tariff_class_code
  join taxi_cdm_marketplace.fct_order
    on fct.order_id = fct_order.order_id
  left join parks
    on parks.clid = fct_order.park_client_id::numeric
  left join taxi_high_surge
    on taxi_high_surge.source_geohash = substr(fct.source_geohash,1,5)
    and taxi_high_surge.time_slot = date_trunc('hour',fct.utc_order_created_dttm)
           + make_interval(0, 0, 0, 0, 0,
               (floor(extract(minute from fct.utc_order_created_dttm)/10.)*10) :: int)
where true
  and fct.utc_order_created_dttm >= '2021-11-30'
  and fct_order.utc_order_created_dttm >= '2021-11-30'
  and fct.msk_order_created_dt >= '2021-12-01'
  and fct.success_order_flg
group by 1,2,3,4,5;


--====================================================================================================================--
-- MAIN
drop table if exists snb_delivery.niksm_temp_1002_fct;
create table snb_delivery.niksm_temp_1002_fct as
select order_id,
       utc_order_created_dttm,
       executor_profile_sk,
       country_name_ru,
       corp_order_flg,
       --
       substr(source_geohash,1,5) as source_geohash,
       date_trunc('hour',utc_order_created_dttm)
       + make_interval(0, 0, 0, 0, 0,
           (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot,
       --
       delivery_point_cnt as deliveries_cnt,
       gmv_amt * coalesce(currency_rate,1.) as gmv_rub,
       gross_commission_revenue_amt * coalesce(currency_rate,1.) as gross_commission_revenue_rub
from taxi_cdm_marketplace.fct_order_metric fct
  join snb_delivery.logdata_delivery_tariff
    on tariff_class_code = order_tariff
where utc_order_created_dttm >= '2022-01-01'
  and utc_order_created_dttm < current_date
  and success_order_flg
distributed by (order_id, executor_profile_sk)
;
analyse snb_delivery.niksm_temp_1002_fct;

-- slot [geohash - 10 min] with high econom surge
-- create table snb_delivery.niksm_temp_1002_taxi_high_surge as
truncate table snb_delivery.niksm_temp_1002_taxi_high_surge;
insert into snb_delivery.niksm_temp_1002_taxi_high_surge (source_geohash, time_slot, taxi_high_surge_flg)
select substr(source_geohash,1,5) as source_geohash,
       date_trunc('hour',utc_order_created_dttm)
       + make_interval(0, 0, 0, 0, 0,
           (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot,
       true as taxi_high_surge_flg
from taxi_cdm_marketplace.fct_order
where true
  and utc_order_created_dttm >= '2021-12-01'
  and tariff_class_code = 'econom'
  and success_order_flg
group by 1,2
having sum(order_cost) > sum(order_before_surge_cost)*1.5
-- distributed by (source_geohash, time_slot)
;
analyse snb_delivery.niksm_temp_1002_taxi_high_surge;

-- drop table if exists snb_delivery.niksm_temp_1002_fct_supply_state_hist;
-- create table snb_delivery.niksm_temp_1002_fct_supply_state_hist as
truncate table snb_delivery.niksm_temp_1002_fct_supply_state_hist;
insert into snb_delivery.niksm_temp_1002_fct_supply_state_hist (order_id, executor_profile_sk, lcl_available_tariff_class_code_list)
select order_id,
       executor_profile_sk,
       lcl_available_tariff_class_code_list
from (
    select sppl.order_id,
           sppl.executor_profile_sk,
           lcl_available_tariff_class_code_list,
           row_number() over (partition by sppl.order_id, sppl.executor_profile_sk order by utc_valid_from_dttm nulls last) as rn
    from taxi_cdm_supply.fct_supply_state_hist sppl
      join snb_delivery.niksm_temp_1002_fct fct
        on sppl.order_id = fct.order_id
        and sppl.executor_profile_sk = fct.executor_profile_sk
    where utc_valid_from_dttm >= '2021-12-01'
) q
where rn = 1
-- distributed by (order_id, executor_profile_sk)
;
analyse snb_delivery.niksm_temp_1002_fct_supply_state_hist;


drop table if exists snb_delivery.niksm_temp_1002_order_attr;
create table snb_delivery.niksm_temp_1002_order_attr as
-- truncate table snb_delivery.niksm_temp_1002_order_attr;
-- insert into snb_delivery.niksm_temp_1002_order_attr (order_id, country_name_ru, driver_has_taxi_tariff_flg, driver_has_courier_tag_flg, taxi_high_surge_flg)
select fct.order_id,
       country_name_ru,
       fct.corp_order_flg,
       case when sppl.order_id is not null then
           array_length(
               array_remove(
                   array_remove(
                       array_remove(
                           array_remove(
                               array_remove(
                                   lcl_available_tariff_class_code_list,
                                   'courier'),
                               'express'),
                           'cargo'),
                       'cargocorp'),
                   'ubernight')
               , 1) is not null
           else False
         end as driver_has_taxi_tariff_flg,
--        lcl_available_tariff_class_code_list,
       tag_code_list && array['auto_courier'::character varying,'walking_courier'::character varying] as driver_has_courier_tag_flg,
       coalesce(taxi_high_surge_flg,False) as taxi_high_surge_flg
from snb_delivery.niksm_temp_1002_fct fct
  left join snb_delivery.niksm_temp_1002_fct_supply_state_hist sppl
    on sppl.order_id = fct.order_id
    and sppl.executor_profile_sk = fct.executor_profile_sk
  left join taxi_cdm_executor.dim_executor_profile_tag_list_hist et
    on et.executor_profile_sk = fct.executor_profile_sk
    and fct.utc_order_created_dttm < et.utc_valid_to_dttm
    AND et.utc_valid_from_dttm < fct.utc_order_created_dttm
  left join snb_delivery.niksm_temp_1002_taxi_high_surge taxi_high_surge
    on taxi_high_surge.source_geohash = fct.source_geohash
    and taxi_high_surge.time_slot = fct.time_slot
-- group by 1,2,3,4
-- distributed by (order_id)
;
analyse snb_delivery.niksm_temp_1002_order_attr;

drop table if exists snb_delivery.niksm_temp_1002_tlog_raw;
create table snb_delivery.niksm_temp_1002_tlog_raw as
select utc_transaction_dttm::date as utc_transaction_dt,
       service_id,
       currency_code,
       order_id,
       detailed_product,
       transaction_value
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2021-12-01'
union all
select utc_transaction_dttm::date as utc_transaction_dt,
       service_id,
       currency_code,
       order_id,
       detailed_product,
       transaction_value
from core_ods_billing.expenses
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where true
  and utc_transaction_dttm >= '2021-12-01'
distributed by (order_id)
;
analyse snb_delivery.niksm_temp_1002_tlog_raw;

------------------------------------------------------------------------------------------------------------------------
-- data
select utc_transaction_dt,
       service_id,
       currency_code,
       order_attr.country_name_ru,
       order_attr.corp_order_flg,
       order_attr.driver_has_taxi_tariff_flg,
--        order_attr.driver_has_courier_tag_flg,
       order_attr.taxi_high_surge_flg,
       sum(transaction_value * metr.gross_commission_revenue) as gross_commission_revenue_lcy
from snb_delivery.niksm_temp_1002_tlog_raw tlog
  join snb_delivery.niksm_temp_1002_order_attr order_attr
    on order_attr.order_id = tlog.order_id
  join snb_b2b.niksm_finance_tlog_metrics metr
    on metr.detailed_product = tlog.detailed_product
where true
  and metr.gross_commission_revenue <> 0
  and utc_transaction_dt between '2021-12-01' and current_date-1
group by utc_transaction_dt,
         service_id,
         currency_code,
         order_attr.country_name_ru,
         order_attr.corp_order_flg,
         order_attr.driver_has_taxi_tariff_flg,
--          order_attr.driver_has_courier_tag_flg,
         order_attr.taxi_high_surge_flg
order by utc_transaction_dt;


-- select source, detailed_product, aggregated_product, gross_commission_revenue
-- from snb_b2b.niksm_finance_tlog_metrics
-- where gross_commission_revenue <> 0;

select msk_order_created_dt,
       country_name_ru,
       corp_order_flg,
       sum(gmv_amt * coalesce(currency_rate,1.)),
       sum(gross_commission_revenue_amt * coalesce(currency_rate,1.)),
       sum(b2b_decoupling_amt * coalesce(currency_rate,1.))
from taxi_cdm_marketplace.fct_order_metric
  join snb_delivery.logdata_delivery_tariff
    on tariff_class_code = order_tariff
where utc_order_created_dttm >= '2021-11-01'::date - 1
  and msk_order_created_dt between '2021-11-01' and current_date-1
group by 1,2,3
order by 1;


select source, detailed_product, aggregated_product,
       gross_commission_revenue, incentives, b2b_revenue, b2b_expenses
from snb_b2b.niksm_finance_tlog_metrics

--====================================================================================================================--
-- клиентские оплаты через таксишный сервис
drop table if exists snb_delivery.niksm_temp_1002_tlog;
create table snb_delivery.niksm_temp_1002_tlog as
select coalesce(order_id, taxi_order_id) as order_id,
       revenue.service_id,
       revenue.currency_code,
       revenue.tariff_class,
       sum(case when transaction_type = 'payment' then transaction_value * b2b_revenue
                when transaction_type = 'refund' then -transaction_value * b2b_revenue end) as transaction_value,
       sum(case when transaction_type = 'payment' then transaction_value * b2b_revenue
                when transaction_type = 'refund' then -transaction_value * b2b_revenue end)::double precision
           / nullif(
               sum(
                   sum(case when transaction_type = 'payment' then transaction_value * b2b_revenue
                    when transaction_type = 'refund' then -transaction_value * b2b_revenue end)
                   ) over (partition by coalesce(order_id, taxi_order_id)),
               0) as record_share
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on order_tariff = tariff_class
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and utc_created_dttm >= '2021-11-01'
  join snb_b2b.niksm_finance_tlog_metrics metr
    on metr.detailed_product = revenue.detailed_product
    and metr.source = 'revenue'
    and metr.b2b_revenue<>0
where utc_transaction_dttm >= '2021-12-01'
  and utc_transaction_dttm < current_date
group by 1,2,3,4
distributed by (order_id);
--
analyse snb_delivery.niksm_temp_1002_tlog;

-- with trf as (
--     select client_id,
--            max(tariff_plan_series_name) as tariff_plan_series_name
--     from snb_b2b.niksm_b2b_client_tariff_plans ctp
--       join (
--           select tariff_plan_series_id,
--                  max(tariff_plan_series_name) as tariff_plan_series_name
--           from snb_b2b.niksm_b2b_tariff_plans
--           where dttm_from < current_timestamp
--             and (dttm_to is null
--               or dttm_to > current_timestamp)
--           group by tariff_plan_series_id
--           ) tp
--         on ctp.tariff_plan_series_id = tp.tariff_plan_series_id
--     where true
--       and dttm_from < current_timestamp
--       and (dttm_to is null
--         or dttm_to > current_timestamp)
--       and service = 'cargo'
--     group by client_id
-- )
select
--        trf.tariff_plan_series_name,
       tlog.service_id,
       tlog.currency_code,
       tlog.tariff_class,
       sum(tlog.transaction_value) as transaction_value,
       fct.order_id is not null as fct_order_flg,
       crm.contract_id is not null as delivery_client_flg,
       sum(gmv_amt * coalesce(currency_rate,1.) * record_share) as gmv_rub,
       sum(gross_commission_revenue_amt * coalesce(currency_rate,1.) * record_share) as gross_commission_revenue_rub,
       sum(incentives_amt * coalesce(currency_rate,1.) * record_share) as incentives_rub,
       sum(net_inflow_amt * coalesce(currency_rate,1.) * record_share) as net_inflow_rub,
       sum(case when decoupling_success_flg
                then decoupling_user_cost * coalesce(currency_rate,1.) * record_share else 0 end) as decoupling_user_cost_rub,
       sum(case when decoupling_success_flg
                then decoupling_driver_cost * coalesce(currency_rate,1.) * record_share else 0 end) as decoupling_driver_cost_rub,
       sum(b2b_decoupling_amt * coalesce(currency_rate,1.) * record_share) as b2b_decoupling_rub
from snb_delivery.niksm_temp_1002_tlog tlog
  left join taxi_cdm_marketplace.fct_order_metric fct
    on fct.order_id = tlog.order_id
    and utc_order_created_dttm >= '2021-11-01'
  left join snb_b2b.niksm_b2b_contracts_info crm
    on contract_id = corp_contract_id
    and which_crm = 6
--   left join trf
--     on trf.client_id = fct.corp_client_id
-- where fct.order_id is null
-- order by transaction_value desc;
group by
--          trf.tariff_plan_series_name,
         tlog.service_id,
         tlog.currency_code,
         tlog.tariff_class,
         fct.order_id is not null,
         crm.contract_id is not null;


-- check
select order_id,
       count(distinct service_id),
       count(distinct revenue.currency_code)
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on order_tariff = tariff_class
  left join delivery_ods_cargo_claims.claim
    on claim.cargo_ref_id = revenue.cargo_claim_id
    and utc_created_dttm >= '2021-12-01'
  join snb_b2b.niksm_finance_tlog_metrics metr
    on metr.detailed_product = revenue.detailed_product
    and metr.source = 'revenue'
    and metr.b2b_revenue<>0
where utc_transaction_dttm >='2022-01-01'
group by 1
having count(distinct service_id)>1
    or count(distinct revenue.currency_code)>1;


select taxi_high_surge_flg_wght, taxi_high_surge_flg_avg, count()
from (
    select substr(source_geohash,1,5) as source_geohash,
           date_trunc('hour',utc_order_created_dttm)
           + make_interval(0, 0, 0, 0, 0,
               (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot,
           sum(order_cost) > sum(order_before_surge_cost) * 1.5 as taxi_high_surge_flg_wght,
           avg(balance_rate) > 1.5 as taxi_high_surge_flg_avg
    from taxi_cdm_marketplace.fct_order
    where true
      and utc_order_created_dttm >= '2022-01-01'
      and tariff_class_code = 'econom'
      and success_order_flg
    group by 1,2
) q
group by 1,2;

select transaction_type, aggregation_sign_code, count(),
       sum(transaction_value * gross_commission_revenue) as gross_commission_revenue,
       sum(transaction_value * incentives) as incentives,
       sum(transaction_value * b2b_revenue) as b2b_revenue,
       sum(transaction_value * b2b_expenses) as b2b_expenses
from core_ods_billing.expenses tlog
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = 'expenses'
    and metr.detailed_product = tlog.detailed_product
where utc_transaction_dttm>='2022-01-01'
  and tariff_class in ('courier', 'express', 'cargo', 'cargocorp', 'ubernight')
group by 1,2 order by 1,2;

select *
from snb_b2b.niksm_finance_tlog_metrics
where b2b_expenses <> 0;


select order_id,
       count(distinct service_id),
       count(distinct currency_code)
from snb_delivery.niksm_temp_1002_tlog_detailed as tlog
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = tlog.source
    and metr.detailed_product = tlog.detailed_product
    and b2b_expenses <> 0
group by order_id
having count(distinct service_id) > 1
    or count(distinct currency_code) > 1;


select *
from snb_delivery.niksm_temp_1002_tlog_detailed as tlog
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = tlog.source
    and metr.detailed_product = tlog.detailed_product
    and b2b_expenses <> 0
where order_id in (
'daf937f302d9c5329f69b0e15340b55c',
'c3bf23d58f88c757afa66c1a2545d625',
'ac4a5deafed0145ba3e9dc90831f7e9d',
'6802965ad3f03987ba0b63d345ead9ea'
    );

select transaction_type, aggregation_sign_code, detailed_product,
       count(),
       sum(transaction_value)
from core_ods_billing.revenue
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where utc_transaction_dttm >= '2022-01-01'
  and ((transaction_type = 'payment' and aggregation_sign_code = -1)
    or (transaction_type = 'refund' and aggregation_sign_code = 1))
group by transaction_type, aggregation_sign_code, detailed_product;


-- Service-service daily
with tlog_rev as (
    select 'revenue' as source,
           service_id,
           revenue.currency_code,
           coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
           revenue.cargo_claim_id,
           detailed_product,
           transaction_value * aggregation_sign_code as transaction_value,
           utc_transaction_dttm
    from core_ods_billing.revenue
      join snb_delivery.logdata_delivery_tariff
        on tariff_class = order_tariff
      left join delivery_ods_cargo_claims.claim
        on claim.cargo_ref_id = revenue.cargo_claim_id
        and claim.utc_created_dttm >= '2021-10-01'
        and claim.cargo_ref_id is not null
    where true
      and utc_transaction_dttm >= '2022-01-01'
--       and client_id = '91460093'
)
, tlog_exp as (
    select 'expenses' as source,
           service_id,
           currency_code,
           order_id,
           NULL::varchar as cargo_claim_id,
           detailed_product,
           case when transaction_type = 'payment' then transaction_value else -transaction_value end as transaction_value,
           utc_transaction_dttm
    from core_ods_billing.expenses
      join snb_delivery.logdata_delivery_tariff
        on tariff_class = order_tariff
    where true
      and utc_transaction_dttm >= '2022-01-01'
)
, exp_serv as (
    select order_id,
           string_agg(distinct service_id::text,',') as b2b_expenses_service_id
    from tlog_exp tlog
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = tlog.source
        and metr.detailed_product = tlog.detailed_product
        and b2b_expenses <> 0
    where utc_transaction_dttm >= '2022-01-01'
      and transaction_value <> 0
    group by order_id
)
, rev as (
    select order_id,
           cargo_claim_id,
           service_id,
           currency_code,
           min(utc_transaction_dttm::date) as utc_transaction_dt,
           sum(transaction_value * b2b_revenue) as b2b_revenue,
           count(distinct service_id) over (partition by order_id) as service_cnt
    from tlog_rev tlog
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = tlog.source
        and metr.detailed_product = tlog.detailed_product
        and b2b_revenue <> 0
    where utc_transaction_dttm >= '2022-01-01'
    group by order_id,
           cargo_claim_id,
           service_id,
           currency_code
)
select utc_transaction_dt,
       currency_code,
       service_id,
       b2b_expenses_service_id,
       cargo_claim_id is not null as cargo_claim_flg,
       count() as claims_cnt,
       sum(b2b_revenue) as b2b_revenue
from rev
  left join exp_serv
    on exp_serv.order_id = rev.order_id
group by utc_transaction_dt,
       currency_code,
       service_id,
       b2b_expenses_service_id,
       cargo_claim_id is not null
order by utc_transaction_dt;

-- топ компонены b2b_expenses
select currency_code,
       tlog.detailed_product,
       metr.b2b_expenses,
       sum(transaction_value)
from snb_delivery.niksm_temp_1002_tlog_detailed tlog
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = tlog.source
    and metr.detailed_product = tlog.detailed_product
    and b2b_expenses <> 0
where utc_transaction_dttm >= '2022-01-01'
  and utc_transaction_dttm <  '2022-02-01'
group by 1,2,3 order by 1,2;


select service_id,
       currency_code,
       tlog.detailed_product,
       sum(case when transaction_type = 'payment' then transaction_value else -transaction_value end) as transaction_value
from core_ods_billing.expenses tlog
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = 'expenses'
    and metr.detailed_product = tlog.detailed_product
    and b2b_expenses <> 0
where true
  and utc_transaction_dttm >= '2021-07-01'
  and utc_transaction_dttm <  '2021-08-01'
group by 1,2,3;


select *
from core_ods_billing.expenses tlog
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = 'expenses'
    and metr.detailed_product = tlog.detailed_product
    and b2b_expenses <> 0
where utc_transaction_dttm >= '2022-01-01'
  and utc_transaction_dttm <  '2022-02-01'
limit 10;


select currency_code,
       tlog.detailed_product,
       service_id,
--        order_id,
--        transaction_type,
--        transaction_value,
--        vat
       sum(case when transaction_type = 'payment' then transaction_value else -transaction_value end) as transaction_value,
       sum(case when transaction_type = 'payment' then vat else -vat end) as vat
from core_ods_billing.expenses tlog
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = 'expenses'
    and metr.detailed_product = tlog.detailed_product
    and incentives <> 0
where utc_transaction_dttm >= '2022-01-01'
  and utc_transaction_dttm <  '2022-02-01'
--   and vat = 0
--     and currency_code = 'RUB'
-- limit 10
group by 1,2,3 order by 1,2,3




with tlog_rev as (
    select 'revenue' as source,
           service_id,
           revenue.currency_code,
           coalesce(revenue.order_id,claim.taxi_order_id) as order_id,
           revenue.cargo_claim_id,
           detailed_product,
           transaction_value * aggregation_sign_code as transaction_value,
           utc_transaction_dttm
    from core_ods_billing.revenue
      join snb_delivery.logdata_delivery_tariff
        on tariff_class = order_tariff
      left join delivery_ods_cargo_claims.claim
        on claim.cargo_ref_id = revenue.cargo_claim_id
        and claim.utc_created_dttm >= '2022-03-01'
        and claim.cargo_ref_id is not null
    where true
      and utc_transaction_dttm >= '2022-03-26'
--       and client_id = '91460093'
)
, tlog_exp as (
    select 'expenses' as source,
           service_id,
           currency_code,
           order_id,
           NULL::varchar as cargo_claim_id,
           detailed_product,
           case when transaction_type = 'payment' then transaction_value else -transaction_value end as transaction_value,
           utc_transaction_dttm,
           client_id
    from core_ods_billing.expenses
      join snb_delivery.logdata_delivery_tariff
        on tariff_class = order_tariff
    where true
      and utc_transaction_dttm >= '2022-03-26'
)
, exp_serv as (
    select order_id,
           string_agg(distinct service_id::text,',') as b2b_expenses_service_id,
           max(client_id) as client_id
    from tlog_exp tlog
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = tlog.source
        and metr.detailed_product = tlog.detailed_product
        and b2b_expenses <> 0
    where utc_transaction_dttm >= '2022-01-01'
      and transaction_value <> 0
    group by order_id
)
, rev as (
    select order_id,
           cargo_claim_id,
           service_id,
           currency_code,
           min(utc_transaction_dttm::date) as utc_transaction_dt,
           sum(transaction_value * b2b_revenue) as b2b_revenue,
           count(distinct service_id) over (partition by order_id) as service_cnt
    from tlog_rev tlog
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = tlog.source
        and metr.detailed_product = tlog.detailed_product
        and b2b_revenue <> 0
    where utc_transaction_dttm >= '2022-01-01'
    group by order_id,
           cargo_claim_id,
           service_id,
           currency_code
)
select *
from rev
  left join exp_serv
    on exp_serv.order_id = rev.order_id
where cargo_claim_id is null
  and service_id = 650
  and b2b_expenses_service_id = '651'
  and currency_code = 'RUB'
limit 10;

with tlog_exp as (
    select 'expenses' as source,
           service_id,
           currency_code,
           order_id,
           NULL::varchar as cargo_claim_id,
           expenses.detailed_product,
           case when transaction_type = 'payment' then transaction_value else -transaction_value end as transaction_value,
           utc_transaction_dttm,
           client_id
    from core_ods_billing.expenses
      join snb_delivery.logdata_delivery_tariff
        on tariff_class = order_tariff
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = 'expenses'
        and metr.detailed_product = expenses.detailed_product
        and b2b_expenses <> 0
    where true
      and utc_transaction_dttm >= '2022-03-26'
)
select service_id, sum(transaction_value)
from tlog_exp
where client_id = '68934679'
group by 1