#!/usr/bin/env python
# coding: utf-8


import pandas as pd
from business_models import greenplum, hahn
from business_models.greenplum import GreenplumManager
import json
with open('keys.json', 'r') as f:
    keys = json.load(f)
gp_user = 'robot-sam-bridges'
gp_token = keys['sam_gp_token']
greenplum = GreenplumManager(user=gp_user, token = gp_token)

import argparse
import datetime
from datetime import datetime as dt
import logging

import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

def add_month_1st(calday, shift_month=1):
    year = calday.year
    month = calday.month
    res = {}
    year_new = year + (month - 1 + shift_month)//12
    month_new = (month - 1 + shift_month)%12 + 1
    return datetime.date(year_new, month_new, 1)

def monthly_range(start_date_str, finish_date_str):
    start_date = dt.strptime(start_date_str,'%Y-%m-%d').date()
    finish_date = dt.strptime(finish_date_str,'%Y-%m-%d').date()
    rng = []
    v_datefrom = start_date
    i = 0
    while v_datefrom <= finish_date:
        v_dateto = add_month_1st(v_datefrom,1) - datetime.timedelta(days = 1)
        if v_dateto > finish_date:
            v_dateto = finish_date
        rng.append([v_datefrom, v_dateto])
        i+=1
        v_datefrom = add_month_1st(start_date,i)
    return rng

with open ('niksm_fct_delivery.sql') as f:
    sql_template = f.read()


# Var 1: long period
def main_full():
    logging.info('full recalculation start')
    p_datefrom = '2020-01-01'
    p_dateto = datetime.date.today().strftime('%Y-%m-%d')
    for cntr in monthly_range(p_datefrom,p_dateto):
        v_datefrom_str = cntr[0].strftime('%Y-%m-%d')
        v_dateto_str = cntr[1].strftime('%Y-%m-%d')
        sql = sql_template.format(utc_datefrom = v_datefrom_str, utc_dateto = v_dateto_str)
        greenplum(sql)
        logging.info(f"data loaded from {v_datefrom_str} to {v_dateto_str}")
    logging.info('full recalculation success')

# Var 2: short period
def main_short():
    logging.info('short recalculation start')
    v_datefrom_str = (datetime.date.today() - datetime.timedelta(days = 13)).strftime('%Y-%m-%d')
    v_dateto_str = datetime.date.today().strftime('%Y-%m-%d')
    sql = sql_template.format(utc_datefrom = v_datefrom_str, utc_dateto = v_dateto_str)
    greenplum(sql)
    logging.info(f"data loaded from {v_datefrom_str} to {v_dateto_str}")
    logging.info('short recalculation success')

if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument("-f", "--full", help="full datamart recalculation", action='store_true')
    parser.add_argument("-s", "--short", help="short period (2 weeks) recalculation", action='store_true')
    args = parser.parse_args()

    if args.full:
        main_full()
    if args.short:
        main_short()

    logging.info('SUCCESS')
