insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_fct_delivery', 'Start', clock_timestamp());

--1.1 Taxi log
drop table if exists niksm_temp_fulldlv_taxi_orders;
create temporary table niksm_temp_fulldlv_taxi_orders as
select order_id
from taxi_cdm_marketplace.fct_order
  join snb_delivery.logdata_delivery_tariff
    on tariff_class_code = order_tariff
where true
  and utc_order_created_dttm >= '{utc_datefrom}'::date
  and utc_order_created_dttm <  ('{utc_dateto}'::date + interval '7 days')
distributed by (order_id);
--
analyse niksm_temp_fulldlv_taxi_orders;

drop table if exists niksm_temp_fulldlv_taxi_log;
create temporary table niksm_temp_fulldlv_taxi_log as
select order_status_log.order_id,
       case when bool_or(backend_event_code='start-lookup')
            then min(case when backend_event_code='start-lookup' then utc_status_created_dttm end)
            else min(case when backend_event_code='create' then utc_status_created_dttm end)
           end as utc_lookup_dttm,
       min(case when backend_status = 'assigned' then utc_status_created_dttm end)    as utc_found_dttm,
       min(case when driver_status = 'waiting' then utc_status_created_dttm end)      as utc_a_arrived_dttm,
       min(case when driver_status = 'transporting' then utc_status_created_dttm end) as utc_a_visited_dttm,
       max(case when driver_status = 'complete' then utc_status_created_dttm end)     as utc_b_visited_last_dttm,
       min(case when backend_status = 'cancelled' then utc_status_created_dttm end)   as utc_cancelled_dttm
from taxi_stg_dbprocessing.order_status_log
  join niksm_temp_fulldlv_taxi_orders
    on niksm_temp_fulldlv_taxi_orders.order_id = order_status_log.order_id
where true
  and utc_order_created_dttm >= '{utc_datefrom}'::date
  and utc_order_created_dttm <  ('{utc_dateto}'::date + interval '7 days')
--   and utc_order_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
group by order_status_log.order_id
distributed by (order_id);
--
analyse niksm_temp_fulldlv_taxi_log;
------------------------------------------------------------------------------------------------------------------------

--1.2 Taxi orders
drop table if exists niksm_temp_fulldlv_fct_order;
create temporary table niksm_temp_fulldlv_fct_order as
select fct.order_id,
       fct.utc_order_created_dttm,
       fct.msk_order_created_dt,
       fct.corp_order_flg,
       fct.corp_client_id,
       fct.corp_contract_id,
       fct.tariff_class_code,
       fct.tariff_geo_zone_code,
       fct.user_status,
       fct.driver_status,
       fct.success_order_flg,
       fct.order_source_code,
       fct.order_type,
       fct.utc_order_due_dttm,
       fct.source_address,
       fct.source_geohash,
       fct.destination_plan_address,
       fct.destination_plan_geohash,
       fct.user_phone_pd_id,
       fct.transporting_distance_plan_km,
       fct.transporting_time_plan_mnt,
       fct.delivery_plan_point_cnt,
       fct.delivery_point_cnt,
       fct.currency_code,
       fct.gmv_amt as gmv_lcy,
       fct.gmv_amt * fct.currency_rate as gmv_rub,
       fct.net_inflow_amt as net_inflow_lcy,
       fct.net_inflow_amt * fct.currency_rate as net_inflow_rub,
       --
       taxi_log.order_id is not null as logging_flg,
       taxi_log.utc_lookup_dttm, taxi_log.utc_found_dttm, taxi_log.utc_a_arrived_dttm, taxi_log.utc_a_visited_dttm, taxi_log.utc_b_visited_last_dttm,
       taxi_log.utc_cancelled_dttm
from taxi_cdm_marketplace.fct_order_metric fct
  join snb_delivery.logdata_delivery_tariff lgst
    on lgst.order_tariff = fct.tariff_class_code
    and fct.utc_order_created_dttm between utc_datefrom and utc_dateto
  left join niksm_temp_fulldlv_taxi_log as taxi_log
    on taxi_log.order_id = fct.order_id
where true
  and fct.utc_order_created_dttm >= '{utc_datefrom}'::date
  and fct.utc_order_created_dttm <  '{utc_dateto}'::date + interval '7 days'
--   and fct.utc_order_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
--   and fct_order.utc_order_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
distributed by (order_id);
--
analyse niksm_temp_fulldlv_fct_order;
------------------------------------------------------------------------------------------------------------------------

--2.1 Cargo log
drop table if exists niksm_temp_fulldlv_cargo_log;
create temporary table niksm_temp_fulldlv_cargo_log as
select claim_id,
       bool_or(new_claim_status = 'accepted') as accepted_flg,
       min(case when new_claim_status = 'accepted' then utc_created_dttm end) as utc_accepted_dttm,
       min(case when new_claim_status = 'performer_lookup' then utc_created_dttm end) as utc_lookup_dttm,
       min(case when new_claim_status = 'performer_found' then utc_created_dttm end) as utc_found_dttm,
       min(case when new_claim_status = 'pickup_arrived' then utc_created_dttm end)  as utc_a_arrived_dttm,
       min(case when new_claim_status = 'pickuped' then utc_created_dttm end)        as utc_a_visited_dttm,
       max(case when new_claim_status = 'delivered' then utc_created_dttm end)       as utc_b_visited_last_dttm,
       min(case when new_claim_status in ('cancelled', 'cancelled_with_items_on_hands', 'cancelled_with_payment', 'cancelled_by_taxi')
            then utc_created_dttm end) as utc_cancelled_dttm
from delivery_ods_cargo_claims.claim_status_log
where true
  and utc_created_dttm >= '{utc_datefrom}'::date
  and utc_created_dttm <  '{utc_dateto}'::date + interval '7 days'
--   and utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
group by claim_id
having bool_or(new_claim_status = 'accepted')       --!!! без accepted за 90 дней: cancelled/failed; 6 заявок с taxi_order_id
distributed by (claim_id);
--
analyse niksm_temp_fulldlv_cargo_log;
------------------------------------------------------------------------------------------------------------------------

--2.2 Cargo points
drop table if exists niksm_temp_fulldlv_claim_point;
create temporary table niksm_temp_fulldlv_claim_point as
select claim_point.claim_id,
       string_agg(case when claim_point.point_type = 'source' then point.point_full_address end, '; ') as source_address,
       string_agg(case when claim_point.point_type = 'source'
                        and point.point_lon between -180. and 180.
                        and point.point_lat between -90. and 90.
                       then substr(ST_GeoHash(ST_SetSRID(ST_MakePoint(point.point_lon, point.point_lat),4326)), 1, 9)
           end, '; ') as source_geohash,
       string_agg(case when claim_point.point_type = 'destination' then point.point_full_address end, '; ') as destination_address,
       string_agg(case when claim_point.point_type = 'destination'
                        and point.point_lon between -180. and 180.
                        and point.point_lat between -90. and 90.
                       then substr(ST_GeoHash(ST_SetSRID(ST_MakePoint(point.point_lon, point.point_lat),4326)), 1, 9)
           end, '; ') as destination_geohash,
       sum(case when claim_point.point_type = 'destination' then 1 else 0 end) as destination_point_cnt,
       sum(case when claim_point.point_type = 'destination' and claim_point.visit_status = 'visited' then 1 else 0 end) as destination_point_visited_cnt,
       --
       string_agg(case when claim_point.point_type = 'source' then point.contact_phone_pd_id end, '; ') as source_contact_phone_pd_id,
       string_agg(case when claim_point.point_type = 'destination' then point.contact_phone_pd_id end, '; ') as destination_contact_phone_pd_id
from delivery_ods_cargo_claims.claim_point
  left join delivery_ods_cargo_claims.point
    on point.point_id = claim_point.point_id
    and point.utc_created_dttm >= '{utc_datefrom}'::date
    and point.utc_created_dttm <  '{utc_dateto}'::date + interval '7 days'
--     and point.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
where true
  and claim_point.utc_created_dttm >= '{utc_datefrom}'::date
  and claim_point.utc_created_dttm <  '{utc_dateto}'::date + interval '7 days'
--   and claim_point.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
group by claim_point.claim_id
distributed by (claim_id);
--
analyse niksm_temp_fulldlv_claim_point;
------------------------------------------------------------------------------------------------------------------------

-- 2.3 Cargo claims
drop table if exists niksm_temp_fulldlv_cargo;
create temporary table niksm_temp_fulldlv_cargo as
select claim.claim_id,
       claim.cargo_ref_id,
       claim.utc_created_dttm,
       claim.tariff_zone,
       claim.corp_client_id,
       claim.corp_client_id is not null as corp_claim_flg,
       claim.taxi_order_id,
       claim.status_code,
       claim.utc_due_dttm,
       claim.currency_code,
       claim.final_price_w_vat_cur,
       claim.final_price_wo_vat_cur,
       count() over (partition by claim.taxi_order_id) as claims_per_order,
       --
       cargo_log.claim_id is not null as logging_flg,       -- always true because of accepted_flg
       cargo_log.accepted_flg,
       cargo_log.utc_accepted_dttm,
       cargo_log.utc_lookup_dttm,
       cargo_log.utc_found_dttm,
       cargo_log.utc_a_arrived_dttm,
       cargo_log.utc_a_visited_dttm,
       cargo_log.utc_b_visited_last_dttm,
       cargo_log.utc_cancelled_dttm,
       --
       claim_point.source_address,
       claim_point.source_geohash,
       claim_point.destination_address,
       claim_point.destination_geohash,
       claim_point.destination_point_cnt,
       claim_point.destination_point_visited_cnt,
       claim_point.source_contact_phone_pd_id,
       claim_point.destination_contact_phone_pd_id,
       --
       k2_lavka_claims.claim_id is not null as k2_lavka_flg,
       lk.contract_external_id as corp_contract_id_act          -- текущий corp_contract_id, подставлять в крайнем случае
from delivery_ods_cargo_claims.claim
  join niksm_temp_fulldlv_cargo_log cargo_log
    on cargo_log.claim_id = claim.claim_id
  join niksm_temp_fulldlv_claim_point claim_point
    on claim_point.claim_id = claim.claim_id
  left join snb_b2b.niksm_k2_lavka_claims k2_lavka_claims
    on k2_lavka_claims.claim_id = claim.claim_id
  left join snb_b2b.niksm_b2b_lk_client_service_info lk
    on lk.lk_client_id = corp_client_id
    and lk.lk_service_name = 'cargo'
where true
  and claim.utc_created_dttm >= '{utc_datefrom}'::date
  and claim.utc_created_dttm <  '{utc_dateto}'::date + interval '1 day'
--   and claim.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
distributed by (taxi_order_id);
--
analyse niksm_temp_fulldlv_cargo;
------------------------------------------------------------------------------------------------------------------------

-- Result full join
drop table if exists niksm_temp_fulldlv_res;
create temporary table niksm_temp_fulldlv_res as
select coalesce(cargo.corp_client_id, taxi.corp_client_id) as corp_client_id,
       coalesce(taxi.corp_contract_id, cargo.corp_contract_id_act) as corp_contract_id,     -- taxi исторический, cargo только текущий
       coalesce(cargo.tariff_zone, taxi.tariff_geo_zone_code) as tariff_zone,
       coalesce(cargo.taxi_order_id, taxi.order_id) as order_id,
       tariff_class_code,
       coalesce(cargo.source_address, taxi.source_address) as source_address,
       coalesce(cargo.source_geohash, taxi.source_geohash) as source_geohash,
       coalesce(cargo.destination_address, taxi.destination_plan_address) as destination_address,
       coalesce(cargo.destination_geohash, taxi.destination_plan_geohash) as destination_geohash,
       taxi.user_phone_pd_id,
       cargo.source_contact_phone_pd_id as source_contact_phone_pd_id,
       cargo.destination_contact_phone_pd_id as destination_contact_phone_pd_id,
       coalesce(cargo.currency_code, taxi.currency_code) as currency_code,
       --
       coalesce(cargo.destination_point_cnt, taxi.delivery_plan_point_cnt) as deliveries_plan_cnt,
       coalesce(cargo.destination_point_visited_cnt, taxi.delivery_point_cnt) as deliveries_cnt,
       transporting_distance_plan_km / coalesce(claims_per_order,1) as transporting_distance_plan_km,
       transporting_time_plan_mnt / coalesce(claims_per_order,1) as transporting_time_plan_mnt,
       gmv_lcy / coalesce(claims_per_order,1) as gmv_lcy,
       gmv_rub / coalesce(claims_per_order,1) as gmv_rub,
       net_inflow_lcy / coalesce(claims_per_order,1) as net_inflow_lcy,
       net_inflow_rub / coalesce(claims_per_order,1) as net_inflow_rub,
       claims_per_order,
       --
       case when cargo.claim_id is not null then cargo.utc_created_dttm else taxi.utc_order_created_dttm end as utc_created_dttm,
       case when cargo.claim_id is not null
           then (cargo.utc_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date
           else taxi.msk_order_created_dt end as msk_created_dt,
       --
       case when cargo.claim_id is not null then cargo.logging_flg else taxi.logging_flg end as logging_flg,
       case when cargo.claim_id is not null
           then coalesce(cargo.utc_accepted_dttm, cargo.utc_created_dttm)
           else taxi.utc_order_created_dttm end as utc_accepted_dttm,
       case when cargo.claim_id is not null then cargo.utc_lookup_dttm else taxi.utc_lookup_dttm end as utc_lookup_dttm,
       case when cargo.claim_id is not null then cargo.utc_found_dttm else taxi.utc_found_dttm end as utc_found_dttm,
       case when cargo.claim_id is not null then cargo.utc_a_arrived_dttm else taxi.utc_a_arrived_dttm end as utc_a_arrived_dttm,
       case when cargo.claim_id is not null then cargo.utc_a_visited_dttm else taxi.utc_a_visited_dttm end as utc_a_visited_dttm,
       case when cargo.claim_id is not null then cargo.utc_b_visited_last_dttm else taxi.utc_b_visited_last_dttm end as utc_b_visited_last_dttm,
       case when cargo.claim_id is not null then cargo.utc_cancelled_dttm else taxi.utc_cancelled_dttm end as utc_cancelled_dttm,
       case when cargo.claim_id is not null then cargo.utc_due_dttm else taxi.utc_order_due_dttm end as utc_due_dttm,
       --
       cargo.claim_id is not null as cargo_flg,
       taxi.order_id is not null as taxi_flg,
       --
       case when cargo.claim_id is not null then cargo.corp_claim_flg else taxi.corp_order_flg end as corp_flg,
       coalesce(k2_lavka_flg,false) as k2_lavka_flg,
       cargo.claim_id, cargo.cargo_ref_id,
       status_code as claim_status_code,
       accepted_flg as claim_accepted_flg,
       user_status as taxi_user_status,
       driver_status as taxi_driver_status,
       success_order_flg,
       order_source_code,
       order_type,
       cargo.utc_created_dttm as cargo_utc_created_dttm,
       taxi.utc_order_created_dttm as taxi_utc_order_created_dttm,
       cargo.utc_due_dttm as cargo_utc_due_dttm,
       taxi.utc_order_due_dttm as taxi_utc_order_due_dttm,
       cargo.final_price_w_vat_cur as claim_final_price_w_vat_cur,
       cargo.final_price_wo_vat_cur as claim_final_price_wo_vat_cur
from niksm_temp_fulldlv_cargo cargo
  full join niksm_temp_fulldlv_fct_order taxi
    on cargo.taxi_order_id = taxi.order_id
where cargo.claim_id is not null
  or ( (taxi.order_source_code is null or taxi.order_source_code <> 'cargo')
    and taxi.utc_order_created_dttm < '{utc_dateto}'::date + interval '1 day'
    );
--
analyse niksm_temp_fulldlv_res;


-- drop table if exists snb_delivery.niksm_fct_delivery;
-- create table snb_delivery.niksm_fct_delivery as
-- truncate table snb_delivery.niksm_fct_delivery;
delete from snb_delivery.niksm_fct_delivery
where true
  and utc_created_dttm >= '{utc_datefrom}'::date
  and utc_created_dttm <  '{utc_dateto}'::date + interval '1 day';
insert into snb_delivery.niksm_fct_delivery
      (corp_client_id, corp_contract_id, tariff_zone, order_id, tariff_class_code,
       source_address, source_geohash, destination_address, destination_geohash,
       user_phone_pd_id, source_contact_phone_pd_id, destination_contact_phone_pd_id,
       currency_code,
       deliveries_plan_cnt, deliveries_cnt,
       transporting_distance_plan_km, transporting_time_plan_mnt,
       gmv_lcy, gmv_rub, net_inflow_lcy, net_inflow_rub,
       claims_per_order,
       utc_created_dttm, msk_created_dt,
       logging_flg, utc_accepted_dttm, utc_lookup_dttm, utc_found_dttm, utc_a_arrived_dttm, utc_a_visited_dttm, utc_b_visited_last_dttm, utc_cancelled_dttm, utc_due_dttm,
       cargo_flg, taxi_flg, corp_flg, k2_lavka_flg,
       claim_id, cargo_ref_id, claim_status_code, claim_accepted_flg,
       taxi_user_status, taxi_driver_status, success_order_flg, order_source_code, order_type,
       cargo_utc_created_dttm, taxi_utc_order_created_dttm, cargo_utc_due_dttm, taxi_utc_order_due_dttm,
       claim_final_price_w_vat_cur, claim_final_price_wo_vat_cur,
       etl_utc_dttm)
select corp_client_id, corp_contract_id, tariff_zone, order_id, tariff_class_code,
       source_address, source_geohash, destination_address, destination_geohash,
       user_phone_pd_id, source_contact_phone_pd_id, destination_contact_phone_pd_id,
       currency_code,
       deliveries_plan_cnt, deliveries_cnt,
       transporting_distance_plan_km, transporting_time_plan_mnt,
       gmv_lcy, gmv_rub, net_inflow_lcy, net_inflow_rub,
       claims_per_order,
       utc_created_dttm, msk_created_dt,
       logging_flg, utc_accepted_dttm, utc_lookup_dttm, utc_found_dttm, utc_a_arrived_dttm, utc_a_visited_dttm, utc_b_visited_last_dttm, utc_cancelled_dttm, utc_due_dttm,
       cargo_flg, taxi_flg, corp_flg, k2_lavka_flg,
       claim_id, cargo_ref_id, claim_status_code, claim_accepted_flg,
       taxi_user_status, taxi_driver_status, success_order_flg, order_source_code, order_type,
       cargo_utc_created_dttm, taxi_utc_order_created_dttm, cargo_utc_due_dttm, taxi_utc_order_due_dttm,
       claim_final_price_w_vat_cur, claim_final_price_wo_vat_cur,
       current_timestamp as etl_utc_dttm
from niksm_temp_fulldlv_res;

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_fct_delivery', 'Finish', clock_timestamp());
