with src as (
    select least(last_claims_date, last_fct_date) as last_full_date
    from (
        select (max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow')::date - 1 as last_claims_date
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm >= current_date - 7
        ) cc
    cross join (
        select max(msk_order_created_dttm)::date - 1 as last_fct_date
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm >= current_date - 7
        ) fct
)
, res as (
    select max(msk_created_dt)-1 as last_full_date
    from snb_delivery.niksm_fct_delivery
    where utc_created_dttm >= current_date - 7
)
select case when src.last_full_date > res.last_full_date
                 or res.last_full_date is null
            then 1::int else 0::int end as flg
from src cross join res;
