-- drop table if exists snb_b2b.amo_inquisitor_list;
-- create table snb_b2b.amo_inquisitor_list as
truncate table snb_b2b.amo_inquisitor_list;
insert into snb_b2b.amo_inquisitor_list

with tasks_deal as (select entity_id as deal_id
                    from delivery_ods_amocrm.task
                    where entity_type = 'leads'
                      and completed_flg = false
                    group by entity_id),
     company_deal as (select entity_id as company_id
                      from delivery_ods_amocrm.task
                      where entity_type = 'companies'
                        and completed_flg = false
                      group by entity_id)
select ali.lead_id
     , lead_name
     , pipeline_name
     , user_group_name
     , manager_login
     , manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id as link_deal
     , 'task'                                                          as strim
     , 'no_active_tasks'                                               as hyg_filt
     , 'Нет задач в активных ни в сделках, ни в организации'           as hyg_filt_text
     --distinct pipeline_name
from snb_b2b.amo_leads_info ali
         left join tasks_deal td on td.deal_id = ali.lead_id
         left join company_deal cd on cd.company_id = ali.company_id
where pipeline_name in ('ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ')
  and lead_status = 'open'
  and (td.deal_id is null
    and cd.company_id is null);

-----------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with tasks_deal as (select entity_id as deal_id
                    from delivery_ods_amocrm.task
                    where entity_type = 'leads'
                      and completed_flg = false
                    group by entity_id)
select ali.lead_id
     , lead_name
     , pipeline_name
     , user_group_name
     , manager_login
     , manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id as link_deal
     , 'task'                                                          as strim
     , 'task_should_not_be'                                            as hyg_filt
     , 'Есть задачи в сделках, а их быть не должно'                    as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join tasks_deal td on td.deal_id = ali.lead_id
where (pipeline_name in ('ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ', 'РАСТОРГНУТЫЕ ДОГОВОРЫ')
    or (pipeline_name in ('ХОЛОД') and pipeline_status_name in ('ИДЕЯ (БАЗА ДЛЯ ПРОРАБОТКИ)')))
  and lead_status = 'open'
  and td.deal_id is not null;
------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , lead_name
     , pipeline_name
     , user_group_name
     , manager_login
     , manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                                                           as link_deal
     , 'loss'                                                                                                                                    as strim
     , 'no_product_reasons'                                                                                                                      as hyg_filt
     , 'Нельзя проиграть сделку с причиной "Продуктовые причины", если не заполнено хотя бы одно поле Продуктовая причина проигрыша в Продуктах' as hyg_filt_text
from snb_b2b.amo_leads_info ali
where lead_status = 'lost'
  and loss_reason_name = 'Продуктовые причины'
  and ndd_reason_loss is null
  and sdd_reason_loss is null
  and cargo_reason_loss is null
  and express_reason_loss is null;
------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with hst as (select *
             from snb_b2b.amo_leads_info_hist
             where msk_snapshot_dt = current_date - 1
               and lead_status = 'open'
               and pipeline_status_name not in ('ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ'))
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                       as link_deal
     , 'loss'                                                                                                as strim
     , 'incorrect_reason_no_contact_been'                                                                    as hyg_filt
     , 'Нельзя проиграть сделку с причиной "Не установлен контакт" НЕ на этапе "Договориться о презентации"' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join hst on hst.lead_id = ali.lead_id
where ali.lead_status = 'lost'
  and ali.loss_reason_name = 'Не установлен контакт'
  and hst.pipeline_status_name is not null;
----------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with hst as (select *
             from snb_b2b.amo_leads_info_hist
             where msk_snapshot_dt = current_date - 1
               and lead_status = 'open'
               and pipeline_status_name in ('ИЗУЧИТЬ И ЗАБРАТЬ', 'ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ'))
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                                                  as link_deal
     , 'loss'                                                                                                                           as strim
     , 'incorrect_reason_stopped_contacting'                                                                                            as hyg_filt
     , 'Нельзя проиграть сделку с причиной "Перестал выходить на связь" на на этапах "Изучить и забрать", "Договориться о презентации"' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join hst on hst.lead_id = ali.lead_id
where ali.lead_status = 'lost'
  and ali.loss_reason_name = 'Перестал выходить на связь'
  and hst.pipeline_status_name is not null;
---------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with hst as (select *
             from snb_b2b.amo_leads_info_hist
             where msk_snapshot_dt = current_date - 1
               and lead_status = 'open'
               and pipeline_status_name in ('ИЗУЧИТЬ И ЗАБРАТЬ'))
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                as link_deal
     , 'loss'                                                                                         as strim
     , 'incorrect_reason_signed_another_legal'                                                        as hyg_filt
     , 'Нельзя проиграть сделку с причиной "Заключили на другое ЮЛ" на на этапах "Изучить и забрать"' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join hst on hst.lead_id = ali.lead_id
where ali.lead_status = 'lost'
  and ali.loss_reason_name = 'Заключили на другое ЮЛ'
  and hst.pipeline_status_name is not null;
--------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with hst as (select *
             from snb_b2b.amo_leads_info_hist
             where msk_snapshot_dt = current_date - 1
               and lead_status = 'open'
               and pipeline_status_name in ('ИЗУЧИТЬ И ЗАБРАТЬ'))
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                                            as link_deal
     , 'loss'                                                                                                                     as strim
     , 'incorrect_reason_delivery_not_start'                                                                                      as hyg_filt
     , 'Нельзя проиграть сделку с причиной "Не запущена доставка" на на этапах "Изучить и забрать", "Договориться о презентации"' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join hst on hst.lead_id = ali.lead_id
where ali.lead_status = 'lost'
  and ali.loss_reason_name = 'Не запущена доставка'
  and hst.pipeline_status_name is not null;
--------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with hst as (select *
             from snb_b2b.amo_leads_info_hist
             where msk_snapshot_dt = current_date - 1
               and lead_status = 'open'
               and pipeline_status_name in ('ИЗУЧИТЬ И ЗАБРАТЬ', 'ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ'))
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                               as link_deal
     , 'loss'                                                                                        as strim
     , 'incorrect_reason_organization_closed'                                                        as hyg_filt
     , 'Нельзя проиграть сделку с причиной "Организация закрылась" на на этапах "Изучить и забрать"' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join hst on hst.lead_id = ali.lead_id
where ali.lead_status = 'lost'
  and ali.loss_reason_name = 'Организация закрылась'
  and hst.pipeline_status_name is not null;
--------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                        as link_deal
     , 'loss'                                                                                                 as strim
     , 'product_reasons_customization'                                                                        as hyg_filt
     , 'Продуктовая причина проигрыша = "Требуется кастомизация", но не заполнен вишлист (учитывать продукт)' as hyg_filt_text
from snb_b2b.amo_leads_info ali
where lead_status = 'lost'
  and loss_reason_name = 'Продуктовые причины'
  and ((ndd_reason_loss = 'Требуется кастомизация' and ndd_wishlist is null)
    or (sdd_reason_loss = 'Требуется кастомизация' and sdd_wishlist is null)
    or (cargo_reason_loss = 'Требуется кастомизация' and cargo_wishlist is null)
    or (express_reason_loss = 'Требуется кастомизация' and express_wishlist is null));
--------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                                     as link_deal
     , 'loss'                                                                                                              as strim
     , 'product_reasons_no_product_detail'                                                                                 as hyg_filt
     , 'Cделка проиграна с причиной "Продуктовые причины", но по продукту из поля Продукты не указаны продуктовые причины' as hyg_filt_text
from snb_b2b.amo_leads_info ali
where lead_status = 'lost'
  and loss_reason_name = 'Продуктовые причины'
  and ((product like '%NDD%' and ndd_reason_loss is null)
    or (product like '%SDD%' and sdd_reason_loss is null)
    or (product like '%Грузовой%' and cargo_reason_loss is null)
    or (product like '%Экспресс%' and express_reason_loss is null)
    );
-------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id as link_deal
     , 'working_client'                                                as strim
     , 'product_no_product_detail'                                     as hyg_filt
     , 'Заполнен продукт, но не указан этап работы с продуктом'        as hyg_filt_text
from snb_b2b.amo_leads_info ali
where lead_status = 'open'
  and ((product like '%NDD%' and ndd_pipeline_stage is null)
    or (product like '%SDD%' and sdd_pipeline_stage is null)
    or (product like '%Грузовой%' and cargo_pipeline_stage is null)
    or (product like '%Экспресс%' and express_pipeline_stage is null))
  AND (pipeline_name not in ('ХОЛОД', 'РАСТОРГНУТЫЕ ДОГОВОРЫ', 'DEBT-BRUT', 'DEBT-LONGIN', 'ДОГОВОРЫ ЯНДЕКС ТАКСИ')
    );

-------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with tasks_deal as (select entity_id as deal_id
                    from delivery_ods_amocrm.task
                    where entity_type = 'leads'
                      and completed_flg = false
                    group by entity_id)
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id as link_deal
     , 'loss'                                                          as strim
     , 'no_scheduled_task'                                             as hyg_filt
     , 'Причина проигрыша "Отложить", но нет запланированной задачи'   as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join tasks_deal td on td.deal_id = ali.lead_id
where lead_status = 'lost'
  and loss_reason_name = 'Отложить'
  and td.deal_id is null;
----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with lead_right as (select lead_id, pipeline_name
                    from snb_b2b.amo_leads_info ali
                    where pipeline_name in ('ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ'))

select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                 as link_deal
     , 'working_client'                                                                as strim
     , 'no_related_major_deals'                                                        as hyg_filt
     , 'У сделки в ДД нет связанных сделок в основной воронке (Подключение, Развитие)' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join lead_right on lead_right.lead_id = (SUBSTRING(ali.main_deal_link, 'Y*([0-9]{1,20})')::bigint) and
                                 (ali.main_deal_link like '%https://yandexdelivery.amocrm.ru/leads/detail/%')
where ali.pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ'
  and lead_right.lead_id is null;
----------------------------------------------------------------------------------------
-- insert into snb_b2b.amo_inquisitor_list
-- select ali.lead_id
--              ,  ali.lead_name
--              ,  ali.pipeline_name
--              , ali.user_group_name
--              ,  ali.manager_login
--              ,  ali.manager_name
--              , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id as link_deal
--              , 'contract'                                                          as strim
--              , 'no_contract_in_balance'                              as hyg_filt
-- ,'Некорректный номер договора (присутствуют пробелы, лишние знаки, неверная сделка)' as hyg_filt_text
-- from snb_b2b.amo_leads_info ali
--                     left join (select *, row_number() over (partition by contract_eid order by dt desc) rn
--                                from snb_b2b.balance_contracts) bcnt
--                         on bcnt.contract_eid = ali.contract_id and bcnt.person_inn=ali.inn and rn=1
-- where ali.contract_id is not null
--   and bcnt.contract_eid is null;
----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with act as (select contract_eid,
                    invoice_eid,
                    sum(amount) as accruals
             from snb_b2b.balance_sales_daily
--              where contract_eid  in ('1581488/21') --in('570170/20','420579/19')
             group by contract_eid, invoice_eid)
   , pay as (select invoice_eid,
                    sum(amt_w_nds) as payment
             from snb_b2b.balance_oebs_cash_payment_fact
--           where invoice_eid in ('ЛСТ-3550850726-1')  --in('ЛСТ-2789306117-1','ЛСТ-1978207345-1')
             group by invoice_eid)
   , debt_all as (select contract_eid, coalesce(sum(accruals), 0) - coalesce(sum(payment), 0) as debt
                  from act
                           left join pay on act.invoice_eid = pay.invoice_eid
                  group by contract_eid)
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id as link_deal
     , 'contract'                                                      as strim
     , 'cancelled_contract_with_debt'                                  as hyg_filt
     , 'Есть долг по договору в воронке Расторгнутые'                  as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join debt_all on debt_all.contract_eid = ali.contract_id and debt_all.debt > 0
where ali.contract_id is not null
  and pipeline_name = 'РАСТОРГНУТЫЕ ДОГОВОРЫ'
  and debt_all.contract_eid is not null;
----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
with act_flgt as (select distinct corp_contract_id
                  from snb_b2b.dbcorp_contract_info
                  where activate_flg),
     blnc_flag as (select distinct contract_external_id,
                                   finish_dt
                   from snb_b2b.niksm_b2b_balance_contract_info
                   where is_active = 1)
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id as link_deal
     , 'contract'                                                      as strim
     , 'cancelled_contract_with_activate_admin'                        as hyg_filt
     , 'Активный договор в воронке Расторгнутые'                       as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join act_flgt on act_flgt.corp_contract_id = ali.contract_id
         left join blnc_flag on blnc_flag.contract_external_id = ali.contract_id

where ali.contract_id is not null
  and pipeline_name = 'РАСТОРГНУТЫЕ ДОГОВОРЫ'
  and
    (not
        (pipeline_status_name in ('Договор не подписан/не акцептован')
            and contract_type in ('Оферта'))
    or not
           (contract_type = 'Бумажный' and finish_dt is not null))
  and (act_flgt.corp_contract_id is not null
    or blnc_flag.contract_external_id is not null);

----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id as link_deal
     , 'users'                                                         as strim
     , 'no_active_users'                                               as hyg_filt
     , 'У активной сделки деактивирован владелец'                      as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join delivery_ods_amocrm.user usr on usr.user_id = ali.responsible_user_id and user_active_flg = true
where ali.lead_status = 'open'
  and usr.user_id is null;
----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                as link_deal
     , 'risks'                                                                        as strim
     , 'no_risk_downside'                                                             as hyg_filt
     , 'Не заполнено поле Риск снижения 2022 для сделки на этапах Развитие/Удержание' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join delivery_ods_amocrm.user usr on usr.user_id = ali.responsible_user_id and user_active_flg = true
where pipeline_status_name in ('РАЗВИТИЕ', 'УДЕРЖАНИЕ')
  and risk_downside_2022 is null;
----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                 as link_deal
     , 'risks'                                                                         as strim
     , 'no_risk_debt'                                                                  as hyg_filt
     , 'Не заполнено поле Риск дебиторки 2022 для сделки на этапах Развитие/Удержание' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join delivery_ods_amocrm.user usr on usr.user_id = ali.responsible_user_id and user_active_flg = true
where pipeline_status_name in ('РАЗВИТИЕ', 'УДЕРЖАНИЕ')
  and risk_debt_2022 is null;
----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                             as link_deal
     , 'risks'                                                                                     as strim
     , 'no_risk_repay_ovr_debt'                                                                    as hyg_filt
     , 'Не заполнено поле Риск возврата просроченной задолженности для сделок в воронке Debt-Brut' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join delivery_ods_amocrm.user usr on usr.user_id = ali.responsible_user_id and user_active_flg = true
where pipeline_name in ('DEBT-BRUT')
  and risk_repay_ovr_debt is null;
----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                    as link_deal
     , 'contract'                                                                                         as strim
     , 'no_contract_in_balance_KZ'                                                                        as hyg_filt
     , 'Некорректный номер договора (присутствуют пробелы, лишние знаки, неверная сделка) для Казахстана' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join (select *, row_number() over (partition by contract_external_id order by start_dt desc) rn
                    from snb_b2b.niksm_b2b_balance_contract_info) bcnt
                   on bcnt.contract_external_id = ali.contract_id and bcnt.person_kz_bin = ali.inn and rn = 1
where ali.country = 'Казахстан'
  and ali.contract_id is not null
  and bcnt.contract_external_id is null;
----------------------------------------------------------------------------------------
insert into snb_b2b.amo_inquisitor_list
select ali.lead_id
     , ali.lead_name
     , ali.pipeline_name
     , ali.user_group_name
     , ali.manager_login
     , ali.manager_name
     , 'https://yandexdelivery.amocrm.ru/leads/detail/' || ali.lead_id                                  as link_deal
     , 'contract'                                                                                       as strim
     , 'no_contract_in_balance_RB'                                                                      as hyg_filt
     , 'Некорректный номер договора (присутствуют пробелы, лишние знаки, неверная сделка) для Беларуси' as hyg_filt_text
from snb_b2b.amo_leads_info ali
         left join (select *, row_number() over (partition by contract_external_id order by start_dt desc) rn
                    from snb_b2b.niksm_b2b_balance_contract_info) bcnt
                   on bcnt.contract_external_id = ali.contract_id and bcnt.person_inn = ali.inn and rn = 1
where ali.country = 'Беларусь'
  and ali.contract_id is not null
  and bcnt.contract_external_id is null;

----------------------------------------------------------------------------------------






