SELECT
    corp_client_id,
    claim.referral_source_code as referral_source,
    date_trunc('week',claim.utc_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as calweek,
    sum(case when claim_point.point_type = 'destination' and claim_point.visit_status = 'visited' then 1 else 0 end) as deliveries_cnt
from delivery_ods_cargo_claims.claim
  join delivery_ods_cargo_claims.claim_point
    on claim_point.claim_id = claim.claim_id
    and claim_point.utc_created_dttm >= timestamp'2020-09-01' at time zone 'UTC' at time zone 'Europe/Moscow'
WHERE claim.referral_source_code is not null
  and claim.corp_client_id is not null
  and claim.utc_created_dttm >= timestamp'2020-09-01' at time zone 'UTC' at time zone 'Europe/Moscow'
  and claim.utc_created_dttm <  current_date at time zone 'UTC'
group by 1,2,3