PRAGMA yson.DisableStrict;
PRAGMA yt.InferSchema;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA AnsiOrderByLimitInUnionAll;

$dttm_to_string_dt = DateTime::Format('%Y-%m-%d');
$dt_to_dbl = ($dt) -> { RETURN cast( DateTime::ToSeconds( cast ($dt as date) ) as double) };

SELECT
    corp_client_id,
    referral_source,
    transaction_week,
    sum(
        case when d.currency in AsList('RUB', 'BYN') then
                cast(d.amount as Double) * d.aggregation_sign --* 1.2
                when d.currency = 'ILS' then
                cast(d.amount as Double) * d.aggregation_sign
                else
                cast(d.amount as Double) * d.aggregation_sign --* 1.12
            end
    ) as total_dec_cost
from `//home/taxi/production/replica/postgres/cargo_claims/claims` as cc
  left join range(`//home/taxi/production/export/tlog/revenues`, `2020-09-01`) as d
    on cc.uuid_id = Yson::ConvertToString(d.`payload`['claim_id'])
WHERE cc.referral_source is not null
  and cc.corp_client_id is not null
  and cc.created_ts >= $dt_to_dbl('2020-09-01')
group by cc.corp_client_id as corp_client_id,
    cc.referral_source as referral_source,
    $dttm_to_string_dt(DateTime::StartOfWeek(DateTime::ParseIso8601(d.`transaction_time`))) as transaction_week