from b2b_mailer import main2

import json
from business_models import greenplum
from business_models.greenplum import GreenplumManager

import logging
import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

key_file = 'keys.json'

with open(key_file) as f:
    from_file = json.load(f)
gp_user = 'robot-sam-bridges'
gp_token = from_file['sam_gp_token']
greenplum = GreenplumManager(user=gp_user, token = gp_token)

with open('mailer_integra.sql') as f:
    query_GP = f.read()
df = greenplum(query_GP)

logging.info(f"df len {len(df)}")

# name columns for excel
col_names = {
    'corp_client_id': 'corp_client_id',
    'corp_client_name': 'corp_client_name',
    'corp_contract_id': 'corp_contract_id',
    'potential': 'CRM potential',
    'manager_name': 'Manager name',
    'crm_source': 'crm_source',
    'lead_id': 'Lead ID',
    'start_dt': 'Balance start date',
    'legal_entity': 'Legal entity',
    'ya_campaign': 'ya_campaign',
    'corpwelcome_ticket_key': 'CORPWELCOME key',
    'referral_source': 'referral_source',
    'calweek': 'week',
    'claims_plan_cnt': 'Claims count (attempts)',
    'deliveries_plan_cnt': 'Deliveries count (attempts)',
    'deliveries_cnt': 'Deliveries count (visited)'
}

key_key = 'sam_gp_token'
main2(
    receivers_url=None,
    # add to receivers all people from specific groups at staff
    receivers_ancestors=None,
    # add to receivers people, who have listed groups above theirs
    receivers_logins=None,  # add to receivers people by logins
    exclude_logins=None,
    mail_name='Integration weekly report',  # name of letter
    mail_text='Clients with ya_campaign and/or deliveries with referral_source',  # body of letter
    mail_cc=None,  # send a copy to listed emails
    hierarchy=True,
    # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
    emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
    key_file=key_file,  # where the keys are
    key_key=key_key,  # key of gp token in file
    flat=['niksm','vzhukov94','jshumova','alexeyfedotov'],  #  list of emails. mail all rows to these addresses
    user=gp_user,
    database='ritchie',
    host='gpdb-master.taxi.yandex.net',
    port=5432,
    managers_table='snb_b2b.voytekh_manager_v2',
    sheets=[
        {'query': None,
         'df': df,
         'exclude_columns': None,
         'col_names': col_names,
         'sheet_name': 'data'}
    ]
)

logging.info('SUCCESS')
