drop table if exists claim_points;
create temporary table claim_points as
select claim_id,
       count() as deliveries_plan_cnt,
       sum(case when visit_status = 'visited' then 1 else 0 end) as deliveries_cnt
from delivery_ods_cargo_claims.claim_point
where true
  and utc_created_dttm >= timestamp'2020-12-28' at time zone 'UTC' at time zone 'Europe/Moscow'
  and point_type = 'destination'
group by 1;

drop table if exists claims;
create temporary table claims as
SELECT corp_client_id,
       claim.referral_source_code as referral_source,
       date_trunc('week',claim.utc_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as calweek,
       count() as claims_plan_cnt,
       sum(deliveries_plan_cnt) as deliveries_plan_cnt,
       sum(deliveries_cnt) as deliveries_cnt
from delivery_ods_cargo_claims.claim
  join claim_points
    on claim_points.claim_id = claim.claim_id
WHERE true
  and claim.referral_source_code is not null
  and claim.corp_client_id is not null
  and claim.utc_created_dttm >= timestamp'2020-12-28' at time zone 'UTC' at time zone 'Europe/Moscow'
  and claim.utc_created_dttm <  current_date at time zone 'UTC'
group by 1,2,3;

drop table if exists clients;
create temporary table clients as
select lk.corp_client_id,
       lk.corp_client_name,
       lk.corp_contract_id,
       crm.price as potential,
       coalesce(crm.manager_name,crm.manager_login) as manager_name,
       crm.crm_source,
       crm.lead_id,
       blnc.start_dt,
       case
           when blnc.legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
           when blnc.legal_contract_taxi  = 1 then 'ООО Яндекс.Такси'
        end as legal_entity,
       utm.ya_campaign,
       utm.ticket_key as corpwelcome_ticket_key
from snb_b2b.dbcorp_client_info lk
  left join snb_b2b.amo_contracts_info crm
    on crm.contract_id = lk.corp_contract_id
  left join snb_b2b.niksm_b2b_balance_contract_ext_info as blnc
    on blnc.contract_external_id = lk.corp_contract_id
  left join snb_b2b.niksm_b2b_contract_utm utm
    on utm.contract_id = lk.corp_contract_id
distributed by (corp_client_id);

select clients.corp_client_id,
       corp_client_name, corp_contract_id, potential, manager_name, crm_source, lead_id, start_dt, legal_entity,
       ya_campaign, corpwelcome_ticket_key,
       --
       referral_source, calweek, claims_plan_cnt, deliveries_plan_cnt, deliveries_cnt
from clients
  left join claims
    on claims.corp_client_id = clients.corp_client_id
where ya_campaign is not null
   or referral_source is not null;
