insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_contract_utm', 'Start', clock_timestamp());

drop table if exists corpwelcome;
create temporary table corpwelcome as
select substring(key from 'CORPWELCOME-(\d+)')::bigint as ticket_id,
       key as ticket_key,
       deal as lead_link,
       substring(deal from
           'https://(yandexdelivery.pipedrive.com/deal' ||
           '|yandexdelivery.amocrm.ru/leads/detail' ||
           '|ydinter.amocrm.com/leads/detail)/(\d+)(([^\d]+.*)|)$'
           ) as crm_domain,
        -- если питон ругается на двоеточие, поставить бэкслеш перед ним
       substring(deal from
           'https://(?:yandexdelivery.pipedrive.com/deal' ||
           '|yandexdelivery.amocrm.ru/leads/detail' ||
           '|ydinter.amocrm.com/leads/detail)/(\d+)(([^\d]+.*)|)$'
           )::int as lead_id,
       --
       utmsource, utmmedium, utmcampaign, utmterm, utmcontent,
       substring(description from '.*ya_medium[\s\-:–\t'']{1,4}(.+?)[\\n,\t'']{1}.*') as ya_medium,
       case
           when substring(description from '.*ya_medium[\s\-:–\t'']{1,4}(.+?)[\\n,\t'']{1}.*') = 'module'
           then substring(description from '.*ya_campaign[\s\-:–\t'']{1,4}(.+?)[\\n,\t'']{1}.*')
        end as ya_campaign
from snb_b2b.voytekh_corpwelcome
where true
  and type = 'task'
  and resolution in ('fixed', 'escalated')
  and deal ~ 'https://(yandexdelivery.pipedrive.com/deal|yandexdelivery.amocrm.ru/leads/detail|ydinter.amocrm.com/leads/detail)/(\d+)';

drop table if exists crm_comp;
create temporary table crm_comp as
with crm_raw as (
    select crm.crm_source,
           crm.company_id,
           cw.ticket_id,
           cw.ticket_key,
           cw.lead_link,
           cw.crm_domain,
           utmsource, utmmedium, utmcampaign, utmterm, utmcontent,
           ya_medium, ya_campaign
    from snb_b2b.amo_leads_info crm
      join corpwelcome cw
        on cw.lead_id = crm.lead_id
        and crm.crm_source = 'yandexdelivery'
        and cw.crm_domain = 'yandexdelivery.amocrm.ru/leads/detail'
    union all
    select crm.crm_source,
           crm.company_id,
           cw.ticket_id,
           cw.ticket_key,
           cw.lead_link,
           cw.crm_domain,
           utmsource, utmmedium, utmcampaign, utmterm, utmcontent,
           ya_medium, ya_campaign
    from snb_b2b.amo_leads_info crm
      join corpwelcome cw
        on cw.lead_id = crm.pd_deal_id
        and crm.crm_source = 'yandexdelivery'
        and cw.crm_domain = 'yandexdelivery.pipedrive.com/deal'
    union all
    select 'ydinter'::text as crm_source,
           crm.company_id,
           cw.ticket_id,
           cw.ticket_key,
           cw.lead_link,
           cw.crm_domain,
           utmsource, utmmedium, utmcampaign, utmterm, utmcontent,
           ya_medium, ya_campaign
    from delivery_ods_amocrm_international.lead as crm
      join corpwelcome cw
        on cw.lead_id = crm.lead_id
        and cw.crm_domain = 'ydinter.amocrm.com/leads/detail'
)
select crm_source,
       company_id,
       ticket_key, lead_link,
       utmsource, utmmedium, utmcampaign, utmterm, utmcontent,
       ya_medium, ya_campaign
from (
    select crm_source,
           company_id,
           --
           ticket_key, lead_link,
           utmsource, utmmedium, utmcampaign, utmterm, utmcontent,
           ya_medium, ya_campaign,
           row_number() over (partition by crm_source, company_id order by ticket_id) as rn
    from crm_raw
)q
where rn = 1;

drop table if exists contract_utm;
create temporary table contract_utm as
with crm_contr_un as (
    select contract_id,
           crm_source,
           company_id
    from snb_b2b.amo_contracts_info
    where crm_source = 'yandexdelivery'
    union all
    select contract_num as contract_id,
           'ydinter'::text as crm_source,
           company_id
    from delivery_ods_amocrm_international.lead
    where contract_num is not null
      and contract_num <> ''
)
select cntr.contract_id,
       cntr.crm_source,
       cntr.company_id,
       --
       ticket_key, lead_link,
       utmsource, utmmedium, utmcampaign, utmterm, utmcontent,
       ya_medium, ya_campaign
from (
     select contract_id,
            crm_source,
            company_id,
            row_number() over (partition by contract_id
                order by
                    case when crm_source = 'yandexdelivery' then 0 else 1 end) as rn
     from crm_contr_un
) cntr
  left join crm_comp
    on crm_comp.crm_source = cntr.crm_source
    and crm_comp.company_id = cntr.company_id
where rn = 1;

------------------------------------------------------------------------------------------------------------------------
-- drop table if exists snb_b2b.niksm_b2b_contract_utm;
-- create table snb_b2b.niksm_b2b_contract_utm as
truncate table snb_b2b.niksm_b2b_contract_utm;
insert into snb_b2b.niksm_b2b_contract_utm
    (contract_id, crm_source, company_id, ticket_key, lead_link, utmsource, utmmedium, utmcampaign, utmterm, utmcontent, ya_medium, ya_campaign)
select contract_id, crm_source, company_id, ticket_key, lead_link, utmsource, utmmedium, utmcampaign, utmterm, utmcontent, ya_medium, ya_campaign
from contract_utm
-- distributed by (contract_id)
;

-- alter table snb_b2b.niksm_b2b_contract_utm add constraint niksm_b2b_contract_utm_pk primary key (contract_id);
-- comment on table snb_b2b.niksm_b2b_contract_utm is 'Справочник UTM-меток по контрактам. Метки тянутся из первого тикета CORPWELCOME для данной компании company_id из CRM';

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_contract_utm', 'Finish', clock_timestamp());
