--========================================================--
-- выгрузка по задачам
with a as (select
--     distinct jsonb_object_keys ( data->0)
(data -> 0 ->> 'entity_id')::bigint                                                           as entity_id,
case
    when data -> 0 ->> 'task_type_id' = '1' then 'Связаться'
    when data -> 0 ->> 'task_type_id' = '2' then 'Встреча'
    when data -> 0 ->> 'task_type_id' = '2486197' then 'Эл. почта'
    when data -> 0 ->> 'task_type_id' = '2486200' then 'На контроле'
    when data -> 0 ->> 'task_type_id' = '2486203' then 'Задание'
    when data -> 0 ->> 'task_type_id' = '2486206' then 'Ждем договор'
    when data -> 0 ->> 'task_type_id' = '2486209' then 'Передать контакт'
    when data -> 0 ->> 'task_type_id' = '2486212' then 'Чек доставок'
    when data -> 0 ->> 'task_type_id' = '2486215' then 'Контроль оплаты'
    when data -> 0 ->> 'task_type_id' = '2486218' then 'Проверка скоринг'
    when data -> 0 ->> 'task_type_id' = '2486221' then 'Отток'
    when data -> 0 ->> 'task_type_id' = '2486224' then 'Гигфильтры в CRM'
    when data -> 0 ->> 'task_type_id' = '2501971' then 'Холодный звонок'
    when data -> 0 ->> 'task_type_id' = '2503027' then 'Арбитраж'
    else 'others' end                                                              as task_type_name,
data -> 0 -> 'task_type_id'                                                        as task_type_id,

(to_timestamp((data -> 0 ->> 'created_at')::bigint) at time zone 'Europe/Moscow')::date    as msk_created_date,
to_timestamp((data -> 0 ->> 'created_at')::bigint) at time zone 'Europe/Moscow'    as created_at,
to_timestamp((data -> 0 ->> 'updated_at')::bigint) at time zone 'Europe/Moscow'    as updated_at,
to_timestamp((data -> 0 ->> 'complete_till')::bigint) at time zone 'Europe/Moscow' as complete_till,
case
    when (to_timestamp((data -> 0 ->> 'updated_at')::bigint) at time zone 'Europe/Moscow') >
         (to_timestamp((data -> 0 ->> 'created_at')::bigint) at time zone 'Europe/Moscow') then true
    when (to_timestamp((data -> 0 ->> 'updated_at')::bigint) at time zone 'Europe/Moscow') =
         (to_timestamp((data -> 0 ->> 'created_at')::bigint) at time zone 'Europe/Moscow')
        and (to_timestamp((data -> 0 ->> 'created_at')::bigint) at time zone 'Europe/Moscow') =
            (to_timestamp((data -> 0 ->> 'complete_till')::bigint) at time zone 'Europe/Moscow') then true
    else false end                                                                 as finish_task_flg,
case
    when to_timestamp((data -> 0 ->> 'created_at')::bigint) at time zone 'Europe/Moscow'
        = to_timestamp((data -> 0 ->> 'complete_till')::bigint) at time zone 'Europe/Moscow' then true
    when to_timestamp((data -> 0 ->> 'complete_till')::bigint) at time zone 'Europe/Moscow' >=
         to_timestamp((data -> 0 ->> 'updated_at')::bigint) at time zone 'Europe/Moscow' then true
    else false end                                                                 as successful_flg,
data -> 0 ->> 'id'                                                                  as id

--  data->0->'created_by' as created_by,
--  data->0->'text' as text,
--  data->0->'account_id' as account_id,
--  data->0->'duration' as duration,
--
--  data->0->'result' as result,
--  data->0->'updated_by' as updated_by,
--  data->0->'entity_type' as entity_type,
-- --  data->0->'updated_at' as updated_at,
--
--  data->0->'_links' as _links,
-- --  data->0->'created_at' as created_at,
--  data->0->'group_id' as group_id,
--  data->0->'is_completed' as is_completed,
-- --  data->0->'entity_id' as entity_id,
--
-- --   data->0->'complete_till' as complete_till,
--  data->0->'responsible_user_id' as responsible_user_id

           from snb_b2b.voytekh_amo_tasks
           where data -> 0 ->> 'entity_type' = 'leads'
-- and   data->0->>'entity_id'='7851929'
-- and data->0->>'task_type_id'='2503027'
)
, tt as (select entity_id as deal_id,
                msk_created_date,
                task_type_name,
                finish_task_flg,
                successful_flg,
                count(distinct id) as cnt_task
         from a
         group by entity_id, msk_created_date, task_type_name, finish_task_flg, successful_flg)

select manager_metagroup,manager_group,manager_login, manager_name,  msk_created_date, task_type_name, finish_task_flg, successful_flg,
       sum(cnt_task) as cnt_task
from snb_b2b.amo_leads_info aml
left join tt on tt.deal_id=aml.lead_id
where manager_metagroup='Тир 2'
group by manager_metagroup,manager_group,manager_login, manager_name,  msk_created_date, task_type_name, finish_task_flg, successful_flg
 ;
--=============================================================
--выгрузка по доставкам

with dl as (
    select corp_client_id,(date_trunc('month',utc_order_created_dttm))::date as month,
       case when (date_trunc('month',utc_order_created_dttm))::date=date_trunc('month', current_date-1)::date
           then  (current_date-1)-date_trunc('month', current_date-1)::date+1
           else EXTRACT(DAY from(((date_trunc('month',utc_order_created_dttm))::date+'1 month'::interval) -(date_trunc('month',utc_order_created_dttm))::date))
           end  as cnt_days_dlv,
           EXTRACT(DAY from((date_trunc('month',utc_order_created_dttm))::date+'1 month'::interval) -(date_trunc('month',utc_order_created_dttm))::date) as cnt_days_m,
           count() as deliveries_cnt
from taxi_cdm_logistic.fct_delivery
where true
  and utc_created_dttm >=date_trunc('month',date_trunc('month', current_date-1)::date-1)
  and taxi_tariff_class_code is not null
   and (claim_dst_point_status = 'visited'  or (claim_id is null and taxi_success_order_flg))
group by corp_client_id,(date_trunc('month',utc_order_created_dttm))::date

)

select manager_metagroup,manager_group,manager_login, manager_name, month, cnt_days_dlv,cnt_days_m,
       sum(deliveries_cnt) deliveries_cnt
from snb_b2b.amo_leads_info aml
left join snb_b2b.niksm_b2b_lk_contract_info lkc on lkc.contract_external_id=aml.contract_id
left join  dl on dl.corp_client_id=coalesce(lkc.lk_client_id,aml.corp_client_id)
where manager_metagroup='Тир 2'
group by manager_metagroup,manager_group,manager_login, manager_name, month, cnt_days_dlv,cnt_days_m;