-- deal_history - источник для нескольких таблиц
drop table if exists niksm_temp_927_ndd_funnel_ndd_hist;
create temporary table niksm_temp_927_ndd_funnel_ndd_hist as
with tt as (select dlh.*
            from snb_b2b.amo_leads_info_hist dlh
                     join snb_b2b.amo_leads_info crm
                          on dlh.crm_source = 'yandexdelivery'
                              and crm.lead_id = dlh.lead_id
            where dlh.crm_source = 'yandexdelivery'
              and dlh.msk_snapshot_dt >= '2021-01-01'
              and crm.ndd_pipeline_stage is not null)

select msk_snapshot_dt as record_date,
       6 as which_crm,
       lead_id as deal_id,
       --
       null as ndd_pipeline_stage_key,
       max(ndd_pipeline_stage) ndd_pipeline_stage,
        null as ndd_integration_status_key,
       max(ndd_integration_status) as ndd_integration_status
from tt
group by msk_snapshot_dt,
         lead_id;
--
analyse niksm_temp_927_ndd_funnel_ndd_hist;

--====================================================================================================================--
-- drop table if exists niksm_temp_927_ndd_funnel_dlh;
-- create temporary table niksm_temp_927_ndd_funnel_dlh as
-- select dlh.*
-- from snb_b2b.voytekh_pd2_deal_history dlh
--   join snb_b2b.amo_leads_info crm
--     on dlh.which_crm = 6
--     and crm.pd_deal_id = dlh.id
-- where dlh.which_crm = 6
--   and dlh.record_date >= '2021-01-01'
--   and crm.ndd_pipeline_stage is not null;
-- --
-- analyse niksm_temp_927_ndd_funnel_dlh;
-- ------------------------------------------------------------------------------------------------------------------------
-- drop table if exists niksm_temp_927_ndd_funnel_ndd_hist;
-- create temporary table niksm_temp_927_ndd_funnel_ndd_hist as
-- with deal_custom_fields_raw as (
--     select f.attribute_name,
--            f.which_crm,
--            f.key,
--            cast(json_each_text(options) as varchar) as custom_fields
--     from snb_b2b.voytekh_pd2_deal_field as opt
--       join snb_b2b.niksm_b2b_deal_field as f
--         on f.which_crm = opt.which_crm
--         and f.key = opt.key
--     where f.with_dict
--       and f.which_crm = 6
--       and f.attribute_name in ('Этап воронки NDD','Статус интеграции NDD')
-- )
-- , deal_custom_fields as (
--     select attribute_name,
--            which_crm,
--            key,
--            SUBSTRING(custom_fields from '^\((\d+),.*\)$') as field_id,
--            replace( SUBSTRING(custom_fields from '^\(\d+,(.*)\)$'),
--                '"','')::text as field_name
--     from deal_custom_fields_raw
-- )
-- , attr_splitted as (
--     select deals.record_date,
--            deals.which_crm,
--            deals.id as deal_id,
--            --
--            f.key,
--            f.attribute_name,
--            f.with_dict,
--            f.array_flg,
--            (deals.custom_fields ->> f.key)::text as attribute_key,
--            case
--                when f.array_flg then unnest(string_to_array((deals.custom_fields ->> f.key), ','))
--                else (deals.custom_fields ->> f.key) end as attribute_key_splitted
--     from niksm_temp_927_ndd_funnel_dlh as deals
--       left join snb_b2b.niksm_b2b_deal_field as f
--         on f.which_crm = deals.which_crm
-- )
-- , attr_mult as (
--     select attr_splitted.record_date,
--            attr_splitted.which_crm,
--            attr_splitted.deal_id,
--            --
--            attr_splitted.attribute_name,
--            bool_or(with_dict) as with_dict,
--            bool_or(array_flg) as array_flg,
--            max(attribute_key) as attribute_key,
--            case
--                when not bool_or(with_dict) then max(attribute_key)
--                when bool_or(array_flg) then '[' || string_agg(format('"%s"', ocf.field_name), ',') || ']'      -- для запуска без питона убрать 1 %
--                else max(ocf.field_name)::text end as attribute_value
--     from attr_splitted
--       left join deal_custom_fields as ocf
--         on ocf.attribute_name = attr_splitted.attribute_name
--         and ocf.which_crm = attr_splitted.which_crm
--         and ocf.key = attr_splitted.key
--         and ocf.field_id = attribute_key_splitted
--     group by attr_splitted.record_date,
--              attr_splitted.which_crm,
--              attr_splitted.deal_id,
--              attr_splitted.attribute_name
-- )
-- select record_date,
--        which_crm,
--        deal_id,
--        --
--        max(case when attribute_name = 'Этап воронки NDD' then attribute_key::int end) as ndd_pipeline_stage_key,
--        max(case when attribute_name = 'Этап воронки NDD' then attribute_value end) as ndd_pipeline_stage,
--        max(case when attribute_name = 'Статус интеграции NDD' then attribute_key::int end) as ndd_integration_status_key,
--        max(case when attribute_name = 'Статус интеграции NDD' then attribute_value end) as ndd_integration_status
-- from attr_mult
-- group by record_date,
--          which_crm,
--          deal_id;
-- --
-- analyse niksm_temp_927_ndd_funnel_ndd_hist;

--====================================================================================================================--
-- select jsonb_array_elements(data -> 0 -> 'enums') ->> 'value' as ndd_pipeline_stage,
--        (jsonb_array_elements(data -> 0 -> 'enums') ->> 'sort')::int as ndd_pipeline_stage_srt
-- from snb_b2b.voytekh_amo_leads_custom_fields cf
--   join snb_b2b.amo_lead_custom_field fld
--     on cf.id = fld.field_id
--     and cf.data->>1 = fld.crm_source
-- where dt = (select max(dt) from snb_b2b.voytekh_amo_leads_custom_fields)
--   and fld.field_name = 'Этап воронки NDD';

drop table if exists niksm_temp_927_ndd_funnel_res;
create temporary table niksm_temp_927_ndd_funnel_res as
with ndd_pipeline_stage_srt(field_srt, stage_name) as (
    values (-3, 'Проиграно'),
           (-2, '(old) Отложить'),
           (-1, '(old) Отток'),
           (1, '1. Идея'),
           (2, '2. Провести встречу'),
           (3, '3. Переговоры'),
           (4, '4. Заключение договора'),
           (5, '5. Старт'),
           (6, '6. Разгон'),
           (7, '7. Развитие'),
           (8, '8. Удержание')

)
, ndd_integration_status_srt(field_srt, integration_name) as (
    values (1, '1. Направлена информация по интеграции'), -- Направлена информация по интеграции
           (2, '2. Получено решение о запуске интеграции'), -- Получено решение о запуске интеграции
           (3, '3. Подготовка к запуску интеграции'), -- Подготовка к запуску интеграции
           (4, '4. Идет интеграция'), -- Идет интеграция
           (5, '5. Интеграция завершена') -- Интеграция завершена
)
, calend as (
    select calday, calday_prev
    from (
        select clnd.calday as calday,
               wd.calday as calday_prev,
               row_number() over (partition by clnd.calday order by wd.calday desc) as rn
        from snb_delivery.logdata_calendar clnd
          cross join snb_delivery.logdata_calendar wd
        where wd.working_day_flg
          and wd.calday < clnd.calday
    ) q
    where rn = 5
)
, raw as (
    select crm.which_crm,
           crm.deal_id,
           max(deal_title) as deal_title,
           max(manager_group) as manager_group,
           max(manager_login) as manager_login,
           max(manager_name) as manager_name,
           max(crm.contract_id) as contract_id,
           max(crm.add_date) as deal_add_date,
           max(crm.channel) as channel,
           max(market_segment) as market_segment,
           max(crm.wishlist) as wishlist,
           max(crm.product) as product,
           max(crm.city) as city,
           max(crm.geography) as geography,
           max(srt_stage_crm.field_srt) as ndd_pipeline_stage_srt,
           max(crm.ndd_pipeline_stage) as ndd_pipeline_stage,
           max(srt_intgr_crm.field_srt) as ndd_integration_status_srt,
           max(crm.ndd_integration_status) as ndd_integration_status,
           max(crm.ndd_potential) as ndd_potential,
           min(case when hist.ndd_pipeline_stage is not null and srt_stage_hist.field_srt <> 1 then hist.record_date end) as ndd_add_date,
           ----
           min(case when srt_stage_hist.field_srt = 1 then hist.record_date end) as pipeline_stage_first_dt_stage_1,
           min(case when srt_stage_hist.field_srt = 2 then hist.record_date end) as pipeline_stage_first_dt_stage_2,
           min(case when srt_stage_hist.field_srt = 3 then hist.record_date end) as pipeline_stage_first_dt_stage_3,
           min(case when srt_stage_hist.field_srt = 4 then hist.record_date end) as pipeline_stage_first_dt_stage_4,
           min(case when srt_stage_hist.field_srt = 5 then hist.record_date end) as pipeline_stage_first_dt_stage_5,
           min(case when srt_stage_hist.field_srt = 6 then hist.record_date end) as pipeline_stage_first_dt_stage_6,
           min(case when srt_stage_hist.field_srt = 7 then hist.record_date end) as pipeline_stage_first_dt_stage_7,
           min(case when srt_stage_hist.field_srt = 8 then hist.record_date end) as pipeline_stage_first_dt_stage_8,
           sum(case when crm.ndd_pipeline_stage = hist.ndd_pipeline_stage then 1 else 0 end) as days_in_last_pipeline_stage,
           --
           max(case when hist.record_date = crm.record_date -  1 then srt_stage_hist.field_srt end) as prev_pipeline_stage_srt_1d,
           max(case when hist.record_date = crm.record_date -  7 then srt_stage_hist.field_srt end) as prev_pipeline_stage_srt_1w,
           max(case when hist.record_date = crm.record_date - 30 then srt_stage_hist.field_srt end) as prev_pipeline_stage_srt_1m,
           ----
           min(case when srt_intgr_hist.field_srt = 1 then hist.record_date end) as integration_status_first_dt_stage_1,
           min(case when srt_intgr_hist.field_srt = 2 then hist.record_date end) as integration_status_first_dt_stage_2,
           min(case when srt_intgr_hist.field_srt = 3 then hist.record_date end) as integration_status_first_dt_stage_3,
           min(case when srt_intgr_hist.field_srt = 4 then hist.record_date end) as integration_status_first_dt_stage_4,
           min(case when srt_intgr_hist.field_srt = 5 then hist.record_date end) as integration_status_first_dt_stage_5,
           sum(case when crm.ndd_integration_status = hist.ndd_integration_status then 1 else 0 end) as days_in_last_integration_status,
           --
           max(case when hist.record_date = crm.record_date -  1 then srt_intgr_hist.field_srt end) as prev_integration_status_srt_1d,
           max(case when hist.record_date = crm.record_date -  7 then srt_intgr_hist.field_srt end) as prev_integration_status_srt_1w,
           max(case when hist.record_date = crm.record_date - 30 then srt_intgr_hist.field_srt end) as prev_integration_status_srt_1m,
           --
           max(crm.record_date) as record_date,
           max(crm.pipeline_name) as pipeline_name,
           max(crm.stage_name) as stage_name,
           max(crm.ndd_connected_options) ndd_connected_options,
           max(crm.ndd_reason_loss) ndd_reason_loss,
           max(crm.ndd_dynamics)ndd_dynamics,
           max(crm.ndd_reason_churn) ndd_reason_churn ,
           max(crm.ndd_wishlist) ndd_wishlist
    from snb_b2b.niksm_b2b_deals_info_amo crm
      join ndd_pipeline_stage_srt srt_stage_crm
        on srt_stage_crm.stage_name = crm.ndd_pipeline_stage
      left join ndd_integration_status_srt srt_intgr_crm
        on srt_intgr_crm.integration_name = crm.ndd_integration_status
      left join niksm_temp_927_ndd_funnel_ndd_hist hist
        on crm.which_crm = hist.which_crm
        and crm.deal_id = hist.deal_id
      left join ndd_pipeline_stage_srt srt_stage_hist
        on srt_stage_hist.stage_name = hist.ndd_pipeline_stage
      left join ndd_integration_status_srt srt_intgr_hist
        on srt_intgr_hist.integration_name = hist.ndd_integration_status
    where crm.which_crm = 6
    group by crm.which_crm, crm.deal_id
)
, contract_dlv as (
    select corp_client_id,
           min(substr(created_dttm,1,10)::date) as first_delivery_dt,
           count(distinct case when substr(created_dttm,1,10)::date
               between current_date-7 and current_date-1
               then request_id end) as orders_cnt_7d,
           count(distinct case when substr(created_dttm,1,10)::date
               between date_trunc('week',current_date)::date-7 and date_trunc('week',current_date)::date-1
               then request_id end) as orders_cnt_lw,
           count(distinct case when substr(created_dttm,1,10)::date
               between current_date-30 and current_date-1
               then request_id end) as orders_cnt_30d
    from snb_delivery.logdata_ndd_requests_datamart ndd
    where corp_client_id is not null
      and mapped_event_type in ('Доставлен', 'Доставлен частично')
    group by corp_client_id
)
select which_crm, deal_id,
       deal_title,
       manager_group,
       coalesce(manager_name, manager_login) as manager_name,
       deal_add_date,
       case when deal_add_date <= calday_prev or calday_prev is null then 'Кросс-сейл' else channel end as channel,
       coalesce(market_segment, 'N/A') as market_segment,
       wishlist, product,
       coalesce(city, 'N/A') as city,
       geography,
       ndd_pipeline_stage_srt, ndd_pipeline_stage,
       ndd_integration_status_srt, ndd_integration_status,
       ndd_potential,
       ndd_add_date,
       pipeline_stage_first_dt_stage_1, pipeline_stage_first_dt_stage_2, pipeline_stage_first_dt_stage_3,
       pipeline_stage_first_dt_stage_4, pipeline_stage_first_dt_stage_5, pipeline_stage_first_dt_stage_6,
       pipeline_stage_first_dt_stage_7,pipeline_stage_first_dt_stage_8,
       days_in_last_pipeline_stage,
       prev_pipeline_stage_srt_1d, prev_pipeline_stage_srt_1w, prev_pipeline_stage_srt_1m,
       --
       integration_status_first_dt_stage_1, integration_status_first_dt_stage_2, integration_status_first_dt_stage_3,
       integration_status_first_dt_stage_4, integration_status_first_dt_stage_5,
       days_in_last_integration_status,
       prev_integration_status_srt_1d, prev_integration_status_srt_1w, prev_integration_status_srt_1m,
       contract_dlv.corp_client_id is not null as ndd_delivery_flg,
       first_delivery_dt,
       orders_cnt_7d, orders_cnt_lw, orders_cnt_30d,
       case when contract_dlv.corp_client_id is not null then greatest(0, first_delivery_dt - ndd_add_date) else 0 end as ndd_dlv_cycle_days,
       blnc.contract_external_id is not null as balance_contract_flg,
       lk_cargo_next_day_delivery::boolean as lk_cargo_ndd_flg,
       record_date,
       pipeline_name,
       stage_name,
       ndd_connected_options,
       ndd_reason_loss,
       ndd_dynamics,
       ndd_reason_churn ,
       ndd_wishlist
from raw
  left join calend
    on calend.calday = raw.ndd_add_date
  left join snb_b2b.niksm_b2b_lk_contract_info lk
    on lk.contract_external_id = raw.contract_id
  left join contract_dlv
    on contract_dlv.corp_client_id = lk.lk_client_id
  left join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = raw.contract_id;
--
analyse niksm_temp_927_ndd_funnel_res;

--====================================================================================================================--
--
-- drop table if exists snb_b2b.niksm_dash_ndd_funnel_927;
-- create table snb_b2b.niksm_dash_ndd_funnel_927 as
truncate table snb_b2b.niksm_dash_ndd_funnel_927;
insert into snb_b2b.niksm_dash_ndd_funnel_927
    (which_crm, deal_id,
       deal_title, manager_group, manager_name, deal_add_date, channel, market_segment, wishlist, product, city, geography,
       ndd_pipeline_stage_srt, ndd_pipeline_stage, ndd_integration_status_srt, ndd_integration_status, ndd_potential, ndd_add_date,
       pipeline_stage_first_dt_stage_1, pipeline_stage_first_dt_stage_2, pipeline_stage_first_dt_stage_3,
       pipeline_stage_first_dt_stage_4, pipeline_stage_first_dt_stage_5, pipeline_stage_first_dt_stage_6,
       pipeline_stage_first_dt_stage_7,pipeline_stage_first_dt_stage_8,
       days_in_last_pipeline_stage,
       prev_pipeline_stage_srt_1d, prev_pipeline_stage_srt_1w, prev_pipeline_stage_srt_1m,
       integration_status_first_dt_stage_1, integration_status_first_dt_stage_2, integration_status_first_dt_stage_3,
       integration_status_first_dt_stage_4, integration_status_first_dt_stage_5,
       days_in_last_integration_status,
       prev_integration_status_srt_1d, prev_integration_status_srt_1w, prev_integration_status_srt_1m,
       ndd_delivery_flg, first_delivery_dt, orders_cnt_7d, orders_cnt_lw, orders_cnt_30d, ndd_dlv_cycle_days,
       balance_contract_flg, lk_cargo_ndd_flg,
       record_date,pipeline_name, stage_name
       ,ndd_connected_options, ndd_reason_loss, ndd_dynamics, ndd_reason_churn, ndd_wishlist)
select which_crm, deal_id,
       deal_title, manager_group, manager_name, deal_add_date, channel, market_segment, wishlist, product, city, geography,
       ndd_pipeline_stage_srt, ndd_pipeline_stage, ndd_integration_status_srt, ndd_integration_status, ndd_potential, ndd_add_date,
       pipeline_stage_first_dt_stage_1, pipeline_stage_first_dt_stage_2, pipeline_stage_first_dt_stage_3,
       pipeline_stage_first_dt_stage_4, pipeline_stage_first_dt_stage_5, pipeline_stage_first_dt_stage_6,
       pipeline_stage_first_dt_stage_7,pipeline_stage_first_dt_stage_8,
       days_in_last_pipeline_stage,
       prev_pipeline_stage_srt_1d, prev_pipeline_stage_srt_1w, prev_pipeline_stage_srt_1m,
       integration_status_first_dt_stage_1, integration_status_first_dt_stage_2, integration_status_first_dt_stage_3,
       integration_status_first_dt_stage_4, integration_status_first_dt_stage_5,
       days_in_last_integration_status,
       prev_integration_status_srt_1d, prev_integration_status_srt_1w, prev_integration_status_srt_1m,
       ndd_delivery_flg, first_delivery_dt, orders_cnt_7d, orders_cnt_lw, orders_cnt_30d, ndd_dlv_cycle_days,
       balance_contract_flg, lk_cargo_ndd_flg,
       record_date,pipeline_name, stage_name
      ,ndd_connected_options, ndd_reason_loss, ndd_dynamics, ndd_reason_churn, ndd_wishlist
from niksm_temp_927_ndd_funnel_res;

-- comment on table snb_b2b.niksm_dash_ndd_funnel_927 is 'Витрина для дашборда воронки NDD. LOGDATA-927';
