drop table if exists temp_amo_contract_permission;
create temporary table temp_amo_contract_permission as
with t as (
    select distinct contract_id,
           substr(login_q,2,length(login_q)-2) as user_login
    from (
        select contract_id,
               unnest(
                string_to_array(substr(permissions,2,length(permissions)-2),',')) as login_q
        from (
            select contract_id,
                   permissions
            from snb_b2b.amo_contracts_info
            union all
            select contract_id, permissions
            from snb_b2b.niksm_b2b_contracts_info_sf
            ) q
    ) qq
)
select t.contract_id, t.user_login,
       person.staff_uid
from t
  left join meta_cdm_staff.person
    on t.user_login = person.login;

-- drop table if exists snb_b2b.amo_contract_permission;
-- create table snb_b2b.amo_contract_permission as
truncate table snb_b2b.amo_contract_permission;
insert into snb_b2b.amo_contract_permission (contract_id, user_login, staff_uid)
select contract_id, user_login, staff_uid
from temp_amo_contract_permission;

-- comment on table snb_b2b.amo_contract_permission is 'Список юзеров, кому доступны данные по контракту: менеджер CRM + руководители + ручные доступы';
------------------------------------------------------------------------------------------------------------------------

drop table if exists temp_amo_client_permission;
create temporary table temp_amo_client_permission as
with t as (
    select distinct corp_client_id,
           substr(login_q,2,length(login_q)-2) as user_login
    from (
        select corp_client_id,
               unnest(
                string_to_array(substr(permissions,2,length(permissions)-2),',')) as login_q
        from snb_b2b.amo_clients_info
    ) qq
)
select t.corp_client_id, t.user_login,
       person.staff_uid
from t
  left join meta_cdm_staff.person
    on t.user_login = person.login;

-- drop table if exists snb_b2b.amo_client_permission;
-- create table snb_b2b.amo_client_permission as
truncate table snb_b2b.amo_client_permission;
insert into snb_b2b.amo_client_permission (corp_client_id, user_login, staff_uid)
select corp_client_id, user_login, staff_uid
from temp_amo_client_permission;

-- comment on table snb_b2b.amo_client_permission is 'Список юзеров, кому доступны данные по контракту: менеджер CRM + руководители + ручные доступы';
