insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('amo_leads_info_hist', 'Start', clock_timestamp());

drop table if exists amo_leads_raw;
create temporary table amo_leads_raw as
    select msk_snapshot_dt, data
from (
    select data,
           (to_timestamp(dt) at time zone 'Europe/Moscow')::date as msk_snapshot_dt,
           row_number() over (partition by id,
               (to_timestamp(dt) at time zone 'Europe/Moscow')::date
               order by dt desc nulls last) as rn
    from snb_b2b.voytekh_amo_leads
    where dt >= extract(epoch from date_trunc('day', current_timestamp at time zone 'Europe/Moscow' - interval '7 days') at time zone 'Europe/Moscow')
) q
where rn = 1;
analyse amo_leads_raw;

drop table if exists amo_leads_loss_reasons;
create temporary table amo_leads_loss_reasons as
select msk_snapshot_dt, data
from (
    select data,
           (to_timestamp(dt) at time zone 'Europe/Moscow')::date as msk_snapshot_dt,
           row_number() over (partition by id,
               (to_timestamp(dt) at time zone 'Europe/Moscow')::date
               order by dt desc nulls last) as rn
    from snb_b2b.voytekh_amo_leads_loss_reasons
    where dt >= extract(epoch from date_trunc('day', current_timestamp at time zone 'Europe/Moscow' - interval '7 days') at time zone 'Europe/Moscow')
) q
where rn = 1;
analyse amo_leads_loss_reasons;

drop table if exists amo_leads_pipelines;
create temporary table amo_leads_pipelines as
select msk_snapshot_dt, data
from (
    select data,
           (to_timestamp(dt) at time zone 'Europe/Moscow')::date as msk_snapshot_dt,
           row_number() over (partition by id,
               (to_timestamp(dt) at time zone 'Europe/Moscow')::date
               order by dt desc nulls last) as rn
    from snb_b2b.voytekh_amo_leads_pipelines
    where dt >= extract(epoch from date_trunc('day', current_timestamp at time zone 'Europe/Moscow' - interval '7 days') at time zone 'Europe/Moscow')
) q
where rn = 1;
analyse amo_leads_pipelines;

drop table if exists amo_companies_raw;
create temporary table amo_companies_raw as
select msk_snapshot_dt, data
from (
    select data,
           (to_timestamp(dt) at time zone 'Europe/Moscow')::date as msk_snapshot_dt,
           row_number() over (partition by id,
               (to_timestamp(dt) at time zone 'Europe/Moscow')::date
               order by dt desc nulls last) as rn
    from snb_b2b.voytekh_amo_companies
    where dt >= extract(epoch from date_trunc('day', current_timestamp at time zone 'Europe/Moscow' - interval '7 days') at time zone 'Europe/Moscow')
) q
where rn = 1;
analyse amo_companies_raw;

drop table if exists amo_users_raw;
create temporary table amo_users_raw as
select msk_snapshot_dt, data
from (
    select data,
           (to_timestamp(dt) at time zone 'Europe/Moscow')::date as msk_snapshot_dt,
           row_number() over (partition by id,
               (to_timestamp(dt) at time zone 'Europe/Moscow')::date
               order by dt desc nulls last) as rn
    from snb_b2b.voytekh_amo_users
    where dt >= extract(epoch from date_trunc('day', current_timestamp at time zone 'Europe/Moscow' - interval '7 days') at time zone 'Europe/Moscow')
) q
where rn = 1;
analyse amo_users_raw;

--====================================================================================================================--
drop table if exists amo_leads_main;
create temporary table amo_leads_main as
with leads as (
    select msk_snapshot_dt,
           data ->> 1                                                                 as crm_source,
           (data -> 0 ->> 'id')::bigint                                               as lead_id,
           data -> 0 ->> 'name'                                                       as name,
           (data -> 0 ->> 'price')::bigint                                            as price,
           data -> 0 ->> 'score'                                                      as score,
           (data -> 0 ->> 'group_id')::bigint                                         as group_id,
           tag_name_str                                                               as tags,
           (data -> 0 -> '_embedded' -> 'companies' -> 0 ->> 'id')::bigint            as company_id,
           data -> 0 ->> 'closed_at'                                                  as closed_at,
           (data -> 0 ->> 'status_id')::bigint                                        as status_id,
           (data -> 0 ->> 'account_id')::bigint                                       as account_id,
           to_timestamp((data -> 0 ->> 'created_at')::bigint) at time zone 'UTC'      as utc_created_dttm,
           (data -> 0 ->> 'created_by')::bigint                                       as created_by,
           (data -> 0 ->> 'is_deleted')::bool                                         as is_deleted_flg,
           to_timestamp((data -> 0 ->> 'updated_at')::bigint) at time zone 'UTC'      as utc_updated_dttm,
           (data -> 0 ->> 'updated_by')::bigint                                       as updated_by,
           (data -> 0 ->> 'pipeline_id')::bigint                                      as pipeline_id,
           (data -> 0 ->> 'loss_reason_id')::bigint                                   as loss_reason_id,
           to_timestamp((data -> 0 ->> 'closest_task_at')::bigint) at time zone 'UTC' as utc_closest_task_dttm,
           (data -> 0 ->> 'responsible_user_id')::bigint                              as responsible_user_id,
           contact_id
    from amo_leads_raw,
         lateral (
             select '[' || string_agg(format('"%s"', tag_name), ',' order by tag_name) || ']' as tag_name_str
             from (
                 select jsonb_array_elements(data -> 0 -> '_embedded' -> 'tags')->>'name' as tag_name
             ) tg0
         ) tg,
         lateral (
             select min((contacts ->> 'id')::bigint) as contact_id
             from (
                 select jsonb_array_elements(data -> 0 -> '_embedded' -> 'contacts') as contacts
             ) cntr0
             where (contacts->>'is_main')::bool
         ) cntr
    where not (data -> 0 ->> 'is_deleted')::bool
)
, ppln_raw as (
    select msk_snapshot_dt,
           data->>1 as crm_source,
           (data->0->>'id')::bigint as pipeline_id,
           data->0->>'name' as pipeline_name,
           data -> 0 -> '_embedded' -> 'statuses' as pipeline_statuses
    from amo_leads_pipelines
)
, ppln_names as (
    select msk_snapshot_dt,
           crm_source,
           pipeline_id,
           max(pipeline_name) as pipeline_name
    from ppln_raw
    group by 1,2,3
)
, ppln_status as (
    select msk_snapshot_dt,
           crm_source,
           pipeline_id,
           (elm->>'id')::bigint as pipeline_status_id,
           max(elm->>'name') as pipeline_status_name,
           case when (elm->>'id')::bigint = 143 then 'lost' else 'open' end as lead_status  --Закрыто и не реализовано
    from (
        select msk_snapshot_dt,
               crm_source,
               pipeline_id,
               jsonb_array_elements(pipeline_statuses) as elm
        from ppln_raw
    ) q
    group by 1,2,3,4
)
, loss_reason as (
    select msk_snapshot_dt,
           data->>1 as crm_source,
           (data -> 0 ->> 'id')::bigint as loss_reason_id,
           max(data -> 0 ->> 'name') as loss_reason_name
    from amo_leads_loss_reasons
    group by 1,2,3
)
select
       leads.msk_snapshot_dt,
       leads.crm_source,
       lead_id, name, price, score,
       group_id, tags, company_id, closed_at, account_id, utc_created_dttm, created_by, is_deleted_flg, utc_updated_dttm, updated_by,
       leads.pipeline_id,
       ppln_names.pipeline_name,
       status_id,
       pipeline_status_name,
       lead_status,
       leads.loss_reason_id,
       loss_reason.loss_reason_name,
       utc_closest_task_dttm,
       responsible_user_id,
       contact_id
from leads
  left join ppln_names
    on ppln_names.crm_source = leads.crm_source
    and ppln_names.pipeline_id = leads.pipeline_id
    and ppln_names.msk_snapshot_dt = leads.msk_snapshot_dt
  left join ppln_status
    on ppln_status.crm_source = leads.crm_source
    and ppln_status.pipeline_status_id = leads.status_id
    and ppln_status.pipeline_id = leads.pipeline_id
    and ppln_status.msk_snapshot_dt = leads.msk_snapshot_dt
  left join loss_reason
    on loss_reason.crm_source = leads.crm_source
    and loss_reason.loss_reason_id = leads.loss_reason_id
    and loss_reason.msk_snapshot_dt = leads.msk_snapshot_dt
DISTRIBUTED BY (msk_snapshot_dt, crm_source, lead_id);
analyse amo_leads_main;

------------------------------------------------------------------------------------------------------------------------
drop table if exists amo_leads_custom_fields;
create temporary table amo_leads_custom_fields as
with custom_raw as (
    select msk_snapshot_dt,
           crm_source, lead_id,
           (jsonb_array_elements(custom_fields_values)->>'field_id')::bigint as field_id,
           jsonb_array_elements(custom_fields_values)->'values' as custom_fields_values_unit
    from (
             select msk_snapshot_dt,
                    data ->> 1                          as crm_source,
                    (data -> 0 ->> 'id')::bigint        as lead_id,
                    data -> 0 -> 'custom_fields_values' as custom_fields_values
        from amo_leads_raw
        where true
          and (data->0->'custom_fields_values') <> ('null'::jsonb)
    )q
)
, t as (
    select raw.msk_snapshot_dt,
           raw.crm_source,
           raw.lead_id,
           raw.field_id,
           raw.custom_fields_values_unit,
           fld.field_name,
           fld.data_type,
           fld.multivalue_flg
    from custom_raw raw
      join snb_b2b.amo_lead_custom_field fld
        on fld.crm_source = raw.crm_source
        and fld.field_id = raw.field_id
)
, byfield as (
    select msk_snapshot_dt,
           crm_source, lead_id, field_id,
           field_name,
           data_type, multivalue_flg,
           case when multivalue_flg then custom_fields_values_str else custom_fields_values_unit->0->>'value' end as field_value_str
    from t,
         lateral (
             select '[' || string_agg(format('"%s"', custom_fields_values_unit_value), ',' order by custom_fields_values_unit_value) || ']' as custom_fields_values_str
             from (
                 select jsonb_array_elements(custom_fields_values_unit)->>'value' as custom_fields_values_unit_value
                 where multivalue_flg
             ) q
         ) qq
)
select msk_snapshot_dt, crm_source, lead_id,
        max(case when field_name = 'Продукт' then field_value_str end)::varchar as product,
        max(case when field_name = 'Тип договора' then field_value_str end)::varchar as contract_type,
        max(case when field_name = 'Тип оплаты' then field_value_str end)::varchar as payment_type,
        max(case when field_name = 'Статус интеграции Экспресс' then field_value_str end)::varchar as integration_status,
        max(case when field_name = 'Тикет ManCalcs (MancDelivery)' then field_value_str end)::varchar as mancalc_ticket,
        max(case when field_name = 'Ссылка на основную сделку (для доп. договоров)' then field_value_str end)::varchar as main_deal_link,
        max(case when field_name = 'Канал привлечения' then field_value_str end)::varchar as channel,
        max(case when field_name = 'Фактический модуль интеграции' then field_value_str end)::varchar as integration_module,
        max(case when field_name = 'Потенциал объемов NDD' then field_value_str end)::bigint as ndd_potential,
        max(case when field_name = 'corp_client_id' then field_value_str end)::varchar as corp_client_id,
        max(case when field_name = 'Я.Доставка - ID магазина' then field_value_str end)::varchar as yado_store_id,
        max(case when field_name = 'Я.Доставка - ID клиента' then field_value_str end)::varchar as yado_client_id,
        max(case when field_name = '№ договора' then field_value_str end)::varchar as contract_id,
        max(case when field_name = 'Статус интеграции NDD' then field_value_str end)::varchar as ndd_integration_status,
        max(case when field_name = 'Информационные системы клиента (CMS, CRM, ERP)' then field_value_str end)::varchar as information_system,
        max(case when field_name = 'Этап воронки NDD' then field_value_str end)::varchar as ndd_pipeline_stage,
        max(case when field_name = 'pd_id' then field_value_str end)::bigint as pd_deal_id,
        max(case when field_name = 'Wishlist' then field_value_str end)::varchar as wishlist,
        max(case when field_name = 'Скорер' then field_value_str end)::varchar as scorer,
        max(case when field_name = 'external_event_id' then field_value_str end)::varchar as external_event_id,
        max(case when field_name = 'Bad Debt, причина' then field_value_str end)::varchar as bd_reason,
        max(case when field_name = 'Риск возврата просроченной задолженности' then field_value_str end)::varchar as risk_repay_ovr_debt,
        max(case when field_name = 'Долг' then field_value_str end)::numeric as debt,
        max(case when field_name = 'Риск снижения 2022' then field_value_str end)::varchar as risk_downside_2022,
        max(case when field_name = 'Риск дебиторки 2022' then field_value_str end)::varchar as risk_debt_2022,
        max(case when field_name = 'Работа с долгом' then field_value_str end)::varchar as debt_working,
        max(case when field_name = 'Потенциал объемов SDD' then field_value_str end)::bigint as sdd_potential,
        max(case when field_name = 'Этап воронки SDD' then field_value_str end)::varchar as sdd_pipeline_stage,
        max(case when field_name = 'Статус интеграции SDD' then field_value_str end)::varchar as sdd_integration_status,
        max(case when field_name = 'Подключенные опции NDD' then field_value_str end)::varchar as ndd_connected_options,
        max(case when field_name = 'Причина проигрыша NDD' then field_value_str end)::varchar as ndd_reason_loss,
        max(case when field_name = 'Динамика NDD' then field_value_str end)::varchar as ndd_dynamics,
        max(case when field_name = 'Причина оттока NDD' then field_value_str end)::varchar as ndd_reason_churn,
        max(case when field_name = 'Wishlist NDD' then field_value_str end)::varchar as ndd_wishlist,
        max(case when field_name = 'Тикет LOGISTARIFF NDD' then field_value_str end)::varchar as ndd_ticket_logistariff,
        max(case when field_name = 'Подключенные опции SDD' then field_value_str end)::varchar as sdd_connected_options,
        max(case when field_name = 'Причина проигрыша SDD' then field_value_str end)::varchar as sdd_reason_loss,
        max(case when field_name = 'Динамика SDD' then field_value_str end)::varchar as sdd_dynamics,
        max(case when field_name = 'Причина оттока SDD' then field_value_str end)::varchar as sdd_reason_churn,
        max(case when field_name = 'Wishlist SDD' then field_value_str end)::varchar as sdd_wishlist,
        max(case when field_name = 'Тикет LOGISTARIFF SDD' then field_value_str end)::varchar as sdd_ticket_logistariff,

        max(case when field_name = 'Потенциал Экспресс' then field_value_str end)::bigint  as express_potential,
        max(case when field_name = 'Этап воронки Экспресс' then field_value_str end)::varchar as express_pipeline_stage,
        max(case when field_name = 'Статус интеграции Экспресс' then field_value_str end)::varchar as express_integration_status,
        max(case when field_name = 'Подключенные опции Экспресс' then field_value_str end)::varchar as express_connected_options,
        max(case when field_name = 'Причина проигрыша Экспресс' then field_value_str end)::varchar as express_reason_loss,
        max(case when field_name = 'Динамика Экспресс' then field_value_str end)::varchar as express_dynamics,
        max(case when field_name = 'Причина оттока Экспресс' then field_value_str end)::varchar as express_reason_churn,
        max(case when field_name = 'Wishlist Экспресс' then field_value_str end)::varchar as express_wishlist,
        max(case when field_name = 'Тикет LOGISTARIFF Экспресс' then field_value_str end)::varchar as express_ticket_logistariff,

        max(case when field_name = 'Потенциал Грузовой' then field_value_str end)::bigint as cargo_potential,
        max(case when field_name = 'Этап воронки Грузовой' then field_value_str end)::varchar as cargo_pipeline_stage,
        max(case when field_name = 'Статус интеграции Грузовой' then field_value_str end)::varchar as cargo_integration_status,
        max(case when field_name = 'Подключенные опции Грузовой' then field_value_str end)::varchar as cargo_connected_options,
        max(case when field_name = 'Причина проигрыша Грузовой' then field_value_str end)::varchar as cargo_reason_loss,
        max(case when field_name = 'Динамика Грузовой' then field_value_str end)::varchar as cargo_dynamics,
        max(case when field_name = 'Причина оттока Грузовой' then field_value_str end)::varchar as cargo_reason_churn,
        max(case when field_name = 'Wishlist Грузовой' then field_value_str end)::varchar as cargo_wishlist,
        max(case when field_name = 'Тикет LOGISTARIFF Грузовой' then field_value_str end)::varchar as cargo_ticket_logistariff
from byfield
group by msk_snapshot_dt, crm_source, lead_id
DISTRIBUTED BY (msk_snapshot_dt, crm_source, lead_id);
analyse amo_leads_custom_fields;

------------------------------------------------------------------------------------------------------------------------

drop table if exists amo_companies_main;
create temporary table amo_companies_main as
select msk_snapshot_dt,
       data ->> 1                   as crm_source,
       (data -> 0 ->> 'id')::bigint as company_id,
       data -> 0 ->> 'name'         as name,
       to_timestamp((data -> 0 ->> 'created_at')::bigint) at time zone 'UTC' as utc_created_dttm,
       (data -> 0 ->> 'is_deleted')::bool as is_deleted_flg
from amo_companies_raw
where not (data -> 0 ->> 'is_deleted')::bool;

--------------------------------------------------------
drop table if exists amo_companies_custom_fields;
create temporary table amo_companies_custom_fields as
with custom_raw as (
    select msk_snapshot_dt,
           crm_source, company_id,
           (jsonb_array_elements(custom_fields_values)->>'field_id')::bigint as field_id,
           jsonb_array_elements(custom_fields_values)->'values' as custom_fields_values_unit
    from (
             select msk_snapshot_dt,
                    data ->> 1                          as crm_source,
                    (data -> 0 ->> 'id')::bigint        as company_id,
                    data -> 0 -> 'custom_fields_values' as custom_fields_values
        from amo_companies_raw
        where true
          and (data->0->'custom_fields_values') <> ('null'::jsonb)
    )q
)
, t as (
    select raw.msk_snapshot_dt,
           raw.crm_source,
           raw.company_id,
           raw.field_id,
           raw.custom_fields_values_unit,
           fld.field_name,
           fld.data_type,
           fld.multivalue_flg
    from custom_raw raw
      join snb_b2b.amo_company_custom_field fld
        on fld.crm_source = raw.crm_source
        and fld.field_id = raw.field_id
)
, byfield as (
    select msk_snapshot_dt,
           crm_source, company_id, field_id,
           field_name,
           data_type, multivalue_flg,
           case when multivalue_flg then custom_fields_values_str
                when data_type = 'Text' or custom_fields_values_unit->0->>'value' ~ '^[\d]+$' then custom_fields_values_unit->0->>'value'
            end as field_value_str,
           custom_fields_values_unit->0->>'enum_id' as enum_id
    from t,
         lateral (
             select '[' || string_agg(format('"%s"', custom_fields_values_unit_value), ',' order by custom_fields_values_unit_value) || ']' as custom_fields_values_str
             from (
                 select jsonb_array_elements(custom_fields_values_unit)->>'value' as custom_fields_values_unit_value
                 where multivalue_flg
             ) q
         ) qq
)
select msk_snapshot_dt,
       crm_source, company_id,
        max(case when field_name = 'Web' then field_value_str end)::varchar as website,
        max(case when field_name = 'Tier' then field_value_str end)::varchar as tier,
        max(case when field_name = 'Страна' then field_value_str end)::varchar as country,
        max(case when field_name = 'ID магистрали' then field_value_str end)::varchar as magistral_id,
        max(case when field_name = 'ИНН/БИН' then field_value_str end)::varchar as inn,
        max(case when field_name = 'КПП' then field_value_str end)::varchar as kpp,
        max(case when field_name = 'Сегмент рынка' then field_value_str end)::varchar as market_segment,
        max(case when field_name = 'Кредитный рейтинг' then field_value_str end)::varchar as credit_rating,
        max(case when field_name = 'Тип группы компаний' then field_value_str end)::varchar as company_group_type,
        max(case when field_name = 'Статус взаимодействия по маркетингу' then field_value_str end)::varchar as marketing_status,
        max(case when field_name = 'Город' then field_value_str end)::varchar as city,
        max(case when field_name = 'Группа компаний' then enum_id end)::bigint as holding_id,
        max(case when field_name = 'Группа компаний' then field_value_str end)::varchar as holding_name,
        max(case when field_name = 'География' then field_value_str end)::varchar as geography,
        max(case when field_name = 'pd_id' then field_value_str end)::bigint as pd_org_id
from byfield
group by msk_snapshot_dt, crm_source, company_id
DISTRIBUTED BY (msk_snapshot_dt, crm_source, company_id);
analyse amo_companies_custom_fields;

drop table if exists amo_users;
create temporary table amo_users as
select msk_snapshot_dt,
       (data->0->>'id')::bigint as user_id,
       data->0->>'lang' as user_lang,
       data->0->>'name' as user_name,
       data->0->>'email' as user_email,
       case when split_part(data->0->>'email', '@', 2) in ('yandex-team.ru','yandex-team.com')
            then split_part(data->0->>'email', '@', 1) end as manager_login,
       (data -> 0 -> '_embedded' -> 'groups' -> 0 ->> 'id')::bigint as user_group_id,
       data -> 0 -> '_embedded' -> 'groups' -> 0 ->> 'name' as user_group_name,
       (data -> 0 -> '_embedded' -> 'roles' -> 0 ->> 'id')::bigint as user_role_id,
       data -> 0 -> '_embedded' -> 'roles' -> 0 ->> 'name' as user_role_name
from amo_users_raw
distributed by (msk_snapshot_dt, user_id);
analyse amo_users;

drop table if exists amo_res;
create temporary table amo_res as
select lm.msk_snapshot_dt,
       lm.crm_source, lm.lead_id,
       lm.name as lead_name,
       price, score, group_id, tags,
       lm.company_id, closed_at, account_id,
       lm.utc_created_dttm as utc_lead_created_dttm,
       created_by,
       lm.is_deleted_flg as lead_deleted_flg,
       lm.utc_updated_dttm as utc_lead_updated_dttm,
       updated_by,
       pipeline_id, pipeline_name, status_id, pipeline_status_name, lead_status, loss_reason_id, loss_reason_name,
       utc_closest_task_dttm, responsible_user_id, contact_id,
       pipeline_id = 5208781 as phoenix_flg,
       pipeline_id = 5208763 as contract_terminated_flg,
       pipeline_id = 5208754 as add_contract_flg,
   --amo_leads_custom_fields
       lcf.product, contract_type, payment_type, integration_status, mancalc_ticket, main_deal_link, channel,
       integration_module, ndd_potential, corp_client_id, yado_store_id, yado_client_id, contract_id,
       ndd_integration_status, information_system, ndd_pipeline_stage, pd_deal_id, wishlist, scorer, external_event_id,
       bd_reason, risk_repay_ovr_debt, debt, risk_downside_2022, risk_debt_2022, debt_working,
   -- amo_companies_main
       cm.name as company_name,
       cm.utc_created_dttm as utc_company_created_dttm,
       cm.is_deleted_flg as company_deleted_flg,
   -- amo_companies_custom_fields
       ccf.website, tier, country, magistral_id, inn, kpp, market_segment, credit_rating,
       company_group_type, marketing_status, city, holding_id, holding_name, geography, pd_org_id,
   -- amo_users
       user_lang, user_name, user_email,
       user_group_id, user_group_name, user_role_id, user_role_name,
       usr.manager_login,
       sdd_potential,
       sdd_pipeline_stage,
       sdd_integration_status,
        ndd_connected_options,
            ndd_reason_loss,
            ndd_dynamics,
            ndd_reason_churn,
            ndd_wishlist,
            ndd_ticket_logistariff,
            sdd_connected_options,
            sdd_reason_loss,
            sdd_dynamics,
            sdd_reason_churn,
            sdd_wishlist,
            sdd_ticket_logistariff,
            express_potential,
            express_pipeline_stage,
            express_integration_status,
            express_connected_options,
            express_reason_loss,
            express_dynamics,
            express_reason_churn,
            express_wishlist,
            express_ticket_logistariff,

            cargo_potential,
            cargo_pipeline_stage,
            cargo_integration_status,
            cargo_connected_options,
            cargo_reason_loss,
            cargo_dynamics,
            cargo_reason_churn,
            cargo_wishlist,
            cargo_ticket_logistariff
from amo_leads_main lm
  left join amo_leads_custom_fields lcf
    on lcf.crm_source = lm.crm_source
    and lcf.lead_id = lm.lead_id
    and lcf.msk_snapshot_dt = lm.msk_snapshot_dt
  left join amo_companies_main cm
    on cm.crm_source = lm.crm_source
    and cm.company_id = lm.company_id
    and cm.msk_snapshot_dt = lm.msk_snapshot_dt
  left join amo_companies_custom_fields ccf
    on ccf.crm_source = lm.crm_source
    and ccf.company_id = lm.company_id
    and ccf.msk_snapshot_dt = lm.msk_snapshot_dt
  left join amo_users usr
    on usr.user_id = lm.responsible_user_id
    and usr.msk_snapshot_dt = lm.msk_snapshot_dt;

--====================================================================================================================--
-- drop table if exists snb_b2b.amo_leads_info_hist;
-- create table snb_b2b.amo_leads_info_hist as
-- truncate table snb_b2b.amo_leads_info_hist;
delete from snb_b2b.amo_leads_info_hist
where msk_snapshot_dt >= date_trunc('day', current_timestamp at time zone 'Europe/Moscow' - interval '7 days')::date;
--
insert into snb_b2b.amo_leads_info_hist
    (msk_snapshot_dt,
     crm_source, lead_id,
     lead_name, price, score, group_id, tags, company_id, closed_at, account_id, utc_lead_created_dttm, created_by,
     lead_deleted_flg, utc_lead_updated_dttm, updated_by, pipeline_id, pipeline_name, status_id, pipeline_status_name,
     lead_status, loss_reason_id, loss_reason_name, utc_closest_task_dttm, responsible_user_id, contact_id,
     phoenix_flg, contract_terminated_flg, add_contract_flg,
     product, contract_type, payment_type, integration_status, mancalc_ticket, main_deal_link, channel,
     integration_module, ndd_potential, corp_client_id, yado_store_id, yado_client_id, contract_id,
     ndd_integration_status, information_system, ndd_pipeline_stage, pd_deal_id, wishlist, scorer, external_event_id,
     bd_reason, risk_repay_ovr_debt, debt, risk_downside_2022, risk_debt_2022, debt_working,
     company_name, utc_company_created_dttm, company_deleted_flg, website, tier, country, magistral_id,
     inn, kpp, market_segment, credit_rating, company_group_type, marketing_status, city, holding_id, holding_name,
     geography, pd_org_id,
     user_lang, user_name, user_email,
     user_group_id, user_group_name, user_role_id, user_role_name,
     manager_login,
     sdd_potential,sdd_pipeline_stage,sdd_integration_status,
     ndd_connected_options, ndd_reason_loss,ndd_dynamics,ndd_reason_churn,ndd_wishlist,ndd_ticket_logistariff,
     sdd_connected_options,sdd_reason_loss,sdd_dynamics,sdd_reason_churn,sdd_wishlist,sdd_ticket_logistariff,
     express_potential,  express_pipeline_stage,  express_integration_status, express_connected_options,
     express_reason_loss, express_dynamics,express_reason_churn,express_wishlist, express_ticket_logistariff,
     cargo_potential,cargo_pipeline_stage,cargo_integration_status,cargo_connected_options,
     cargo_reason_loss,cargo_dynamics,cargo_reason_churn,cargo_wishlist,cargo_ticket_logistariff)
select msk_snapshot_dt,
       crm_source, lead_id,
     lead_name, price, score, group_id, tags, company_id, closed_at, account_id, utc_lead_created_dttm, created_by,
     lead_deleted_flg, utc_lead_updated_dttm, updated_by, pipeline_id, pipeline_name, status_id, pipeline_status_name,
     lead_status, loss_reason_id, loss_reason_name, utc_closest_task_dttm, responsible_user_id, contact_id,
     phoenix_flg, contract_terminated_flg, add_contract_flg,
     product, contract_type, payment_type, integration_status, mancalc_ticket, main_deal_link, channel,
     integration_module, ndd_potential, corp_client_id, yado_store_id, yado_client_id, contract_id,
     ndd_integration_status, information_system, ndd_pipeline_stage, pd_deal_id, wishlist, scorer, external_event_id,
     bd_reason, risk_repay_ovr_debt, debt, risk_downside_2022, risk_debt_2022, debt_working,
     company_name, utc_company_created_dttm, company_deleted_flg, website, tier, country, magistral_id,
     inn, kpp, market_segment, credit_rating, company_group_type, marketing_status, city, holding_id, holding_name,
     geography, pd_org_id,
     user_lang, user_name, user_email,
     user_group_id, user_group_name, user_role_id, user_role_name,
     manager_login,
     sdd_potential,sdd_pipeline_stage,sdd_integration_status,
     ndd_connected_options, ndd_reason_loss,ndd_dynamics,ndd_reason_churn,ndd_wishlist,ndd_ticket_logistariff,
     sdd_connected_options,sdd_reason_loss,sdd_dynamics,sdd_reason_churn,sdd_wishlist,sdd_ticket_logistariff,
     express_potential,  express_pipeline_stage,  express_integration_status, express_connected_options,
     express_reason_loss, express_dynamics,express_reason_churn,express_wishlist, express_ticket_logistariff,
     cargo_potential,cargo_pipeline_stage,cargo_integration_status,cargo_connected_options,
     cargo_reason_loss,cargo_dynamics,cargo_reason_churn,cargo_wishlist,cargo_ticket_logistariff
from amo_res;

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('amo_leads_info_hist', 'Finish', clock_timestamp());
