create table snb_b2b.amo_lead_custom_field
(
    crm_source     text,
    field_id       bigint,
    field_name     text,
    data_type      text,
    multivalue_flg boolean,
    constraint amo_lead_custom_field_pk primary key (crm_source, field_id)
);
insert into snb_b2b.amo_lead_custom_field (crm_source, field_id, field_name, data_type, multivalue_flg)
select data->>1 as crm_source,
       (data->0->>'id')::bigint as field_id,
       data->0->>'name' as field_name,
--        data->0->>'type' as field_type,
       case when (data->0->>'type') in ('numeric') then 'Numeric' else 'Text' end as data_type,
       (data->0->>'type') in ('multiselect') as multivalue_flg
from snb_b2b.voytekh_amo_leads_custom_fields
where dt = (select max(dt) from snb_b2b.voytekh_amo_leads_custom_fields)
  and (data->0->>'name') in (
--      'Потенциал объемов NDD',
--      'pd_id',
--      'Ссылка на основную сделку (для доп. договоров)',
--      'Тикет ManCalcs (MancDelivery)',
--      'Этап воронки NDD',
--      'Канал привлечения',
--      'Тип договора',
--      'Тип оплаты',
--      'Статус интеграции NDD',
--      'Статус интеграции Экспресс',
--      'Фактический модуль интеграции',
--      'Продукт',
--      'Wishlist',
--      'Информационные системы клиента (CMS, CRM, ERP)',
--      '№ договора',
--      'corp_client_id',
--      'Скорер',
--      'Я.Доставка - ID клиента',
--      'Я.Доставка - ID магазина'
        'external_event_id'
    )
order by field_id;
-----------------------------------------------------------------

create table snb_b2b.amo_contact_custom_field
(
    crm_source     text,
    field_id       bigint,
    field_name     text,
    data_type      text,
    multivalue_flg boolean,
    constraint amo_contact_custom_field_pk primary key (crm_source, field_id)
);
insert into snb_b2b.amo_contact_custom_field (crm_source, field_id, field_name, data_type, multivalue_flg)
select data->>1 as crm_source,
       (data->0->>'id')::bigint as field_id,
       data->0->>'name' as field_name,
--        data->0->>'type' as field_type,
       case when (data->0->>'type') in ('numeric') then 'Numeric' else 'Text' end as data_type,
       (data->0->>'type') in ('multiselect') as multivalue_flg
from
    snb_b2b.voytekh_amo_contacts_custom_fields
    --snb_b2b.voytekh_amo_leads_custom_fields
where dt = (select max(dt) from snb_b2b.voytekh_amo_leads_custom_fields)
--            and (data->0->>'name') in (
--      'Должность',
--      'pd_id',
--      'Телефон',
--      'Email'
--            )
order by field_id;


create table snb_b2b.amo_company_custom_field
(
    crm_source     text,
    field_id       bigint,
    field_name     text,
    data_type      text,
    multivalue_flg boolean,
    constraint amo_company_custom_field_pk primary key (crm_source, field_id)
);
insert into snb_b2b.amo_company_custom_field
    (crm_source, field_id, field_name, data_type, multivalue_flg)
select data->>1 as crm_source,
       (data->0->>'id')::bigint as field_id,
       data->0->>'name' as field_name,
--        data->0->>'type' as field_type,
       case when (data->0->>'type') in ('numeric') then 'Numeric' else 'Text' end as data_type,
       (data->0->>'type') in ('multiselect','multitext') as multivalue_flg
from snb_b2b.voytekh_amo_companies_custom_fields
where dt = (select max(dt) from snb_b2b.voytekh_amo_companies_custom_fields)
  and (data->0->>'name') in (
    'Web',
    'Tier',
    'Страна',
    'ID магистрали',
    'ИНН/БИН',
    'КПП',
    'Сегмент рынка',
    'Кредитный рейтинг',
    'Тип группы компаний',
    'Статус взаимодействия по маркетингу',
    'Город',
    'Группа компаний',
    'География',
    'pd_id'
    )
order by field_id;

drop table if exists snb_b2b.amo_leads_info;
create table snb_b2b.amo_leads_info
(
    crm_source               text,
    lead_id                  bigint,
    lead_name                text,
    price                    bigint,
    score                    text,
    group_id                 bigint,
    tags                     text,
    company_id               bigint,
    closed_at                text,
    account_id               bigint,
    utc_lead_created_dttm    timestamp,
    created_by               bigint,
    lead_deleted_flg         boolean,
    utc_lead_updated_dttm    timestamp,
    updated_by               bigint,
    pipeline_id              bigint,
    pipeline_name            text,
    status_id                bigint,
    pipeline_status_name     text,
    lead_status              text,
    loss_reason_id           bigint,
    loss_reason_name         text,
    utc_closest_task_dttm    timestamp,
    responsible_user_id      bigint,
    contact_id               bigint,
    _etl_processed_dttm      timestamp,
    product                  varchar,
    contract_type            varchar,
    payment_type             varchar,
    integration_status       varchar,
    mancalc_ticket           varchar,
    main_deal_link           varchar,
    channel                  varchar,
    integration_module       varchar,
    ndd_potential            bigint,
    corp_client_id           varchar,
    yado_store_id            varchar,
    yado_client_id           varchar,
    contract_id              varchar,
    ndd_integration_status   varchar,
    information_system       varchar,
    ndd_pipeline_stage       varchar,
    pd_deal_id               bigint,
    wishlist                 varchar,
    scorer                   varchar,
    company_name             text,
    utc_company_created_dttm timestamp,
    company_deleted_flg      boolean,
    website                  varchar,
    tier                     varchar,
    country                  varchar,
    magistral_id             varchar,
    inn                      varchar,
    kpp                      varchar,
    market_segment           varchar,
    credit_rating            varchar,
    company_group_type       varchar,
    marketing_status         varchar,
    city                     varchar,
    holding_id               bigint,
    holding_name             varchar,
    geography                varchar,
    pd_org_id                bigint,
    user_lang                text,
    user_name                text,
    user_email               text,
    manager_login            text,
    manager_name             text,
    manager_name_first       varchar(128),
    manager_name_last        varchar(128),
    teamlead_name            text,
    teamlead_name_first      varchar(128),
    teamlead_name_last       varchar(128),
    department_name          varchar(128),
    manager_group            text,
    permissions              text,
    constraint amo_leads_info_pk primary key (crm_source, lead_id)
);
comment on table snb_b2b.amo_leads_info is 'Витрина по сделкам (лидам) AmoCRM. Ключ crm_source-lead_id';


drop table if exists snb_b2b.amo_contracts_info;
create table snb_b2b.amo_contracts_info
(
    crm_source               text,
    lead_id                  bigint,
    lead_name                text,
    price                    bigint,
    score                    text,
    group_id                 bigint,
    tags                     text,
    company_id               bigint,
    closed_at                text,
    account_id               bigint,
    utc_lead_created_dttm    timestamp,
    created_by               bigint,
    lead_deleted_flg         boolean,
    utc_lead_updated_dttm    timestamp,
    updated_by               bigint,
    pipeline_id              bigint,
    pipeline_name            text,
    status_id                bigint,
    pipeline_status_name     text,
    lead_status              text,
    loss_reason_id           bigint,
    loss_reason_name         text,
    utc_closest_task_dttm    timestamp,
    responsible_user_id      bigint,
    contact_id               bigint,
    _etl_processed_dttm      timestamp,
    product                  varchar,
    contract_type            varchar,
    payment_type             varchar,
    integration_status       varchar,
    mancalc_ticket           varchar,
    main_deal_link           varchar,
    channel                  varchar,
    integration_module       varchar,
    ndd_potential            bigint,
    corp_client_id           varchar,
    yado_store_id            varchar,
    yado_client_id           varchar,
    contract_id              varchar,
    ndd_integration_status   varchar,
    information_system       varchar,
    ndd_pipeline_stage       varchar,
    pd_deal_id               bigint,
    wishlist                 varchar,
    scorer                   varchar,
    company_name             text,
    utc_company_created_dttm timestamp,
    company_deleted_flg      boolean,
    website                  varchar,
    tier                     varchar,
    country                  varchar,
    magistral_id             varchar,
    inn                      varchar,
    kpp                      varchar,
    market_segment           varchar,
    credit_rating            varchar,
    company_group_type       varchar,
    marketing_status         varchar,
    city                     varchar,
    holding_id               bigint,
    holding_name             varchar,
    geography                varchar,
    pd_org_id                bigint,
    user_lang                text,
    user_name                text,
    user_email               text,
    manager_login            text,
    manager_name             text,
    manager_name_first       varchar(128),
    manager_name_last        varchar(128),
    teamlead_name            text,
    teamlead_name_first      varchar(128),
    teamlead_name_last       varchar(128),
    department_name          varchar(128),
    manager_group            text,
    permissions              text,
    constraint amo_contracts_info_pk primary key (contract_id)
);
comment on table snb_b2b.amo_contracts_info is 'Витрина по контрактам AmoCRM. Ключ contract_id';

drop table if exists snb_b2b.amo_clients_info;
create table snb_b2b.amo_clients_info
(
    crm_source               text,
    lead_id                  bigint,
    lead_name                text,
    price                    bigint,
    score                    text,
    group_id                 bigint,
    tags                     text,
    company_id               bigint,
    closed_at                text,
    account_id               bigint,
    utc_lead_created_dttm    timestamp,
    created_by               bigint,
    lead_deleted_flg         boolean,
    utc_lead_updated_dttm    timestamp,
    updated_by               bigint,
    pipeline_id              bigint,
    pipeline_name            text,
    status_id                bigint,
    pipeline_status_name     text,
    lead_status              text,
    loss_reason_id           bigint,
    loss_reason_name         text,
    utc_closest_task_dttm    timestamp,
    responsible_user_id      bigint,
    contact_id               bigint,
    _etl_processed_dttm      timestamp,
    product                  varchar,
    contract_type            varchar,
    payment_type             varchar,
    integration_status       varchar,
    mancalc_ticket           varchar,
    main_deal_link           varchar,
    channel                  varchar,
    integration_module       varchar,
    ndd_potential            bigint,
    corp_client_id           varchar,
    yado_store_id            varchar,
    yado_client_id           varchar,
    contract_id              varchar,
    ndd_integration_status   varchar,
    information_system       varchar,
    ndd_pipeline_stage       varchar,
    pd_deal_id               bigint,
    wishlist                 varchar,
    scorer                   varchar,
    company_name             text,
    utc_company_created_dttm timestamp,
    company_deleted_flg      boolean,
    website                  varchar,
    tier                     varchar,
    country                  varchar,
    magistral_id             varchar,
    inn                      varchar,
    kpp                      varchar,
    market_segment           varchar,
    credit_rating            varchar,
    company_group_type       varchar,
    marketing_status         varchar,
    city                     varchar,
    holding_id               bigint,
    holding_name             varchar,
    geography                varchar,
    pd_org_id                bigint,
    user_lang                text,
    user_name                text,
    user_email               text,
    manager_login            text,
    manager_name             text,
    manager_name_first       varchar(128),
    manager_name_last        varchar(128),
    teamlead_name            text,
    teamlead_name_first      varchar(128),
    teamlead_name_last       varchar(128),
    department_name          varchar(128),
    manager_group            text,
    permissions              text,
    constraint amo_clients_info_pk primary key (corp_client_id)
);
comment on table snb_b2b.amo_clients_info is 'Витрина по клиентам воронки Феникс AmoCRM. Ключ corp_client_id';

alter table snb_b2b.amo_leads_info add external_event_id varchar;
alter table snb_b2b.amo_contracts_info add external_event_id varchar;
alter table snb_b2b.amo_clients_info add external_event_id varchar;
alter table snb_b2b.amo_leads_info_hist add external_event_id varchar;
--
alter table snb_b2b.amo_leads_info add phoenix_flg boolean;
alter table snb_b2b.amo_contracts_info add phoenix_flg boolean;
alter table snb_b2b.amo_clients_info add phoenix_flg boolean;
alter table snb_b2b.amo_leads_info_hist add phoenix_flg boolean;
--
alter table snb_b2b.amo_leads_info add contract_terminated_flg boolean;
alter table snb_b2b.amo_contracts_info add contract_terminated_flg boolean;
alter table snb_b2b.amo_clients_info add contract_terminated_flg boolean;
alter table snb_b2b.amo_leads_info_hist add contract_terminated_flg boolean;
--
alter table snb_b2b.amo_leads_info add add_contract_flg boolean;
alter table snb_b2b.amo_contracts_info add add_contract_flg boolean;
alter table snb_b2b.amo_clients_info add add_contract_flg boolean;
alter table snb_b2b.amo_leads_info_hist add add_contract_flg boolean;
--
alter table snb_b2b.amo_leads_info add user_group_id bigint;
alter table snb_b2b.amo_contracts_info add user_group_id bigint;
alter table snb_b2b.amo_clients_info add user_group_id bigint;
alter table snb_b2b.amo_leads_info_hist add user_group_id bigint;
--
alter table snb_b2b.amo_leads_info add user_group_name text;
alter table snb_b2b.amo_contracts_info add user_group_name text;
alter table snb_b2b.amo_clients_info add user_group_name text;
alter table snb_b2b.amo_leads_info_hist add user_group_name text;
--
alter table snb_b2b.amo_leads_info add user_role_id bigint;
alter table snb_b2b.amo_contracts_info add user_role_id bigint;
alter table snb_b2b.amo_clients_info add user_role_id bigint;
alter table snb_b2b.amo_leads_info_hist add user_role_id bigint;
--
alter table snb_b2b.amo_leads_info add user_role_name text;
alter table snb_b2b.amo_contracts_info add user_role_name text;
alter table snb_b2b.amo_clients_info add user_role_name text;
alter table snb_b2b.amo_leads_info_hist add user_role_name text;


drop view if exists snb_b2b.niksm_b2b_deals_info_amo;
create or replace view snb_b2b.niksm_b2b_deals_info_amo as
select
    6::int as which_crm,
    lead_id as deal_id,
    lead_name as deal_title,
    contact_id as person_id,
    company_id as org_id,
    company_name as org_name,
    pipeline_id,
    pipeline_name,
    status_id as stage_id,
    pipeline_status_name as stage_name,
    price as potential,
    lead_status as status,
    loss_reason_name as lost_reason,
    (utc_lead_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as add_date,
    utc_lead_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as add_time,
    contract_id,
    channel,
    integration_status,
    integration_module,
    main_deal_link,
    NULL::text as tags_key,
    tags,
    NULL::text as wishlist_key,
    wishlist,
    NULL::text as product_key,
    product,
    yado_client_id,
    yado_store_id,
    contract_type,
    payment_type,
    (utc_company_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as org_add_date,
    utc_company_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as org_add_time,
    NULL::int as company_id,
    NULL::int as owner_id,
    not company_deleted_flg as org_active_flag,
    country,
    city,
    NULL::text as geography_key,
    geography,
    market_segment,
    tier,
    holding_id,
    holding_name,
    '6_' || coalesce(holding_id::text,'')|| case when holding_id is null then '_' || company_id::text else '' end as client_id,
    coalesce(holding_name, company_name) as client_name,
    marketing_status,
    website,
    inn,
    credit_rating,
    manager_login,
    manager_name,
    manager_name_first,
    manager_name_last,
    teamlead_name as lead_name,
    teamlead_name_first as lead_name_first,
    teamlead_name_last as lead_name_last,
    department_name,
    manager_group,
    permissions,
    (_etl_processed_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as record_date,
    ndd_potential,
    ndd_pipeline_stage,
    ndd_integration_status,
    NULL::int as ndd_pipeline_stage_key,
    NULL::int as ndd_integration_status_key,
    corp_client_id,
    pd_deal_id
from snb_b2b.amo_leads_info;

drop table if exists snb_b2b.amo_leads_info_hist;
create table snb_b2b.amo_leads_info_hist
(
    msk_snapshot_dt date,
    crm_source               text   not null,
    lead_id                  bigint not null,
    lead_name                text,
    price                    bigint,
    score                    text,
    group_id                 bigint,
    tags                     text,
    company_id               bigint,
    closed_at                text,
    account_id               bigint,
    utc_lead_created_dttm    timestamp,
    created_by               bigint,
    lead_deleted_flg         boolean,
    utc_lead_updated_dttm    timestamp,
    updated_by               bigint,
    pipeline_id              bigint,
    pipeline_name            text,
    status_id                bigint,
    pipeline_status_name     text,
    lead_status              text,
    loss_reason_id           bigint,
    loss_reason_name         text,
    utc_closest_task_dttm    timestamp,
    responsible_user_id      bigint,
    contact_id               bigint,
    product                  varchar,
    contract_type            varchar,
    payment_type             varchar,
    integration_status       varchar,
    mancalc_ticket           varchar,
    main_deal_link           varchar,
    channel                  varchar,
    integration_module       varchar,
    ndd_potential            bigint,
    corp_client_id           varchar,
    yado_store_id            varchar,
    yado_client_id           varchar,
    contract_id              varchar,
    ndd_integration_status   varchar,
    information_system       varchar,
    ndd_pipeline_stage       varchar,
    pd_deal_id               bigint,
    wishlist                 varchar,
    scorer                   varchar,
    company_name             text,
    utc_company_created_dttm timestamp,
    company_deleted_flg      boolean,
    website                  varchar,
    tier                     varchar,
    country                  varchar,
    magistral_id             varchar,
    inn                      varchar,
    kpp                      varchar,
    market_segment           varchar,
    credit_rating            varchar,
    company_group_type       varchar,
    marketing_status         varchar,
    city                     varchar,
    holding_id               bigint,
    holding_name             varchar,
    geography                varchar,
    pd_org_id                bigint,
    user_lang                text,
    user_name                text,
    user_email               text,
    manager_login            text,
    external_event_id        varchar,
    phoenix_flg              boolean,
    contract_terminated_flg  boolean,
    user_group_id            bigint,
    user_group_name          text,
    user_role_id             bigint,
    user_role_name           text,
    add_contract_flg         boolean,
    bd_reason                varchar,
    risk_repay_ovr_debt      varchar,
    debt                     numeric,
    risk_downside_2022       varchar,
    risk_debt_2022           varchar,
    debt_working             varchar,
    constraint amo_leads_info_hist_pk
        primary key (msk_snapshot_dt, crm_source, lead_id)
)
PARTITION BY RANGE (msk_snapshot_dt)
    (
        START ('2022-01-01T00:00:00'::timestamp)
        END ('2025-01-01T00:00:00'::timestamp)
        EVERY ('1 month'::INTERVAL)
    );
