create table snb_delivery.logdata_delivery_tariff
(
	order_tariff text not null
		constraint logdata_delivery_tariff_pk
			primary key,
	logistic_tariff_flag boolean,
	utc_datefrom date,
	utc_dateto date
)
distributed by (order_tariff);

comment on table snb_delivery.logdata_delivery_tariff is 'Справочник тарифов доставки (tariff_class_code)';
comment on column snb_delivery.logdata_delivery_tariff.utc_datefrom is 'Начало действия тарифа доставки, (включая)';
comment on column snb_delivery.logdata_delivery_tariff.utc_dateto is 'Окончание действия тарифа доставки, (не включая)';

grant select on snb_delivery.logdata_delivery_tariff to analyst;

truncate table snb_delivery.logdata_delivery_tariff;
insert into snb_delivery.logdata_delivery_tariff
    (order_tariff, logistic_tariff_flag, utc_datefrom, utc_dateto)
values ('courier', true, '1970-01-01'::date, '2999-01-01'::date),
       ('express', true, '1970-01-01'::date, '2999-01-01'::date),
       ('cargo', true, '1970-01-01'::date, '2999-01-01'::date),
       ('cargocorp', true, '1970-01-01'::date, '2999-01-01'::date),
       ('ubernight', true, '2021-08-01'::date, '2999-01-01'::date);

-- select * from snb_delivery.logdata_delivery_tariff;
