-- dm_order
drop view if exists snb_taxi.logdata_dm_order_v;
create or replace view snb_taxi.logdata_dm_order_v as
 SELECT o.*,
    (d.taxi_order_id IS NOT NULL) AS cargo_order_flg,
    COALESCE(d.n_deliveries_total, (1)::bigint) AS n_deliveries_total,
    COALESCE(d.n_deliveries_visited, success_order_flg::int) AS n_deliveries_visited,
    d.points,
    d.point_est_distances,
    d.point_eta,
    COALESCE(trf.logistic_tariff_flag, false) AS logistic_tariff_flag
   FROM ((summary.dm_order o
     LEFT JOIN snb_taxi.logdata_deliveries_v d ON (((o.order_id)::text = (d.taxi_order_id)::text)))
     LEFT JOIN snb_taxi.logdata_logistic_tariffs trf ON ((trf.order_tariff = (o.order_tariff)::text)));
--
grant select on snb_taxi.logdata_dm_order_v to analyst, ro_snb_delivery;
comment on view snb_taxi.logdata_dm_order_v is 'dm_order + точки доставки. Автор: аналитика логистики';

-- fct_order
drop view if exists snb_taxi.logdata_fct_order;
create or replace view snb_taxi.logdata_fct_order as
 SELECT o.*,
    (d.taxi_order_id IS NOT NULL) AS cargo_order_flg,
    COALESCE(d.n_deliveries_total, (1)::bigint) AS n_deliveries_total,
    COALESCE(d.n_deliveries_visited, success_order_flg::int) AS n_deliveries_visited,
    d.points,
    d.point_est_distances,
    d.point_eta,
    COALESCE(trf.logistic_tariff_flag, false) AS logistic_tariff_flag
   FROM ((taxi_cdm_marketplace.fct_order o
     LEFT JOIN snb_taxi.logdata_deliveries_v d ON (((o.order_id)::text = (d.taxi_order_id)::text)))
     LEFT JOIN snb_taxi.logdata_logistic_tariffs trf ON ((trf.order_tariff = (o.tariff_class_code)::text)));
--
grant select on snb_taxi.logdata_fct_order to analyst, ro_snb_delivery, nemici;
comment on view snb_taxi.logdata_fct_order is 'fct_order + точки доставки. Автор: аналитика логистики';

-- fct_order_metric
drop view if exists snb_taxi.logdata_fct_order_metric;
create or replace view snb_taxi.logdata_fct_order_metric as
 SELECT o.*,
    (d.taxi_order_id IS NOT NULL) AS cargo_order_flg,
    COALESCE(d.n_deliveries_total, (1)::bigint) AS n_deliveries_total,
    COALESCE(d.n_deliveries_visited, success_order_flg::int) AS n_deliveries_visited,
    d.points,
    d.point_est_distances,
    d.point_eta,
    COALESCE(trf.logistic_tariff_flag, false) AS logistic_tariff_flag
   FROM ((taxi_cdm_marketplace.fct_order_metric o
     LEFT JOIN snb_taxi.logdata_deliveries_v d ON (((o.order_id)::text = (d.taxi_order_id)::text)))
     LEFT JOIN snb_taxi.logdata_logistic_tariffs trf ON ((trf.order_tariff = (o.tariff_class_code)::text)));
--
grant select on snb_taxi.logdata_fct_order_metric to analyst, ro_snb_delivery;
comment on view snb_taxi.logdata_fct_order_metric is 'fct_order_metric + точки доставки. Автор: аналитика логистики';