-- drop table if exists snb_b2b.niksm_b2b_contracts_info;
-- create table  snb_b2b.niksm_b2b_contracts_info as
truncate table snb_b2b.niksm_b2b_contracts_info;
insert into snb_b2b.niksm_b2b_contracts_info
            (which_crm, deal_id, deal_title, person_id, org_id, org_name, pipeline_id, pipeline_name, stage_id,
             stage_name, potential, status, lost_reason, add_date, add_time, contract_id, channel, integration_status,
             integration_module, main_deal_link, tags_key, tags, wishlist_key, wishlist, product_key, product,
             yado_client_id, yado_store_id, contract_type, payment_type, org_add_date, org_add_time, company_id,
             owner_id, org_active_flag, country, city, geography_key, geography, market_segment, tier, holding_id,
             holding_name, client_id, client_name, marketing_status, website, inn, credit_rating, manager_login,
             manager_name, manager_name_first, manager_name_last, lead_name, lead_name_first, lead_name_last,
             department_name, manager_group, permissions, record_date, ndd_potential, ndd_pipeline_stage,
             ndd_integration_status, ndd_pipeline_stage_key, ndd_integration_status_key, corp_client_id)
SELECT 6                                                                                                         AS which_crm,
       amo_contracts_info.lead_id::integer                                                                       AS deal_id,
       amo_contracts_info.lead_name                                                                              AS deal_title,
       amo_contracts_info.contact_id::integer                                                                    AS person_id,
       amo_contracts_info.company_id::integer                                                                    AS org_id,
       amo_contracts_info.company_name                                                                           AS org_name,
       amo_contracts_info.pipeline_id::integer                                                                   AS pipeline_id,
       amo_contracts_info.pipeline_name,
       amo_contracts_info.status_id::integer                                                                     AS stage_id,
       amo_contracts_info.pipeline_status_name                                                                   AS stage_name,
       amo_contracts_info.price::integer                                                                         AS potential,
       amo_contracts_info.lead_status                                                                            AS status,
       amo_contracts_info.loss_reason_name                                                                       AS lost_reason,
       timezone('Europe/Moscow'::text,
                timezone('UTC'::text, amo_contracts_info.utc_lead_created_dttm))::date                           AS add_date,
       timezone('Europe/Moscow'::text,
                timezone('UTC'::text, amo_contracts_info.utc_lead_created_dttm))                                 AS add_time,
       amo_contracts_info.contract_id::text                                                                      AS contract_id,
       amo_contracts_info.channel::text                                                                          AS channel,
       amo_contracts_info.integration_status::text                                                               AS integration_status,
       amo_contracts_info.integration_module::text                                                               AS integration_module,
       amo_contracts_info.main_deal_link::text                                                                   AS main_deal_link,
       NULL::text                                                                                                AS tags_key,
       amo_contracts_info.tags,
       NULL::text                                                                                                AS wishlist_key,
       amo_contracts_info.wishlist::text                                                                         AS wishlist,
       NULL::text                                                                                                AS product_key,
       amo_contracts_info.product::text                                                                          AS product,
       amo_contracts_info.yado_client_id::text                                                                   AS yado_client_id,
       amo_contracts_info.yado_store_id::text                                                                    AS yado_store_id,
       amo_contracts_info.contract_type::text                                                                    AS contract_type,
       amo_contracts_info.payment_type::text                                                                     AS payment_type,
       timezone('Europe/Moscow'::text,
                timezone('UTC'::text, amo_contracts_info.utc_company_created_dttm))::date                        AS org_add_date,
       timezone('Europe/Moscow'::text,
                timezone('UTC'::text, amo_contracts_info.utc_company_created_dttm))                              AS org_add_time,
       NULL::integer                                                                                             AS company_id,
       NULL::integer                                                                                             AS owner_id,
       NOT amo_contracts_info.company_deleted_flg                                                                AS org_active_flag,
       amo_contracts_info.country::text                                                                          AS country,
       amo_contracts_info.city::text                                                                             AS city,
       NULL::text                                                                                                AS geography_key,
       amo_contracts_info.geography::text                                                                        AS geography,
       amo_contracts_info.market_segment::text                                                                   AS market_segment,
       amo_contracts_info.tier::text                                                                             AS tier,
       amo_contracts_info.holding_id::integer                                                                    AS holding_id,
       amo_contracts_info.holding_name::text                                                                     AS holding_name,
       ('6_'::text || COALESCE(amo_contracts_info.holding_id::text, ''::text)) ||
       CASE
           WHEN amo_contracts_info.holding_id IS NULL THEN '_'::text || amo_contracts_info.company_id::text
           ELSE ''::text
           END                                                                                                   AS client_id,
       COALESCE(amo_contracts_info.holding_name,
                amo_contracts_info.company_name::character varying)::text                                        AS client_name,
       amo_contracts_info.marketing_status::text                                                                 AS marketing_status,
       amo_contracts_info.website::text                                                                          AS website,
       amo_contracts_info.inn::text                                                                              AS inn,
       amo_contracts_info.credit_rating::text                                                                    AS credit_rating,
       amo_contracts_info.manager_login,
       amo_contracts_info.manager_name,
       amo_contracts_info.manager_name_first,
       amo_contracts_info.manager_name_last,
       amo_contracts_info.teamlead_name                                                                          AS lead_name,
       amo_contracts_info.teamlead_name_first                                                                    AS lead_name_first,
       amo_contracts_info.teamlead_name_last                                                                     AS lead_name_last,
       amo_contracts_info.department_name,
       amo_contracts_info.manager_group,
       amo_contracts_info.permissions,
       timezone('Europe/Moscow'::text,
                timezone('UTC'::text, amo_contracts_info._etl_processed_dttm))::date                             AS record_date,
       amo_contracts_info.ndd_potential::integer                                                                 AS ndd_potential,
       amo_contracts_info.ndd_pipeline_stage::text                                                               AS ndd_pipeline_stage,
       amo_contracts_info.ndd_integration_status::text                                                           AS ndd_integration_status,
       NULL::integer                                                                                             AS ndd_pipeline_stage_key,
       NULL::integer                                                                                             AS ndd_integration_status_key,
       amo_contracts_info.corp_client_id::text                                                                   AS corp_client_id
FROM snb_b2b.amo_contracts_info;

-- comment on table snb_b2b.niksm_b2b_contracts_info is 'Параметры контрактов из snb_b2b.niksm_b2b_deals_info. Ключ - contract_id';

------------------------------------------------------------------------------------------------------------------------

-- drop table if exists snb_b2b.niksm_b2b_clients_info;
-- create table  snb_b2b.niksm_b2b_clients_info as
truncate table snb_b2b.niksm_b2b_clients_info;
insert into snb_b2b.niksm_b2b_clients_info
(which_crm, deal_id, deal_title, person_id, org_id, org_name, pipeline_id, pipeline_name, stage_id,
             stage_name, potential, status, lost_reason, add_date, add_time, contract_id, channel, integration_status,
             integration_module, main_deal_link, tags_key, tags, wishlist_key, wishlist, product_key, product,
             yado_client_id, yado_store_id, contract_type, payment_type, org_add_date, org_add_time, company_id,
             owner_id, org_active_flag, country, city, geography_key, geography, market_segment, tier, holding_id,
             holding_name, client_id, client_name, marketing_status, website, inn, credit_rating, manager_login,
             manager_name, manager_name_first, manager_name_last, lead_name, lead_name_first, lead_name_last,
             department_name, manager_group, permissions, record_date, ndd_potential, ndd_pipeline_stage,
             ndd_integration_status, ndd_pipeline_stage_key, ndd_integration_status_key, corp_client_id)
select
    6::int as which_crm,
    lead_id::int as deal_id,
    lead_name::text as deal_title,
    contact_id::int as person_id,
    company_id::int as org_id,
    company_name::text as org_name,
    pipeline_id::int as pipeline_id,
    pipeline_name::text as pipeline_name,
    status_id::int as stage_id,
    pipeline_status_name::text as stage_name,
    price::int as potential,
    lead_status::text as status,
    loss_reason_name::text as lost_reason,
    (utc_lead_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as add_date,
    utc_lead_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as add_time,
    contract_id::text as contract_id,
    channel::text as channel,
    integration_status::text as integration_status,
    integration_module::text as integration_module,
    main_deal_link::text as main_deal_link,
    NULL::text as tags_key,
    tags::text as tags,
    NULL::text as wishlist_key,
    wishlist::text as wishlist,
    NULL::text as product_key,
    product::text as product,
    yado_client_id::text as yado_client_id,
    yado_store_id::text as yado_store_id,
    contract_type::text as contract_type,
    payment_type::text as payment_type,
    (utc_company_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as org_add_date,
    utc_company_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as org_add_time,
    NULL::int as company_id,
    NULL::int as owner_id,
    not company_deleted_flg as org_active_flag,
    country::text as country,
    city::text as city,
    NULL::text as geography_key,
    geography::text as geography,
    market_segment::text as market_segment,
    tier::text as tier,
    holding_id::int as holding_id,
    holding_name::text as holding_name,
    '6_' || coalesce(holding_id::text,'')|| case when holding_id is null then '_' || company_id::text else '' end as client_id,
    coalesce(holding_name, company_name)::text as client_name,
    marketing_status::text as marketing_status,
    website::text as website,
    inn::text as inn,
    credit_rating::text as credit_rating,
    manager_login::text as manager_login,
    manager_name::text as manager_name,
    manager_name_first::varchar(128) as manager_name_first,
    manager_name_last::varchar(128) as manager_name_last,
    teamlead_name::text as lead_name,
    teamlead_name_first::varchar(128) as lead_name_first,
    teamlead_name_last::varchar(128) as lead_name_last,
    department_name::varchar(128) as department_name,
    manager_group::text as manager_group,
    permissions::text as permissions,
    (_etl_processed_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as record_date,
    ndd_potential::int as ndd_potential,
    ndd_pipeline_stage::text as ndd_pipeline_stage,
    ndd_integration_status::text as ndd_integration_status,
    NULL::int as ndd_pipeline_stage_key,
    NULL::int as ndd_integration_status_key,
    corp_client_id::text as corp_client_id
from snb_b2b.amo_clients_info;
