-- drop table if exists snb_b2b.niksm_contract_permissions;
-- create table  snb_b2b.niksm_contract_permissions as
truncate table snb_b2b.niksm_contract_permissions;
insert into snb_b2b.niksm_contract_permissions

with t as (
    select distinct contract_id, which_crm,
           substr(login_q,2,length(login_q)-2) as user_login
    from (
        select contract_id,
               which_crm,
               unnest(
                string_to_array(substr(permissions,2,length(permissions)-2),',')) as login_q
        from (
            select contract_id,
                   6::int as which_crm,
                   permissions
            from snb_b2b.amo_contracts_info
            union all
            select contract_id, which_crm, permissions
            from snb_b2b.niksm_b2b_contracts_info_sf
            ) q
    ) qq
)
select t.contract_id, t.which_crm, t.user_login,
       person.staff_uid
from t
  left join meta_cdm_staff.person
    on t.user_login = person.login;

-- comment on table snb_b2b.niksm_contract_permissions is 'Список юзеров, кому доступны данные по контракту: менеджер CRM + руководители + ручные доступы';
------------------------------------------------------------------------------------------------------------------------

-- drop table if exists snb_b2b.niksm_delivery_contract_permissions;
-- create table  snb_b2b.niksm_delivery_contract_permissions as
truncate table snb_b2b.niksm_delivery_contract_permissions;
insert into snb_b2b.niksm_delivery_contract_permissions

select contract_id, which_crm, user_login, staff_uid
from snb_b2b.niksm_contract_permissions
where which_crm in (6,88);

-- comment on table snb_b2b.niksm_delivery_contract_permissions is 'Список юзеров, кому доступны данные по контракту: менеджер CRM + руководители + ручные доступы. Только контракты Доставки';