drop table if exists niksm_temp_b2b_contracts_info_sf_res;
create temporary table niksm_temp_b2b_contracts_info_sf_res as
with sf_cntr as (
    select contract_id, account_id, opportunity_id
    from (
         select "Contract_Num_Yandex_Taxi__c" as contract_id,
                "AccountId" as account_id,
                "Opportunity__c" as opportunity_id,
                row_number() over (partition by "Contract_Num_Yandex_Taxi__c" order by "CreatedDate" desc, "LastModifiedDate" desc) as rn
        from snb_b2b.bmiklaz_ods_sf_b2b_contracts_isr
        where "Contract_Num_Yandex_Taxi__c" is not null
         ) q
    where rn = 1
)
, users as (
    select users_isr.user_id,
           users_isr.staff_user_login as manager_login,
           name_last_ru || ' ' || name_first_ru as manager_name,
           name_first_ru as manager_name_first,
           name_last_ru as manager_name_last,
           lead_name_last || ' ' || lead_name_first as lead_name,
           lead_name_first as lead_name_first,
           lead_name_last as lead_name_last,
           group_name as department_name,
          array_to_json( array(select json_array_elements_text(hierarchy))
        -- Full base
           || (select array_agg(user_login)
               from snb_b2b.niksm_b2b_user_permission
               where user_group in ('Full base','Israel','International'))
           )::text as permissions
    from snb_b2b.salesforce_b2b_user users_isr
      left join snb_b2b.voytekh_manager_v2 man
        on users_isr.staff_user_login = man.login
)
select contract_id,
--        NULL as deal_id,
--        False as add_contract_flg,
       NULL::text as status,
       floor(opp."Potential__c")::integer as potential,
       88::integer as which_crm,
       acc."Name" as client_name,
       NULL::text as holding_name,
       NULL::text as deal_title,
       acc."Region__c" as country,
       acc."Industry" as market_segment,
       NULL::text as tier,
       users.manager_login,
       coalesce(users.manager_name,users.manager_login) as manager_name,
       users.lead_name,
       users.department_name,
       users.permissions,
       'Израиль'::text as manager_group
from sf_cntr
  join snb_b2b.bmiklaz_ods_sf_b2b_accounts_isr acc
    on acc."Id" = sf_cntr.account_id
  join snb_b2b.bmiklaz_ods_sf_b2b_opportunities_isr opp
    on opp."Id" = sf_cntr.opportunity_id
  join users
    on users.user_id = opp."OwnerId"
where true
  and acc."Region__c" = 'ISR';


-- drop table if exists snb_b2b.niksm_b2b_contracts_info_sf;
-- create table snb_b2b.niksm_b2b_contracts_info_sf as         -- ! distributed by
truncate table snb_b2b.niksm_b2b_contracts_info_sf;
insert into snb_b2b.niksm_b2b_contracts_info_sf
    (contract_id,
       status, potential,
       which_crm, client_name, holding_name, deal_title,
       country, market_segment, tier,
       manager_login, manager_name, lead_name, department_name, permissions, manager_group)
select contract_id,
       status, potential,
       which_crm, client_name, holding_name, deal_title,
       country, market_segment, tier,
       manager_login, manager_name, lead_name, department_name, permissions, manager_group
from niksm_temp_b2b_contracts_info_sf_res
-- distributed by (contract_id)
;

-- alter table snb_b2b.niksm_b2b_contracts_info_sf add constraint niksm_b2b_contracts_info_sf_pk primary key (contract_id);
-- comment on table snb_b2b.niksm_b2b_contracts_info_sf is 'Аналог niksm_b2b_contracts_info для SalesForce';
