insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_deals_info', 'Start', clock_timestamp());

-- drop table if exists niksm_temp_b2b_dlh;
-- create temporary table niksm_temp_b2b_dlh as
-- with mx as(
--     select which_crm,
--        max(record_date) as record_date
--     from analyst.voytekh_pd2_deal_history as d
--     group by which_crm
-- )
-- select d.*
-- from analyst.voytekh_pd2_deal_history as d
--   join mx using(which_crm, record_date)
-- DISTRIBUTED BY (which_crm, id)
-- ;
-- --
-- analyze niksm_temp_b2b_dlh;
--
-- drop table if exists niksm_temp_b2b_deals;
-- create temporary table niksm_temp_b2b_deals as
-- select which_crm,
--        id as deal_id,
--        title as deal_title,
--        person_id,
--        split_part(custom_fields #>> '{user_id,email}', '@', 1) as manager_login,
--        org_id,
--        stage_id,
--        pipeline_id,
--        value as potential,
--        status,
--        lost_reason,
--        add_time,
--        custom_fields,
--        record_date
-- from (
--     select *,
--            row_number() over (partition by which_crm, id order by update_time desc) as rn
--     from niksm_temp_b2b_dlh
-- ) qq
-- where rn = 1
-- DISTRIBUTED BY (which_crm, deal_id)
-- ;
-- analyze niksm_temp_b2b_deals;
--
-- drop table if exists niksm_temp_b2b_deals_info;
-- create temporary table niksm_temp_b2b_deals_info as
-- --
-- with deal_custom_fields_raw as (
--     select f.attribute_name,
--            f.which_crm,
--            f.key,
--            cast(json_each_text(options) as varchar) as custom_fields
--     from analyst.voytekh_pd2_deal_field as opt
--       join snb_b2b.niksm_b2b_deal_field as f
--         on f.which_crm = opt.which_crm
--         and f.key = opt.key
--     where f.with_dict
-- )
-- , deal_custom_fields as (
--     select attribute_name,
--            which_crm,
--            key,
--            SUBSTRING(custom_fields from '^\((\d+),.*\)$') as field_id,
--            replace( SUBSTRING(custom_fields from '^\(\d+,(.*)\)$'),
--                '"','')::text as field_name
--     from deal_custom_fields_raw
-- )
-- , logins as (
--     select login as manager_login,
--            name_last_ru || ' ' || name_first_ru as manager_name,
--            name_first_ru as manager_name_first,
--            name_last_ru as manager_name_last,
--            lead_name_last || ' ' || lead_name_first as lead_name,
--            lead_name_first as lead_name_first,
--            lead_name_last as lead_name_last,
--            group_name as department_name,
--            array(select json_array_elements_text(hierarchy)) as permissions_array
--     from snb_b2b.voytekh_manager_v2
-- )
-- , attr_splitted as (
--     select deals.which_crm,
--            deals.deal_id,
--            deals.deal_title,
--            deals.person_id,
--            deals.org_id,
--            deals.stage_id,
--            deals.pipeline_id,
--            deals.potential,
--            deals.status,
--            deals.lost_reason,
--            deals.add_time,
--            deals.manager_login,
--            deals.record_date,
--            --
--            f.key,
--            f.attribute_name,
--            f.with_dict,
--            f.array_flg,
--            (deals.custom_fields ->> f.key)::text as attribute_key,
--            case
--                when f.array_flg then unnest(string_to_array((deals.custom_fields ->> f.key), ','))
--                else (deals.custom_fields ->> f.key) end as attribute_key_splitted
--     from niksm_temp_b2b_deals as deals
--       left join snb_b2b.niksm_b2b_deal_field as f
--         on f.which_crm = deals.which_crm
-- )
-- , attr_mult as (
--     select attr_splitted.which_crm,
--            attr_splitted.deal_id,
--            max(deal_title) as deal_title,
--            max(person_id) as person_id,
--            max(org_id) as org_id,
--            max(stage_id) as stage_id,
--            max(pipeline_id) as pipeline_id,
--            max(potential) as potential,
--            max(status) as status,
--            max(lost_reason) as lost_reason,
--            max(add_time) as add_time,
--            max(manager_login) as manager_login,
--            max(record_date) as record_date,
--            --
--            attr_splitted.attribute_name,
--            bool_or(with_dict) as with_dict,
--            bool_or(array_flg) as array_flg,
--            max(attribute_key) as attribute_key,
--            case
--                when not bool_or(with_dict) then max(attribute_key)
--                when bool_or(array_flg) then '[' || string_agg(format('"%s"', ocf.field_name), ',') || ']'
--                else max(ocf.field_name)::text end as attribute_value
--     from attr_splitted
--       left join deal_custom_fields as ocf
--         on ocf.attribute_name = attr_splitted.attribute_name
--         and ocf.which_crm = attr_splitted.which_crm
--         and ocf.key = attr_splitted.key
--         and ocf.field_id = attribute_key_splitted
--     group by attr_splitted.which_crm,
--              attr_splitted.deal_id,
--              attr_splitted.attribute_name
-- )
-- , deals_gr as (
--     select which_crm,
--            deal_id,
--            max(deal_title) as deal_title,
--            max(person_id) as person_id,
--            max(org_id) as org_id,
--            max(stage_id) as stage_id,
--            max(pipeline_id) as pipeline_id,
--            max(potential) as potential,
--            max(status) as status,
--            max(lost_reason) as lost_reason,
--            max(add_time) as add_time,
--            max(manager_login) as manager_login,
--            max(record_date) as record_date,
--            --
--            max(case when attribute_name = '№ договора' then attribute_value end) as contract_id,
--            max(case when attribute_name = 'Канал привлечения' then attribute_value end) as channel,
--            max(case when attribute_name = 'Статус интеграции' then attribute_value end) as integration_status,
--            max(case when attribute_name = 'Фактический модуль интеграции' then attribute_value end) as integration_module,
--            max(case when attribute_name = 'Ссылка на основную сделку (для дополнительных договоров)' then attribute_value end) as main_deal_link,
--            max(case when attribute_name = 'Теги' then attribute_key end) as tags_key,
--            max(case when attribute_name = 'Теги' then attribute_value end) as tags,
--            max(case when attribute_name = 'Wishlist' then attribute_key end) as wishlist_key,
--            max(case when attribute_name = 'Wishlist' then attribute_value end) as wishlist,
--            max(case when attribute_name = 'Продукт' then attribute_key end) as product_key,
--            max(case when attribute_name = 'Продукт' then attribute_value end) as product,
--            max(case when attribute_name = 'Я.Доставка - ID клиента' then attribute_value end) as yado_client_id,
--            max(case when attribute_name = 'Я.Доставка - ID магазина' then attribute_value end) as yado_store_id,
--            max(case when attribute_name = 'Market segment' then attribute_value end) as market_segment_deal,
--            max(case when attribute_name = 'Тип договора' then attribute_value end) as contract_type,
--            max(case when attribute_name = 'Тип оплаты' then attribute_value end) as payment_type,
--            max(case when attribute_name = 'Потенциал объемов NDD' then attribute_value::int end) as ndd_potential,
--            max(case when attribute_name = 'Этап воронки NDD' then attribute_key::int end) as ndd_pipeline_stage_key,
--            max(case when attribute_name = 'Этап воронки NDD' then attribute_value end) as ndd_pipeline_stage,
--            max(case when attribute_name = 'Статус интеграции NDD' then attribute_key::int end) as ndd_integration_status_key,
--            max(case when attribute_name = 'Статус интеграции NDD' then attribute_value end) as ndd_integration_status,
--            max(case when attribute_name = 'corp_client_id' then attribute_key end) as corp_client_id
--     from attr_mult
--     group by which_crm,
--            deal_id
-- )
-- select deals_gr.which_crm,
--        deals_gr.deal_id,
--        deals_gr.deal_title,
--        deals_gr.person_id,
--        deals_gr.org_id,
--        o.org_name,
--        deals_gr.pipeline_id,
--        ppln.name as pipeline_name,
--        deals_gr.stage_id,
--        stgn.name as stage_name,
--        deals_gr.potential,
--        deals_gr.status,
--        deals_gr.lost_reason,
--        date(deals_gr.add_time) as add_date,
--        deals_gr.add_time,
--        deals_gr.contract_id,
--        deals_gr.channel,
--        deals_gr.integration_status,
--        deals_gr.integration_module,
--        deals_gr.main_deal_link,
--        deals_gr.tags_key,
--        deals_gr.tags,
--        deals_gr.wishlist_key,
--        deals_gr.wishlist,
--        deals_gr.product_key,
--        deals_gr.product,
--        deals_gr.yado_client_id,
--        deals_gr.yado_store_id,
--        deals_gr.contract_type,
--        deals_gr.payment_type,
--        deals_gr.ndd_potential,
--        deals_gr.ndd_pipeline_stage_key,
--        deals_gr.ndd_pipeline_stage,
--        deals_gr.ndd_integration_status_key,
--        deals_gr.ndd_integration_status,
--        deals_gr.corp_client_id,
--        o.add_date as org_add_date,
--        o.add_time as org_add_time,
--        o.company_id,
--        o.owner_id,
--        o.active_flag as org_active_flag,
--        o.country,
--        o.city,
--        o.geography_key,
--        o.geography,
--        coalesce(o.market_segment,deals_gr.market_segment_deal) as market_segment,       -- для which_crm = 5 market_segment - атрибут сделки
--        o.tier,
-- 	   o.holding_id,
-- 	   o.holding_name,
--        o.client_id,
--        o.client_name,
--        o.marketing_status,
--        o.website,
--        o.inn,
--        o.credit_rating,
--        deals_gr.manager_login,
--        logins.manager_name,
--        logins.manager_name_first,
--        logins.manager_name_last,
--        logins.lead_name,
--        logins.lead_name_first,
--        logins.lead_name_last,
--        logins.department_name,
--        case when deals_gr.which_crm in (6) then
--             case when deals_gr.pipeline_id in (7) then 'B2B платформа'   -- (РАСТОРГНУТЫЕ ДОГОВОРЫ)
--                 when deals_gr.manager_login = 'erast' then 'INTERCO'
--                 when logins.permissions_array && array ['anashche'] then 'ГПП 1'
--                 when logins.permissions_array && array ['smelovdv'] then 'ГПП 2'
--                 when logins.permissions_array && array ['farber-olga'] then 'ГМП 2'     -- suvorov-a-v руководитель outstaff_2289_6747_dep94284_dep80684_dep95183, permissions сбиваются, farber-olga нужно ставить в приоритет
--                 when logins.permissions_array && array ['suvorov-a-v'] then 'ГМП 1'
--                 when logins.permissions_array && array ['alitovchenko'] then 'ГМП NDD'
--                 when logins.permissions_array && array ['isinchurin'] then 'СНГ'
--             else 'Тир 3' end
--            when deals_gr.which_crm in (8) then 'Израиль'
--         else 'B2B платформа' end as manager_group,
--        array_to_json( logins.permissions_array
--         -- Full base
--            || (select array_agg(user_login)
--                from snb_b2b.niksm_b2b_user_permission
--                where user_group in ('Full base'))
--         -- Israel
--            || case when deals_gr.which_crm = 8
--                     or (deals_gr.which_crm = 5 and deals_gr.manager_login = 'galben')
--                then (
--                    select array_agg(user_login)
--                    from snb_b2b.niksm_b2b_user_permission
--                    where user_group in ('Israel')
--                    ) end
--         -- International
--            || case when (deals_gr.which_crm in (6,8)
--                       and o.country is not null and o.country <> 'РФ' and o.country <> 'Россия')
--                     or (deals_gr.which_crm = 5 and deals_gr.manager_login = 'galben')
--                then (
--                    select array_agg(user_login)
--                    from snb_b2b.niksm_b2b_user_permission
--                    where user_group in ('International')
--                    ) end
--         -- Telemarketing
--            || case when deals_gr.which_crm in (6) and deals_gr.manager_login = 'wubbo_ockels'
--                then (
--                    select array_agg(user_login)
--                    from snb_b2b.niksm_b2b_user_permission
--                    where user_group in ('Telemarketing')
--                    ) end
--         -- Partner
--            || case when deals_gr.which_crm in (6) and deals_gr.channel = 'ПАРТНЕРСКИЕ ПРОДАЖИ'
--                then (
--                    select array_agg(user_login)
--                    from snb_b2b.niksm_b2b_user_permission
--                    where user_group in ('Partner')
--                    ) end
--            )::text as permissions,
--        deals_gr.record_date
-- from deals_gr
--   left join snb_b2b.niksm_b2b_orgs_info as o
--     on o.which_crm = deals_gr.which_crm
--     and o.org_id = deals_gr.org_id
--   left join logins
--     on logins.manager_login = deals_gr.manager_login
--   left join analyst.voytekh_pd_pipeline as ppln
--     on ppln.which_crm = deals_gr.which_crm
--     and ppln.pd_id = deals_gr.pipeline_id
--   left join analyst.voytekh_pd_stage as stgn
--     on stgn.which_crm = deals_gr.which_crm
--     and stgn.pd_id = deals_gr.stage_id;
--
-- ------------------------------------------------------------------------------------------------------------------------
-- -- drop table if exists snb_b2b.niksm_b2b_deals_info;
-- -- create table snb_b2b.niksm_b2b_deals_info as
-- truncate table snb_b2b.niksm_b2b_deals_info;
-- insert into snb_b2b.niksm_b2b_deals_info
--     (which_crm, deal_id,
--      deal_title,
--      person_id,
--      org_id, org_name,
--      pipeline_id, pipeline_name, stage_id, stage_name, potential, status, lost_reason, add_date, add_time, contract_id,
--      channel, integration_status, integration_module, main_deal_link, tags_key, tags, wishlist_key, wishlist,
--      product_key, product, yado_client_id, yado_store_id, contract_type, payment_type,
--      ndd_potential, ndd_pipeline_stage_key, ndd_pipeline_stage, ndd_integration_status_key, ndd_integration_status,
--      org_add_date, org_add_time, company_id, owner_id, org_active_flag,
--      country, city, geography_key, geography,
--      market_segment, tier, holding_id, holding_name, client_id, client_name,
--      marketing_status, website, inn, credit_rating,
--      manager_login, manager_name, manager_name_first, manager_name_last, lead_name, lead_name_first, lead_name_last, department_name, manager_group, permissions,
--      record_date, corp_client_id)
-- --
-- select which_crm, deal_id,
--        deal_title,
--        person_id,
--        org_id, org_name,
--        pipeline_id, pipeline_name, stage_id, stage_name, potential, status, lost_reason, add_date, add_time, contract_id,
--        channel, integration_status, integration_module, main_deal_link, tags_key, tags, wishlist_key, wishlist,
--        product_key, product, yado_client_id, yado_store_id, contract_type, payment_type,
--        ndd_potential, ndd_pipeline_stage_key, ndd_pipeline_stage, ndd_integration_status_key, ndd_integration_status,
--        org_add_date, org_add_time, company_id, owner_id, org_active_flag,
--        country, city, geography_key, geography,
--        market_segment, tier, holding_id, holding_name, client_id, client_name,
--        marketing_status, website, inn, credit_rating,
--        manager_login, manager_name, manager_name_first, manager_name_last, lead_name, lead_name_first, lead_name_last, department_name, manager_group, permissions,
--        record_date, corp_client_id
-- from niksm_temp_b2b_deals_info
--
-- -- DISTRIBUTED BY (which_crm, deal_id)
-- ;
--
-- -- alter table snb_b2b.niksm_b2b_deals_info add constraint niksm_b2b_deals_info_pk primary key (which_crm, deal_id);
-- -- grant all on snb_b2b.niksm_b2b_deals_info to "robot-sam-bridges", "robot-corploader";
-- -- comment on table snb_b2b.niksm_b2b_deals_info is 'Справочник организаций в CRM';
-- --
-- -- ------------------------------------------------------------------------------------------------------------------------
-- -- create or replace view snb_taxi.niksm_b2b_deals_info as
-- -- select * from snb_b2b.niksm_b2b_deals_info;
-- -- -- --
-- -- grant select on snb_taxi.niksm_b2b_deals_info to rw_snb_b2b, niksm;
-- -- comment on view snb_taxi.niksm_b2b_deals_info is 'Копия snb_b2b. Справочник сделок в CRM';

--====================================================================================================================--

truncate table snb_b2b.niksm_b2b_deals_info;
insert into snb_b2b.niksm_b2b_deals_info
    (which_crm, deal_id, deal_title, person_id, org_id, org_name, pipeline_id, pipeline_name, stage_id, stage_name, potential, status, lost_reason, add_date, add_time, contract_id, channel, integration_status, integration_module, main_deal_link, tags_key, tags, wishlist_key, wishlist, product_key, product, yado_client_id, yado_store_id, contract_type, payment_type, org_add_date, org_add_time, company_id, owner_id, org_active_flag, country, city, geography_key, geography, market_segment, tier, holding_id, holding_name, client_id, client_name, marketing_status, website, inn, credit_rating, manager_login, manager_name, manager_name_first, manager_name_last, lead_name, lead_name_first, lead_name_last, department_name, manager_group, permissions, record_date, ndd_potential, ndd_pipeline_stage, ndd_integration_status, ndd_pipeline_stage_key, ndd_integration_status_key, corp_client_id,bd_reason, risk_repay_ovr_debt, debt, risk_downside_2022, risk_debt_2022, debt_working)
select
    6::int as which_crm,
    lead_id::int as deal_id,
    lead_name::text as deal_title,
    contact_id::int as person_id,
    company_id::int as org_id,
    company_name::text as org_name,
    pipeline_id::int as pipeline_id,
    pipeline_name::text as pipeline_name,
    status_id::int as stage_id,
    pipeline_status_name::text as stage_name,
    price::int as potential,
    lead_status::text as status,
    loss_reason_name::text as lost_reason,
    (utc_lead_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as add_date,
    utc_lead_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as add_time,
    contract_id::text as contract_id,
    channel::text as channel,
    integration_status::text as integration_status,
    integration_module::text as integration_module,
    main_deal_link::text as main_deal_link,
    NULL::text as tags_key,
    tags::text as tags,
    NULL::text as wishlist_key,
    wishlist::text as wishlist,
    NULL::text as product_key,
    product::text as product,
    yado_client_id::text as yado_client_id,
    yado_store_id::text as yado_store_id,
    contract_type::text as contract_type,
    payment_type::text as payment_type,
    (utc_company_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as org_add_date,
    utc_company_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as org_add_time,
    NULL::int as company_id,
    NULL::int as owner_id,
    not company_deleted_flg as org_active_flag,
    country::text as country,
    city::text as city,
    NULL::text as geography_key,
    geography::text as geography,
    market_segment::text as market_segment,
    tier::text as tier,
    holding_id::int as holding_id,
    holding_name::text as holding_name,
    '6_' || coalesce(holding_id::text,'')|| case when holding_id is null then '_' || company_id::text else '' end as client_id,
    coalesce(holding_name, company_name)::text as client_name,
    marketing_status::text as marketing_status,
    website::text as website,
    inn::text as inn,
    credit_rating::text as credit_rating,
    manager_login::text as manager_login,
    manager_name::text as manager_name,
    manager_name_first::varchar(128) as manager_name_first,
    manager_name_last::varchar(128) as manager_name_last,
    teamlead_name::text as lead_name,
    teamlead_name_first::varchar(128) as lead_name_first,
    teamlead_name_last::varchar(128) as lead_name_last,
    department_name::varchar(128) as department_name,
    manager_group::text as manager_group,
    permissions::text as permissions,
    (_etl_processed_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as record_date,
    ndd_potential::int as ndd_potential,
    ndd_pipeline_stage::text as ndd_pipeline_stage,
    ndd_integration_status::text as ndd_integration_status,
    NULL::int as ndd_pipeline_stage_key,
    NULL::int as ndd_integration_status_key,
    corp_client_id::text as corp_client_id,
    bd_reason::text as bd_reason,
    risk_repay_ovr_debt::text as risk_repay_ovr_debt,
    debt::numeric as debt,
    risk_downside_2022::text as risk_downside_2022,
    risk_debt_2022::text as risk_debt_2022,
    debt_working::text as debt_working
from snb_b2b.amo_leads_info;

insert into snb_b2b.niksm_b2b_process_log (process_name, event_name, event_timestamp) VALUES ('niksm_b2b_deals_info', 'Finish', clock_timestamp());
