-- drop table if exists niksm_temp_b2b_orgs_info;
-- create temporary table niksm_temp_b2b_orgs_info as
-- with org_custom_fields_raw as (
--     select f.attribute_name,
--            f.which_crm,
--            f.key,
--            cast(json_each_text(options) as varchar) as custom_fields
--     from analyst.voytekh_pd2_org_field as opt
--       join snb_b2b.niksm_b2b_org_field as f
--         on f.which_crm = opt.which_crm
--         and f.key = opt.key
--     where f.with_dict
-- )
-- , org_custom_fields as (
--     select attribute_name,
--            which_crm,
--            key,
--            SUBSTRING(custom_fields from '^\((\d+),.*\)$') as field_id,
--            replace( SUBSTRING(custom_fields from '^\(\d+,(.*)\)$'),
--                '"','')::text as field_name
--     from org_custom_fields_raw
-- )
-- , orgs as (
--     select which_crm,
--            id as org_id,
--            name as org_name,
--            add_time,
--            company_id,
--            owner_id,
--            active_flag,
--            custom_fields
--     from (
--         select o.*,
--                row_number() over (partition by o.which_crm, o.id order by update_time desc) as rn
--         from analyst.voytekh_pd2_org as o
--     ) as q
--     where rn = 1
-- )
-- , attr_splitted as (
--     select orgs.which_crm,
--            orgs.org_id,
--            orgs.org_name,
--            orgs.add_time,
--            orgs.company_id,
--            orgs.owner_id,
--            orgs.active_flag,
--            --
--            f.key,
--            f.attribute_name,
--            f.with_dict,
--            f.array_flg,
--            (orgs.custom_fields ->> f.key)::text as attribute_key,
--            case
--                when f.array_flg then unnest(string_to_array((orgs.custom_fields ->> f.key), ','))
--                else (orgs.custom_fields ->> f.key) end as attribute_key_splitted
--     from orgs
--       left join snb_b2b.niksm_b2b_org_field as f
--         on f.which_crm = orgs.which_crm
-- )
-- , attr_mult as (
--     select attr_splitted.which_crm,
--            attr_splitted.org_id,
--            max(org_name) as org_name,
--            max(add_time) as add_time,
--            max(company_id) as company_id,
--            max(owner_id) as owner_id,
--            bool_or(active_flag) as active_flag,
--            --
--            attr_splitted.attribute_name,
--            bool_or(with_dict) as with_dict,
--            bool_or(array_flg) as array_flg,
--            max(attribute_key) as attribute_key,
--            case
--                when not bool_or(with_dict) then max(attribute_key)
--                when bool_or(array_flg) then '[' || string_agg(format('"%s"', ocf.field_name), ',') || ']'
--                else max(ocf.field_name)::text end as attribute_value
--     from attr_splitted
--       left join org_custom_fields as ocf
--         on ocf.attribute_name = attr_splitted.attribute_name
--         and ocf.which_crm = attr_splitted.which_crm
--         and ocf.key = attr_splitted.key
--         and ocf.field_id = attribute_key_splitted
--     group by attr_splitted.which_crm,
--              attr_splitted.org_id,
--              attr_splitted.attribute_name
-- )
-- , orgs_gr as (
--     select which_crm,
--            org_id,
--            max(org_name) as org_name,
--            date(max(add_time)) as add_date,
--            max(add_time) as add_time,
--            max(company_id) as company_id,
--            max(owner_id) as owner_id,
--            bool_or(active_flag) as active_flag,
--            max(case when attribute_name = 'Страна' then attribute_value end) as country,
--            max(case when attribute_name = 'Город' then attribute_value end) as city,
--            max(case when attribute_name = 'География' then attribute_key end) as geography_key,
--            max(case when attribute_name = 'География' then attribute_value end) as geography,
--            max(case when attribute_name = 'Сегмент рынка' then attribute_value end) as market_segment,
--            max(case when attribute_name = 'Tier' then attribute_value end) as tier,
--            max(case when attribute_name = 'Группа компаний' then attribute_key::integer end) as holding_id,
--            max(case when attribute_name = 'Группа компаний' then attribute_value end) as holding_name,
--            max(case when attribute_name = 'Статус взаимодействия по маркетингу' then attribute_value end) as marketing_status,
--            max(case when attribute_name = 'Сайт' then attribute_value end) as website,
--            max(case when attribute_name = 'ИНН' then attribute_value end) as INN,
--            max(case when attribute_name = 'Кредитный рейтинг' then attribute_value end) as credit_rating
--     from attr_mult
--     group by which_crm,
--            org_id
-- )
-- select which_crm,
--        org_id,
--        org_name,
--        date(add_time) as add_date,
--        add_time,
--        company_id,
--        owner_id,
--        active_flag,
--        country,
--        city,
--        geography_key,
--        geography,
--        market_segment,
--        tier,
--        holding_id,
--        holding_name,
--        which_crm::text || '_' || coalesce(holding_id::text,'')
--            || case when holding_id is null then '_' || org_id::text else '' end as client_id,
--        coalesce(holding_name, org_name) as client_name,
--        marketing_status,
--        website,
--        INN,
--        credit_rating
-- from orgs_gr;
--
-- ------------------------------------------------------------------------------------------------------------------------
--
-- -- drop table if exists snb_b2b.niksm_b2b_orgs_info;
-- -- create table snb_b2b.niksm_b2b_orgs_info as
-- truncate table snb_b2b.niksm_b2b_orgs_info;
-- insert into snb_b2b.niksm_b2b_orgs_info
--     (which_crm, org_id, org_name, add_date, add_time, company_id, owner_id, active_flag,
--      country, city, geography_key, geography, market_segment, tier, holding_id, holding_name,
--      client_id, client_name, marketing_status, website, inn, credit_rating)
-- --
-- select which_crm, org_id, org_name, add_date, add_time, company_id, owner_id, active_flag,
--      country, city, geography_key, geography, market_segment, tier, holding_id, holding_name,
--      client_id, client_name, marketing_status, website, inn, credit_rating
-- from niksm_temp_b2b_orgs_info
-- --  DISTRIBUTED BY (which_crm, org_id)
-- ;
--
-- -- alter table snb_b2b.niksm_b2b_orgs_info add constraint niksm_b2b_orgs_info_pk primary key (which_crm, org_id);
-- -- grant all on snb_b2b.niksm_b2b_orgs_info to "robot-sam-bridges", "robot-corploader";
-- -- comment on table snb_b2b.niksm_b2b_orgs_info is 'Справочник организаций в CRM';
-- --
-- -- ------------------------------------------------------------------------------------------------------------------------
-- -- create or replace view snb_taxi.niksm_b2b_orgs_info as
-- -- select * from snb_b2b.niksm_b2b_orgs_info;
-- -- -- --
-- -- grant select on snb_taxi.niksm_b2b_orgs_info to rw_snb_b2b, niksm;
-- -- comment on view snb_taxi.niksm_b2b_orgs_info is 'Копия snb_b2b. Справочник организаций в CRM';
select 42
